/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.options.Bundle;
import org.netbeans.modules.options.CategoryModel;
import org.netbeans.modules.options.OptionsPanel;
import org.netbeans.modules.options.classic.OptionsAction;
import org.netbeans.modules.options.export.OptionsChooserPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class OptionsDisplayerImpl {
    private static Dialog dialog;
    private static WeakReference<DialogDescriptor> descriptorRef;
    private static String title;
    private static Logger log;
    private FileChangeListener fcl;
    private boolean modal;
    static final LookupListener lookupListener;
    private JButton bOK;
    private JButton bAPPLY;
    private JButton bClassic;
    private JButton btnExport;
    private JButton btnImport;
    private static final RequestProcessor RP;
    private static final int DELAY = 500;
    private boolean savingInProgress = false;
    private FileObject configFile;

    public OptionsDisplayerImpl(boolean bl) {
        this.modal = bl;
        this.fcl = new DefaultFSListener();
        try {
            FileUtil.getConfigRoot().getFileSystem().addFileChangeListener(this.fcl);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
    }

    public void setIsModal(boolean bl) {
        this.modal = bl;
    }

    public boolean isOpen() {
        return dialog != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void selectCategory(String string) {
        DialogDescriptor dialogDescriptor = null;
        Object object = lookupListener;
        synchronized (object) {
            dialogDescriptor = (DialogDescriptor)descriptorRef.get();
        }
        if (dialogDescriptor != null) {
            object = (OptionsPanel)dialogDescriptor.getMessage();
            String string2 = string.indexOf(47) == -1 ? string : string.substring(0, string.indexOf(47));
            String string3 = string.indexOf(47) == -1 ? null : string.substring(string.indexOf(47) + 1);
            ((OptionsPanel)object).initCurrentCategory(string2, string3);
        }
        dialog.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showOptionsDialog(String string, String string2, CategoryModel categoryModel) {
        Object[] objectArray;
        log.fine("showOptionsDialog(" + string + ", " + string2 + ")");
        if (this.isOpen()) {
            dialog.setVisible(true);
            dialog.toFront();
            log.fine("Front Options Dialog");
            return;
        }
        DialogDescriptor dialogDescriptor = null;
        Object object = lookupListener;
        synchronized (object) {
            dialogDescriptor = (DialogDescriptor)descriptorRef.get();
        }
        object = null;
        if (dialogDescriptor == null) {
            object = string == null ? new OptionsPanel(categoryModel) : new OptionsPanel(string, categoryModel);
            this.bOK = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_OK");
            this.bOK.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_OKButton"));
            this.bAPPLY = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_APPLY");
            this.bAPPLY.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_APPLYButton"));
            this.bAPPLY.setEnabled(false);
            this.bClassic = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Classic");
            this.bClassic.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_ClassicButton"));
            this.btnExport = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Export");
            this.btnExport.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_Export"));
            this.btnImport = (JButton)OptionsDisplayerImpl.loc(new JButton(), "CTL_Import");
            this.btnImport.getAccessibleContext().setAccessibleDescription(OptionsDisplayerImpl.loc("ACS_Import"));
            this.updateButtons();
            boolean bl = Utilities.isMac();
            objectArray = new Object[]{bl ? DialogDescriptor.CANCEL_OPTION : this.bOK, this.bAPPLY, bl ? this.bOK : DialogDescriptor.CANCEL_OPTION};
            dialogDescriptor = new DialogDescriptor(object, title, this.modal, objectArray, DialogDescriptor.OK_OPTION, 0, null, null, false);
            JPanel jPanel = new JPanel(new FlowLayout(1, 5, 0));
            jPanel.add(this.bClassic);
            jPanel.add(this.btnExport);
            jPanel.add(this.btnImport);
            this.setUpButtonListeners((OptionsPanel)object);
            dialogDescriptor.setAdditionalOptions(new Object[]{jPanel});
            dialogDescriptor.setHelpCtx(((OptionsPanel)object).getHelpCtx());
            OptionsPanelListener optionsPanelListener = new OptionsPanelListener(dialogDescriptor, (OptionsPanel)object, this.bOK, this.bAPPLY);
            dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION, this.bOK});
            dialogDescriptor.setButtonListener((ActionListener)optionsPanelListener);
            ((Container)object).addPropertyChangeListener(optionsPanelListener);
            LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
            synchronized (lookupListener) {
                descriptorRef = new WeakReference<DialogDescriptor>(dialogDescriptor);
            }
            log.fine("Create new Options Dialog");
        } else {
            object = (OptionsPanel)dialogDescriptor.getMessage();
            ((OptionsPanel)object).setCategoryInstance(categoryModel);
            ((OptionsPanel)object).update();
            log.fine("Reopen Options Dialog");
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor, WindowManager.getDefault().getMainWindow());
        log.fine("Options Dialog created; descriptor.title = " + dialogDescriptor.getTitle() + "; descriptor.message = " + dialogDescriptor.getMessage());
        ((OptionsPanel)object).initCurrentCategory(string, string2);
        dialog.addWindowListener(new MyWindowListener((OptionsPanel)object, dialog));
        objectArray = this.getUserLocation((OptionsPanel)object);
        if (objectArray != null) {
            dialog.setLocation((Point)objectArray);
            log.fine("userLocation is set to " + objectArray);
        }
        log.fine("setting Options Dialog visible");
        dialog.setVisible(true);
        OptionsDisplayerImpl.dialog = dialog;
        this.setUpApplyChecker((OptionsPanel)object);
    }

    private void setUpApplyChecker(final OptionsPanel optionsPanel) {
        final RequestProcessor.Task task = RP.post(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!OptionsDisplayerImpl.this.savingInProgress) {
                            OptionsDisplayerImpl.this.bAPPLY.setEnabled(optionsPanel.isChanged() && optionsPanel.dataValid());
                        }
                    }
                });
            }
        });
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task2) {
                if (dialog != null) {
                    task.schedule(500);
                }
            }
        });
    }

    private void setUpButtonListeners(OptionsPanel optionsPanel) {
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsChooserPanel.showExportDialog();
            }
        });
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsChooserPanel.showImportDialog();
            }
        });
        final OptionsPanel optionsPanel2 = optionsPanel;
        this.bClassic.addActionListener(new ActionListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NotifyDescriptor.Confirmation confirmation;
                log.fine("Options Dialog - Classic pressed.");
                Dialog dialog = dialog;
                OptionsDisplayerImpl.dialog = null;
                if (optionsPanel2.isChanged()) {
                    confirmation = new NotifyDescriptor.Confirmation((Object)OptionsDisplayerImpl.loc("CTL_Some_values_changed"), 1, 3);
                    Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (object == NotifyDescriptor.YES_OPTION) {
                        optionsPanel2.save();
                        dialog.dispose();
                    } else {
                        if (object != NotifyDescriptor.NO_OPTION) {
                            OptionsDisplayerImpl.dialog = dialog;
                            return;
                        }
                        optionsPanel2.cancel();
                        dialog.dispose();
                    }
                } else {
                    dialog.dispose();
                    optionsPanel2.cancel();
                }
                try {
                    confirmation = (CallableSystemAction)SystemAction.get(OptionsAction.class);
                    confirmation.putValue("additionalActionName", (Object)OptionsDisplayerImpl.loc("CTL_Modern"));
                    confirmation.putValue("optionsDialogTitle", (Object)OptionsDisplayerImpl.loc("CTL_Classic_Title"));
                    confirmation.putValue("additionalActionListener", (Object)new OpenOptionsListener());
                    confirmation.performAction();
                    return;
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        });
    }

    private void updateButtons() {
        if (this.bClassic != null) {
            this.bClassic.setVisible(this.advancedOptionsNotEmpty());
        }
        boolean bl = this.optionsExportNotEmpty();
        if (this.btnExport != null) {
            this.btnExport.setVisible(bl);
        }
        if (this.btnImport != null) {
            this.btnImport.setVisible(bl);
        }
    }

    private boolean advancedOptionsNotEmpty() {
        FileObject fileObject = this.doGetConfigFile("UI/Services");
        if (fileObject != null) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                Object object = fileObject2.getAttribute("hidden");
                if (object != null && ((Boolean)object).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean optionsExportNotEmpty() {
        FileObject fileObject = this.doGetConfigFile("OptionsExport");
        if (fileObject != null) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                FileObject[] fileObjectArray2;
                Object object = fileObject2.getAttribute("hidden");
                if (object != null && ((Boolean)object).booleanValue()) continue;
                for (FileObject fileObject3 : fileObjectArray2 = fileObject2.getChildren()) {
                    Object object2 = fileObject3.getAttribute("hidden");
                    if (object2 != null && ((Boolean)object2).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private FileObject doGetConfigFile(final String string) {
        this.configFile = null;
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                OptionsDisplayerImpl.this.configFile = FileUtil.getConfigFile((String)string);
            }
        }, (String)Bundle.Get_Config_File_Lengthy_Operation(), (AtomicBoolean)atomicBoolean, (boolean)false, (int)50, (int)1000);
        if (atomicBoolean.get()) {
            log.log(Level.FINE, "Options Dialog - Getting config file for path ''{0}'', cancelled by user.", string);
        }
        return this.configFile;
    }

    private Point getUserLocation(OptionsPanel optionsPanel) {
        GraphicsDevice[] graphicsDeviceArray;
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            Point point = this.getUserLocation(graphicsDevice.getDefaultConfiguration(), optionsPanel);
            if (point == null) continue;
            return point;
        }
        return null;
    }

    private Point getUserLocation(GraphicsConfiguration graphicsConfiguration, OptionsPanel optionsPanel) {
        Rectangle rectangle = Utilities.getUsableScreenBounds((GraphicsConfiguration)graphicsConfiguration);
        int n = NbPreferences.forModule(OptionsDisplayerImpl.class).getInt("OptionsX", Integer.MAX_VALUE);
        int n2 = NbPreferences.forModule(OptionsDisplayerImpl.class).getInt("OptionsY", Integer.MAX_VALUE);
        Dimension dimension = optionsPanel.getUserSize();
        if ((double)n > (double)rectangle.x + rectangle.getWidth() || (double)n2 > (double)rectangle.y + rectangle.getHeight() || (double)(n + dimension.width) > (double)rectangle.x + rectangle.getWidth() || (double)(n2 + dimension.height) > (double)rectangle.y + rectangle.getHeight() || n < rectangle.x && rectangle.x >= 0 || n > rectangle.x && rectangle.x < 0 || n2 < rectangle.y && rectangle.y >= 0 || n2 > rectangle.y && rectangle.y < 0) {
            return null;
        }
        return new Point(n, n2);
    }

    private static String loc(String string) {
        return NbBundle.getMessage(OptionsDisplayerImpl.class, (String)string);
    }

    private static Component loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)OptionsDisplayerImpl.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)OptionsDisplayerImpl.loc(string));
        }
        return component;
    }

    static {
        descriptorRef = new WeakReference<Object>(null);
        title = OptionsDisplayerImpl.loc("CTL_Options_Dialog_Title");
        log = Logger.getLogger(OptionsDisplayerImpl.class.getName());
        lookupListener = new LookupListenerImpl();
        RP = new RequestProcessor(OptionsDisplayerImpl.class.getName(), 1, true);
    }

    private class DefaultFSListener
    implements FileChangeListener {
        private DefaultFSListener() {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileChanged(FileEvent fileEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileDeleted(FileEvent fileEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            OptionsDisplayerImpl.this.updateButtons();
        }
    }

    private static class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
            synchronized (lookupListener) {
                descriptorRef = new WeakReference<Object>(null);
                if (dialog != null) {
                    Mutex.EVENT.readAccess(new Runnable(){

                        @Override
                        public void run() {
                            if (dialog != null) {
                                log.log(Level.FINE, "Options Dialog - closing dialog when categories change.");
                                dialog.setVisible(false);
                                OptionsDisplayerImpl.dialog = null;
                            }
                        }
                    });
                }
            }
        }
    }

    class OpenOptionsListener
    implements ActionListener {
        OpenOptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            log.fine("Options Dialog - Back to modern.");
                            OptionsDisplayer.getDefault().open();
                        }
                    });
                }
            });
        }
    }

    private class MyWindowListener
    implements WindowListener {
        private OptionsPanel optionsPanel;
        private Dialog originalDialog;

        MyWindowListener(OptionsPanel optionsPanel, Dialog dialog) {
            this.optionsPanel = optionsPanel;
            this.originalDialog = dialog;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (dialog == null) {
                return;
            }
            log.fine("Options Dialog - windowClosing ");
            this.optionsPanel.cancel();
            OptionsDisplayerImpl.this.bOK.setEnabled(true);
            OptionsDisplayerImpl.this.bAPPLY.setEnabled(false);
            if (this.originalDialog == dialog) {
                OptionsDisplayerImpl.dialog = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosed(WindowEvent windowEvent) {
            this.optionsPanel.storeUserSize();
            NbPreferences.forModule(OptionsDisplayerImpl.class).putInt("OptionsX", this.originalDialog.getX());
            NbPreferences.forModule(OptionsDisplayerImpl.class).putInt("OptionsY", this.originalDialog.getY());
            try {
                FileUtil.getConfigRoot().getFileSystem().removeFileChangeListener(OptionsDisplayerImpl.this.fcl);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            if (this.optionsPanel.needsReinit()) {
                LookupListener lookupListener = OptionsDisplayerImpl.lookupListener;
                synchronized (lookupListener) {
                    descriptorRef = new WeakReference<Object>(null);
                }
            }
            if (this.originalDialog == dialog) {
                OptionsDisplayerImpl.dialog = null;
            }
            log.fine("Options Dialog - windowClosed");
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }
    }

    private class OptionsPanelListener
    implements PropertyChangeListener,
    ActionListener {
        private DialogDescriptor descriptor;
        private OptionsPanel optionsPanel;
        private JButton bOK;
        private JButton bAPPLY;
        private HelpCtx helpCtx = HelpCtx.DEFAULT_HELP;

        OptionsPanelListener(DialogDescriptor dialogDescriptor, OptionsPanel optionsPanel, JButton jButton, JButton jButton2) {
            this.descriptor = dialogDescriptor;
            this.optionsPanel = optionsPanel;
            this.bOK = jButton;
            this.bAPPLY = jButton2;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("buranhelpCtx")) {
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        OptionsPanelListener.this.helpCtx = OptionsPanelListener.this.optionsPanel.getHelpCtx();
                    }
                }, (String)Bundle.Loading_HelpCtx_Lengthy_Operation(), (AtomicBoolean)atomicBoolean, (boolean)false, (int)50, (int)5000);
                if (atomicBoolean.get()) {
                    log.fine("Options Dialog - HelpCtx loading cancelled by user.");
                }
                this.descriptor.setHelpCtx(this.helpCtx);
            } else if (propertyChangeEvent.getPropertyName().equals("buranvalid")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionsPanelListener.this.bOK.setEnabled(OptionsPanelListener.this.optionsPanel.dataValid());
                        OptionsPanelListener.this.bAPPLY.setEnabled(OptionsPanelListener.this.optionsPanel.isChanged() && OptionsPanelListener.this.optionsPanel.dataValid());
                    }
                });
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.bOK) {
                log.fine("Options Dialog - Ok pressed.");
                this.saveOptionsOffEDT(true);
                if (OptionsDisplayerImpl.this.isOpen()) {
                    dialog.dispose();
                    OptionsDisplayerImpl.dialog = null;
                }
            } else if (actionEvent.getSource() == this.bAPPLY) {
                log.fine("Options Dialog - Apply pressed.");
                this.saveOptionsOffEDT(false);
                this.bAPPLY.setEnabled(false);
            } else if (actionEvent.getSource() == DialogDescriptor.CANCEL_OPTION || actionEvent.getSource() == DialogDescriptor.CLOSED_OPTION) {
                log.fine("Options Dialog - Cancel pressed.");
                this.optionsPanel.cancel();
                this.bOK.setEnabled(true);
                this.bAPPLY.setEnabled(false);
                if (OptionsDisplayerImpl.this.isOpen()) {
                    dialog.dispose();
                    OptionsDisplayerImpl.dialog = null;
                }
            }
        }

        private void saveOptionsOffEDT(final boolean bl) {
            OptionsDisplayerImpl.this.savingInProgress = true;
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel(Bundle.Saving_Options_Lengthy_Operation()));
            ProgressUtils.runOffEventThreadWithCustomDialogContent((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        OptionsPanelListener.this.optionsPanel.save();
                    } else {
                        OptionsPanelListener.this.optionsPanel.save(true);
                    }
                }
            }, (String)Bundle.Saving_Options_Lengthy_Operation_Title(), (JPanel)jPanel, (int)50, (int)5000);
            OptionsDisplayerImpl.this.savingInProgress = false;
        }
    }
}

