import { Segment } from '@volar/source-map';
import { FileRangeCapabilities } from '@volar/language-core';
import * as CompilerDOM from '@vue/compiler-dom';
import type * as ts from 'typescript/lib/tsserverlibrary';
import { Sfc, VueCompilerOptions } from '../types';
import * as muggle from 'muggle-string';
type Code = Segment<FileRangeCapabilities>;
export declare function generate(ts: typeof import('typescript/lib/tsserverlibrary'), compilerOptions: ts.CompilerOptions, vueCompilerOptions: VueCompilerOptions, sourceTemplate: string, sourceLang: string, sfc: Sfc, hasScriptSetupSlots: boolean, codegenStack: boolean): {
    codes: Code[];
    codeStacks: muggle.StackNode[];
    formatCodes: Code[];
    formatCodeStacks: muggle.StackNode[];
    cssCodes: Code[];
    cssCodeStacks: muggle.StackNode[];
    tagNames: Record<string, number[]>;
    identifiers: Set<string>;
    hasSlot: boolean;
};
export declare function walkElementNodes(node: CompilerDOM.RootNode | CompilerDOM.TemplateChildNode, cb: (node: CompilerDOM.ElementNode) => void): void;
export {};
