"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BottomUpMovement = exports.TopDownMovement = exports.RightLeftMovement = exports.LeftRightMovement = exports.Slide = exports.XAxisMovement = exports.YAxisMovement = exports.Opacity = exports.Transition = exports.TransitionContainer = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
const React = __importStar(require("react"));
const react_1 = require("@emotion/react");
const motions_1 = require("./motions");
const { CSSTransition, TransitionGroup } = require('react-transition-group');
const TransitionContainer = (props) => (0, jsx_runtime_1.jsx)(TransitionGroup, Object.assign({}, props));
exports.TransitionContainer = TransitionContainer;
const Transition = (_a) => {
    var { animationStyle, timeout, component = 'div', children } = _a, props = __rest(_a, ["animationStyle", "timeout", "component", "children"]);
    return ((0, jsx_runtime_1.jsx)(react_1.ClassNames, { children: ({ css }) => ((0, jsx_runtime_1.jsx)(CSSTransition, Object.assign({ timeout: timeout, classNames: css(animationStyle) }, props, { children: component ? React.createElement(component, {}, children) : children }))) }));
};
exports.Transition = Transition;
const Opacity = (_a) => {
    var { startValue = 0, endValue = 1, timeout = motions_1.DURATION.DEFAULT } = _a, props = __rest(_a, ["startValue", "endValue", "timeout"]);
    return ((0, jsx_runtime_1.jsx)(exports.Transition, Object.assign({ animationStyle: {
            '&-enter': { opacity: startValue },
            '&-enter-active': {
                opacity: endValue,
                transition: `all ${timeout}ms ${motions_1.EASE.QUART}`,
            },
            '&-exit': { opacity: endValue },
            '&-exit-active': {
                opacity: startValue,
                pointerEvents: 'none',
                transition: `all ${timeout}ms ${motions_1.EASE.QUART}`,
            },
            '&-exit-done': { opacity: startValue },
        }, timeout: timeout }, props)));
};
exports.Opacity = Opacity;
const YAxisMovement = (_a) => {
    var { startValue = '-100%', endValue = '0%', timeout = motions_1.DURATION.DEFAULT } = _a, props = __rest(_a, ["startValue", "endValue", "timeout"]);
    return ((0, jsx_runtime_1.jsx)(exports.Transition, Object.assign({ animationStyle: {
            '&-enter': { transform: `translateY(${startValue})` },
            '&-enter-active': {
                transform: `translateY(${endValue})`,
                transition: `all ${timeout}ms ${motions_1.EASE.EXPONENTIAL}`,
            },
            '&-exit': { transform: `translateY(${endValue})` },
            '&-exit-active': {
                pointerEvents: 'none',
                transform: `translateY(${startValue})`,
                transition: `all ${timeout}ms ${motions_1.EASE.EXPONENTIAL}`,
            },
            '&-exit-done': { transform: `translateY(${startValue})` },
        }, timeout: timeout }, props)));
};
exports.YAxisMovement = YAxisMovement;
const XAxisMovement = (_a) => {
    var { startValue = '-100%', endValue = '0%', timeout = motions_1.DURATION.DEFAULT } = _a, props = __rest(_a, ["startValue", "endValue", "timeout"]);
    return ((0, jsx_runtime_1.jsx)(exports.Transition, Object.assign({ animationStyle: {
            '&-enter': { transform: `translateX(${startValue})` },
            '&-enter-active': {
                transform: `translateX(${endValue})`,
                transition: `all ${timeout}ms ${motions_1.EASE.EXPONENTIAL}`,
            },
            '&-exit': { transform: `translateX(${endValue})` },
            '&-exit-active': {
                pointerEvents: 'none',
                transform: `translateX(${startValue})`,
                transition: `all ${timeout}ms ${motions_1.EASE.EXPONENTIAL}`,
            },
            '&-exit-done': { transform: `translateX(${startValue})` },
        }, timeout: timeout }, props)));
};
exports.XAxisMovement = XAxisMovement;
const Slide = (_a) => {
    var { startValue = '-100%', endValue = '0%', timeout = motions_1.DURATION.DEFAULT } = _a, props = __rest(_a, ["startValue", "endValue", "timeout"]);
    return ((0, jsx_runtime_1.jsx)(exports.Transition, Object.assign({ animationStyle: {
            '&-enter': { marginTop: startValue },
            '&-enter-active': {
                marginTop: endValue,
                transition: `all ${timeout}ms ${motions_1.EASE.QUART}`,
            },
            '&-exit': { marginTop: endValue },
            '&-exit-active': {
                marginTop: startValue,
                pointerEvents: 'none',
                transition: `all ${timeout}ms ${motions_1.EASE.QUART}`,
            },
            '&-exit-done': { marginTop: startValue },
        }, timeout: timeout }, props)));
};
exports.Slide = Slide;
const LeftRightMovement = props => (0, jsx_runtime_1.jsx)(exports.XAxisMovement, Object.assign({ startValue: "-100vh", endValue: "0vh" }, props));
exports.LeftRightMovement = LeftRightMovement;
const RightLeftMovement = props => (0, jsx_runtime_1.jsx)(exports.XAxisMovement, Object.assign({ startValue: "100vh", endValue: "0vh" }, props));
exports.RightLeftMovement = RightLeftMovement;
const TopDownMovement = props => (0, jsx_runtime_1.jsx)(exports.YAxisMovement, Object.assign({ startValue: "-100%", endValue: "0%" }, props));
exports.TopDownMovement = TopDownMovement;
const BottomUpMovement = props => (0, jsx_runtime_1.jsx)(exports.YAxisMovement, Object.assign({ startValue: "100%", endValue: "0%" }, props));
exports.BottomUpMovement = BottomUpMovement;
