"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MenuOpenButton = exports.menuOpenButtonStyle = void 0;
const jsx_runtime_1 = require("@emotion/react/jsx-runtime");
const mediaQueries_1 = require("../../mediaQueries");
const util_1 = require("../../util");
const menuOpenButtonStyle = (theme, { open }) => ({
    display: 'block',
    div: {
        backgroundColor: theme.general.color,
        height: '2px',
        margin: '4px',
        transition: 'all 0.25s ease-in-out',
        width: '16px',
    },
    'div:nth-of-type(1)': {
        transform: open ? 'translateY(6px) rotate(-45deg)' : undefined,
    },
    'div:nth-of-type(2)': {
        opacity: open ? 0 : undefined,
        transform: open ? 'scale(0, 1)' : undefined,
    },
    'div:nth-of-type(3)': {
        transform: open ? 'translateY(-6px) rotate(45deg)' : undefined,
    },
    [mediaQueries_1.media[mediaQueries_1.QueryKeys.DESKTOP]]: {
        display: 'none',
    },
    zIndex: 2,
});
exports.menuOpenButtonStyle = menuOpenButtonStyle;
const filterMenuOpenButtonProps = (props) => (0, util_1.filterProps)(props, ['open']);
const MenuOpenButton = (props) => ((0, jsx_runtime_1.jsxs)("div", Object.assign({ css: (theme) => (0, exports.menuOpenButtonStyle)(theme, props) }, filterMenuOpenButtonProps(props), { children: [(0, jsx_runtime_1.jsx)("div", {}), (0, jsx_runtime_1.jsx)("div", {}), (0, jsx_runtime_1.jsx)("div", {})] })));
exports.MenuOpenButton = MenuOpenButton;
