/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.RescaleOp;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Predicate;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.util.CollectionUtils;

final class RoadPainter {
    private int tileHeight;
    private int tileWidth;
    private int halfHeight;
    private int halfWidth;
    private final EnumMap<Direction, Point2D.Float> corners = new EnumMap(Direction.class);
    private final EnumMap<Direction, List<Direction>> prohibitedRoads = new EnumMap(Direction.class);
    private Stroke roadStroke = new BasicStroke(2.0f);

    RoadPainter(Dimension tileSize) {
        this.tileHeight = tileSize.height;
        this.tileWidth = tileSize.width;
        this.halfHeight = this.tileHeight / 2;
        this.halfWidth = this.tileWidth / 2;
        int dy = this.tileHeight / 16;
        this.roadStroke = new BasicStroke((float)dy / 2.0f);
        this.corners.put(Direction.N, new Point2D.Float(this.halfWidth, 0.0f));
        this.corners.put(Direction.NE, new Point2D.Float(0.75f * (float)this.tileWidth, 0.25f * (float)this.tileHeight));
        this.corners.put(Direction.E, new Point2D.Float(this.tileWidth, this.halfHeight));
        this.corners.put(Direction.SE, new Point2D.Float(0.75f * (float)this.tileWidth, 0.75f * (float)this.tileHeight));
        this.corners.put(Direction.S, new Point2D.Float(this.halfWidth, this.tileHeight));
        this.corners.put(Direction.SW, new Point2D.Float(0.25f * (float)this.tileWidth, 0.75f * (float)this.tileHeight));
        this.corners.put(Direction.W, new Point2D.Float(0.0f, this.halfHeight));
        this.corners.put(Direction.NW, new Point2D.Float(0.25f * (float)this.tileWidth, 0.25f * (float)this.tileHeight));
        this.prohibitedRoads.put(Direction.N, Arrays.asList(Direction.NW, Direction.NE));
        this.prohibitedRoads.put(Direction.NE, Arrays.asList(Direction.N, Direction.E));
        this.prohibitedRoads.put(Direction.E, Arrays.asList(Direction.NE, Direction.SE));
        this.prohibitedRoads.put(Direction.SE, Arrays.asList(Direction.E, Direction.S));
        this.prohibitedRoads.put(Direction.S, Arrays.asList(Direction.SE, Direction.SW));
        this.prohibitedRoads.put(Direction.SW, Arrays.asList(Direction.S, Direction.W));
        this.prohibitedRoads.put(Direction.W, Arrays.asList(Direction.SW, Direction.NW));
        this.prohibitedRoads.put(Direction.NW, Arrays.asList(Direction.W, Direction.N));
    }

    void displayRoad(Graphics2D g, Tile tile, RescaleOp rop) {
        Color oldColor = g.getColor();
        g.setColor(ImageLibrary.getRoadColor());
        g.setStroke(this.roadStroke);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Map map = tile.getMap();
        int x = tile.getX();
        int y = tile.getY();
        Predicate<Direction> borderPred = d -> {
            TileImprovement r;
            Tile borderingTile = map.getTile(d.step(x, y));
            return borderingTile != null && (r = borderingTile.getRoad()) != null && r.isComplete();
        };
        List<Direction> directions = CollectionUtils.transform(Direction.allDirections, borderPred);
        List<Point2D.Float> points = CollectionUtils.transform(directions, CollectionUtils.alwaysTrue(), d -> this.corners.get(d));
        GeneralPath path = new GeneralPath();
        switch (points.size()) {
            case 0: {
                path.moveTo(0.35f * (float)this.tileWidth, 0.35f * (float)this.tileHeight);
                path.lineTo(0.65f * (float)this.tileWidth, 0.65f * (float)this.tileHeight);
                path.moveTo(0.35f * (float)this.tileWidth, 0.65f * (float)this.tileHeight);
                path.lineTo(0.65f * (float)this.tileWidth, 0.35f * (float)this.tileHeight);
                break;
            }
            case 1: {
                path.moveTo(this.halfWidth, this.halfHeight);
                path.lineTo(points.get(0).getX(), points.get(0).getY());
                break;
            }
            case 2: {
                path.moveTo(points.get(0).getX(), points.get(0).getY());
                path.quadTo((double)this.halfWidth, (double)this.halfHeight, points.get(1).getX(), points.get(1).getY());
                break;
            }
            case 3: 
            case 4: {
                Direction pen = directions.get(directions.size() - 1);
                Point2D pt = this.corners.get(pen);
                path.moveTo(pt.getX(), pt.getY());
                for (Direction direction : directions) {
                    pt = this.corners.get(direction);
                    if (this.prohibitedRoads.get(pen).contains(direction)) {
                        path.moveTo(pt.getX(), pt.getY());
                    } else {
                        path.quadTo((double)this.halfWidth, (double)this.halfHeight, pt.getX(), pt.getY());
                    }
                    pen = direction;
                }
                break;
            }
            default: {
                for (Point2D point2D : points) {
                    path.moveTo(this.halfWidth, this.halfHeight);
                    path.lineTo(point2D.getX(), point2D.getY());
                }
            }
        }
        g.draw(path);
        g.setColor(oldColor);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }
}

