/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.generator.SimpleMapGenerator;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class MapGeneratorTest
extends FreeColTestCase {
    public void testWithNoIndians() {
        MapGeneratorTest.spec().setFile("model.option.importFile", null);
        Game g = MapGeneratorTest.getStandardGame();
        g.setNationOptions(new NationOptions(MapGeneratorTest.spec()));
        MapGeneratorTest.assertNull((String)"No new map", (Object)g.getMap());
        SimpleMapGenerator gen = new SimpleMapGenerator(new Random(1L));
        for (Nation n : MapGeneratorTest.spec().getNations()) {
            if (!n.getType().isEuropean() || n.getType().isREF() || n.isUnknownEnemy()) continue;
            g.addPlayer(new ServerPlayer(g, false, n));
        }
        gen.generateMap(g, null, true, new LogBuilder(-1));
        MapGeneratorTest.assertNotNull((String)"New map", (Object)g.getMap());
    }

    public void testSinglePlayerOnSmallMap() {
        MapGeneratorTest.spec().setFile("model.option.importFile", null);
        Game g = MapGeneratorTest.getStandardGame();
        g.setNationOptions(new NationOptions(MapGeneratorTest.spec()));
        MapGeneratorTest.assertNull((String)"No new map", (Object)g.getMap());
        SimpleMapGenerator gen = new SimpleMapGenerator(new Random(1L));
        Nation nation = MapGeneratorTest.spec().getNation("model.nation.dutch");
        g.addPlayer(new ServerPlayer(g, false, nation));
        gen.generateMap(g, null, true, new LogBuilder(-1));
        MapGeneratorTest.assertNotNull((String)"New map", (Object)g.getMap());
        MapGeneratorTest.assertNotNull((Object)g.getMap());
        MapGeneratorTest.assertEquals((int)g.getMapGeneratorOptions().getInteger("model.option.mapWidth"), (int)g.getMap().getWidth());
        MapGeneratorTest.assertEquals((int)g.getMapGeneratorOptions().getInteger("model.option.mapHeight"), (int)g.getMap().getHeight());
    }

    public void testMapGenerator() {
        MapGeneratorTest.spec().setFile("model.option.importFile", null);
        Game g = MapGeneratorTest.getStandardGame();
        g.setNationOptions(new NationOptions(MapGeneratorTest.spec()));
        MapGeneratorTest.assertNull((String)"No new map", (Object)g.getMap());
        SimpleMapGenerator gen = new SimpleMapGenerator(new Random(1L));
        gen.generateMap(g, null, true, new LogBuilder(-1));
        MapGeneratorTest.assertNotNull((String)"New map", (Object)g.getMap());
        Map m = g.getMap();
        MapGeneratorTest.assertEquals((int)m.getWidth(), (int)g.getMapGeneratorOptions().getInteger("model.option.mapWidth"));
        MapGeneratorTest.assertEquals((int)m.getHeight(), (int)g.getMapGeneratorOptions().getInteger("model.option.mapHeight"));
        int total = m.getWidth() * m.getHeight();
        int land = m.getTileSet(Tile::isLand).size();
        MapGeneratorTest.assertTrue((100 * land / total >= g.getMapGeneratorOptions().getInteger("model.option.landMass") ? 1 : 0) != 0);
        MapGeneratorTest.assertEquals((int)total, (int)(g.getMapGeneratorOptions().getInteger("model.option.mapWidth") * g.getMapGeneratorOptions().getInteger("model.option.mapHeight")));
    }

    public void testIndianCapital() {
        MapGeneratorTest.spec().setFile("model.option.importFile", null);
        Game g = MapGeneratorTest.getStandardGame();
        g.setNationOptions(new NationOptions(MapGeneratorTest.spec()));
        SimpleMapGenerator gen = new SimpleMapGenerator(new Random(1L));
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>();
        for (Nation nation : MapGeneratorTest.spec().getNations()) {
            if (nation.isUnknownEnemy()) continue;
            ServerPlayer p = new ServerPlayer(g, false, nation);
            p.setAI(!nation.getType().isEuropean() || nation.getType().isREF());
            g.addPlayer(p);
            players.add(p);
        }
        gen.generateMap(g, null, true, new LogBuilder(-1));
        MapGeneratorTest.assertNotNull((Object)g.getMap());
        for (Player player : players) {
            if (!player.isIndian()) continue;
            int settlements = 0;
            int capitals = 0;
            for (IndianSettlement s : player.getIndianSettlementList()) {
                ++settlements;
                if (!s.isCapital()) continue;
                ++capitals;
            }
            if (settlements <= 0) continue;
            MapGeneratorTest.assertEquals((int)1, (int)capitals);
        }
    }

    public void testImportMap() {
        SimpleMapGenerator gen = new SimpleMapGenerator(new Random(1L));
        Map importMap = null;
        ArrayList<File> mapFiles = new ArrayList<File>();
        for (String name : FreeColTestCase.STANDARD_MAPS) {
            mapFiles.add(new File(name));
        }
        for (File importFile : mapFiles) {
            Game game = MapGeneratorTest.getStandardGame();
            Specification spec = game.getSpecification();
            spec.setFile("model.option.importFile", importFile);
            System.gc();
            try {
                importMap = FreeColServer.readMap(importFile, spec);
            }
            catch (IOException | XMLStreamException | FreeColException ex) {
                MapGeneratorTest.fail((String)("Map read of " + importFile.getName() + " failed: " + ex.toString()));
            }
            try {
                MapGeneratorTest.assertNotNull((Object)gen.generateMap(game, importMap, true, new LogBuilder(-1)));
            }
            catch (Exception ex) {
                MapGeneratorTest.fail((String)("Map generate of " + importFile.getName() + " failed: " + ex.toString()));
            }
            spec.setFile("model.option.importFile", null);
        }
    }

    public void testRegions() {
        MapGeneratorTest.spec().setFile("model.option.importFile", null);
        Game game = MapGeneratorTest.getStandardGame();
        SimpleMapGenerator gen = new SimpleMapGenerator(new Random(1L));
        gen.generateMap(game, null, true, new LogBuilder(-1));
        Map map = game.getMap();
        Region pacific = map.getRegionByKey("model.region.pacific");
        MapGeneratorTest.assertNotNull((Object)pacific);
        MapGeneratorTest.assertTrue((boolean)pacific.isPacific());
        MapGeneratorTest.assertEquals((Object)pacific, (Object)pacific.getDiscoverableRegion());
        Region southPacific = map.getRegionByKey("model.region.southPacific");
        MapGeneratorTest.assertNotNull((Object)southPacific);
        MapGeneratorTest.assertFalse((boolean)southPacific.getDiscoverable());
        MapGeneratorTest.assertTrue((boolean)southPacific.isPacific());
        MapGeneratorTest.assertEquals((Object)pacific, (Object)southPacific.getParent());
        MapGeneratorTest.assertEquals((Object)pacific, (Object)southPacific.getDiscoverableRegion());
        Player player = new Player(game, "id");
        ServerUnit unit = new ServerUnit(game, null, player, MapGeneratorTest.spec().getUnitType("model.unit.caravel"));
        MapGeneratorTest.assertTrue((boolean)pacific.checkDiscover(unit));
        List<Region> discovered = pacific.discover(player, unit, new Turn(1));
        MapGeneratorTest.assertEquals((int)1, (int)discovered.size());
        MapGeneratorTest.assertEquals((Object)pacific, (Object)discovered.get(0));
        MapGeneratorTest.assertFalse((boolean)pacific.getDiscoverable());
        MapGeneratorTest.assertNull((Object)pacific.getDiscoverableRegion());
        MapGeneratorTest.assertFalse((boolean)southPacific.getDiscoverable());
        MapGeneratorTest.assertTrue((boolean)southPacific.isPacific());
        MapGeneratorTest.assertEquals((Object)pacific, (Object)southPacific.getParent());
        MapGeneratorTest.assertNull((Object)southPacific.getDiscoverableRegion());
        Region atlantic = map.getRegionByKey("model.region.atlantic");
        MapGeneratorTest.assertNotNull((Object)atlantic);
        MapGeneratorTest.assertFalse((boolean)atlantic.isPacific());
        MapGeneratorTest.assertFalse((boolean)atlantic.getDiscoverable());
        MapGeneratorTest.assertNull((Object)atlantic.getDiscoverableRegion());
        Region northAtlantic = map.getRegionByKey("model.region.northAtlantic");
        MapGeneratorTest.assertNotNull((Object)northAtlantic);
        MapGeneratorTest.assertFalse((boolean)northAtlantic.isPacific());
        MapGeneratorTest.assertFalse((boolean)northAtlantic.getDiscoverable());
        MapGeneratorTest.assertNull((Object)northAtlantic.getDiscoverableRegion());
    }
}

