/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.infonode.gui.FontUtil;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.border.BorderUtil;
import net.infonode.util.ColorUtil;

public class UIManagerUtil {
    private UIManagerUtil() {
    }

    public static Insets getInsets(String key) {
        return InsetsUtil.copy(UIManager.getInsets(key));
    }

    public static Insets getInsets(String key, Insets insets) {
        Insets i = UIManagerUtil.getInsets(key);
        return i == null ? insets : i;
    }

    public static Insets getInsets(String key, String defaultKey) {
        Insets i = UIManagerUtil.getInsets(key);
        if (i != null) {
            return i;
        }
        i = UIManagerUtil.getInsets(defaultKey);
        return i == null ? new Insets(0, 0, 0, 0) : i;
    }

    public static Color getColor(String key) {
        return ColorUtil.copy(UIManager.getColor(key));
    }

    public static Color getColor(String key, String defaultKey) {
        return UIManagerUtil.getColor(key, defaultKey, Color.BLACK);
    }

    public static Color getColor(String key, String defaultKey, Color defaultColor) {
        Color i = UIManagerUtil.getColor(key);
        if (i != null) {
            return i;
        }
        i = UIManagerUtil.getColor(defaultKey);
        return i == null ? defaultColor : i;
    }

    public static Border getBorder(String key) {
        return BorderUtil.copy(UIManager.getBorder(key));
    }

    public static Border getBorder(String key, String defaultKey) {
        Border i = UIManagerUtil.getBorder(key);
        if (i != null) {
            return i;
        }
        i = UIManagerUtil.getBorder(defaultKey);
        return i == null ? BorderFactory.createEmptyBorder() : i;
    }

    public static Font getFont(String key) {
        Font font = UIManager.getFont(key);
        if (font == null) {
            font = new JLabel().getFont();
        }
        return FontUtil.copy(font);
    }

    public static Font getFont(String key, String defaultKey) {
        Font i = UIManagerUtil.getFont(key);
        if (i != null) {
            return i;
        }
        i = UIManagerUtil.getFont(defaultKey);
        return i == null ? new Font("Dialog", 0, 11) : i;
    }

    public static Color getColor(String key, Color defaultColor) {
        Color c = UIManagerUtil.getColor(key);
        return c == null ? defaultColor : c;
    }
}

