/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.componentpainter;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.util.Direction;
import net.infonode.util.ImageUtils;

public abstract class AbstractComponentPainter
implements ComponentPainter,
Serializable {
    private static final long serialVersionUID = 1L;

    protected AbstractComponentPainter() {
    }

    @Override
    public void paint(Component component, Graphics g, int x, int y, int width, int height) {
        this.paint(component, g, x, y, width, height, Direction.RIGHT, false, false);
    }

    @Override
    public void paint(Component component, Graphics g, int x, int y, int width, int height, Direction direction, boolean horizontalFlip, boolean verticalFlip) {
        if (direction != Direction.RIGHT || horizontalFlip || verticalFlip) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform t = g2.getTransform();
            try {
                int w = direction.isHorizontal() ? width : height;
                int h = direction.isHorizontal() ? height : width;
                AffineTransform nt = ImageUtils.createTransform(direction, horizontalFlip, verticalFlip, w, h);
                g2.translate(x, y);
                g2.transform(nt);
                this.paint(component, g, 0, 0, w, h);
            }
            finally {
                g2.setTransform(t);
            }
        } else {
            this.paint(component, g, x, y, width, height);
        }
    }

    @Override
    public boolean isOpaque(Component component) {
        return true;
    }
}

