/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.componentpainter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.lang.ref.SoftReference;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.componentpainter.AbstractComponentPainter;
import net.infonode.util.ColorUtil;
import net.infonode.util.Direction;
import net.infonode.util.ImageUtils;

public class GradientComponentPainter
extends AbstractComponentPainter {
    private static final long serialVersionUID = 1L;
    private final ColorProvider[] colorProviders = new ColorProvider[4];
    private transient Color[] colors;
    private final int size = 128;
    private transient SoftReference[] images;
    private transient boolean hasAlpha;

    public GradientComponentPainter(Color topLeftColor, Color topRightColor, Color bottomLeftColor, Color bottomRightColor) {
        this(new FixedColorProvider(topLeftColor), new FixedColorProvider(topRightColor), new FixedColorProvider(bottomLeftColor), new FixedColorProvider(bottomRightColor));
    }

    public GradientComponentPainter(ColorProvider topLeftColor, ColorProvider topRightColor, ColorProvider bottomLeftColor, ColorProvider bottomRightColor) {
        this.colorProviders[0] = topLeftColor;
        this.colorProviders[1] = topRightColor;
        this.colorProviders[2] = bottomLeftColor;
        this.colorProviders[3] = bottomRightColor;
    }

    @Override
    public void paint(Component component, Graphics g, int x, int y, int width, int height, Direction direction, boolean horizontalFlip, boolean verticalFlip) {
        this.updateColors(component);
        if (this.colors[0] != null && this.colors[1] != null && this.colors[2] != null && this.colors[3] != null) {
            if (this.colors[0].equals(this.colors[2]) && this.colors[1].equals(this.colors[3]) && this.colors[0].equals(this.colors[1])) {
                g.setColor(this.colors[0]);
                g.fillRect(x, y, width, height);
            } else {
                Image image;
                int imageIndex = direction.getValue() + (horizontalFlip ? 4 : 0) + (verticalFlip ? 8 : 0);
                SoftReference ref = this.images[imageIndex];
                Image image2 = image = ref == null ? null : (Image)ref.get();
                if (image == null) {
                    image = this.createGradientImage(this.fixColors(direction, horizontalFlip, verticalFlip));
                    this.images[imageIndex] = new SoftReference<Image>(image);
                }
                g.drawImage(image, x, y, width, height, null);
            }
        }
    }

    private Color[] fixColors(Direction direction, boolean horizontalFlip, boolean verticalFlip) {
        Color t;
        Color[] c = new Color[4];
        if (horizontalFlip) {
            c[0] = this.colors[1];
            c[1] = this.colors[0];
            c[2] = this.colors[3];
            c[3] = this.colors[2];
        } else {
            c[0] = this.colors[0];
            c[1] = this.colors[1];
            c[2] = this.colors[2];
            c[3] = this.colors[3];
        }
        if (verticalFlip) {
            t = c[2];
            c[2] = c[0];
            c[0] = t;
            t = c[3];
            c[3] = c[1];
            c[1] = t;
        }
        if (direction == Direction.RIGHT) {
            return c;
        }
        if (direction == Direction.DOWN) {
            t = c[0];
            c[0] = c[2];
            c[2] = c[3];
            c[3] = c[1];
            c[1] = t;
        } else if (direction == Direction.LEFT) {
            t = c[0];
            c[0] = c[3];
            c[3] = t;
            t = c[1];
            c[1] = c[2];
            c[2] = t;
        } else if (direction == Direction.UP) {
            t = c[0];
            c[0] = c[1];
            c[1] = c[3];
            c[3] = c[2];
            c[2] = t;
        }
        return c;
    }

    private Image createGradientImage(Color[] colors) {
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(128, 128, ImageUtils.createGradientPixels(colors, 128, 128), 0, 128));
    }

    private void updateColors(Component component) {
        if (this.images == null) {
            this.images = new SoftReference[16];
        }
        if (this.colors == null) {
            this.colors = new Color[4];
        }
        int i = 0;
        while (i < this.colors.length) {
            Color c = this.colorProviders[i].getColor(component);
            if (c != null && !c.equals(this.colors[i])) {
                int j = 0;
                while (j < this.images.length) {
                    this.images[j] = null;
                    ++j;
                }
            }
            this.colors[i] = c;
            this.hasAlpha |= c != null && c.getAlpha() != 255;
            ++i;
        }
    }

    @Override
    public boolean isOpaque(Component component) {
        this.updateColors(component);
        return !this.hasAlpha;
    }

    @Override
    public Color getColor(Component component) {
        this.updateColors(component);
        return ColorUtil.blend(ColorUtil.blend(this.colors[0], this.colors[1], 0.5), ColorUtil.blend(this.colors[2], this.colors[3], 0.5), 0.5);
    }
}

