/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.util.collection;

import java.util.Collection;
import java.util.Iterator;
import net.infonode.util.collection.Closure;

public final class CopyOnWriteArrayList {
    private Object[] elements;
    private int size;

    public CopyOnWriteArrayList(int initialCapacity) {
        this.elements = new Object[initialCapacity];
    }

    public void removeAll(Collection toRemove) {
        Object[] ne = new Object[this.size - toRemove.size()];
        int j = 0;
        int i = 0;
        while (i < this.size) {
            if (!toRemove.contains(this.elements[i])) {
                ne[j++] = this.elements[i];
            }
            ++i;
        }
        this.size = j;
        this.elements = ne;
    }

    public void add(Object element) {
        if (this.size >= this.elements.length) {
            Object[] newElements = new Object[CopyOnWriteArrayList.getPreferredSize(this.size)];
            System.arraycopy(this.elements, 0, newElements, 0, this.size);
            this.elements = newElements;
        }
        this.elements[this.size++] = element;
    }

    public boolean remove(Object element) {
        int index = this.indexOf(element);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public void remove(int index) {
        --this.size;
        Object[] newElements = new Object[CopyOnWriteArrayList.getPreferredSize(this.size)];
        System.arraycopy(this.elements, 0, newElements, 0, index);
        System.arraycopy(this.elements, index + 1, newElements, index, this.size - index);
        this.elements = newElements;
    }

    public int indexOf(Object element) {
        int i = 0;
        while (i < this.size) {
            if (this.elements[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void each(Closure closure) {
        Object[] l = this.elements;
        int s = this.size;
        int i = 0;
        while (i < s) {
            closure.apply(l[i]);
            ++i;
        }
    }

    public Iterator iterator() {
        return new IteratorImpl(this.elements, this.size, 0);
    }

    private static int getPreferredSize(int size) {
        return size * 3 / 2 + 1;
    }

    public int size() {
        return this.size;
    }

    public Object get(int index) {
        return this.elements[index];
    }

    public Object[] getElements() {
        return this.elements;
    }

    private static class IteratorImpl
    implements Iterator {
        private Object[] e;
        private int size;
        private int index;

        IteratorImpl(Object[] e, int size, int index) {
            this.e = e;
            this.size = size;
            this.index = index;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        public Object next() {
            return this.e[this.index++];
        }
    }
}

