/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.FrameworkContext;
import org.osgi.dto.DTO;
import org.osgi.framework.Version;

public class Util {
    private static final String DOUBLE_TYPE = "Double";
    private static final String LONG_TYPE = "Long";
    private static final String LIST_TYPE = "List";
    private static final String STRING_TYPE = "String";
    private static final String VERSION_TYPE = "Version";
    public static final String FWDIR_PROP = "org.osgi.framework.dir";
    public static final String FWDIR_DEFAULT = "fwdir";
    private static final Method nanoTimeMethod = Util.getMethod(System.class, "nanoTime", new Class[0]);
    protected static String WHITESPACE = " \t\n\r";
    protected static char CITCHAR = (char)34;
    private static final byte[] encTab = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public static String getFrameworkDir(Map<String, String> props) {
        String s = props.get("org.osgi.framework.storage");
        if (s == null || s.length() == 0) {
            s = props.get(FWDIR_PROP);
        }
        if (s == null || s.length() == 0) {
            s = System.getProperty(FWDIR_PROP);
        }
        if (s == null || s.length() == 0) {
            s = FWDIR_DEFAULT;
        }
        return s;
    }

    public static String getFrameworkDir(FrameworkContext ctx) {
        String s = ctx.props.getProperty("org.osgi.framework.storage");
        if (s == null || s.length() == 0) {
            s = ctx.props.getProperty(FWDIR_PROP);
        }
        if (s == null || s.length() == 0) {
            s = FWDIR_DEFAULT;
        }
        return s;
    }

    public static FileTree getFileStorage(FrameworkContext ctx, String name, boolean create) {
        String fwdir = Util.getFrameworkDir(ctx);
        if (fwdir == null) {
            return null;
        }
        FileTree dir = new FileTree(new File(fwdir).getAbsoluteFile(), name);
        if (dir != null) {
            if (dir.exists()) {
                if (!dir.isDirectory()) {
                    throw new RuntimeException("Not a directory: " + dir);
                }
            } else if (create && !dir.mkdirs()) {
                throw new RuntimeException("Cannot create directory: " + dir);
            }
        }
        return dir;
    }

    public static FileTree getFileStorage(FrameworkContext ctx, String name) {
        return Util.getFileStorage(ctx, name, true);
    }

    public static int compareStringVersion(String ver1, String ver2) throws NumberFormatException {
        while (ver1 != null || ver2 != null) {
            int i2;
            int i1;
            if (ver1 != null) {
                int d1 = ver1.indexOf(".");
                if (d1 == -1) {
                    i1 = Integer.parseInt(ver1.trim());
                    ver1 = null;
                } else {
                    i1 = Integer.parseInt(ver1.substring(0, d1).trim());
                    ver1 = ver1.substring(d1 + 1);
                }
            } else {
                i1 = 0;
            }
            if (ver2 != null) {
                int d2 = ver2.indexOf(".");
                if (d2 == -1) {
                    i2 = Integer.parseInt(ver2.trim());
                    ver2 = null;
                } else {
                    i2 = Integer.parseInt(ver2.substring(0, d2).trim());
                    ver2 = ver2.substring(d2 + 1);
                }
            } else {
                i2 = 0;
            }
            if (i1 < i2) {
                return -1;
            }
            if (i1 <= i2) continue;
            return 1;
        }
        return 0;
    }

    public static Set<String> parseEnumeration(String d, String s) {
        HashSet<String> result = new HashSet<String>();
        if (s != null) {
            AttributeTokenizer at = new AttributeTokenizer(s);
            do {
                String key;
                if ((key = at.getKey(true)) == null) {
                    throw new IllegalArgumentException("Directive " + d + ", unexpected character at: " + at.getRest());
                }
                if (!at.getEntryEnd()) {
                    throw new IllegalArgumentException("Directive " + d + ", expected end of entry at: " + at.getRest());
                }
                result.add(key);
            } while (!at.getEnd());
            return result;
        }
        return null;
    }

    public static List<HeaderEntry> parseManifestHeader(String a, String s, boolean single, boolean unique, boolean single_entry) {
        ArrayList<HeaderEntry> res = new ArrayList<HeaderEntry>();
        if (s != null) {
            AttributeTokenizer at = new AttributeTokenizer(s);
            do {
                String param;
                HeaderEntry he = new HeaderEntry(a, single);
                String key = at.getKey(single);
                if (key == null) {
                    String msg = "Definition, " + a + ", expected key at: " + at.getRest() + ". Key values are terminated " + "by a ';' or a ',' and may not " + "contain unquoted ':', '=' if multiple keys are allowed.";
                    throw new IllegalArgumentException(msg);
                }
                he.keys.add(key);
                if (!single) {
                    while ((key = at.getKey(false)) != null) {
                        he.keys.add(key);
                    }
                }
                while ((param = at.getParam()) != null) {
                    String msg;
                    boolean is_directive = at.isDirective();
                    if (is_directive) {
                        if (he.directives.containsKey(param)) {
                            String msg2 = "Definition, " + a + ", duplicate directive: " + param;
                            throw new IllegalArgumentException(msg2);
                        }
                        String valueStr = at.getValue(false);
                        if (valueStr == null) {
                            msg = "Definition, " + a + ", expected value for " + " directive " + param + " at: " + at.getRest();
                            throw new IllegalArgumentException(msg);
                        }
                        he.directives.put(param, valueStr);
                        continue;
                    }
                    Object old = he.attributes.get(param);
                    if (old != null && unique) {
                        msg = "Definition, " + a + ", duplicate attribute: " + param;
                        throw new IllegalArgumentException(msg);
                    }
                    String paramType = at.getParamType();
                    boolean keepEscape = paramType != null && paramType.startsWith(LIST_TYPE);
                    String valueStr = at.getValue(keepEscape);
                    if (valueStr == null) {
                        String msg3 = "Definition, " + a + ", expected value for " + " attribute " + param + " at: " + at.getRest();
                        throw new IllegalArgumentException(msg3);
                    }
                    Object value = Util.toValue(a, param, paramType, valueStr);
                    if (unique) {
                        he.attributes.put(param, value);
                        continue;
                    }
                    ArrayList<Object> oldValues = (ArrayList<Object>)old;
                    if (oldValues == null) {
                        oldValues = new ArrayList<Object>();
                        he.attributes.put(param, oldValues);
                    }
                    oldValues.add(value);
                }
                if (!at.getEntryEnd()) {
                    throw new IllegalArgumentException("Definition, " + a + ", expected end of entry at: " + at.getRest());
                }
                res.add(he);
                if (!single_entry || at.getEnd()) continue;
                throw new IllegalArgumentException("Definition, " + a + ", expected end of single entry at: " + at.getRest());
            } while (!at.getEnd());
        }
        return res;
    }

    private static Object toValue(String a, String param, String type, String value) {
        ArrayList<Object> res;
        String string = type = type == null ? STRING_TYPE : type.intern();
        if (STRING_TYPE == type) {
            res = value;
        } else if (LONG_TYPE == type) {
            try {
                res = new Long(value.trim());
            }
            catch (Exception e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Definition, " + a + ", expected value of type Long but found '" + value + "' for attribute '" + param + "'.").initCause(e);
            }
        } else if (DOUBLE_TYPE == type) {
            try {
                res = new Double(value.trim());
            }
            catch (Exception e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Definition, " + a + ", expected value of type Double but found '" + value + "' for attribute '" + param + "'.").initCause(e);
            }
        } else if (VERSION_TYPE == type) {
            try {
                res = new Version(value);
            }
            catch (Exception e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Definition, " + a + ", expected value of type Version but found '" + value + "' for attribute '" + param + "'.").initCause(e);
            }
        } else if (type.startsWith(LIST_TYPE)) {
            String elemType = type.substring(LIST_TYPE.length()).trim();
            if (elemType.length() > 0) {
                if ('<' != elemType.charAt(0) || elemType.charAt(elemType.length() - 1) != '>') {
                    throw new IllegalArgumentException("Definition, " + a + ", expected List type definition '" + type + "' for attribute '" + param + "'.");
                }
                elemType = elemType.substring(1, elemType.length() - 1).trim().intern();
            }
            if (elemType.length() == 0) {
                elemType = STRING_TYPE;
            }
            try {
                List<String> elements = Util.splitWords(value, ',', STRING_TYPE != elemType);
                ArrayList<Object> l = new ArrayList<Object>(elements.size());
                for (String elem : elements) {
                    l.add(Util.toValue(a, param, elemType, elem));
                }
                res = l;
            }
            catch (Exception e) {
                throw (IllegalArgumentException)new IllegalArgumentException("Definition, " + a + ", expected '" + type + "' value but found '" + value + "' for attribute '" + param + "'.").initCause(e);
            }
        } else {
            throw new IllegalArgumentException("Definition, " + a + ", unknown type '" + type + "' for attribute '" + param + "'.");
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readResource(String name) throws IOException {
        byte[] buf = new byte[1024];
        InputStream in = Util.class.getResourceAsStream(name);
        try {
            int n;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((n = in.read(buf)) > 0) {
                bout.write(buf, 0, n);
            }
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ignored) {}
        }
    }

    static String readResource(String file, String defaultValue, String encoding) {
        try {
            return new String(Util.readResource(file), encoding).trim();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    static String readFrameworkVersion() {
        return Util.readResource("/version", "0.0.0", "UTF-8");
    }

    static String readTstampYear() {
        String year = Util.readResource("/tstamp", "2013", "UTF-8");
        int pos = year.indexOf(44);
        if (pos > -1 && (pos = (year = year.substring(0, pos)).lastIndexOf(32)) > -1) {
            year = year.substring(pos + 1);
        }
        return year;
    }

    public static String[] splitwords(String s) {
        return Util.splitwords(s, WHITESPACE);
    }

    public static String[] splitwords(String s, String whiteSpace) {
        return Util.splitwords(s, whiteSpace, CITCHAR);
    }

    public static String[] splitwords(String s, String whiteSpace, char citChar) {
        boolean bCit = false;
        Vector<String> v = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (bCit || whiteSpace.indexOf(c) == -1) {
                if (c == citChar) {
                    bCit = !bCit;
                } else {
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    buf.append(c);
                }
                ++i;
                continue;
            }
            if (buf != null) {
                v.addElement(buf.toString());
                buf = null;
            }
            while (i < s.length() && -1 != whiteSpace.indexOf(s.charAt(i))) {
                ++i;
            }
        }
        if (buf != null) {
            v.addElement(buf.toString());
        }
        Object[] r = new String[v.size()];
        v.copyInto(r);
        return r;
    }

    public static List<String> splitWords(String s, char sepChar, boolean trim) {
        ArrayList<String> res = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        int length = s.length();
        boolean esc = false;
        int end = 0;
        for (int pos = 0; pos < length; ++pos) {
            if (esc) {
                esc = false;
                buf.append(s.charAt(pos));
                end = buf.length();
                continue;
            }
            char c = s.charAt(pos);
            if (c == '\\') {
                esc = true;
                continue;
            }
            if (c == sepChar) {
                if (trim) {
                    buf.setLength(end);
                }
                res.add(buf.toString());
                buf.setLength(0);
                end = 0;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (buf.length() <= 0 && trim) continue;
                buf.append(c);
                continue;
            }
            buf.append(c);
            end = buf.length();
        }
        if (esc) {
            throw new IllegalArgumentException("Value ends on escape character");
        }
        if (trim) {
            buf.setLength(end);
        }
        res.add(buf.toString());
        return res;
    }

    public static String replace(String s, String v1, String v2) {
        if (s == null || v1 == null || v2 == null || v1.length() == 0 || v1.equals(v2)) {
            return s;
        }
        int ix = 0;
        int v1Len = v1.length();
        int n = 0;
        while (-1 != (ix = s.indexOf(v1, ix))) {
            ++n;
            ix += v1Len;
        }
        if (n == 0) {
            return s;
        }
        int start = 0;
        int v2Len = v2.length();
        char[] r = new char[s.length() + n * (v2Len - v1Len)];
        int rPos = 0;
        while (-1 != (ix = s.indexOf(v1, start))) {
            while (start < ix) {
                r[rPos++] = s.charAt(start++);
            }
            for (int j = 0; j < v2Len; ++j) {
                r[rPos++] = v2.charAt(j);
            }
            start += v1Len;
        }
        ix = s.length();
        while (start < ix) {
            r[rPos++] = s.charAt(start++);
        }
        return new String(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContent(File f) {
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(f));
            String string = ((DataInputStream)in).readUTF();
            return string;
        }
        catch (IOException ignore) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static void putContent(File f, String content) throws IOException {
        Util.putContent(f, content, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putContent(File f, String content, boolean useUTF8) throws IOException {
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(f));
            if (useUTF8) {
                ((DataOutputStream)out).writeUTF(content);
            } else {
                ((DataOutputStream)out).writeChars(content);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static <A> void sort(List<A> a, Comparator<A, A> cf, boolean bReverse) {
        Util.sort(a, 0, a.size() - 1, cf, bReverse ? -1 : 1);
    }

    static <A> void sort(List<A> a, int lo0, int hi0, Comparator<A, A> cf, int k) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            A mid = a.get((lo0 + hi0) / 2);
            while (lo <= hi) {
                while (lo < hi0 && k * cf.compare(a.get(lo), mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && k * cf.compare(a.get(hi), mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Util.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Util.sort(a, lo0, hi, cf, k);
            }
            if (lo < hi0) {
                Util.sort(a, lo, hi0, cf, k);
            }
        }
    }

    private static <A> void swap(List<A> a, int i, int j) {
        A tmp = a.get(i);
        a.set(i, a.get(j));
        a.set(j, tmp);
    }

    public static <A, B> int binarySearch(List<A> pl, Comparator<A, B> c, B k) {
        int l = 0;
        int u = pl.size() - 1;
        while (l <= u) {
            int m = (l + u) / 2;
            int v = c.compare(pl.get(m), k);
            if (v > 0) {
                l = m + 1;
                continue;
            }
            if (v < 0) {
                u = m - 1;
                continue;
            }
            return m;
        }
        return -(l + 1);
    }

    public static String base64Encode(String s) throws IOException {
        return Util.encode(s.getBytes(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encode(byte[] in, int len) throws IOException {
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream bais = null;
        try {
            baos = new ByteArrayOutputStream();
            bais = new ByteArrayInputStream(in);
            Util.encode(bais, baos, len);
            String string = new String(baos.toByteArray());
            return string;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (bais != null) {
                bais.close();
            }
        }
    }

    public static void encode(InputStream in, OutputStream out, int len) throws IOException {
        int b;
        if (len % 4 != 0) {
            throw new IllegalArgumentException("Length must be a multiple of 4");
        }
        int bits = 0;
        int nbits = 0;
        int nbytes = 0;
        while ((b = in.read()) != -1) {
            bits = bits << 8 | b;
            nbits += 8;
            while (nbits >= 6) {
                out.write(encTab[0x3F & bits >> (nbits -= 6)]);
                if (len == 0 || ++nbytes < len) continue;
                out.write(13);
                out.write(10);
                nbytes -= len;
            }
        }
        switch (nbits) {
            case 2: {
                out.write(encTab[0x3F & bits << 4]);
                out.write(61);
                out.write(61);
                break;
            }
            case 4: {
                out.write(encTab[0x3F & bits << 2]);
                out.write(61);
            }
        }
        if (len != 0) {
            if (nbytes != 0) {
                out.write(13);
                out.write(10);
            }
            out.write(13);
            out.write(10);
        }
    }

    static <A, B> void mergeDictionaries(Dictionary<A, B> target, Dictionary<A, B> extra) {
        Enumeration<A> e = extra.keys();
        while (e.hasMoreElements()) {
            A key = e.nextElement();
            if (target.get(key) != null) continue;
            target.put(key, extra.get(key));
        }
    }

    public static boolean filterMatch(String filter, String s) {
        return Util.patSubstr(s.toCharArray(), 0, filter.toCharArray(), 0);
    }

    private static boolean patSubstr(char[] s, int si, char[] pat, int pi) {
        if (pat.length - pi == 0) {
            return s.length - si == 0;
        }
        if (pat[pi] == '*') {
            ++pi;
            while (true) {
                if (Util.patSubstr(s, si, pat, pi)) {
                    return true;
                }
                if (s.length - si == 0) {
                    return false;
                }
                ++si;
            }
        }
        if (s.length - si == 0) {
            return false;
        }
        if (s[si] != pat[pi]) {
            return false;
        }
        return Util.patSubstr(s, ++si, pat, ++pi);
    }

    public static Method getMethod(Class<?> c, String name, Class<?>[] args) {
        Method m = null;
        while (true) {
            try {
                m = c.getDeclaredMethod(name, args);
            }
            catch (NoSuchMethodException e) {
                if ((c = c.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
        m.setAccessible(true);
        return m;
    }

    public static long timeMillis() {
        if (nanoTimeMethod != null) {
            try {
                Object res = nanoTimeMethod.invoke(null, new Object[0]);
                if (res != null) {
                    return (Long)res / 1000000L;
                }
            }
            catch (IllegalAccessException _ignore) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return System.currentTimeMillis();
    }

    public static Map<String, Object> safeDTOMap(Map<String, Object> m) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : m.entrySet()) {
            res.put(e.getKey(), Util.safeDTOObject(e.getValue()));
        }
        return res;
    }

    public static Object safeDTOObject(Object val) {
        Class<?> c = val.getClass();
        String[] res = val;
        if (c.isArray()) {
            if (!Util.validDTOType(c.getComponentType())) {
                Object[] oa = val;
                String[] sa = new String[oa.length];
                for (int i = 0; i < sa.length; ++i) {
                    sa[i] = oa[i].toString();
                }
                res = sa;
            }
        } else if (!Util.validDTOType(c)) {
            res = val.toString();
        }
        return res;
    }

    public static boolean validDTOType(Class c) {
        return c == String.class || c == Boolean.class || c.isPrimitive() && c != Boolean.TYPE && c != Character.TYPE || Number.class.isAssignableFrom(c) || DTO.class.isAssignableFrom(c);
    }

    public static class HeaderEntry {
        final String headerName;
        final boolean singleKey;
        final List<String> keys = new ArrayList<String>();
        final Map<String, Object> attributes = new HashMap<String, Object>();
        final Map<String, String> directives = new HashMap<String, String>();

        HeaderEntry(String headerName, boolean singleKey) {
            this.headerName = headerName;
            this.singleKey = singleKey;
        }

        public String getKey() {
            if (this.singleKey) {
                return this.keys.get(0);
            }
            throw new IllegalArgumentException("Requesting single key for multi key header clause");
        }

        public List<String> getKeys() {
            return this.keys;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public Map<String, String> getDirectives() {
            return this.directives;
        }
    }

    static class AttributeTokenizer {
        final String s;
        int length;
        int pos = 0;

        AttributeTokenizer(String input) {
            this.s = input;
            this.length = this.s.length();
        }

        String getWord(boolean keepEscapse, boolean valueWord) {
            this.skipWhite();
            boolean backslash = false;
            boolean quote = false;
            StringBuffer val = new StringBuffer();
            int end = 0;
            block5: while (this.pos < this.length) {
                if (backslash) {
                    backslash = false;
                    if (keepEscapse) {
                        val.append('\\');
                    }
                    val.append(this.s.charAt(this.pos));
                    end = val.length();
                } else {
                    char c = this.s.charAt(this.pos);
                    switch (c) {
                        case '\"': {
                            quote = !quote;
                            end = val.length();
                            break;
                        }
                        case '\\': {
                            backslash = true;
                            break;
                        }
                        case ',': 
                        case ':': 
                        case ';': 
                        case '=': {
                            if (!quote && (!valueWord || c != ':' && c != '=')) break block5;
                        }
                        default: {
                            val.append(c);
                            if (Character.isWhitespace(c)) break;
                            end = val.length();
                        }
                    }
                }
                ++this.pos;
            }
            if (quote || backslash || end == 0) {
                return null;
            }
            val.setLength(end);
            return val.toString();
        }

        String getKey(boolean singleKey) {
            String res;
            if (this.pos >= this.length) {
                return null;
            }
            int save = this.pos;
            if (this.s.charAt(this.pos) == ';') {
                ++this.pos;
            }
            if ((res = this.getWord(false, singleKey)) != null) {
                if (this.pos == this.length) {
                    return res;
                }
                char c = this.s.charAt(this.pos);
                if (c == ';' || c == ',') {
                    return res;
                }
            }
            this.pos = save;
            return null;
        }

        String getParam() {
            if (this.pos == this.length || this.s.charAt(this.pos) != ';') {
                return null;
            }
            int save = this.pos++;
            String res = this.getWord(false, false);
            if (res != null) {
                if (this.pos < this.length && this.s.charAt(this.pos) == '=') {
                    return res;
                }
                if (this.pos < this.length && this.s.charAt(this.pos) == ':') {
                    return res;
                }
            }
            this.pos = save;
            return null;
        }

        boolean isDirective() {
            if (this.pos + 1 < this.length && this.s.charAt(this.pos) == ':' && this.s.charAt(this.pos + 1) == '=') {
                ++this.pos;
                return true;
            }
            return false;
        }

        String getParamType() {
            if (this.pos == this.length || this.s.charAt(this.pos) != ':') {
                return null;
            }
            int save = this.pos++;
            String res = this.getWord(false, false);
            if (res != null && this.pos < this.length && this.s.charAt(this.pos) == '=') {
                return res;
            }
            this.pos = save;
            return null;
        }

        String getValue() {
            return this.getValue(false);
        }

        String getValue(boolean keepEscapes) {
            if (this.s.charAt(this.pos) != '=') {
                return null;
            }
            int save = this.pos++;
            this.skipWhite();
            String val = this.getWord(keepEscapes, true);
            if (val == null) {
                this.pos = save;
                return null;
            }
            return val;
        }

        boolean getEntryEnd() {
            int save = this.pos;
            this.skipWhite();
            if (this.pos == this.length) {
                return true;
            }
            if (this.s.charAt(this.pos) == ',') {
                ++this.pos;
                return true;
            }
            this.pos = save;
            return false;
        }

        boolean getEnd() {
            int save = this.pos;
            this.skipWhite();
            if (this.pos == this.length) {
                return true;
            }
            this.pos = save;
            return false;
        }

        String getRest() {
            String res = this.s.substring(this.pos).trim();
            return res.length() == 0 ? "<END OF LINE>" : res;
        }

        private void skipWhite() {
            while (this.pos < this.length && Character.isWhitespace(this.s.charAt(this.pos))) {
                ++this.pos;
            }
        }
    }

    public static interface Comparator<A, B> {
        public int compare(A var1, B var2);
    }
}

