/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework.bundlestorage.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.knopflerfish.framework.AutoManifest;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleResourceStream;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.bundlestorage.file.BundleArchiveImpl;

public class Archive
implements FileArchive {
    private static final String ARCHIVE = "jar";
    private static final String SUBDIR = "sub";
    private static final String CERTS_SUFFIX = ".crt";
    private static final String META_INF_DIR = "META-INF/";
    private static final String OSGI_OPT_DIR = "OSGI-OPT/";
    protected FileTree bundleDir;
    protected FileTree file;
    private boolean fileIsReference = false;
    protected ZipFile jar = null;
    private Certificate[] certs = null;
    Manifest manifest;
    private ZipEntry subJar;
    private boolean bClosed = false;
    private Map<String, String> nativeLibs;
    private Map<String, String> renameLibs;
    private final BundleArchiveImpl ba;
    protected int subId;
    protected int revision;

    protected Archive(BundleArchiveImpl ba, FileTree dir, int rev) {
        this.ba = ba;
        this.bundleDir = dir;
        this.revision = rev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadArchive(InputStream is, URL source) throws IOException {
        FileTree sourceFile;
        this.subId = 0;
        boolean isDirectory = false;
        FileTree bsFile = new FileTree(this.bundleDir, ARCHIVE + this.revision);
        if (this.isReference(source)) {
            this.fileIsReference = true;
            this.file = sourceFile = new FileTree(this.getFile(source));
        } else {
            sourceFile = this.isFile(source) ? new FileTree(this.getFile(source)) : null;
            this.file = bsFile;
        }
        if (sourceFile != null && (isDirectory = sourceFile.isDirectory())) {
            File mfd = new File(sourceFile.getAbsolutePath(), META_INF_DIR);
            File mf = new File(mfd, "MANIFEST.MF");
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(mf));
            try {
                this.manifest = new Manifest(bis);
            }
            finally {
                bis.close();
            }
        }
        BufferedInputStream bis = null;
        boolean doUnpack = false;
        JarInputStream ji = null;
        if (this.manifest == null) {
            bis = new BufferedInputStream(is);
            if (this.ba.storage.alwaysUnpack) {
                ji = new JarInputStream((InputStream)bis, this.ba.storage.checkSigned);
                this.manifest = ji.getManifest();
                doUnpack = true;
            } else if (this.ba.storage.unpack) {
                bis.mark(1000000);
                ji = new JarInputStream((InputStream)bis, this.ba.storage.checkSigned);
                this.manifest = ji.getManifest();
                if (this.manifest != null && !this.needUnpack(this.manifest.getMainAttributes())) {
                    bis.reset();
                } else {
                    doUnpack = true;
                }
            }
            if (doUnpack) {
                if (this.ba.storage.isReadOnly()) {
                    throw new IOException("Bundle storage is read-only, no archive unpack.");
                }
                if (this.fileIsReference) {
                    this.fileIsReference = false;
                    this.file = bsFile;
                }
                this.file.mkdirs();
                if (this.manifest == null) {
                    if (this.ba.storage.checkSigned) {
                        throw new IOException("MANIFEST.MF must be first in archive when using signatures.");
                    }
                } else {
                    File f = new File(this.file, META_INF_DIR);
                    f.mkdir();
                    FileOutputStream fo = new FileOutputStream(new File(f, "MANIFEST.MF"));
                    BufferedOutputStream o = new BufferedOutputStream(fo);
                    try {
                        this.manifest.write(o);
                    }
                    finally {
                        o.close();
                    }
                }
                boolean verify = this.ba.storage.checkSigned;
                int verifiedEntries = 0;
                while (this.processNextJarEntry(ji, verify, this.file)) {
                    if (!verify) continue;
                    if (this.isArchiveSigned()) {
                        ++verifiedEntries;
                        continue;
                    }
                    verify = false;
                }
                if (verify) {
                    this.checkCertificates(verifiedEntries);
                }
            }
        }
        if (!doUnpack) {
            if (isDirectory) {
                if (!this.fileIsReference) {
                    if (this.ba.storage.isReadOnly()) {
                        throw new IOException("Bundle storage is read-only, unable to save archive.");
                    }
                    sourceFile.copyTo(this.file);
                }
                if (this.ba.storage.checkSigned) {
                    // empty if block
                }
            } else {
                if (!this.fileIsReference) {
                    this.loadFile(this.file, bis);
                }
                if (this.ba.storage.checkSigned) {
                    this.processSignedJar(this.file);
                }
                this.jar = new ZipFile(this.file);
            }
        }
        this.manifest = this.manifest != null ? new AutoManifest(this.ba.storage.framework, this.manifest, this.ba.location) : this.getManifest();
        this.checkManifest();
        this.handleAutoManifest();
        this.saveCertificates();
        if (ji != null) {
            ji.close();
        } else if (bis != null) {
            bis.close();
        }
    }

    protected void restoreArchive() throws IOException {
        this.subId = 0;
        String[] f = this.bundleDir.list();
        this.file = null;
        if (this.revision != -1) {
            this.file = new FileTree(this.bundleDir, ARCHIVE + this.revision);
        } else {
            this.revision = Integer.MAX_VALUE;
            for (String element : f) {
                if (!element.startsWith(ARCHIVE)) continue;
                try {
                    int c = Integer.parseInt(element.substring(ARCHIVE.length()));
                    if (c >= this.revision) continue;
                    this.revision = c;
                    this.file = new FileTree(this.bundleDir, element);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
        }
        for (String element : f) {
            if (element.startsWith(ARCHIVE)) {
                try {
                    int c = Integer.parseInt(element.substring(ARCHIVE.length()));
                    if (c != this.revision) {
                        new FileTree(this.bundleDir, element).delete();
                    }
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            if (!element.startsWith(SUBDIR)) continue;
            try {
                int c = Integer.parseInt(element.substring(SUBDIR.length()));
                if (c == this.revision) continue;
                new FileTree(this.bundleDir, element).delete();
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        if (this.file == null) {
            try {
                URL url = new URL(this.ba.location);
                if (this.isReference(url)) {
                    this.file = new FileTree(this.getFile(url));
                }
            }
            catch (Exception e) {
                throw new IOException("Bad file URL stored in referenced jar in: " + this.bundleDir.getAbsolutePath() + ", location=" + this.ba.location + ", e=" + e);
            }
            if (this.file == null || !this.file.exists()) {
                throw new IOException("No saved jar file found in: " + this.bundleDir.getAbsolutePath() + ", old location=" + this.ba.location);
            }
            this.fileIsReference = true;
        }
        if (!this.file.isDirectory()) {
            this.jar = new ZipFile(this.file);
        }
        if (this.ba.storage.checkSigned) {
            this.loadCertificates();
        }
        if (this.manifest == null) {
            this.manifest = this.getManifest();
        }
        this.handleAutoManifest();
    }

    protected Archive subArchive(String path, int id) throws IOException {
        Archive res = this.ba.storage.createArchive(this.ba, this.bundleDir, this.revision);
        res.subId = id;
        if (this.jar != null) {
            res.jar = this.jar;
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            res.subJar = this.jar.getEntry(path);
            if (res.subJar == null) {
                res.subJar = this.jar.getEntry(path.substring(0, path.length() - 1));
            }
            if (res.subJar == null) {
                throw new IOException("No such JAR component: " + path);
            }
            res.file = this.file;
        } else {
            res.file = this.findFile(this.file, path);
            if (!res.file.isDirectory()) {
                res.jar = new ZipFile(res.file);
            }
        }
        return res;
    }

    public String toString() {
        if (this.subJar != null) {
            return this.file.getAbsolutePath() + "(" + this.subJar.getName() + ")";
        }
        return this.file.getAbsolutePath();
    }

    private String getFile(URL source) {
        String sfile = source.getFile();
        if (sfile.startsWith("file:")) {
            return sfile.substring(5);
        }
        return sfile;
    }

    private boolean isFile(URL source) {
        return source != null && "file".equals(source.getProtocol());
    }

    private boolean isReference(URL source) {
        return source != null && ("reference".equals(source.getProtocol()) || this.ba.storage.fileReference && this.isFile(source));
    }

    int getRevision() {
        try {
            return Integer.parseInt(this.file.getName().substring(ARCHIVE.length()));
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    @Override
    public BundleGeneration getBundleGeneration() {
        return this.ba.getBundleGeneration();
    }

    @Override
    public int getSubId() {
        return this.subId;
    }

    String getAttribute(String key) {
        Attributes a = this.manifest.getMainAttributes();
        if (a != null) {
            return a.getValue(key);
        }
        return null;
    }

    @Override
    public byte[] getClassBytes(String classFile) throws IOException {
        if (this.bClosed) {
            return null;
        }
        BundleResourceStream cif = this.getBundleResourceStream(classFile);
        if (cif != null) {
            byte[] bytes;
            long ilen = cif.getContentLength();
            if (ilen >= 0L) {
                bytes = new byte[(int)ilen];
                DataInputStream dis = new DataInputStream(cif);
                dis.readFully(bytes);
            } else {
                bytes = new byte[]{};
                byte[] tmp = new byte[8192];
                try {
                    int len;
                    while ((len = cif.read(tmp)) > 0) {
                        byte[] oldbytes = bytes;
                        bytes = new byte[oldbytes.length + len];
                        System.arraycopy(oldbytes, 0, bytes, 0, oldbytes.length);
                        System.arraycopy(tmp, 0, bytes, oldbytes.length, len);
                    }
                }
                catch (EOFException ignore) {
                    // empty catch block
                }
            }
            cif.close();
            return bytes;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BundleResourceStream getBundleResourceStream(String component) {
        if (this.bClosed) {
            return null;
        }
        try {
            if (this.jar != null) {
                if (this.subJar != null) {
                    JarEntry ze;
                    if (this.subJar.isDirectory()) {
                        ZipEntry ze2 = this.jar.getEntry(this.subJar.getName() + component);
                        if (null == ze2) return null;
                        InputStream is = this.jar.getInputStream(ze2);
                        if (null != is) {
                            return new BundleResourceStream(is, ze2.getSize());
                        }
                        if (component.endsWith("/")) return new BundleResourceStream(is, ze2.getSize());
                        ZipEntry ze22 = this.jar.getEntry(this.subJar.getName() + component + "/");
                        is = this.jar.getInputStream(ze22);
                        return new BundleResourceStream(is, ze2.getSize());
                    }
                    if (component.equals("")) {
                        return new BundleResourceStream(this.jar.getInputStream(this.subJar), this.subJar.getSize());
                    }
                    JarInputStream ji = new JarInputStream(this.jar.getInputStream(this.subJar));
                    do {
                        if ((ze = ji.getNextJarEntry()) != null) continue;
                        ji.close();
                        return null;
                    } while (!component.equals(ze.getName()));
                    return new BundleResourceStream(ji, ze.getSize());
                }
                if (component.equals("")) {
                    File f = new File(this.jar.getName());
                    return new BundleResourceStream(new FileInputStream(f), f.length());
                }
                ZipEntry ze = this.jar.getEntry(component);
                if (null == ze) return null;
                InputStream is = this.jar.getInputStream(ze);
                if (null != is) {
                    return new BundleResourceStream(is, ze.getSize());
                }
                if (component.endsWith("/")) return new BundleResourceStream(is, ze.getSize());
                ZipEntry ze2 = this.jar.getEntry(component + "/");
                is = this.jar.getInputStream(ze2);
                return new BundleResourceStream(is, ze.getSize());
            }
            FileTree f = this.findFile(this.file, component);
            if (!f.exists()) return null;
            BundleResourceStream bundleResourceStream = new BundleResourceStream(new FileInputStream(f), f.length());
            return bundleResourceStream;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Enumeration<String> findResourcesPath(String path) {
        if (this.bClosed) {
            return null;
        }
        Vector<String> answer = new Vector<String>();
        if (this.jar != null) {
            if ((path = path.replace('\\', '/')).startsWith("/")) {
                path = path.substring(1);
            }
            if (!path.endsWith("/") && path.length() > 1) {
                path = path + "/";
            }
            Enumeration<? extends ZipEntry> entries = this.jar.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(path)) continue;
                int idx = name.lastIndexOf(47);
                if (entry.isDirectory()) {
                    idx = name.substring(0, idx).lastIndexOf(47);
                }
                if (idx > 0) {
                    if (!name.substring(0, idx + 1).equals(path)) continue;
                    answer.add(name);
                    continue;
                }
                if (!path.equals("")) continue;
                answer.add(name);
            }
        } else {
            FileTree f = this.findFile(this.file, path);
            if (!f.exists()) {
                return null;
            }
            if (!f.isDirectory()) {
                return null;
            }
            File[] files = f.listFiles();
            int length = files.length;
            for (int i = 0; i < length; ++i) {
                String filePath = files[i].getPath();
                filePath = filePath.substring(this.file.getPath().length() + 1);
                filePath = filePath.replace(File.separatorChar, '/');
                if (files[i].isDirectory()) {
                    filePath = filePath + "/";
                }
                answer.add(filePath);
            }
        }
        if (answer.size() == 0) {
            return null;
        }
        return answer.elements();
    }

    public boolean isJar() {
        return this.jar != null;
    }

    @Override
    public Class<?> loadClassBytes(String name, ClassLoader cl) {
        return null;
    }

    @Override
    public Set<String> listDir(String path) {
        if (this.bClosed) {
            return null;
        }
        if (path.startsWith("/")) {
            throw new RuntimeException("Assert! Path should never start with / here");
        }
        try {
            if (this.jar != null) {
                if (path.length() > 0 && !path.endsWith("/")) {
                    path = path + "/";
                }
                if (this.subJar != null) {
                    if (this.subJar.isDirectory()) {
                        path = this.subJar.getName() + path;
                    } else {
                        JarInputStream ji = new JarInputStream(this.jar.getInputStream(this.subJar));
                        return this.listZipDir(path, ji);
                    }
                }
                HashSet<String> res = new HashSet<String>();
                Enumeration<? extends ZipEntry> ize = this.jar.entries();
                while (ize.hasMoreElements()) {
                    ZipEntry ze = ize.nextElement();
                    String e = this.matchPath(path, ze.getName());
                    if (e == null) continue;
                    res.add(e);
                }
                return res;
            }
            FileTree f = this.findFile(this.file, path);
            if (f.isDirectory()) {
                HashSet<String> res = new HashSet<String>();
                for (File fl : f.listFiles()) {
                    if (fl.isDirectory()) {
                        res.add(fl.getName() + "/");
                        continue;
                    }
                    res.add(fl.getName());
                }
                return res;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private Set<String> listZipDir(String path, JarInputStream ji) {
        HashSet<String> res = new HashSet<String>();
        try {
            JarEntry ze = ji.getNextJarEntry();
            while (ze != null) {
                String e = this.matchPath(path, ze.getName());
                if (e == null) continue;
                res.add(e);
            }
        }
        catch (IOException ioe) {
            try {
                ji.close();
            }
            catch (IOException _ignore) {
                // empty catch block
            }
        }
        return res;
    }

    private String matchPath(String basePath, String path) {
        int len = basePath.length();
        if (path.length() > len && path.startsWith(basePath)) {
            int i = path.indexOf(47, len);
            if (i == -1) {
                return path.substring(len);
            }
            return path.substring(len, i + 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exists(String path, boolean onlyDirs) {
        if (this.bClosed) {
            return false;
        }
        if (path.startsWith("/")) {
            throw new RuntimeException("Assert! Path should never start with / here");
        }
        if (path.equals("")) {
            return true;
        }
        try {
            if (this.jar != null) {
                if (onlyDirs && !path.endsWith("/")) {
                    path = path + "/";
                }
                if (this.subJar != null) {
                    if (this.subJar.isDirectory()) {
                        path = this.subJar.getName() + path;
                        ZipEntry ze = this.jar.getEntry(path);
                        if (null == ze) {
                            if (!onlyDirs) return false;
                            return this.checkMatch(path);
                        }
                        if (ze.isDirectory()) return true;
                        if (!onlyDirs) return true;
                        return false;
                    }
                    JarInputStream ji = new JarInputStream(this.jar.getInputStream(this.subJar));
                    try {
                        block19: {
                            if (onlyDirs && !path.endsWith("/")) {
                                path = path + "/";
                            }
                            JarEntry ze = ji.getNextJarEntry();
                            while (ze != null) {
                                String n = ze.getName();
                                if (onlyDirs) {
                                    if (!n.startsWith(path)) continue;
                                    boolean bl = true;
                                    return bl;
                                }
                                if (!n.equals(path)) {
                                    continue;
                                }
                                break block19;
                            }
                            return false;
                        }
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        ji.close();
                    }
                }
                ZipEntry ze = this.jar.getEntry(path);
                if (null == ze) {
                    if (!onlyDirs) return false;
                    return this.checkMatch(path);
                }
                if (ze.isDirectory()) return true;
                if (!onlyDirs) return true;
                return false;
            }
            FileTree f = this.findFile(this.file, path);
            if (!f.exists()) return false;
            if (f.isDirectory()) return true;
            if (!onlyDirs) return true;
            return false;
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return false;
    }

    private boolean checkMatch(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        Enumeration<? extends ZipEntry> ize = this.jar.entries();
        while (ize.hasMoreElements()) {
            ZipEntry ze = ize.nextElement();
            String e = this.matchPath(path, ze.getName());
            if (e == null) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String checkNativeLibrary(String path) {
        String key;
        File lib;
        if (this.bClosed) {
            return null;
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (this.jar != null) {
            lib = this.getSubFile(this, path);
            if (!lib.exists()) {
                new File(lib.getParent()).mkdirs();
                ZipEntry ze = this.jar.getEntry(path);
                if (ze == null) return null;
                InputStream is = null;
                try {
                    is = this.jar.getInputStream(ze);
                    this.loadFile(lib, is);
                }
                catch (IOException _ignore) {
                    if (is == null) return null;
                    try {
                        is.close();
                        return null;
                    }
                    catch (IOException _ignore2) {
                        // empty catch block
                    }
                    return null;
                }
            }
        } else {
            lib = this.findFile(this.file, path);
            if (!lib.exists()) {
                if (lib.getParent() == null) return null;
                final String libname = lib.getName();
                File[] list = lib.getParentFile().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        int pos = name.lastIndexOf(libname);
                        return pos > 1 && name.charAt(pos - 1) == '_';
                    }
                });
                if (list.length <= 0) return null;
                list[0].renameTo(lib);
            }
        }
        this.setPerm(lib);
        String libstr = lib.getAbsolutePath();
        int sp = libstr.lastIndexOf(File.separatorChar);
        String string = key = sp != -1 ? libstr.substring(sp + 1) : libstr;
        if (this.nativeLibs == null) {
            this.nativeLibs = new HashMap<String, String>();
            this.renameLibs = new HashMap<String, String>();
        }
        this.nativeLibs.put(key, libstr);
        return key;
    }

    @Override
    public String getNativeLibrary(String libNameKey) {
        File f;
        String file = this.nativeLibs.get(libNameKey);
        if (file != null && (f = new File(file)).isFile()) {
            return this.doRename(libNameKey, f);
        }
        return null;
    }

    private String doRename(String key, File file1) {
        File file2;
        String val = file1.getAbsolutePath();
        if (!this.ba.storage.isReadOnly() && this.renameLibs.containsKey(key) && file1.renameTo(file2 = new File(this.renameLibs.get(key)))) {
            val = file2.getAbsolutePath();
            this.nativeLibs.put(key, val);
        }
        StringBuffer rename = new StringBuffer(val);
        int index0 = val.lastIndexOf(File.separatorChar) + 1;
        int index1 = val.indexOf("_", index0);
        if (index1 > index0 && index1 == val.length() - key.length() - 1) {
            try {
                int prefix = Integer.parseInt(val.substring(index0, index1));
                rename.replace(index0, index1, Integer.toString(prefix + 1));
            }
            catch (Throwable t) {
                rename.insert(index0, "0_");
            }
        } else {
            rename.insert(index0, "0_");
        }
        this.renameLibs.put(key, rename.toString());
        return val;
    }

    private void setPerm(File f) {
        int start;
        String[] cmdarray;
        if (this.ba.storage.isReadOnly() || this.ba.storage.execPermCmd.length() == 0) {
            return;
        }
        String abspath = f.getAbsolutePath();
        String[] execarray = Util.splitwords(this.ba.storage.execPermCmd);
        if (this.ba.storage.isWindows && !execarray[0].equalsIgnoreCase("cmd")) {
            cmdarray = new String[execarray.length + 2];
            cmdarray[0] = "cmd";
            cmdarray[1] = "/c";
            start = 2;
        } else {
            cmdarray = new String[execarray.length];
            start = 0;
        }
        for (int i = 0; i < execarray.length; ++i) {
            cmdarray[i + start] = Util.replace(execarray[i], "${abspath}", abspath);
        }
        try {
            Process p = Runtime.getRuntime().exec(cmdarray);
            InputGlobber ti = new InputGlobber(null, p.getInputStream());
            InputGlobber te = new InputGlobber(cmdarray, p.getErrorStream());
            ti.start();
            te.start();
            while (true) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException _ie) {
                    _ie.printStackTrace();
                    continue;
                }
                break;
            }
            while (true) {
                try {
                    ti.join();
                }
                catch (InterruptedException _ie) {
                    _ie.printStackTrace();
                    continue;
                }
                break;
            }
            while (true) {
                try {
                    te.join();
                }
                catch (InterruptedException _ie) {
                    _ie.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (IOException _ioe) {
            _ioe.printStackTrace();
        }
    }

    void purge() {
        this.close();
        if (!this.fileIsReference) {
            this.file.delete();
        }
        this.getSubFileTree(this).delete();
        this.removeCertificates();
    }

    void close() {
        this.bClosed = true;
        if (this.subJar == null && this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected File getFile() {
        return this.file;
    }

    String getPath() {
        return this.file.getAbsolutePath();
    }

    Certificate[] getCertificates() {
        return this.certs;
    }

    private void checkManifest() {
        Attributes a = this.manifest.getMainAttributes();
        Util.parseManifestHeader("Export-Package", a.getValue("Export-Package"), false, true, false);
        Util.parseManifestHeader("Import-Package", a.getValue("Import-Package"), false, true, false);
        if (this.ba.storage.isReadOnly() && !this.file.isDirectory() && this.needUnpack(a)) {
            throw new IllegalArgumentException("Framework is in read-only mode, we can not install bundles that needs to be downloaded (e.g. has native code or an internal Bundle-ClassPath)");
        }
    }

    private boolean needUnpack(Attributes a) {
        List<Util.HeaderEntry> nc = Util.parseManifestHeader("Bundle-NativeCode", a.getValue("Bundle-NativeCode"), false, false, false);
        String bc = a.getValue("Bundle-ClassPath");
        return bc != null && !bc.trim().equals(".") || !nc.isEmpty();
    }

    private void handleAutoManifest() throws IOException {
        AutoManifest mf;
        if (this.manifest instanceof AutoManifest && (mf = (AutoManifest)this.manifest).isAuto()) {
            if (this.jar != null) {
                mf.addZipFile(this.jar);
            } else if (this.file != null && this.file.isDirectory()) {
                mf.addFile(this.file.getAbsolutePath(), this.file);
            }
        }
    }

    private FileTree findFile(File root, String path) {
        return new FileTree(root, path.replace('/', File.separatorChar));
    }

    private AutoManifest getManifest() throws IOException {
        BundleResourceStream mi = this.getBundleResourceStream("META-INF/MANIFEST.MF");
        if (mi != null) {
            return new AutoManifest(this.ba.storage.framework, new Manifest(mi), this.ba.location);
        }
        throw new IOException("Manifest is missing");
    }

    private FileTree getSubFileTree(Archive archive) {
        return new FileTree(archive.file.getParent(), SUBDIR + archive.file.getName().substring(ARCHIVE.length()));
    }

    private File getSubFile(Archive archive, String path) {
        return new File(this.getSubFileTree(archive), path.replace('/', '-'));
    }

    private void loadFile(File output, InputStream is) throws IOException {
        if (output != null && this.ba.storage.isReadOnly()) {
            throw new IOException("Bundle storage is read-only, unable to save: " + output);
        }
        OutputStream os = null;
        try {
            if (output != null) {
                os = new FileOutputStream(output);
            }
            byte[] buf = new byte[8192];
            try {
                int n;
                while ((n = is.read(buf)) >= 0) {
                    if (os == null) continue;
                    os.write(buf, 0, n);
                }
            }
            catch (EOFException ignore) {
                // empty catch block
            }
        }
        catch (IOException e) {
            if (os != null) {
                output.delete();
            }
            throw e;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private boolean isArchiveSigned() {
        return this.certs != null;
    }

    private boolean processNextJarEntry(JarInputStream ji, boolean verify, File saveDir) throws IOException {
        JarEntry je;
        while ((je = ji.getNextJarEntry()) != null) {
            if (je.isDirectory()) continue;
            String name = je.getName();
            if (saveDir != null && !this.startsWithIgnoreCase(name, OSGI_OPT_DIR)) {
                StringTokenizer st = new StringTokenizer(name, "/");
                File f = new File(saveDir, st.nextToken());
                while (st.hasMoreTokens()) {
                    f.mkdir();
                    f = new File(f, st.nextToken());
                }
                this.loadFile(f, ji);
            } else {
                this.loadFile(null, ji);
            }
            ji.closeEntry();
            if (this.startsWithIgnoreCase(name, META_INF_DIR)) {
                int idx;
                String sub = name.substring(META_INF_DIR.length());
                if (sub.indexOf(47) == -1 && (this.startsWithIgnoreCase(sub, "SIG-") || (idx = sub.lastIndexOf(46)) != -1 && ((sub = sub.substring(idx + 1)).equalsIgnoreCase("DSA") || sub.equalsIgnoreCase("RSA") || sub.equalsIgnoreCase("SF")))) continue;
                if (this.ba.storage.jarVerifierBug) {
                    if (this.certs == null) {
                        this.certs = new Certificate[0];
                        verify = false;
                    } else if (this.certs.length == 0) {
                        verify = false;
                    }
                }
            }
            if (verify) {
                Object[] c = je.getCertificates();
                if (c != null) {
                    if (this.certs != null && this.certs.length > 0) {
                        if (!Arrays.equals(c, this.certs)) {
                            this.certs = null;
                        }
                    } else {
                        this.certs = c;
                    }
                } else {
                    this.certs = null;
                }
            }
            return true;
        }
        return false;
    }

    private boolean startsWithIgnoreCase(String name, String prefix) {
        if (name.length() >= prefix.length()) {
            for (int i = 0; i < prefix.length(); ++i) {
                if (Character.toUpperCase(name.charAt(i)) == prefix.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSignedJar(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        ZipInputStream ji = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            ji = new JarInputStream(bis);
            int count = 0;
            this.manifest = ((JarInputStream)ji).getManifest();
            while (this.processNextJarEntry((JarInputStream)ji, true, null) && this.isArchiveSigned()) {
                ++count;
            }
            this.checkCertificates(count);
        }
        finally {
            if (ji != null) {
                ji.close();
            } else {
                fis.close();
            }
        }
    }

    private void checkCertificates(int filesVerified) {
        if (filesVerified > 0) {
            IOException warn = null;
            if (this.certs != null) {
                if (this.certs.length > 0) {
                    return;
                }
                warn = new IOException("Only contained META-INF entries with no certs due to JRE bug. Entries found " + filesVerified);
            } else {
                warn = new IOException("All entries in bundle not completly signed, scan aborted");
            }
            this.certs = null;
            this.ba.frameworkWarning(warn);
        }
    }

    private void saveCertificates() throws IOException {
        if (!this.ba.storage.isReadOnly()) {
            File f = new File(this.getPath() + CERTS_SUFFIX);
            if (this.certs != null) {
                try {
                    FileOutputStream fos = new FileOutputStream(f);
                    for (Certificate cert : this.certs) {
                        fos.write(cert.getEncoded());
                    }
                    fos.close();
                }
                catch (CertificateEncodingException e) {
                    this.ba.frameworkWarning(e);
                }
            }
        }
    }

    private void loadCertificates() throws IOException {
        File f = new File(this.getPath() + CERTS_SUFFIX);
        if (f.canRead()) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                FileInputStream fis = new FileInputStream(f);
                Collection<? extends Certificate> c = cf.generateCertificates(fis);
                if (c.size() > 0) {
                    this.certs = new Certificate[c.size()];
                    this.certs = c.toArray(this.certs);
                }
            }
            catch (CertificateException e) {
                this.ba.frameworkWarning(e);
            }
        }
    }

    private void removeCertificates() {
        File f = new File(this.getPath() + CERTS_SUFFIX);
        f.delete();
    }

    static class InputGlobber
    extends Thread {
        String[] cmd;
        final InputStream in;
        boolean copyToStdout;

        InputGlobber(String[] cmd, InputStream in) {
            this.cmd = cmd;
            this.in = in;
            this.copyToStdout = cmd != null;
        }

        @Override
        public void run() {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
            try {
                String line = br.readLine();
                while (null != line) {
                    if (null != this.cmd) {
                        StringBuffer sb = new StringBuffer();
                        for (String element : this.cmd) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append(element);
                        }
                        System.err.println("Failed to execute: '" + sb.toString() + "':");
                        this.cmd = null;
                    }
                    if (this.copyToStdout) {
                        System.out.println(line);
                    }
                    line = br.readLine();
                }
            }
            catch (IOException _ioe) {
                _ioe.printStackTrace();
            }
        }
    }
}

