/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.ConfigurationUtils;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.main.addons.AddOnProperties;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.plugin.script.ExecuteScriptAction;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.ScriptingRegistration;
import org.freeplane.plugin.script.addons.ScriptAddOnProperties;

class ScriptingGuiConfiguration {
    private static final ExecuteScriptAction.ExecutionMode DEFAULT_EXECUTION_MODE = ExecuteScriptAction.ExecutionMode.ON_SELECTED_NODE;
    private final TreeMap<String, String> menuTitleToPathMap = new TreeMap();
    private final TreeMap<String, ScriptMetaData> menuTitleToMetaDataMap = new TreeMap();

    ScriptingGuiConfiguration() {
        this.initMenuTitleToPathMap();
    }

    private void initMenuTitleToPathMap() {
        Map<File, ScriptAddOnProperties.Script> addOnScriptMap = this.createAddOnScriptMap();
        this.addAddOnScripts(addOnScriptMap);
        this.addNonAddOnScripts(addOnScriptMap);
    }

    private void addAddOnScripts(Map<File, ScriptAddOnProperties.Script> addOnScriptMap) {
        for (File file : addOnScriptMap.keySet()) {
            this.addScript(file, addOnScriptMap);
        }
    }

    private void addNonAddOnScripts(Map<File, ScriptAddOnProperties.Script> addOnScriptMap) {
        FilenameFilter scriptFilenameFilter = ScriptingRegistration.createFilenameFilter(ScriptingRegistration.createScriptRegExp());
        for (File dir : this.getScriptDirs()) {
            this.addNonAddOnScripts(dir, addOnScriptMap, scriptFilenameFilter);
        }
    }

    private Map<File, ScriptAddOnProperties.Script> createAddOnScriptMap() {
        LinkedHashMap<File, ScriptAddOnProperties.Script> result = new LinkedHashMap<File, ScriptAddOnProperties.Script>();
        for (ScriptAddOnProperties scriptAddOnProperties : this.getInstalledScriptAddOns()) {
            List<ScriptAddOnProperties.Script> scripts = scriptAddOnProperties.getScripts();
            for (ScriptAddOnProperties.Script script : scripts) {
                script.active = scriptAddOnProperties.isActive();
                result.put(this.findScriptFile(scriptAddOnProperties, script), script);
            }
        }
        return result;
    }

    private List<ScriptAddOnProperties> getInstalledScriptAddOns() {
        ArrayList<ScriptAddOnProperties> installedAddOns = new ArrayList<ScriptAddOnProperties>();
        for (AddOnProperties addOnProperties : AddOnsController.getController().getInstalledAddOns()) {
            if (addOnProperties.getAddOnType() != AddOnProperties.AddOnType.SCRIPT) continue;
            installedAddOns.add((ScriptAddOnProperties)addOnProperties);
        }
        return installedAddOns;
    }

    private File findScriptFile(AddOnProperties addOnProperties, ScriptAddOnProperties.Script script) {
        File dir = new File(this.getPrivateAddOnDirectory(addOnProperties), "scripts");
        File result = new File(dir, script.name);
        return result.exists() ? result : this.findScriptFile_pre_1_3_x_final(script);
    }

    private File getPrivateAddOnDirectory(AddOnProperties addOnProperties) {
        return new File(AddOnsController.getController().getAddOnsDir(), addOnProperties.getName());
    }

    @Deprecated
    private File findScriptFile_pre_1_3_x_final(ScriptAddOnProperties.Script script) {
        return new File(ScriptResources.getUserScriptsDir(), script.name);
    }

    private TreeSet<File> getScriptDirs() {
        ResourceController resourceController = ResourceController.getResourceController();
        String dirsString = resourceController.getProperty("script_directories");
        TreeSet<File> dirs = new TreeSet<File>();
        if (dirsString != null) {
            for (String dir : ConfigurationUtils.decodeListValue((String)dirsString, (boolean)false)) {
                dirs.add(this.createFile(dir));
            }
        }
        dirs.add(ScriptResources.getBuiltinScriptsDir());
        dirs.add(ScriptResources.getUserScriptsDir());
        return dirs;
    }

    private File createFile(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(ResourceController.getResourceController().getFreeplaneUserDirectory(), path);
        }
        return file;
    }

    private void addNonAddOnScripts(File dir, Map<File, ScriptAddOnProperties.Script> addOnScriptMap, FilenameFilter filenameFilter) {
        if (dir.isDirectory()) {
            File[] files = dir.listFiles(filenameFilter);
            if (files != null) {
                for (File file : files) {
                    if (addOnScriptMap.get(file) != null) continue;
                    this.addScript(file, addOnScriptMap);
                }
            }
        } else {
            LogUtils.warn((String)("not a (script) directory: " + dir));
        }
    }

    private void addScript(File file, Map<File, ScriptAddOnProperties.Script> addOnScriptMap) {
        ScriptAddOnProperties.Script scriptConfig = addOnScriptMap.get(file);
        if (scriptConfig != null && !scriptConfig.active) {
            LogUtils.info((String)("skipping deactivated " + scriptConfig));
            return;
        }
        String menuTitle = this.disambiguateMenuTitle(this.getOrCreateMenuTitle(file, scriptConfig));
        try {
            this.menuTitleToPathMap.put(menuTitle, file.getAbsolutePath());
            ScriptMetaData metaData = this.createMetaData(file, menuTitle, scriptConfig);
            this.menuTitleToMetaDataMap.put(menuTitle, metaData);
            File parentFile = file.getParentFile();
            if (parentFile.equals(ScriptResources.getBuiltinScriptsDir())) {
                metaData.setPermissions(ScriptingPermissions.getPermissiveScriptingPermissions());
            }
        }
        catch (IOException e) {
            LogUtils.warn((String)("problems with script " + file.getAbsolutePath()), (Throwable)e);
            this.menuTitleToPathMap.remove(menuTitle);
            this.menuTitleToMetaDataMap.remove(menuTitle);
        }
    }

    private String disambiguateMenuTitle(String menuTitleOrig) {
        String menuTitle = menuTitleOrig;
        int i = 2;
        while (this.menuTitleToPathMap.containsKey(menuTitle)) {
            menuTitle = menuTitleOrig + i;
            ++i;
        }
        return menuTitle;
    }

    private ScriptMetaData createMetaData(File file, String scriptName, ScriptAddOnProperties.Script scriptConfig) throws IOException {
        return scriptConfig == null ? new ScriptMetaData(scriptName, FileUtils.slurpFile((File)file)) : this.createMetaData(scriptName, scriptConfig);
    }

    private ScriptMetaData createMetaData(String scriptName, ScriptAddOnProperties.Script scriptConfig) {
        ScriptMetaData metaData = new ScriptMetaData(scriptName);
        metaData.addExecutionMode(scriptConfig.executionMode, scriptConfig.menuLocation, scriptConfig.menuTitleKey);
        metaData.setPermissions(scriptConfig.permissions);
        return metaData;
    }

    private String getOrCreateMenuTitle(File file, ScriptAddOnProperties.Script scriptConfig) {
        if (scriptConfig != null) {
            return scriptConfig.menuTitleKey;
        }
        String string = file.getName().replaceFirst("\\.[^.]+", "");
        return (string = string.replaceAll("\\s+", "_")).length() < 2 ? string : string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private static Pattern makeCaseInsensitivePattern(String regexp) {
        return Pattern.compile(regexp, 34);
    }

    SortedMap<String, String> getMenuTitleToPathMap() {
        return Collections.unmodifiableSortedMap(this.menuTitleToPathMap);
    }

    SortedMap<String, ScriptMetaData> getMenuTitleToMetaDataMap() {
        return Collections.unmodifiableSortedMap(this.menuTitleToMetaDataMap);
    }

    public static String getScriptsLocation(String parentKey) {
        return parentKey + "/scripts";
    }

    static class ScriptMetaData {
        private static final Pattern EXECUTION_MODE_ANNOTATION;
        private static final Pattern EXECUTION_MODE_DEFINITIONS;
        private final TreeMap<ExecuteScriptAction.ExecutionMode, String> executionModeLocationMap = new TreeMap();
        private final TreeMap<ExecuteScriptAction.ExecutionMode, String> executionModeTitleKeyMap = new TreeMap();
        private final String scriptName;
        private ScriptingPermissions permissions;

        ScriptMetaData(String scriptName, String content) {
            this(scriptName);
            this.configure(content);
        }

        ScriptMetaData(String scriptName) {
            this.scriptName = scriptName;
        }

        private void configure(String content) {
            String[] locations;
            Matcher mOuter = EXECUTION_MODE_ANNOTATION.matcher(content.replaceAll("\\s+", ""));
            if (!mOuter.find()) {
                this.addExecutionMode(DEFAULT_EXECUTION_MODE, null, null);
                return;
            }
            for (String match : locations = mOuter.group(1).split(",")) {
                Matcher m = EXECUTION_MODE_DEFINITIONS.matcher(match);
                if (m.matches()) {
                    this.addExecutionMode(ExecuteScriptAction.ExecutionMode.valueOf(m.group(1).toUpperCase(Locale.ENGLISH)), m.group(2), m.group(3));
                    continue;
                }
                LogUtils.severe((String)("script " + this.getScriptName() + ": not a menu location: '" + match + "'"));
            }
        }

        public Set<ExecuteScriptAction.ExecutionMode> getExecutionModes() {
            return this.executionModeLocationMap.keySet();
        }

        public void addExecutionMode(ExecuteScriptAction.ExecutionMode executionMode, String location, String titleKey) {
            this.executionModeLocationMap.put(executionMode, location);
            if (titleKey != null) {
                this.executionModeTitleKeyMap.put(executionMode, titleKey);
            }
        }

        protected String getMenuLocation(ExecuteScriptAction.ExecutionMode executionMode) {
            return this.executionModeLocationMap.get((Object)executionMode);
        }

        String getTitleKey(ExecuteScriptAction.ExecutionMode executionMode) {
            String key = this.executionModeTitleKeyMap.get((Object)executionMode);
            return key;
        }

        public String getScriptName() {
            return this.scriptName;
        }

        public void setPermissions(ScriptingPermissions permissions) {
            this.permissions = permissions;
        }

        public ScriptingPermissions getPermissions() {
            return this.permissions;
        }

        public boolean hasMenuLocation() {
            for (String location : this.executionModeLocationMap.values()) {
                if (location == null) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "ScriptMetaData(" + this.scriptName + ", locations: " + this.executionModeLocationMap + ", titles: " + this.executionModeTitleKeyMap + ")";
        }

        static {
            String modeName = StringUtils.join((Object[])ExecuteScriptAction.ExecutionMode.values(), (String)"|");
            String modeDef = "(?:ExecutionMode\\.)?(" + modeName + ")(?:=\"([^]\"]+)(?:\\[([^]\"]+)\\])?\")?";
            String modeDefs = "(?:" + modeDef + ",?)+";
            EXECUTION_MODE_ANNOTATION = ScriptingGuiConfiguration.makeCaseInsensitivePattern("@ExecutionModes\\(\\{(" + modeDefs + ")\\}\\)");
            EXECUTION_MODE_DEFINITIONS = ScriptingGuiConfiguration.makeCaseInsensitivePattern(modeDef);
        }
    }
}

