/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.util.Objects;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.StyleTranslatedObject;
import org.freeplane.plugin.script.filter.ScriptCondition;
import org.freeplane.plugin.script.proxy.NodeStyleProxy;
import org.freeplane.plugin.script.proxy.Proxy;

public abstract class AConditionalStyleProxy<T>
implements Proxy.ConditionalStyle {
    private final T delegate;
    private final ConditionalStyleModel.Item item;
    private static final String STYLE_MUST_NOT_BE_NULL = "style mustn't be null";

    AConditionalStyleProxy(T delegate, ConditionalStyleModel.Item item) {
        this.delegate = delegate;
        this.item = item;
    }

    AConditionalStyleProxy(T delegate, boolean isActive, String script, String styleName, boolean isLast) {
        this(delegate, isActive, script == null ? null : new ScriptCondition(script), NodeStyleProxy.styleByNameOrThrowException(delegate instanceof NodeModel ? ((NodeModel)delegate).getMap() : (MapModel)delegate, styleName), isLast);
    }

    AConditionalStyleProxy(T delegate, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
        this(delegate, new ConditionalStyleModel.Item(isActive, condition, Objects.requireNonNull(style, STYLE_MUST_NOT_BE_NULL), isLast));
    }

    T getDelegate() {
        return this.delegate;
    }

    abstract ConditionalStyleModel getConditionalStyleModel();

    ConditionalStyleModel.Item getItem() {
        return this.item;
    }

    int getIndex() {
        return this.getConditionalStyleModel().getStyles().indexOf(this.item);
    }

    public String getConditionClassSimpleName() {
        ASelectableCondition condition = this.item.getCondition();
        return condition == null ? null : condition.getClass().getSimpleName();
    }

    public IStyle getStyle() {
        return this.item.getStyle();
    }

    public ASelectableCondition getCondition() {
        return this.item.getCondition();
    }

    public String getStyleName() {
        IStyle style = this.item.getStyle();
        return style == null ? null : StyleTranslatedObject.toKeyString((IStyle)style);
    }

    public String getScript() {
        if (this.hasScriptCondition()) {
            return ((ScriptCondition)this.item.getCondition()).getScript();
        }
        return null;
    }

    public boolean isActive() {
        return this.item.isActive();
    }

    public boolean isLast() {
        return this.item.isLast();
    }

    public boolean isAlways() {
        return this.item.getCondition() == null;
    }

    public boolean hasScriptCondition() {
        return this.item.getCondition() instanceof ScriptCondition;
    }

    public String toString() {
        return "ConditionalStyle{" + (this.isActive() ? "active" : "inactive") + ", " + (this.isAlways() ? "always" : this.getConditionClassSimpleName()) + ", " + this.getStyleName() + ", " + (this.isLast() ? "stop" : "continue") + '}';
    }
}

