/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.cloud.mindmapmode;

import java.awt.Color;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.cloud.CloudShape;
import org.freeplane.features.cloud.mindmapmode.CloudAction;
import org.freeplane.features.cloud.mindmapmode.CloudColorAction;
import org.freeplane.features.cloud.mindmapmode.CloudShapeAction;
import org.freeplane.features.cloud.mindmapmode.RemoveCloudAction;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.LogicalStyleKeys;

public class MCloudController
extends CloudController {
    public MCloudController(ModeController modeController) {
        super(modeController);
        modeController.registerExtensionCopier((IExtensionCopier)new ExtensionCopier());
        modeController.addAction((AFreeplaneAction)new CloudAction());
        modeController.addAction((AFreeplaneAction)new RemoveCloudAction());
        modeController.addAction((AFreeplaneAction)new CloudColorAction());
        for (CloudShape shape : CloudShape.values()) {
            modeController.addAction((AFreeplaneAction)new CloudShapeAction(shape));
        }
    }

    public void setCloud(final NodeModel node, final boolean enable) {
        CloudModel cloud = CloudModel.getModel((NodeModel)node);
        if (cloud != null == enable) {
            return;
        }
        final Color color = cloud != null ? cloud.getColor() : CloudController.getStandardColor();
        final CloudShape shape = cloud != null ? cloud.getShape() : CloudController.getStandardShape();
        final ModeController modeController = Controller.getCurrentModeController();
        IActor actor = new IActor(){

            public void act() {
                if (enable) {
                    this.enable();
                } else {
                    this.disable();
                }
            }

            private void disable() {
                MapController mapController = modeController.getMapController();
                CloudModel.setModel((NodeModel)node, null);
                mapController.nodeChanged(node);
            }

            private void enable() {
                CloudModel cloud = new CloudModel();
                cloud.setColor(color);
                cloud.setShape(shape);
                MapController mapController = modeController.getMapController();
                CloudModel.setModel((NodeModel)node, (CloudModel)cloud);
                mapController.nodeChanged(node);
            }

            public String getDescription() {
                return "setCloud";
            }

            public void undo() {
                if (enable) {
                    this.disable();
                } else {
                    this.enable();
                }
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setColor(final NodeModel node, final Color color) {
        this.setCloud(node, true);
        final ModeController modeController = Controller.getCurrentModeController();
        final Color oldColor = CloudModel.getModel((NodeModel)node).getColor();
        if (color == oldColor || color != null && color.equals(oldColor)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                CloudModel.getModel((NodeModel)node).setColor(color);
                modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setColor";
            }

            public void undo() {
                CloudModel.getModel((NodeModel)node).setColor(oldColor);
                modeController.getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    public void setShape(final NodeModel node, final CloudShape shape) {
        this.setCloud(node, true);
        final ModeController modeController = Controller.getCurrentModeController();
        final CloudShape oldShape = CloudModel.getModel((NodeModel)node).getShape();
        if (shape == oldShape || shape != null && shape.equals((Object)oldShape)) {
            return;
        }
        IActor actor = new IActor(){

            public void act() {
                CloudModel.getModel((NodeModel)node).setShape(shape);
                modeController.getMapController().nodeChanged(node);
            }

            public String getDescription() {
                return "setShape";
            }

            public void undo() {
                CloudModel.getModel((NodeModel)node).setShape(oldShape);
                modeController.getMapController().nodeChanged(node);
            }
        };
        modeController.execute(actor, node.getMap());
    }

    private static class ExtensionCopier
    implements IExtensionCopier {
        private ExtensionCopier() {
        }

        public void copy(Object key, NodeModel from, NodeModel to) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            this.copy(from, to);
        }

        public void copy(NodeModel from, NodeModel to) {
            CloudShape shape;
            CloudModel fromStyle = (CloudModel)from.getExtension(CloudModel.class);
            if (fromStyle == null) {
                return;
            }
            CloudModel toStyle = CloudModel.createModel((NodeModel)to);
            Color color = fromStyle.getColor();
            if (color != null) {
                toStyle.setColor(color);
            }
            if ((shape = fromStyle.getShape()) != null) {
                toStyle.setShape(shape);
            }
        }

        public void remove(Object key, NodeModel from) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            from.removeExtension(CloudModel.class);
        }

        public void remove(Object key, NodeModel from, NodeModel which) {
            if (!key.equals(LogicalStyleKeys.NODE_STYLE)) {
                return;
            }
            CloudModel whichStyle = (CloudModel)which.getExtension(CloudModel.class);
            if (whichStyle == null) {
                return;
            }
            CloudModel fromStyle = (CloudModel)from.getExtension(CloudModel.class);
            if (fromStyle == null) {
                return;
            }
            from.removeExtension((IExtension)fromStyle);
        }
    }
}

