/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IElementHandler;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.presentations.mindmapmode.MapPresentations;
import org.freeplane.features.presentations.mindmapmode.NamedElementCollection;
import org.freeplane.features.presentations.mindmapmode.NamedElementFactory;
import org.freeplane.features.presentations.mindmapmode.Presentation;
import org.freeplane.features.presentations.mindmapmode.PresentationController;
import org.freeplane.features.presentations.mindmapmode.PresentationWriter;
import org.freeplane.features.presentations.mindmapmode.Slide;
import org.freeplane.n3.nanoxml.XMLElement;

class PresentationBuilder {
    static final String PRESENTATIONS = "presentations";
    static final String NODE_ON_SLIDE = "NodeOnSlide";
    static final String NODES_ON_SLIDE = "NodesOnSlide";
    static final String FOLDED_NODES = "FoldedNodes";
    static final String SLIDE_CONDITION = "SlideCondition";
    static final String ZOOM = "zoom";
    static final String CENTERED_NODE_ID = "centeredNodeId";
    static final String ROOT_NODE_ID = "rootNodeId";
    static final String PLACED_NODE_ID = "placedNodeId";
    static final String PLACED_NODE_POSITION = "placedNodePosition";
    static final String CHANGES_ZOOM = "changesZoom";
    static final String SHOWS_ONLY_SPECIFIC_NODES = "showsOnlySpecificNodes";
    static final String SHOWS_DESCENDANTS = "showsDescendants";
    static final String TRUE = "true";
    static final String SHOWS_ANCESTORS = "showsAncestors";
    static final String NAME = "NAME";
    static final String SLIDE = "slide";
    static final String PRESENTATION = "presentation";
    static final String NODE_ID = "nodeId";

    PresentationBuilder() {
    }

    void register(MapController mapController, final PresentationController presentationController) {
        mapController.getReadManager().addElementHandler("hook", (IElementHandler)new IElementDOMHandler(){
            private final ConditionFactory conditionFactory = FilterController.getCurrentFilterController().getConditionFactory();

            public Object createElement(Object parent, String tag, XMLElement attributes) {
                if (attributes == null) {
                    return null;
                }
                if (!PresentationBuilder.PRESENTATIONS.equals(attributes.getAttribute(PresentationBuilder.NAME, null))) {
                    return null;
                }
                return parent;
            }

            public void endElement(Object parent, String tag, Object element, XMLElement dom) {
                if (!ReadManager.belongsToRootNode((XMLElement)dom)) {
                    return;
                }
                NodeModel node = (NodeModel)parent;
                MapModel map = node.getMap();
                NamedElementFactory<Slide> slideFactory = presentationController.getSlideFactory(map);
                MapPresentations mapPresentationExtension = presentationController.getPresentations(map);
                NamedElementCollection<Presentation> presentations = mapPresentationExtension.presentations;
                Enumeration xmlPresentations = dom.enumerateChildren();
                HashSet<XMLElement> knownPresentations = new HashSet<XMLElement>();
                int dublicatePresentationsCount = 0;
                while (xmlPresentations.hasMoreElements()) {
                    XMLElement xmlPresentation = (XMLElement)xmlPresentations.nextElement();
                    if (!knownPresentations.add(xmlPresentation)) {
                        ++dublicatePresentationsCount;
                        continue;
                    }
                    presentations.add(xmlPresentation.getAttribute(PresentationBuilder.NAME, "noname"));
                    Enumeration xmlSlides = xmlPresentation.enumerateChildren();
                    NamedElementCollection<Slide> slides = presentations.getCurrentElement().slides;
                    while (xmlSlides.hasMoreElements()) {
                        XMLElement xmlSlide = (XMLElement)xmlSlides.nextElement();
                        String name = xmlSlide.getAttribute(PresentationBuilder.NAME, "noname");
                        Slide s = slideFactory.create(name);
                        Slide slide = this.applySlideAttributes(xmlSlide, s);
                        slides.add(slide);
                    }
                    if (slides.getSize() <= 1) continue;
                    slides.selectCurrentElement(0);
                }
                if (presentations.getSize() > 1) {
                    presentations.selectCurrentElement(0);
                }
                node.addExtension((IExtension)mapPresentationExtension);
                if (dublicatePresentationsCount > 0) {
                    UITools.errorMessage((Object)TextUtils.format((String)"duplicate_presentations_removed", (Object[])new Object[]{dublicatePresentationsCount, presentations.getSize(), map.getTitle()}));
                }
            }

            Slide applySlideAttributes(XMLElement xmlSlide, Slide s) {
                String placedNodeId;
                String rootNodeId;
                s.setShowsAncestors(this.toBoolean(xmlSlide, PresentationBuilder.SHOWS_ANCESTORS));
                s.setShowsDescendants(this.toBoolean(xmlSlide, PresentationBuilder.SHOWS_DESCENDANTS));
                s.setShowsOnlySpecificNodes(this.toBoolean(xmlSlide, PresentationBuilder.SHOWS_ONLY_SPECIFIC_NODES));
                s.setChangesZoom(this.toBoolean(xmlSlide, PresentationBuilder.CHANGES_ZOOM));
                String centeredNodeId = this.toString(xmlSlide, PresentationBuilder.CENTERED_NODE_ID);
                if (centeredNodeId != null) {
                    s.setPlacedNodeId(centeredNodeId);
                }
                if ((rootNodeId = this.toString(xmlSlide, PresentationBuilder.ROOT_NODE_ID)) != null) {
                    s.setRootNodeId(rootNodeId);
                }
                if ((placedNodeId = this.toString(xmlSlide, PresentationBuilder.PLACED_NODE_ID)) != null) {
                    s.setPlacedNodeId(placedNodeId);
                }
                String nodePosition = xmlSlide.getAttribute(PresentationBuilder.PLACED_NODE_POSITION, IMapSelection.NodePosition.CENTER.name());
                s.setPlacedNodePosition(NodePositionMap.nodePositionOf(nodePosition));
                s.setZoom(this.toFloat(xmlSlide, PresentationBuilder.ZOOM));
                Enumeration childAttributes = xmlSlide.enumerateChildren();
                while (childAttributes.hasMoreElements()) {
                    Set<String> ids;
                    XMLElement xmlElement = (XMLElement)childAttributes.nextElement();
                    if (xmlElement.getName().equals(PresentationBuilder.NODES_ON_SLIDE)) {
                        ids = this.loadSpecificNodeIds(xmlElement);
                        s.setSelectedNodeIds(ids);
                        continue;
                    }
                    if (xmlElement.getName().equals(PresentationBuilder.FOLDED_NODES)) {
                        ids = this.loadSpecificNodeIds(xmlElement);
                        s.setFoldedNodeIDs(ids);
                        continue;
                    }
                    if (!xmlElement.getName().equals(PresentationBuilder.SLIDE_CONDITION)) continue;
                    ASelectableCondition condition = this.loadFilterCondition(xmlElement);
                    s.setFilterCondition(condition);
                }
                return s;
            }

            private Set<String> loadSpecificNodeIds(XMLElement xmlNodeIds) {
                LinkedHashSet<String> nodeIds = new LinkedHashSet<String>();
                Enumeration nodesEnumeration = xmlNodeIds.enumerateChildren();
                while (nodesEnumeration.hasMoreElements()) {
                    String id;
                    XMLElement nodeIdXml = (XMLElement)nodesEnumeration.nextElement();
                    if (!nodeIdXml.getName().equals(PresentationBuilder.NODE_ON_SLIDE) || (id = nodeIdXml.getAttribute(PresentationBuilder.NODE_ID, null)) == null) continue;
                    nodeIds.add(id);
                }
                return nodeIds;
            }

            private ASelectableCondition loadFilterCondition(XMLElement xmlElement) {
                return this.conditionFactory.loadCondition(xmlElement.getChildAtIndex(0));
            }

            private float toFloat(XMLElement element, String attribute) {
                return Float.parseFloat(element.getAttribute(attribute, "1f"));
            }

            private boolean toBoolean(XMLElement element, String attribute) {
                return Boolean.parseBoolean(element.getAttribute(attribute, ""));
            }

            private String toString(XMLElement element, String attribute) {
                return element.getAttribute(attribute, null);
            }
        });
        mapController.getWriteManager().addExtensionElementWriter(MapPresentations.class, new IExtensionElementWriter(){

            public void writeContent(ITreeWriter writer, Object element, IExtension extension) throws IOException {
                new PresentationWriter(((NodeModel)element).getMap()).writeContent(writer, extension);
            }
        });
    }

    private static enum NodePositionMap {
        WEST(IMapSelection.NodePosition.LEFT),
        CENTER(IMapSelection.NodePosition.CENTER),
        EAST(IMapSelection.NodePosition.RIGHT),
        NORTH(IMapSelection.NodePosition.TOP),
        SOUTH(IMapSelection.NodePosition.BOTTOM),
        NORTHWEST(IMapSelection.NodePosition.TOP_LEFT),
        NORTHEAST(IMapSelection.NodePosition.TOP_RIGHT),
        SOUTHWEST(IMapSelection.NodePosition.BOTTOM_LEFT),
        SOUTHEAST(IMapSelection.NodePosition.BOTTOM_RIGHT);

        public final IMapSelection.NodePosition nodePosition;

        private static IMapSelection.NodePosition nodePositionOf(String nodePosition) {
            try {
                return IMapSelection.NodePosition.valueOf((String)nodePosition);
            }
            catch (IllegalArgumentException e) {
                return NodePositionMap.valueOf((String)nodePosition).nodePosition;
            }
        }

        private NodePositionMap(IMapSelection.NodePosition nodePosition) {
            this.nodePosition = nodePosition;
        }
    }
}

