/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import java.util.function.Supplier;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.TransformationException;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;

public class ConditionalContentTransformer
implements IContentTransformer,
IEditBaseCreator {
    private final IContentTransformer target;
    private final String prefsConditionKey;

    public ConditionalContentTransformer(IContentTransformer target, String prefsConditionKey) {
        this.target = target;
        this.prefsConditionKey = prefsConditionKey;
    }

    public int compareTo(IContentTransformer o) {
        return this.target.compareTo((Object)o);
    }

    public Object transformContent(NodeModel node, Object nodeProperty, Object content, TextController textController, IContentTransformer.Mode mode) throws TransformationException {
        if (this.isTransformationActive()) {
            return this.target.transformContent(node, nodeProperty, content, textController, mode);
        }
        return content;
    }

    private boolean isTransformationActive() {
        return ResourceController.getResourceController().getBooleanProperty(this.prefsConditionKey);
    }

    public boolean isFormula(Object content) {
        if (this.isTransformationActive()) {
            return this.target.isFormula(content);
        }
        return false;
    }

    public int getPriority() {
        return this.target.getPriority();
    }

    public boolean markTransformation() {
        return this.target.markTransformation();
    }

    @Override
    public EditNodeBase createEditor(NodeModel node, Object nodeProperty, Object content, EditNodeBase.IEditControl editControl, boolean editLong) {
        if (this.target instanceof IEditBaseCreator && this.isTransformationActive()) {
            return ((IEditBaseCreator)this.target).createEditor(node, nodeProperty, content, editControl, editLong);
        }
        return null;
    }

    @Override
    public JEditorPane createTextEditorPane(Supplier<JScrollPane> scrollPaneSupplier, NodeModel node, Object nodeProperty, Object content, boolean editInline) {
        if (this.target instanceof IEditBaseCreator && this.isTransformationActive()) {
            return ((IEditBaseCreator)this.target).createTextEditorPane(scrollPaneSupplier, node, nodeProperty, content, editInline);
        }
        return null;
    }
}

