/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.net.URI;
import javax.swing.JOptionPane;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.url.FreeplaneUriConverter;

class OpenURLMapAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public OpenURLMapAction() {
        super("OpenURLMapAction");
    }

    public void actionPerformed(ActionEvent e) {
        Controller.getCurrentController().selectMode("MindMap");
        String urlText = JOptionPane.showInputDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), TextUtils.getText((String)"enter_map_url"), "http://");
        if (urlText != null) {
            try {
                String fixedUri = new FreeplaneUriConverter().fixPartiallyDecodedFreeplaneUriComingFromInternetExplorer(urlText);
                URI uri = new URI(fixedUri);
                LinkController.getController().loadHyperlink(new Hyperlink(uri));
            }
            catch (Exception ex) {
                UITools.errorMessage((Object)TextUtils.format((String)"url_open_error", (Object[])new Object[]{urlText}));
                LogUtils.warn((String)("can not load " + urlText), (Throwable)ex);
            }
        }
    }

    public void afterMapChange(UserRole userRole) {
    }
}

