/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.DefaultNodeMouseWheelListener;

public class MNodeMouseWheelListener
extends DefaultNodeMouseWheelListener {
    public MNodeMouseWheelListener(MouseWheelListener mapMouseWheelListener) {
        super(mapMouseWheelListener);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!e.isAltDown()) {
            super.mouseWheelMoved(e);
            return;
        }
        MainView view = (MainView)e.getComponent();
        MapView map = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, (Component)view);
        if (map.usesLayoutSpecificMaxNodeWidth()) {
            return;
        }
        int wheelRotation = e.getWheelRotation();
        NodeView nodeView = view.getNodeView();
        if (!nodeView.isSelected()) {
            map.selectAsTheOnlyOneSelected(nodeView);
        }
        double factor = e.isControlDown() ? 1.0 : 6.0 * LengthUnit.pt.factor();
        double newZoomedWidth = Math.max(((double)view.getWidth() - (double)wheelRotation * factor) / (double)map.getZoom(), 0.0);
        IMapSelection selection = Controller.getCurrentController().getSelection();
        Quantity newZoomedWidthQuantity = LengthUnit.pixelsInPt((double)newZoomedWidth);
        ModeController modeController = map.getModeController();
        MNodeStyleController styleController = (MNodeStyleController)modeController.getExtension(NodeStyleController.class);
        selection.preserveRootNodeLocationOnScreen();
        for (NodeModel node : selection.getSelection()) {
            styleController.setMinNodeWidth(node, (Quantity<LengthUnit>)newZoomedWidthQuantity);
            styleController.setMaxNodeWidth(node, (Quantity<LengthUnit>)newZoomedWidthQuantity);
        }
    }
}

