/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.interfaces;

import java.awt.Point;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileRange;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.Attributed;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;

public interface TileSource
extends Attributed {
    public int getMaxZoom();

    public int getMinZoom();

    public String getName();

    public String getId();

    public String getTileUrl(int var1, int var2, int var3) throws IOException;

    public String getTileId(int var1, int var2, int var3);

    public int getTileSize();

    public int getDefaultTileSize();

    public double getDistance(double var1, double var3, double var5, double var7);

    public Point latLonToXY(double var1, double var3, int var5);

    default public Point latLonToXY(ICoordinate point, int zoom) {
        return this.latLonToXY(point.getLat(), point.getLon(), zoom);
    }

    default public ICoordinate xyToLatLon(Point point, int zoom) {
        return this.xyToLatLon(point.x, point.y, zoom);
    }

    public ICoordinate xyToLatLon(int var1, int var2, int var3);

    public TileXY latLonToTileXY(double var1, double var3, int var5);

    default public TileXY latLonToTileXY(ICoordinate point, int zoom) {
        return this.latLonToTileXY(point.getLat(), point.getLon(), zoom);
    }

    default public ICoordinate tileXYToLatLon(TileXY xy, int zoom) {
        return this.tileXYToLatLon(xy.getXIndex(), xy.getYIndex(), zoom);
    }

    default public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    public ICoordinate tileXYToLatLon(int var1, int var2, int var3);

    public int getTileXMax(int var1);

    public int getTileXMin(int var1);

    public int getTileYMax(int var1);

    public int getTileYMin(int var1);

    public boolean isNoTileAtZoom(Map<String, List<String>> var1, int var2, byte[] var3);

    public Map<String, String> getMetadata(Map<String, List<String>> var1);

    public IProjected tileXYtoProjected(int var1, int var2, int var3);

    public TileXY projectedToTileXY(IProjected var1, int var2);

    public boolean isInside(Tile var1, Tile var2);

    public TileRange getCoveringTileRange(Tile var1, int var2);

    public String getServerCRS();

    default public boolean isModTileFeatures() {
        return false;
    }
}

