/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources;

import java.awt.event.ActionEvent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.util.TextUtils;

@SelectableAction
public class SetBooleanPropertyAction
extends AFreeplaneAction {
    private static final String ACTION_KEY_PREFIX = "SetBooleanPropertyAction.";
    private String propertyName;

    public static String actionKey(String propertyName) {
        return ACTION_KEY_PREFIX + propertyName;
    }

    public SetBooleanPropertyAction(String propertyName) {
        super(SetBooleanPropertyAction.actionKey(propertyName), TextUtils.getRawText("OptionPanel." + propertyName), null);
        this.propertyName = propertyName;
        this.setIcon(propertyName + ".icon");
        this.setTooltip(this.getTooltipKey());
        this.setSelected();
        ResourceController.getResourceController().addPropertyChangeListener((String name, String newValue, String oldValue) -> {
            if (this.propertyName.equals(name)) {
                this.setSelected();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ResourceController.getResourceController().setProperty(this.propertyName, !this.isPropertySet());
    }

    @Override
    public String getTextKey() {
        return "OptionPanel." + this.propertyName;
    }

    @Override
    public String getTooltipKey() {
        return this.getTextKey() + ".tooltip";
    }

    @Override
    public void setSelected() {
        this.setSelected(this.isPropertySet());
    }

    public boolean isPropertySet() {
        return ResourceController.getResourceController().getBooleanProperty(this.propertyName);
    }
}

