/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;

public class XsltPipeReaderFactory {
    private final String xsltResource;

    public XsltPipeReaderFactory(String xsltResource) {
        this.xsltResource = xsltResource;
    }

    public Reader getReader(final InputStream in) throws IOException {
        final URL xsltUrl = ResourceController.getResourceController().getResource(this.xsltResource);
        if (xsltUrl == null) {
            LogUtils.severe("Can't find " + this.xsltResource + " as resource.");
            throw new IllegalArgumentException("Can't find " + this.xsltResource + " as resource.");
        }
        PipedReader reader = new PipedReader();
        final PipedWriter writer = new PipedWriter(reader);
        Thread transformationThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try (InputStream xsltFile = xsltUrl.openStream();
                     Writer writerToClose = writer;){
                    StreamResult result = new StreamResult(writer);
                    XsltPipeReaderFactory.this.transform(new StreamSource(in), xsltFile, result);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, "XSLT Transformation");
        transformationThread.start();
        return reader;
    }

    private void transform(Source xmlSource, InputStream xsltStream, Result result) throws TransformerFactoryConfigurationError {
        StreamSource xsltSource = new StreamSource(xsltStream);
        try {
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource, result);
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
    }
}

