/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.commandsearch;

import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.svgicons.FreeplaneIconFactory;
import org.freeplane.features.commandsearch.AcceleratorDescriptionCreator;
import org.freeplane.features.commandsearch.ItemChecker;
import org.freeplane.features.commandsearch.SearchItem;

public class MenuItem
extends SearchItem {
    private static final ImageIcon menuIcon = FreeplaneIconFactory.toImageIcon(ResourceController.getResourceController().getIcon("/images/menu_items.svg?useAccentColor=true"));
    private static final ImageIcon selectedMenuIcon = FreeplaneIconFactory.toImageIcon(ResourceController.getResourceController().getIcon("/images/selected_menu_items.svg?useAccentColor=true"));
    private final AFreeplaneAction action;
    private final String path;
    private final String tooltip;
    private final String searchedText;

    MenuItem(AFreeplaneAction action, String path) {
        int searchedTextStart = path.indexOf("->") + "->".length();
        this.path = path;
        this.searchedText = MenuItem.normalizeText(path.substring(searchedTextStart));
        this.action = action;
        this.tooltip = (String)action.getValue("ShortDescription");
    }

    @Override
    public Icon getTypeIcon() {
        if (this.action.checkSelectionOnPopup()) {
            this.action.setSelected();
        }
        return this.action.isSelected() ? selectedMenuIcon : menuIcon;
    }

    @Override
    public String getDisplayedText() {
        String accelerator = AcceleratorDescriptionCreator.INSTANCE.createAcceleratorDescription(this.action);
        return accelerator != null ? this.path + " (" + accelerator + ")" : this.path;
    }

    String getSearchedText() {
        String accelerator = AcceleratorDescriptionCreator.INSTANCE.createAcceleratorDescription(this.action);
        return accelerator != null ? this.searchedText + " (" + MenuItem.normalizeText(accelerator) + ")" : this.searchedText;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    void execute(InputEvent event) {
        if (this.action.isEnabled()) {
            this.action.actionPerformed(new ActionEvent(event.getSource(), 1001, (String)this.action.getValue("Name")));
        }
    }

    @Override
    void assignNewAccelerator() {
        this.assignNewAccelerator(this.action);
    }

    @Override
    boolean shouldUpdateResultList() {
        return true;
    }

    @Override
    int getItemTypeRank() {
        return 2;
    }

    @Override
    public String getComparedText() {
        return this.path;
    }

    @Override
    public String getCopiedText() {
        return this.getDisplayedText();
    }

    @Override
    protected boolean checkAndMatch(String searchTerm, ItemChecker textChecker) {
        return textChecker.contains(this.getSearchedText(), searchTerm);
    }

    public String toString() {
        return "MenuItem [" + this.getDisplayedText() + "]";
    }
}

