/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.explorer.NodeAlias;
import org.freeplane.features.map.MapModel;

class NodeAliases
implements IExtension {
    private final Map<NodeAlias, String> idsByAlias = new WeakHashMap<NodeAlias, String>();
    private final MapModel map;

    private NodeAliases(MapModel map) {
        this.map = map;
    }

    void add(NodeAlias alias, String id) {
        this.idsByAlias.put(alias, id);
    }

    Collection<NodeAlias> aliases() {
        ArrayList<NodeAlias> list = new ArrayList<NodeAlias>(this.idsByAlias.size());
        for (Map.Entry<NodeAlias, String> entry : this.idsByAlias.entrySet()) {
            if (this.map.getNodeForID(entry.getValue()) == null) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    static NodeAliases of(MapModel map) {
        NodeAliases aliases = map.getExtension(NodeAliases.class);
        if (aliases == null) {
            aliases = new NodeAliases(map);
            map.addExtension(aliases);
        }
        return aliases;
    }
}

