/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;

@SelectableAction
class QuickHighlightAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final FilterConditionEditor filterEditor;
    private final FilterController filterController;

    QuickHighlightAction(FilterController filterController, FilterConditionEditor quickEditor) {
        super("QuickHighlightAction");
        this.filterController = filterController;
        this.filterEditor = quickEditor;
        filterController.getHighlightNodes().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                QuickHighlightAction.this.setSelected(QuickHighlightAction.this.isModelSelected());
            }
        });
        this.setSelected(this.isModelSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ASelectableCondition condition = this.filterEditor.getCondition();
        boolean isSelected = !this.isModelSelected();
        this.filterController.getHighlightNodes().setSelected(isSelected);
        if (isSelected) {
            this.filterController.setHighlightCondition(condition, null);
        } else {
            this.setSelected(false);
            this.filterController.setHighlightCondition(null, null);
        }
    }

    private boolean isModelSelected() {
        return this.filterController.getHighlightNodes().isSelected();
    }
}

