/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.format;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.core.util.FactoryMethod;
import org.freeplane.core.util.SerializationMethod;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.IFormattedObject;

@FactoryMethod(value="deserialize")
@SerializationMethod(value="serialize")
public class FormattedDate
extends Date
implements IFormattedObject {
    public static final String ISO_DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    public static final String ISO_DATE_TIME_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mmZ";
    public static final Pattern ISO_DATE_TIME_REGEXP_PATTERN = Pattern.compile("\\d{4}(-?)\\d{2}(-?)\\d{2}(([ T])?\\d{2}(:?)\\d{2}(:?)(\\d{2})?(\\.\\d{3})?([-+]\\d{4})?)?");
    private SimpleDateFormat df;
    private String defaultType;

    public FormattedDate(FormattedDate date) {
        this(date.getTime(), date.getDateFormat());
    }

    public FormattedDate(Date date, String pattern) {
        super(date.getTime());
        this.df = FormatController.getController().getDateFormat(pattern);
    }

    public FormattedDate(long date, SimpleDateFormat df) {
        super(date);
        this.df = df;
    }

    public FormattedDate(long date) {
        this(date, FormatController.getController().getDefaultDateFormat());
        this.defaultType = "date";
    }

    public static FormattedDate createDefaultFormattedDate(long time, String type) {
        FormattedDate formattedDate = new FormattedDate(time, (SimpleDateFormat)FormatController.getController().getDefaultFormat(type));
        formattedDate.defaultType = type;
        return formattedDate;
    }

    @Override
    public String toString() {
        return this.df.format(this);
    }

    public static String serialize(FormattedDate date) {
        return FormattedDate.toStringISO(date) + "|" + (date.defaultType != null ? date.defaultType : date.df.toPattern());
    }

    public static String toStringISO(Date date) {
        return FormatController.getController().getDateFormat(ISO_DATE_TIME_FORMAT_PATTERN).format(date);
    }

    public static String toStringShortISO(Date date) {
        return FormatController.getController().getDateFormat(ISO_DATE_FORMAT_PATTERN).format(date);
    }

    public static Object deserialize(String text) {
        String arg;
        FormattedDate date;
        int index = text.indexOf(124);
        if (index == -1) {
            date = FormattedDate.toDateISO(text);
            arg = "date";
        } else {
            date = FormattedDate.toDateISO(text.substring(0, index));
            arg = text.substring(index + 1);
        }
        if (date == null) {
            return text;
        }
        if (arg.equals("date") || arg.equals("datetime")) {
            date.defaultType = arg;
            date.df = (SimpleDateFormat)FormatController.getController().getDefaultFormat(arg);
        } else {
            date.df = FormatController.getController().getDateFormat(arg);
        }
        return date;
    }

    public static FormattedDate toDate(String text) {
        return FormattedDate.toDateISO(text);
    }

    public static boolean isDate(String text) {
        if (text == null) {
            return false;
        }
        return ISO_DATE_TIME_REGEXP_PATTERN.matcher(text).matches();
    }

    public static FormattedDate toDateISO(String text) {
        Matcher matcher = ISO_DATE_TIME_REGEXP_PATTERN.matcher(text);
        if (matcher.matches()) {
            StringBuilder builder = new StringBuilder("yyyy");
            builder.append(matcher.group(1));
            builder.append("MM");
            builder.append(matcher.group(2));
            builder.append("dd");
            if (matcher.group(3) != null) {
                if (matcher.group(4) != null) {
                    builder.append('\'');
                    builder.append(matcher.group(4));
                    builder.append('\'');
                }
                builder.append("HH");
                builder.append(matcher.group(5));
                builder.append("mm");
                if (matcher.group(7) != null) {
                    builder.append(matcher.group(6));
                    builder.append("ss");
                }
                if (matcher.group(8) != null) {
                    builder.append(".SSS");
                }
                if (matcher.group(9) != null) {
                    builder.append("Z");
                }
            }
            String pattern = builder.toString();
            return FormattedDate.parseDate(text, pattern);
        }
        return null;
    }

    private static FormattedDate parseDate(String text, String pattern) {
        ParsePosition pos;
        SimpleDateFormat parser = FormatController.getController().getDateFormat(pattern);
        Date date = parser.parse(text, pos = new ParsePosition(0));
        if (date != null && pos.getIndex() == text.length()) {
            return new FormattedDate(date.getTime(), parser);
        }
        return null;
    }

    public boolean containsTime() {
        return this.df.toPattern().contains("m");
    }

    public SimpleDateFormat getDateFormat() {
        return this.df;
    }

    @Override
    public String getPattern() {
        return this.df.toPattern();
    }

    @Override
    public Date getObject() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof FormattedDate && super.equals(obj) && ((FormattedDate)obj).getDateFormat().equals(this.df);
    }

    @Override
    public int hashCode() {
        return 37 * super.hashCode() + this.df.hashCode();
    }
}

