/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.awt.Color;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.filter.condition.JCondition;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconStore;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.n3.nanoxml.XMLElement;

public class IconContainedCondition
extends ASelectableCondition {
    private static final IconStore STORE = IconStoreFactory.ICON_STORE;
    static final String ICON = "ICON";
    static final String NAME = "icon_contained_condition";
    private final String iconName;

    static ASelectableCondition load(XMLElement element) {
        return new IconContainedCondition(element.getAttribute(ICON, null));
    }

    public IconContainedCondition(String iconName) {
        this.iconName = iconName;
    }

    @Override
    public boolean checkNode(NodeModel node) {
        return this.iconFirstIndex(node) != -1 || this.isStateIconContained(node) || this.isLinkIconContained(node);
    }

    private boolean isLinkIconContained(NodeModel node) {
        return LinkController.getController().containsLinkDecorationIcon(node, this.iconName);
    }

    private int iconFirstIndex(NodeModel node) {
        Collection<NamedIcon> icons = IconController.getController().getIcons(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        int i = 0;
        for (NamedIcon nextIcon : icons) {
            if (this.iconName.equals(nextIcon.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean isStateIconContained(NodeModel node) {
        Collection<UIIcon> stateIcons = IconController.getController().getStateIcons(node);
        return stateIcons.stream().map(UIIcon::getName).anyMatch(this.iconName::equals);
    }

    private String getIconName() {
        return this.iconName;
    }

    @Override
    public JComponent createRendererComponent() {
        JCondition component = new JCondition();
        String text = TextUtils.getText("filter_icon") + ' ' + TextUtils.getText("filter_contains") + ' ';
        component.add(ConditionFactory.createConditionLabel(text));
        JLabel icon = ConditionFactory.createConditionLabel(STORE.getUIIcon(this.getIconName()));
        component.add(icon);
        icon.setBackground(Color.WHITE);
        icon.setOpaque(true);
        return component;
    }

    @Override
    public void fillXML(XMLElement child) {
        child.setAttribute(ICON, this.iconName);
    }

    @Override
    protected String createDescription() {
        return TextUtils.getText("filter_icon") + " \"" + this.getIconName() + "\"";
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

