/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.mode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.freeplane.core.extension.ExtensionContainer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.html.CssRuleBuilder;
import org.freeplane.core.ui.menubuilders.generic.BuilderDestroyerPair;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.undo.IUndoHandler;
import org.freeplane.features.commandsearch.CommandSearchAction;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.IExtensionCopier;
import org.freeplane.features.map.ITooltipProvider;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.AController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.FreeplaneActions;
import org.freeplane.features.mode.SelectAllAction;
import org.freeplane.features.mode.SelectBranchAction;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.ui.INodeViewLifeCycleListener;

public class ModeController
extends AController
implements FreeplaneActions {
    public static final String VIEW_MODE_PROPERTY = "view_mode";
    public static final List<String> USER_INTERFACE_PROPERTIES = Arrays.asList("view_mode");
    private final ExtensionContainer extensionContainer;
    private final Collection<IExtensionCopier> copiers;
    private boolean isBlocked = false;
    private MapController mapController;
    private final Map<Integer, ITooltipProvider> toolTip = new TreeMap<Integer, ITooltipProvider>();
    private final List<INodeViewLifeCycleListener> nodeViewListeners = new LinkedList<INodeViewLifeCycleListener>();
    private IUserInputListenerFactory userInputListenerFactory;
    private final Controller controller;

    public ModeController(Controller controller) {
        this.controller = controller;
        this.extensionContainer = new ExtensionContainer(new HashMap<Class<? extends IExtension>, IExtension>());
        this.copiers = new LinkedList<IExtensionCopier>();
        this.createActions();
    }

    private void createActions() {
        this.addAction(new SelectBranchAction());
        this.addAction(new SelectAllAction());
        this.addAction(new CommandSearchAction());
    }

    @Override
    public void addAction(AFreeplaneAction action) {
        super.addAction(action);
        if (this.mapController != null) {
            this.mapController.addListenerForAction(action);
        }
    }

    public void addExtension(Class<? extends IExtension> clazz, IExtension extension) {
        this.extensionContainer.addExtension(clazz, extension);
    }

    public void registerExtensionCopier(IExtensionCopier copier) {
        this.copiers.add(copier);
    }

    public void unregisterExtensionCopier(IExtensionCopier copier) {
        this.copiers.remove(copier);
    }

    public void copyExtensions(Object key, NodeModel from, NodeModel to) {
        for (IExtensionCopier copier : this.copiers) {
            copier.copy(key, from, to);
        }
    }

    public void undoableCopyExtensions(final Object key, final NodeModel from, final NodeModel to) {
        MapModel map = to.getMap();
        if (map == null) {
            this.copyExtensions(key, from, to);
            return;
        }
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        if (undoHandler == null) {
            this.copyExtensions(key, from, to);
            return;
        }
        final NodeModel backup = new NodeModel(null);
        this.copyExtensions(key, to, backup);
        IActor actor = new IActor(){

            @Override
            public void undo() {
                ModeController.this.removeExtensions(key, to);
                ModeController.this.copyExtensions(key, backup, to);
                ModeController.this.getMapController().nodeChanged(to);
            }

            @Override
            public String getDescription() {
                return "undoableCopyExtensions";
            }

            @Override
            public void act() {
                ModeController.this.copyExtensions(key, from, to);
                ModeController.this.getMapController().nodeChanged(to);
            }
        };
        this.execute(actor, map);
    }

    public void removeExtensions(Object key, NodeModel from, NodeModel which) {
        if (from.equals(which)) {
            for (IExtensionCopier copier : this.copiers) {
                copier.remove(key, from);
            }
            return;
        }
        for (IExtensionCopier copier : this.copiers) {
            copier.remove(key, from, which);
        }
    }

    public void undoableRemoveExtensions(final Object key, final NodeModel from, final NodeModel which) {
        MapModel map = from.getMap();
        if (map == null) {
            this.removeExtensions(key, from, which);
            return;
        }
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        if (undoHandler == null) {
            this.removeExtensions(key, from, which);
            return;
        }
        final NodeModel backup = new NodeModel(null);
        this.copyExtensions(key, from, backup);
        IActor actor = new IActor(){

            @Override
            public void undo() {
                ModeController.this.copyExtensions(key, backup, from);
                ModeController.this.getMapController().nodeChanged(from);
            }

            @Override
            public String getDescription() {
                return "undoableCopyExtensions";
            }

            @Override
            public void act() {
                ModeController.this.removeExtensions(key, from, which);
                ModeController.this.getMapController().nodeChanged(from);
            }
        };
        this.execute(actor, map);
    }

    public void resolveParentExtensions(Object key, NodeModel to) {
        for (IExtensionCopier copier : this.copiers) {
            copier.resolveParentExtensions(key, to);
        }
    }

    public void undoableResolveParentExtensions(final Object key, final NodeModel to) {
        MapModel map = to.getMap();
        if (map == null) {
            this.resolveParentExtensions(key, to);
            return;
        }
        IUndoHandler undoHandler = map.getExtension(IUndoHandler.class);
        if (undoHandler == null) {
            this.resolveParentExtensions(key, to);
            return;
        }
        final NodeModel backup = new NodeModel(null);
        this.copyExtensions(key, to, backup);
        IActor actor = new IActor(){

            @Override
            public void undo() {
                ModeController.this.copyExtensions(key, backup, to);
                ModeController.this.getMapController().nodeChanged(to);
            }

            @Override
            public String getDescription() {
                return "undoableCopyExtensions";
            }

            @Override
            public void act() {
                ModeController.this.resolveParentExtensions(key, to);
                ModeController.this.getMapController().nodeChanged(to);
            }
        };
        this.execute(actor, map);
    }

    void removeExtensions(Object key, NodeModel from) {
        for (IExtensionCopier copier : this.copiers) {
            copier.remove(key, from, from);
        }
    }

    public void addINodeViewLifeCycleListener(INodeViewLifeCycleListener listener) {
        this.nodeViewListeners.add(listener);
    }

    public void addUiBuilder(PhaseProcessor.Phase phase, String name, EntryVisitor builder) {
        this.addUiBuilder(phase, name, new BuilderDestroyerPair(builder));
    }

    public void addUiBuilder(PhaseProcessor.Phase phase, String name, EntryVisitor builder, EntryVisitor destroyer) {
        this.addUiBuilder(phase, name, new BuilderDestroyerPair(builder, destroyer));
    }

    public void addUiBuilder(PhaseProcessor.Phase phase, String name, BuilderDestroyerPair builderDestroyerPair) {
        this.getUserInputListenerFactory().addUiBuilder(phase, name, builderDestroyerPair);
    }

    public void commit() {
    }

    public boolean canEdit(MapModel map) {
        return this.canEdit() && map != null && !map.isReadOnly() && !this.isEditingLocked();
    }

    public UserRole userRole(MapModel map) {
        return map != null ? UserRole.EDITOR : UserRole.NO_MAP;
    }

    public boolean isEditingLocked() {
        return ResourceController.getResourceController().getBooleanProperty(VIEW_MODE_PROPERTY);
    }

    public void execute(IActor actor, MapModel map) {
        actor.act();
    }

    @Override
    public AFreeplaneAction getAction(String key) {
        AFreeplaneAction action = super.getAction(key);
        if (action != null) {
            return action;
        }
        return this.getController().getAction(key);
    }

    public Controller getController() {
        return this.controller;
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        return this.extensionContainer.getExtension(clazz);
    }

    public boolean containsExtension(Class<? extends IExtension> clazz) {
        return this.extensionContainer.containsExtension(clazz);
    }

    public void removeExtension(Class<? extends IExtension> clazz) {
        this.extensionContainer.removeExtension(clazz);
    }

    public MapController getMapController() {
        return this.mapController;
    }

    public String getModeName() {
        return null;
    }

    public IUserInputListenerFactory getUserInputListenerFactory() {
        return this.userInputListenerFactory;
    }

    public boolean hasOneVisibleChild(NodeModel parent, Filter filter) {
        int count = 0;
        for (NodeModel child : parent.getChildren()) {
            if (child.hasVisibleContent(filter)) {
                ++count;
            }
            if (count != 2) continue;
            return false;
        }
        return count == 1;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void onViewCreated(Container node) {
        for (INodeViewLifeCycleListener hook : this.nodeViewListeners) {
            hook.onViewCreated(node);
        }
    }

    public void onViewRemoved(Container node) {
        for (INodeViewLifeCycleListener hook : this.nodeViewListeners) {
            hook.onViewRemoved(node);
        }
    }

    @Override
    public AFreeplaneAction removeAction(String key) {
        AFreeplaneAction action = super.removeAction(key);
        if (this.mapController != null) {
            this.mapController.removeListenerForAction(action);
        }
        return action;
    }

    public void removeINodeViewLifeCycleListener(INodeViewLifeCycleListener listener) {
        this.nodeViewListeners.remove(listener);
    }

    public void rollback() {
    }

    public void setBlocked(boolean isBlocked) {
        this.isBlocked = isBlocked;
    }

    public void setMapController(MapController mapController) {
        this.mapController = mapController;
        this.addExtension(MapController.class, mapController);
    }

    public void setUserInputListenerFactory(IUserInputListenerFactory userInputListenerFactory) {
        this.userInputListenerFactory = userInputListenerFactory;
    }

    public void setVisible(boolean visible) {
        NodeModel node = this.getController().getSelection().getSelected();
        if (visible) {
            this.mapController.onSelect(node);
        } else if (node != null) {
            this.mapController.onDeselect(node);
        }
    }

    public void shutdown() {
    }

    public void startTransaction() {
    }

    public void forceNewTransaction() {
    }

    public void startup() {
    }

    public void updateMenus(String menuStructure, Set<String> plugins) {
        IUserInputListenerFactory userInputListenerFactory = this.getUserInputListenerFactory();
        userInputListenerFactory.updateMenus(menuStructure, plugins);
    }

    public boolean canEdit() {
        return false;
    }

    public String createToolTip(NodeModel node, Component view) {
        MapModel map = node.getMap();
        Color background = this.getExtension(MapStyle.class).getBackground(map);
        Color textColor = UITools.getTextColorForBackground(background);
        StringBuilder style = new StringBuilder("<style type='text/css'>").append(" body { font-size: 10pt;").append(new CssRuleBuilder().withColor(textColor).withBackground(background)).append("} table {border: 0; border-spacing: 0;}").append(" th, td {border: 1px solid;}").append("</style>");
        StringBuilder text = new StringBuilder("<html><head>" + style + "</head><body>");
        boolean tooltipSet = false;
        for (ITooltipProvider provider : this.toolTip.values()) {
            String value = provider.getTooltip(this, node, view);
            if (value == null) continue;
            value = value.replace("<html>", "<div>");
            value = value.replaceAll("\\s*<(?:style>.*?</style|/?(?:body|head))>", "");
            value = value.replace("</html>", "</div>");
            if (tooltipSet) {
                text.append("<hr>");
            }
            text.append(value);
            tooltipSet = true;
        }
        if (tooltipSet) {
            text.append("</body></html>");
            return text.toString();
        }
        return null;
    }

    public void addToolTipProvider(Integer key, ITooltipProvider tooltip) {
        if (tooltip == null) {
            if (this.toolTip.containsKey(key)) {
                this.toolTip.remove(key);
            }
        } else {
            this.toolTip.put(key, tooltip);
        }
    }

    public boolean canEdit(NodeModel model) {
        return true;
    }

    public boolean supportsHookActions() {
        return false;
    }

    public boolean shouldCenterCompactMaps() {
        return true;
    }
}

