/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle;

import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.features.nodestyle.NodeStyleShape;

public class NodeGeometryModel {
    private final NodeStyleShape shape;
    private final Quantity<LengthUnit> horizontalMargin;
    private final Quantity<LengthUnit> verticalMargin;
    private final boolean isUniform;
    public static final Quantity<LengthUnit> DEFAULT_MARGIN = new Quantity(2.0, (Enum)LengthUnit.pt);
    public static NodeGeometryModel NULL_SHAPE = new NodeGeometryModel(null, DEFAULT_MARGIN, DEFAULT_MARGIN, false);
    public static final NodeGeometryModel AS_PARENT = NULL_SHAPE.withShape(NodeStyleShape.as_parent);
    public static final NodeGeometryModel FORK = NULL_SHAPE.withShape(NodeStyleShape.fork);
    private static final Quantity<LengthUnit> DEFAULT_HORIZONTAL_OVAL_MARGIN = new Quantity(6.0, (Enum)LengthUnit.pt);
    private static final Quantity<LengthUnit> DEFAULT_VERTICAL_OVAL_MARGIN = new Quantity(12.0, (Enum)LengthUnit.pt);
    public static final NodeGeometryModel DEFAULT_ROOT_OVAL = NULL_SHAPE.withShape(NodeStyleShape.oval).withHorizontalMargin(DEFAULT_HORIZONTAL_OVAL_MARGIN).withVerticalMargin(DEFAULT_VERTICAL_OVAL_MARGIN);

    private NodeGeometryModel(NodeStyleShape shape, Quantity<LengthUnit> horizontalMargin, Quantity<LengthUnit> verticalMargin, boolean isUniform) {
        this.shape = shape;
        this.horizontalMargin = horizontalMargin;
        this.verticalMargin = verticalMargin;
        this.isUniform = isUniform;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.horizontalMargin == null ? 0 : this.horizontalMargin.hashCode());
        result = 31 * result + (this.isUniform ? 1231 : 1237);
        result = 31 * result + (this.shape == null ? 0 : this.shape.hashCode());
        result = 31 * result + (this.verticalMargin == null ? 0 : this.verticalMargin.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeGeometryModel other = (NodeGeometryModel)obj;
        if (this.shape != other.shape) {
            return false;
        }
        if (this.isUniform != other.isUniform) {
            return false;
        }
        if (!this.horizontalMargin.equals(other.horizontalMargin)) {
            return false;
        }
        return this.verticalMargin.equals(other.verticalMargin);
    }

    public NodeStyleShape getShape() {
        return this.shape;
    }

    public Quantity<LengthUnit> getHorizontalMargin() {
        return this.horizontalMargin;
    }

    public Quantity<LengthUnit> getVerticalMargin() {
        return this.verticalMargin;
    }

    public boolean isUniform() {
        return this.isUniform;
    }

    public NodeGeometryModel withShape(NodeStyleShape shape) {
        return new NodeGeometryModel(shape, this.horizontalMargin, this.verticalMargin, this.isUniform);
    }

    public NodeGeometryModel withHorizontalMargin(Quantity<LengthUnit> horizontalMargin) {
        return new NodeGeometryModel(this.shape, horizontalMargin, this.verticalMargin, this.isUniform);
    }

    public NodeGeometryModel withVerticalMargin(Quantity<LengthUnit> verticalMargin) {
        return new NodeGeometryModel(this.shape, this.horizontalMargin, verticalMargin, this.isUniform);
    }

    public NodeGeometryModel withUniform(boolean isUniform) {
        return new NodeGeometryModel(this.shape, this.horizontalMargin, this.verticalMargin, isUniform);
    }
}

