/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text;

import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.RichTextModel;

public class DetailModel
extends RichTextModel
implements IExtension {
    public static final String EDITING_PURPOSE = "DetailText";
    private boolean hidden = false;

    public static DetailModel createDetailText(NodeModel node) {
        DetailModel details = DetailModel.getDetail(node);
        if (details == null) {
            details = new DetailModel(false);
            node.addExtension(details);
        }
        return details;
    }

    public static DetailModel getDetail(NodeModel node) {
        DetailModel extension = node.getExtension(DetailModel.class);
        return extension;
    }

    public static String getDetailText(NodeModel node) {
        DetailModel extension = DetailModel.getDetail(node);
        return extension != null ? extension.getText() : null;
    }

    public static String getDetailContentType(NodeModel node) {
        DetailModel extension = DetailModel.getDetail(node);
        return extension != null ? extension.getContentType() : null;
    }

    public static String getDetailXml(NodeModel node) {
        DetailModel extension = DetailModel.getDetail(node);
        return extension != null ? extension.getText() : null;
    }

    public DetailModel(boolean hidden) {
        this.hidden = hidden;
    }

    public DetailModel(String contentType, String text, String xml, boolean hidden) {
        super(contentType, text, xml);
        this.hidden = hidden;
    }

    public DetailModel copy() {
        return new DetailModel(this.getContentType(), this.getText(), this.getXml(), this.hidden);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isEmpty() {
        return !this.hidden && super.isEmpty();
    }
}

