/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.attribute;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeSelection;
import org.freeplane.features.attribute.NodeAttribute;
import org.freeplane.features.map.NodeModel;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.attribute.AttributeTable;
import org.freeplane.view.swing.map.attribute.AttributeTableModel;
import org.freeplane.view.swing.map.attribute.AttributeView;

class AttributeSelectionChangeListener
implements PropertyChangeListener,
AttributeSelection {
    AttributeTable selectedTable;

    AttributeSelectionChangeListener() {
    }

    private void focusGained(Component source) {
        AttributeTable newTable = source instanceof AttributeTable ? (AttributeTable)source : (AttributeTable)SwingUtilities.getAncestorOfClass(AttributeTable.class, source);
        if (newTable != null) {
            this.selectedTable = newTable;
            this.selectedTable.setSelectedCellTypeInfo();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NodeView viewer;
                    Container newNodeViewInFocus;
                    if (AttributeSelectionChangeListener.this.selectedTable != null && (newNodeViewInFocus = SwingUtilities.getAncestorOfClass(NodeView.class, AttributeSelectionChangeListener.this.selectedTable)) != null && (viewer = (NodeView)newNodeViewInFocus) != viewer.getMap().getSelected()) {
                        viewer.getMap().selectAsTheOnlyOneSelected(viewer, false);
                    }
                }
            });
        }
    }

    private void focusLost(Component oppositeComponent) {
        if (this.selectedTable == null || null == SwingUtilities.getAncestorOfClass(MapView.class, oppositeComponent) && !(oppositeComponent instanceof AttributeTable)) {
            return;
        }
        Component newTable = oppositeComponent instanceof AttributeTable ? oppositeComponent : SwingUtilities.getAncestorOfClass(AttributeTable.class, oppositeComponent);
        if (this.selectedTable != newTable) {
            this.selectedTable.clearSelection();
            if (this.selectedTable.isEditing()) {
                this.selectedTable.getCellEditor().stopCellEditing();
            }
            if (!this.selectedTable.getAttributeView().isPopupShown()) {
                AttributeView attributeView = this.selectedTable.getAttributeView();
                String currentAttributeViewType = AttributeRegistry.getRegistry(attributeView.getNode().getMap()).getAttributeViewType();
                if (attributeView.getViewType() != currentAttributeViewType) {
                    attributeView.stateChanged(null);
                }
            }
            this.selectedTable = null;
            return;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Component newFocusOwner = (Component)evt.getNewValue();
        if (this.selectedTable != null) {
            this.focusLost(newFocusOwner);
        }
        this.focusGained(newFocusOwner);
    }

    @Override
    public List<AttributeSelection.SelectedAttribute> getSelectedAttributes() {
        if (this.selectedTable == null) {
            return AttributeSelection.EMPTY.getSelectedAttributes();
        }
        ListSelectionModel selectionModel = this.selectedTable.getSelectionModel();
        int minSelectedRow = selectionModel.getMinSelectionIndex();
        if (minSelectedRow == -1) {
            return AttributeSelection.EMPTY.getSelectedAttributes();
        }
        AttributeTableModel attributeTableModel = this.selectedTable.getAttributeTableModel();
        NodeModel node = attributeTableModel.getNode();
        int maxSelectedRow = selectionModel.getMaxSelectionIndex();
        ArrayList<AttributeSelection.SelectedAttribute> selectedAttributes = new ArrayList<AttributeSelection.SelectedAttribute>(maxSelectedRow - minSelectedRow + 1);
        for (int rowIndex = minSelectedRow; rowIndex <= maxSelectedRow; ++rowIndex) {
            if (!selectionModel.isSelectedIndex(rowIndex)) continue;
            AttributeSelection.SelectedAttribute.SelectedPart selectedPart = this.selectedTable.isCellSelected(rowIndex, 0) ? (this.selectedTable.isCellSelected(rowIndex, 1) ? AttributeSelection.SelectedAttribute.SelectedPart.BOTH : AttributeSelection.SelectedAttribute.SelectedPart.NAME) : AttributeSelection.SelectedAttribute.SelectedPart.VALUE;
            Attribute attribute = attributeTableModel.getAttribute(rowIndex);
            if (attribute == null) continue;
            NodeAttribute nodeAttrribute = new NodeAttribute(node, attribute);
            selectedAttributes.add(new AttributeSelection.SelectedAttribute(nodeAttrribute, selectedPart));
        }
        return selectedAttributes;
    }
}

