/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.cloud;

import java.awt.Graphics2D;
import java.awt.geom.QuadCurve2D;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.cloud.CloudView;

public class ArcCloudView
extends CloudView {
    @Override
    protected double calcDistanceBetweenPoints() {
        double distanceBetweenPoints = this.getIterativeLevel() > 4 ? 140.0 * this.getZoom() : 6.0 * this.getDistanceToConvexHull();
        return distanceBetweenPoints;
    }

    ArcCloudView(CloudModel cloudModel, NodeView source) {
        super(cloudModel, source);
    }

    @Override
    protected void paintDecoration(Graphics2D g, Graphics2D gstroke, double x0, double y0, double x1, double y1, double dx, double dy, double dxn, double dyn) {
        double middleDistanceToConvexHull = this.getDistanceToConvexHull();
        double distanceToConvexHull = middleDistanceToConvexHull * 2.2 * this.random(0.7);
        double xctrl = x0 + 0.5 * dx - distanceToConvexHull * dyn;
        double yctrl = y0 + 0.5 * dy + distanceToConvexHull * dxn;
        QuadCurve2D.Double shape = new QuadCurve2D.Double(x0, y0, xctrl, yctrl, x1, y1);
        g.fill(shape);
        gstroke.draw(shape);
    }
}

