/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.cloud;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.cloud.CloudViewFactory;
import org.freeplane.view.swing.map.cloud.ConvexHull;

public abstract class CloudView {
    static final Stroke DEF_STROKE = new BasicStroke(1.0f);
    protected CloudModel cloudModel;
    protected NodeView source;
    private final int iterativeLevel;
    private Random random;

    public static int getAdditionalHeigth(CloudModel cloud, NodeView source) {
        CloudView heightCalculator = new CloudViewFactory().createCloudView(cloud, source);
        return (int)(2.2 * heightCalculator.getDistanceToConvexHull());
    }

    CloudView(CloudModel cloudModel, NodeView source) {
        this.cloudModel = cloudModel;
        this.source = source;
        this.iterativeLevel = this.getCloudIterativeLevel();
    }

    private int getCloudIterativeLevel() {
        int iterativeLevel = 0;
        for (NodeView parentNode = this.source.getParentView(); parentNode != null; parentNode = parentNode.getParentView()) {
            if (null == parentNode.getCloudModel()) continue;
            ++iterativeLevel;
        }
        return iterativeLevel;
    }

    public Color getColor() {
        return this.source.getCloudColor();
    }

    protected double getDistanceToConvexHull() {
        return (double)(20 / (this.getIterativeLevel() + 1)) * this.getZoom();
    }

    public Color getExteriorColor(Color color) {
        return color.darker();
    }

    protected int getIterativeLevel() {
        return this.iterativeLevel;
    }

    protected MapView getMap() {
        return this.source.getMap();
    }

    protected CloudModel getModel() {
        return this.cloudModel;
    }

    public int getRealWidth() {
        int width = this.getWidth();
        return width < 1 ? 1 : width;
    }

    public Stroke getStroke() {
        int width = this.getWidth();
        if (width < 1) {
            return DEF_STROKE;
        }
        return new BasicStroke(width, 0, 0);
    }

    public int getWidth() {
        NodeModel node = this.source.getNode();
        return CloudController.getController(this.source.getMap().getModeController()).getWidth(node);
    }

    protected double getZoom() {
        return this.getMap().getZoom();
    }

    public void paint(Graphics graphics) {
        this.random = new Random(0L);
        Graphics2D g = (Graphics2D)graphics.create();
        Graphics2D gstroke = (Graphics2D)g.create();
        Color color = this.getColor();
        g.setColor(color);
        g.setStroke(this.getStroke());
        gstroke.setColor(this.getExteriorColor(color));
        gstroke.setStroke(this.getStroke());
        this.paintDecoration(g, gstroke);
        g.dispose();
    }

    protected Polygon getCoordinates() {
        Polygon p = new Polygon();
        LinkedList<Point> coordinates = new LinkedList<Point>();
        this.source.getCoordinates(coordinates);
        ConvexHull hull = new ConvexHull();
        Vector<Point> res = hull.calculateHull(coordinates);
        Point lastPt = null;
        for (int i = 0; i < res.size(); ++i) {
            Point pt = res.get(i);
            if (pt.equals(lastPt)) continue;
            p.addPoint(pt.x, pt.y);
            lastPt = pt;
        }
        Point pt = res.get(0);
        p.addPoint(pt.x, pt.y);
        return p;
    }

    protected void paintDecoration(Graphics2D g, Graphics2D gstroke) {
        Polygon p = this.getCoordinates();
        this.fillPolygon(p, g);
        double middleDistanceBetweenPoints = this.calcDistanceBetweenPoints();
        int[] xpoints = p.xpoints;
        int[] ypoints = p.ypoints;
        Point lastPoint = new Point(xpoints[0], ypoints[0]);
        double x0 = lastPoint.x;
        double y0 = lastPoint.y;
        double x2 = x0;
        double y2 = y0;
        for (int i = p.npoints - 2; i >= 0; --i) {
            double distanceBetweenPoints;
            Point nextPoint = new Point(xpoints[i], ypoints[i]);
            double x1 = nextPoint.x;
            double y1 = nextPoint.y;
            double dx = x1 - x0;
            double dy = y1 - y0;
            double length = Math.sqrt(dx * dx + dy * dy);
            double dxn = dx / length;
            double dyn = dy / length;
            int j = 0;
            while ((double)j + 2.0 * (distanceBetweenPoints = middleDistanceBetweenPoints * this.random(0.7)) < length) {
                j = (int)((double)j + distanceBetweenPoints);
                double x3 = x0 + (double)j * dxn;
                double y3 = y0 + (double)j * dyn;
                this.paintDecoration(g, gstroke, x2, y2, x3, y3);
                x2 = x3;
                y2 = y3;
            }
            this.paintDecoration(g, gstroke, x2, y2, x1, y1);
            x2 = x1;
            y2 = y1;
            x0 = x1;
            y0 = y1;
        }
    }

    protected void fillPolygon(Polygon p, Graphics2D g) {
        g.fillPolygon(p);
        g.drawPolygon(p);
    }

    protected void paintDecoration(Graphics2D g, Graphics2D gstroke, double x0, double y0, double x1, double y1) {
        double dx = x1 - x0;
        double dy = y1 - y0;
        double length = Math.sqrt(dx * dx + dy * dy);
        double dxn = dx / length;
        double dyn = dy / length;
        this.paintDecoration(g, gstroke, x0, y0, x1, y1, dx, dy, dxn, dyn);
    }

    protected abstract void paintDecoration(Graphics2D var1, Graphics2D var2, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17);

    protected double calcDistanceBetweenPoints() {
        double distanceBetweenPoints = this.getDistanceToConvexHull();
        return distanceBetweenPoints;
    }

    protected double random(double min) {
        return min + (1.0 - min) * this.random.nextDouble();
    }
}

