/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.base.ClassLoaders;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.Optionals;
import com.tngtech.archunit.base.ResolvesTypesViaReflection;
import com.tngtech.archunit.base.Suppliers;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.ImportContext;
import com.tngtech.archunit.core.domain.InstanceofCheck;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaCall;
import com.tngtech.archunit.core.domain.JavaClassDependencies;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaClassMembers;
import com.tngtech.archunit.core.domain.JavaClassTransitiveDependencies;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaCodeUnitAccess;
import com.tngtech.archunit.core.domain.JavaCodeUnitReference;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaConstructorReference;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaMethodReference;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.domain.JavaPackage;
import com.tngtech.archunit.core.domain.JavaStaticInitializer;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.domain.PackageMatcher;
import com.tngtech.archunit.core.domain.ReferencedClassObject;
import com.tngtech.archunit.core.domain.ReverseDependencies;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.ThrowsDeclaration;
import com.tngtech.archunit.core.domain.properties.CanBeAnnotated;
import com.tngtech.archunit.core.domain.properties.HasAnnotations;
import com.tngtech.archunit.core.domain.properties.HasModifiers;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.core.domain.properties.HasTypeParameters;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableCollection;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class JavaClass
implements JavaType,
HasName.AndFullName,
HasTypeParameters<JavaClass>,
HasAnnotations<JavaClass>,
HasModifiers,
HasSourceCodeLocation {
    private final Optional<Source> source;
    private final SourceCodeLocation sourceCodeLocation;
    private final JavaClassDescriptor descriptor;
    private JavaPackage javaPackage;
    private final boolean isInterface;
    private final boolean isEnum;
    private final boolean isAnnotation;
    private final boolean isRecord;
    private final boolean isAnonymousClass;
    private final boolean isMemberClass;
    private final Set<JavaModifier> modifiers;
    private List<JavaTypeVariable<JavaClass>> typeParameters = Collections.emptyList();
    private final Supplier<Class<?>> reflectSupplier;
    private JavaClassMembers members = JavaClassMembers.empty(this);
    private Superclass superclass = Superclass.access$000();
    private final Supplier<List<JavaClass>> allRawSuperclasses = Suppliers.memoize(() -> {
        ImmutableList.Builder result = ImmutableList.builder();
        JavaClass current = this;
        while (current.getRawSuperclass().isPresent()) {
            current = current.getRawSuperclass().get();
            result.add(current);
        }
        return result.build();
    });
    private Interfaces interfaces = Interfaces.EMPTY;
    private final Supplier<Set<JavaClass>> allRawInterfaces = Suppliers.memoize(() -> {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaClass i : this.interfaces.getRaw()) {
            result.add(i);
            result.addAll(i.getAllRawInterfaces());
        }
        result.addAll(this.superclass.getAllRawInterfaces());
        return result.build();
    });
    private final Supplier<List<JavaClass>> classHierarchy = Suppliers.memoize(() -> {
        ImmutableList.Builder result = ImmutableList.builder();
        result.add(this);
        result.addAll(this.getAllRawSuperclasses());
        return result.build();
    });
    private final Set<JavaClass> subclasses = new HashSet<JavaClass>();
    private final Supplier<Set<JavaClass>> allSubclasses = Suppliers.memoize(() -> {
        HashSet<JavaClass> result = new HashSet<JavaClass>();
        for (JavaClass subclass : this.subclasses) {
            result.add(subclass);
            result.addAll(subclass.getAllSubclasses());
        }
        return ImmutableSet.copyOf(result);
    });
    private EnclosingDeclaration enclosingDeclaration = EnclosingDeclaration.ABSENT;
    private Optional<JavaClass> componentType = Optional.empty();
    private Map<String, JavaAnnotation<JavaClass>> annotations = Collections.emptyMap();
    private JavaClassDependencies javaClassDependencies = new JavaClassDependencies(this);
    private ReverseDependencies reverseDependencies = ReverseDependencies.EMPTY;
    private final CompletionProcess completionProcess;

    JavaClass(DomainBuilders.JavaClassBuilder builder) {
        this.source = Preconditions.checkNotNull(builder.getSource());
        this.descriptor = Preconditions.checkNotNull(builder.getDescriptor());
        this.isInterface = builder.isInterface();
        this.isEnum = builder.isEnum();
        this.isAnnotation = builder.isAnnotation();
        this.isRecord = builder.isRecord();
        this.isAnonymousClass = builder.isAnonymousClass();
        this.isMemberClass = builder.isMemberClass();
        this.modifiers = Preconditions.checkNotNull(builder.getModifiers());
        this.reflectSupplier = Suppliers.memoize(new ReflectClassSupplier());
        this.sourceCodeLocation = SourceCodeLocation.of(this);
        this.javaPackage = JavaPackage.simple(this);
        this.completionProcess = builder.isStub() ? CompletionProcess.stub() : CompletionProcess.start();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<Source> getSource() {
        return this.source;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return "Class <" + this.getName() + ">";
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName() {
        return this.descriptor.getFullyQualifiedClassName();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getFullName() {
        return this.getName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getSimpleName() {
        return this.descriptor.getSimpleClassName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaPackage getPackage() {
        return this.javaPackage;
    }

    void setPackage(JavaPackage javaPackage) {
        this.javaPackage = Preconditions.checkNotNull(javaPackage);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getPackageName() {
        return this.descriptor.getPackageName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isPrimitive() {
        return this.descriptor.isPrimitive();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isInterface() {
        return this.isInterface;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isEnum() {
        return this.isEnum;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isRecord() {
        return this.isRecord;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaEnumConstant> tryGetEnumConstant(String name) {
        Optional<JavaField> field = this.tryGetField(name);
        if (!field.isPresent() || !field.get().getModifiers().contains((Object)JavaModifier.ENUM)) {
            return Optional.empty();
        }
        return Optional.of(new JavaEnumConstant(this, field.get().getName()));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaEnumConstant getEnumConstant(String name) {
        Optional<JavaEnumConstant> enumConstant = this.tryGetEnumConstant(name);
        Preconditions.checkArgument(enumConstant.isPresent(), "There exists no enum constant with name '%s' in class %s", (Object)name, (Object)this.getName());
        return enumConstant.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaEnumConstant> getEnumConstants() {
        return this.members.getEnumConstants();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isArray() {
        return this.descriptor.isArray();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getComponentType() {
        Optional<JavaClass> componentType = this.tryGetComponentType();
        if (!componentType.isPresent()) {
            throw new IllegalStateException(String.format("Type %s is no array", this.getSimpleName()));
        }
        return componentType.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaClass> tryGetComponentType() {
        return this.componentType;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getBaseComponentType() {
        JavaClass type = this;
        while (type.isArray()) {
            type = type.getComponentType();
        }
        return type;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isTopLevelClass() {
        return !this.isNestedClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isNestedClass() {
        return this.enclosingDeclaration.isPresent();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMemberClass() {
        return this.isNestedClass() && this.isMemberClass;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isInnerClass() {
        return this.isNestedClass() && !this.getModifiers().contains((Object)JavaModifier.STATIC);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isLocalClass() {
        return this.isNestedClass() && !this.isMemberClass() && !this.getSimpleName().isEmpty();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnonymousClass() {
        return this.isAnonymousClass;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(Class<? extends Annotation> annotationType) {
        return this.isAnnotatedWith(annotationType.getName());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(String annotationTypeName) {
        return this.annotations.containsKey(annotationTypeName);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return CanBeAnnotated.Utils.isAnnotatedWith(this.annotations.values(), predicate);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(Class<? extends Annotation> type) {
        return this.isMetaAnnotatedWith(type.getName());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(String typeName) {
        return this.isMetaAnnotatedWith(HasType.Functions.GET_RAW_TYPE.then(HasName.Functions.GET_NAME).is(DescribedPredicate.equalTo(typeName)));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isMetaAnnotatedWith(DescribedPredicate<? super JavaAnnotation<?>> predicate) {
        return CanBeAnnotated.Utils.isMetaAnnotatedWith(this.annotations.values(), predicate);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <A extends Annotation> A getAnnotationOfType(Class<A> type) {
        return this.getAnnotationOfType(type.getName()).as(type);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaAnnotation<JavaClass> getAnnotationOfType(String typeName) {
        Optional<JavaAnnotation<JavaClass>> annotation = this.tryGetAnnotationOfType(typeName);
        if (!annotation.isPresent()) {
            throw new IllegalArgumentException(String.format("Type %s is not annotated with @%s", this.getSimpleName(), typeName));
        }
        return annotation.get();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAnnotation<JavaClass>> getAnnotations() {
        return ImmutableSet.copyOf(this.annotations.values());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public <A extends Annotation> Optional<A> tryGetAnnotationOfType(Class<A> type) {
        return this.tryGetAnnotationOfType(type.getName()).map(CanBeAnnotated.Utils.toAnnotationOfType(type));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaAnnotation<JavaClass>> tryGetAnnotationOfType(String typeName) {
        return Optional.ofNullable(this.annotations.get(typeName));
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaTypeVariable<JavaClass>> getTypeParameters() {
        return this.typeParameters;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<InstanceofCheck> getInstanceofChecks() {
        return this.members.getInstanceofChecks();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<ReferencedClassObject> getReferencedClassObjects() {
        return this.members.getReferencedClassObjects();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass toErasure() {
        return this;
    }

    @Override
    public Set<JavaClass> getAllInvolvedRawTypes() {
        return ImmutableSet.of(this.getBaseComponentType());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaClass> getRawSuperclass() {
        return this.superclass.getRaw();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaType> getSuperclass() {
        return this.superclass.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaClass> getClassHierarchy() {
        return this.classHierarchy.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaClass> getAllRawSuperclasses() {
        return this.allRawSuperclasses.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getSubclasses() {
        return this.subclasses;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaType> getInterfaces() {
        return this.interfaces.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getRawInterfaces() {
        return this.interfaces.getRaw();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getAllRawInterfaces() {
        return this.allRawInterfaces.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getAllClassesSelfIsAssignableTo() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(this)).addAll(this.getAllRawSuperclasses())).addAll(this.getAllRawInterfaces())).build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaClass> getEnclosingClass() {
        return this.enclosingDeclaration.getEnclosingClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaCodeUnit> getEnclosingCodeUnit() {
        return this.enclosingDeclaration.getEnclosingCodeUnit();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getAllSubclasses() {
        return this.allSubclasses.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMember> getMembers() {
        return this.members.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMember> getAllMembers() {
        return this.members.getAll();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaField> getFields() {
        return this.members.getFields();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaField> getAllFields() {
        return this.members.getAllFields();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaField getField(String name) {
        return this.members.getField(name);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaField> tryGetField(String name) {
        return this.members.tryGetField(name);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCodeUnit> getCodeUnits() {
        return this.members.getCodeUnits();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getCodeUnitWithParameterTypes(String name, Class<?> ... parameters) {
        return this.getCodeUnitWithParameterTypes(name, ImmutableList.copyOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getCodeUnitWithParameterTypeNames(String name, String ... parameters) {
        return this.getCodeUnitWithParameterTypeNames(name, ImmutableList.copyOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getCodeUnitWithParameterTypes(String name, List<Class<?>> parameters) {
        return this.getCodeUnitWithParameterTypeNames(name, Formatters.formatNamesOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaCodeUnit> tryGetCodeUnitWithParameterTypes(String name, List<Class<?>> parameters) {
        return this.tryGetCodeUnitWithParameterTypeNames(name, Formatters.formatNamesOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getCodeUnitWithParameterTypeNames(String name, List<String> parameters) {
        return this.members.getCodeUnitWithParameterTypeNames(name, parameters);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaCodeUnit> tryGetCodeUnitWithParameterTypeNames(String name, List<String> parameters) {
        return this.members.tryGetCodeUnitWithParameterTypeNames(name, parameters);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaMethod getMethod(String name) {
        return this.members.getMethod(name, Collections.emptyList());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaMethod getMethod(String name, Class<?> ... parameters) {
        return this.members.getMethod(name, Formatters.formatNamesOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaMethod getMethod(String name, String ... parameters) {
        return this.members.getMethod(name, ImmutableList.copyOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaMethod> tryGetMethod(String name) {
        return this.members.tryGetMethod(name, Collections.emptyList());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaMethod> tryGetMethod(String name, Class<?> ... parameters) {
        return this.members.tryGetMethod(name, Formatters.formatNamesOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaMethod> tryGetMethod(String name, String ... parameters) {
        return this.members.tryGetMethod(name, ImmutableList.copyOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethod> getMethods() {
        return this.members.getMethods();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethod> getAllMethods() {
        return this.members.getAllMethods();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaConstructor getConstructor() {
        return this.members.getConstructor(Collections.emptyList());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaConstructor getConstructor(Class<?> ... parameters) {
        return this.members.getConstructor(Formatters.formatNamesOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaConstructor getConstructor(String ... parameters) {
        return this.members.getConstructor(ImmutableList.copyOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaConstructor> tryGetConstructor() {
        return this.members.tryGetConstructor(Collections.emptyList());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaConstructor> tryGetConstructor(Class<?> ... parameters) {
        return this.members.tryGetConstructor(Formatters.formatNamesOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaConstructor> tryGetConstructor(String ... parameters) {
        return this.members.tryGetConstructor(ImmutableList.copyOf(parameters));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructor> getConstructors() {
        return this.members.getConstructors();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructor> getAllConstructors() {
        return this.members.getAllConstructors();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Optional<JavaStaticInitializer> getStaticInitializer() {
        return this.members.getStaticInitializer();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAccess<?>> getAccessesFromSelf() {
        return Sets.union(this.getFieldAccessesFromSelf(), this.getCodeUnitAccessesFromSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAccess<?>> getAllAccessesFromSelf() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaClass clazz : this.getClassHierarchy()) {
            result.addAll(clazz.getAccessesFromSelf());
        }
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaFieldAccess> getFieldAccessesFromSelf() {
        return this.members.getFieldAccessesFromSelf();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCodeUnitAccess<?>> getCodeUnitAccessesFromSelf() {
        return Sets.union(this.getCodeUnitCallsFromSelf(), this.getCodeUnitReferencesFromSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCall<?>> getCodeUnitCallsFromSelf() {
        return Sets.union(this.getMethodCallsFromSelf(), this.getConstructorCallsFromSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethodCall> getMethodCallsFromSelf() {
        return this.members.getMethodCallsFromSelf();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructorCall> getConstructorCallsFromSelf() {
        return this.members.getConstructorCallsFromSelf();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCodeUnitReference<?>> getCodeUnitReferencesFromSelf() {
        return Sets.union(this.getMethodReferencesFromSelf(), this.getConstructorReferencesFromSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethodReference> getMethodReferencesFromSelf() {
        return this.members.getMethodReferencesFromSelf();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructorReference> getConstructorReferencesFromSelf() {
        return this.members.getConstructorReferencesFromSelf();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getDirectDependenciesFromSelf() {
        return this.javaClassDependencies.getDirectDependenciesFromClass();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getTransitiveDependenciesFromSelf() {
        return JavaClassTransitiveDependencies.findTransitiveDependenciesFrom(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<Dependency> getDirectDependenciesToSelf() {
        return this.reverseDependencies.getDirectDependenciesTo(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaFieldAccess> getFieldAccessesToSelf() {
        return this.members.getFieldAccessesToSelf();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCodeUnitAccess<?>> getCodeUnitAccessesToSelf() {
        return Sets.union(this.getCodeUnitCallsToSelf(), this.getCodeUnitReferencesToSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCall<?>> getCodeUnitCallsToSelf() {
        return Sets.union(this.getMethodCallsToSelf(), this.getConstructorCallsToSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCodeUnitReference<?>> getCodeUnitReferencesToSelf() {
        return Sets.union(this.getMethodReferencesToSelf(), this.getConstructorReferencesToSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethodCall> getMethodCallsToSelf() {
        return this.members.getMethodCallsToSelf();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethodReference> getMethodReferencesToSelf() {
        return this.members.getMethodReferencesToSelf();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructorCall> getConstructorCallsToSelf() {
        return this.members.getConstructorCallsToSelf();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructorReference> getConstructorReferencesToSelf() {
        return this.members.getConstructorReferencesToSelf();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAccess<?>> getAccessesToSelf() {
        return Sets.union(this.getFieldAccessesToSelf(), this.getCodeUnitAccessesToSelf());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaField> getFieldsWithTypeOfSelf() {
        return this.reverseDependencies.getFieldsWithTypeOf(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethod> getMethodsWithParameterTypeOfSelf() {
        return this.reverseDependencies.getMethodsWithParameterTypeOf(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaMethod> getMethodsWithReturnTypeOfSelf() {
        return this.reverseDependencies.getMethodsWithReturnTypeOf(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<ThrowsDeclaration<JavaMethod>> getMethodThrowsDeclarationsWithTypeOfSelf() {
        return this.reverseDependencies.getMethodThrowsDeclarationsWithTypeOf(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructor> getConstructorsWithParameterTypeOfSelf() {
        return this.reverseDependencies.getConstructorsWithParameterTypeOf(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<ThrowsDeclaration<JavaConstructor>> getConstructorsWithThrowsDeclarationTypeOfSelf() {
        return this.reverseDependencies.getConstructorsWithThrowsDeclarationTypeOf(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAnnotation<?>> getAnnotationsWithTypeOfSelf() {
        return this.reverseDependencies.getAnnotationsWithTypeOf(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaAnnotation<?>> getAnnotationsWithParameterTypeOfSelf() {
        return this.reverseDependencies.getAnnotationsWithParameterTypeOf(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<InstanceofCheck> getInstanceofChecksWithTypeOfSelf() {
        return this.reverseDependencies.getInstanceofChecksWithTypeOf(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isFullyImported() {
        return this.completionProcess.hasFinished();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isEquivalentTo(Class<?> clazz) {
        return this.getName().equals(clazz.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableFrom(Class<?> type) {
        return this.isAssignableFrom(type.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableFrom(String typeName) {
        return this.isAssignableFrom(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(typeName)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableFrom(DescribedPredicate<? super JavaClass> predicate) {
        ImmutableCollection possibleTargets = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(this)).addAll(this.getAllSubclasses())).build();
        return this.anyMatches((List<JavaClass>)((Object)possibleTargets), predicate);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableTo(Class<?> type) {
        return this.isAssignableTo(type.getName());
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableTo(String typeName) {
        return this.isAssignableTo(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(typeName)));
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isAssignableTo(DescribedPredicate<? super JavaClass> predicate) {
        ImmutableCollection possibleTargets = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.getClassHierarchy())).addAll(this.getAllRawInterfaces())).build();
        return this.anyMatches((List<JavaClass>)((Object)possibleTargets), predicate);
    }

    private boolean anyMatches(List<JavaClass> possibleTargets, DescribedPredicate<? super JavaClass> predicate) {
        return possibleTargets.stream().anyMatch(predicate);
    }

    @ResolvesTypesViaReflection
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Class<?> reflect() {
        return this.reflectSupplier.get();
    }

    void completeClassHierarchyFrom(ImportContext context) {
        this.completeSuperclassFrom(context);
        this.completeInterfacesFrom(context);
        this.completionProcess.markClassHierarchyComplete();
    }

    private void completeSuperclassFrom(ImportContext context) {
        Optional<JavaClass> rawSuperclass = context.createSuperclass(this);
        if (rawSuperclass.isPresent()) {
            rawSuperclass.get().subclasses.add(this);
            this.superclass = this.superclass.withRawType(rawSuperclass.get());
        }
    }

    private void completeInterfacesFrom(ImportContext context) {
        List<JavaClass> rawInterfaces = context.createInterfaces(this);
        for (JavaClass i : rawInterfaces) {
            i.subclasses.add(this);
        }
        this.interfaces = this.interfaces.withRawTypes(rawInterfaces);
    }

    void completeEnclosingDeclarationFrom(ImportContext context) {
        this.enclosingDeclaration = this.createEnclosingDeclaration(context);
        this.completionProcess.markEnclosingDeclarationComplete();
    }

    private EnclosingDeclaration createEnclosingDeclaration(ImportContext context) {
        Optional<JavaCodeUnit> enclosingCodeUnit = context.createEnclosingCodeUnit(this);
        return enclosingCodeUnit.map(EnclosingDeclaration::ofCodeUnit).orElseGet(() -> EnclosingDeclaration.ofClass(context.createEnclosingClass(this)));
    }

    void completeTypeParametersFrom(ImportContext context) {
        this.typeParameters = context.createTypeParameters(this);
        this.completionProcess.markTypeParametersComplete();
    }

    void completeGenericSuperclassFrom(ImportContext context) {
        Optional<JavaType> genericSuperclass = context.createGenericSuperclass(this);
        genericSuperclass.ifPresent(javaType -> {
            this.superclass = this.superclass.withGenericType((JavaType)javaType);
        });
        this.completionProcess.markGenericSuperclassComplete();
    }

    void completeGenericInterfacesFrom(ImportContext context) {
        Optional<List<JavaType>> genericInterfaces = context.createGenericInterfaces(this);
        genericInterfaces.ifPresent(javaTypes -> {
            this.interfaces = this.interfaces.withGenericTypes((List<JavaType>)javaTypes);
        });
        this.completionProcess.markGenericInterfacesComplete();
    }

    void completeMembers(ImportContext context) {
        this.members = JavaClassMembers.create(this, context);
        this.completionProcess.markMembersComplete();
    }

    void completeAnnotations(ImportContext context) {
        this.annotations = context.createAnnotations(this);
        this.members.completeAnnotations(context);
        this.completionProcess.markAnnotationsComplete();
    }

    JavaClassDependencies completeFrom(ImportContext context) {
        this.completeComponentType(context);
        this.members.completeFrom(context);
        this.javaClassDependencies = new JavaClassDependencies(this);
        return this.javaClassDependencies;
    }

    private void completeComponentType(ImportContext context) {
        JavaClass current = this;
        while (current.isArray() && !current.componentType.isPresent()) {
            JavaClass componentType = context.resolveClass(current.descriptor.tryGetComponentType().get().getFullyQualifiedClassName());
            current.componentType = Optional.of(componentType);
            current = componentType;
        }
    }

    void setReverseDependencies(ReverseDependencies reverseDependencies) {
        this.reverseDependencies = reverseDependencies;
        this.members.setReverseDependencies(reverseDependencies);
        this.completionProcess.markDependenciesComplete();
    }

    public String toString() {
        return "JavaClass{name='" + this.descriptor.getFullyQualifiedClassName() + "'}";
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<ThrowsDeclaration<? extends JavaCodeUnit>> getThrowsDeclarations() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (JavaCodeUnit codeUnit : this.getCodeUnits()) {
            result.addAll(codeUnit.getThrowsClause());
        }
        return result.build();
    }

    private static class Superclass {
        private static final Superclass ABSENT = new Superclass(Optional.empty());
        private final Optional<JavaClass> rawType;
        private final Optional<JavaType> type;

        private Superclass(JavaType type) {
            this(Optional.of(type));
        }

        private Superclass(Optional<JavaType> type) {
            this.rawType = type.map(JavaType.Functions.TO_ERASURE);
            this.type = type;
        }

        Optional<JavaClass> getRaw() {
            return this.rawType;
        }

        Optional<JavaType> get() {
            return Optional.ofNullable(this.type.orElse(this.rawType.orElse(null)));
        }

        Set<JavaClass> getAllRawInterfaces() {
            return this.rawType.isPresent() ? this.rawType.get().getAllRawInterfaces() : Collections.emptySet();
        }

        Superclass withRawType(JavaClass newRawType) {
            return new Superclass(newRawType);
        }

        Superclass withGenericType(JavaType newGenericType) {
            return new Superclass(newGenericType);
        }

        static /* synthetic */ Superclass access$000() {
            return ABSENT;
        }
    }

    private static class Interfaces {
        static final Interfaces EMPTY = new Interfaces(ImmutableSet.of(), ImmutableSet.of());
        private final ImmutableSet<JavaClass> rawTypes;
        private final ImmutableSet<JavaType> types;

        private Interfaces(ImmutableSet<JavaClass> rawTypes, ImmutableSet<JavaType> types) {
            this.rawTypes = Preconditions.checkNotNull(rawTypes);
            this.types = Preconditions.checkNotNull(types);
        }

        ImmutableSet<JavaClass> getRaw() {
            return this.rawTypes;
        }

        ImmutableSet<JavaType> get() {
            return this.types.isEmpty() ? this.getRawTypesAsJavaTypes() : this.types;
        }

        private ImmutableSet<JavaType> getRawTypesAsJavaTypes() {
            return this.getRaw();
        }

        Interfaces withRawTypes(List<JavaClass> rawTypes) {
            return new Interfaces(ImmutableSet.copyOf(rawTypes), this.types);
        }

        Interfaces withGenericTypes(List<JavaType> genericTypes) {
            return new Interfaces(this.rawTypes, ImmutableSet.copyOf(genericTypes));
        }
    }

    private static class EnclosingDeclaration {
        static final EnclosingDeclaration ABSENT = new EnclosingDeclaration(Optional.empty(), Optional.empty());
        private final Optional<JavaCodeUnit> enclosingCodeUnit;
        private final Optional<JavaClass> enclosingClass;

        private EnclosingDeclaration(Optional<JavaCodeUnit> enclosingCodeUnit, Optional<JavaClass> enclosingClass) {
            this.enclosingCodeUnit = Preconditions.checkNotNull(enclosingCodeUnit);
            this.enclosingClass = Preconditions.checkNotNull(enclosingClass);
        }

        boolean isPresent() {
            return this.enclosingClass.isPresent();
        }

        Optional<JavaClass> getEnclosingClass() {
            return this.enclosingClass;
        }

        Optional<JavaCodeUnit> getEnclosingCodeUnit() {
            return this.enclosingCodeUnit;
        }

        static EnclosingDeclaration ofCodeUnit(JavaCodeUnit codeUnit) {
            return new EnclosingDeclaration(Optional.of(codeUnit), Optional.of(codeUnit.getOwner()));
        }

        static EnclosingDeclaration ofClass(Optional<JavaClass> clazz) {
            return new EnclosingDeclaration(Optional.empty(), clazz);
        }
    }

    @ResolvesTypesViaReflection
    @MayResolveTypesViaReflection(reason="Just part of a bigger resolution process")
    private class ReflectClassSupplier
    implements Supplier<Class<?>> {
        private ReflectClassSupplier() {
        }

        @Override
        public Class<?> get() {
            return JavaClass.this.descriptor.resolveClass(ClassLoaders.getCurrentClassLoader(this.getClass()));
        }
    }

    private static abstract class CompletionProcess {
        private static final CompletionProcess stubCompletionProcess = new CompletionProcess(){

            @Override
            boolean hasFinished() {
                return false;
            }

            @Override
            public void markClassHierarchyComplete() {
            }

            @Override
            public void markEnclosingDeclarationComplete() {
            }

            @Override
            public void markTypeParametersComplete() {
            }

            @Override
            public void markGenericSuperclassComplete() {
            }

            @Override
            public void markGenericInterfacesComplete() {
            }

            @Override
            public void markMembersComplete() {
            }

            @Override
            public void markAnnotationsComplete() {
            }

            @Override
            public void markDependenciesComplete() {
            }
        };

        private CompletionProcess() {
        }

        abstract boolean hasFinished();

        public abstract void markClassHierarchyComplete();

        public abstract void markEnclosingDeclarationComplete();

        public abstract void markTypeParametersComplete();

        public abstract void markGenericSuperclassComplete();

        public abstract void markGenericInterfacesComplete();

        public abstract void markMembersComplete();

        public abstract void markAnnotationsComplete();

        public abstract void markDependenciesComplete();

        static CompletionProcess start() {
            return new FullCompletionProcess();
        }

        static CompletionProcess stub() {
            return stubCompletionProcess;
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Predicates {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> INTERFACES = new DescribedPredicate<JavaClass>("interfaces", new Object[0]){

            @Override
            public boolean test(JavaClass input) {
                return input.isInterface();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> ENUMS = new DescribedPredicate<JavaClass>("enums", new Object[0]){

            @Override
            public boolean test(JavaClass input) {
                return input.isEnum();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> ANNOTATIONS = new DescribedPredicate<JavaClass>("annotations", new Object[0]){

            @Override
            public boolean test(JavaClass input) {
                return input.isAnnotation();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> RECORDS = new DescribedPredicate<JavaClass>("records", new Object[0]){

            @Override
            public boolean test(JavaClass input) {
                return input.isRecord();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> TOP_LEVEL_CLASSES = new DescribedPredicate<JavaClass>("top level classes", new Object[0]){

            @Override
            public boolean test(JavaClass input) {
                return input.isTopLevelClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> NESTED_CLASSES = new DescribedPredicate<JavaClass>("nested classes", new Object[0]){

            @Override
            public boolean test(JavaClass input) {
                return input.isNestedClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> MEMBER_CLASSES = new DescribedPredicate<JavaClass>("member classes", new Object[0]){

            @Override
            public boolean test(JavaClass input) {
                return input.isMemberClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> INNER_CLASSES = new DescribedPredicate<JavaClass>("inner classes", new Object[0]){

            @Override
            public boolean test(JavaClass input) {
                return input.isInnerClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> LOCAL_CLASSES = new DescribedPredicate<JavaClass>("local classes", new Object[0]){

            @Override
            public boolean test(JavaClass input) {
                return input.isLocalClass();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final DescribedPredicate<JavaClass> ANONYMOUS_CLASSES = new DescribedPredicate<JavaClass>("anonymous classes", new Object[0]){

            @Override
            public boolean test(JavaClass input) {
                return input.isAnonymousClass();
            }
        };
        private static final Function<Optional<JavaStaticInitializer>, Set<JavaStaticInitializer>> AS_SET = Optionals::asSet;

        private Predicates() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> type(Class<?> type) {
            return DescribedPredicate.equalTo(type.getName()).onResultOf(HasName.Functions.GET_NAME).as("type " + type.getName(), new Object[0]);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> simpleName(String name) {
            return DescribedPredicate.equalTo(name).onResultOf(Functions.GET_SIMPLE_NAME).as("simple name '%s'", name);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> simpleNameStartingWith(String prefix) {
            return new SimpleNameStartingWithPredicate(prefix);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> simpleNameContaining(String infix) {
            return new SimpleNameContainingPredicate(infix);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> simpleNameEndingWith(String suffix) {
            return new SimpleNameEndingWithPredicate(suffix);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableTo(Class<?> type) {
            return Predicates.assignableTo(type.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableFrom(Class<?> type) {
            return Predicates.assignableFrom(type.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableTo(String typeName) {
            return Predicates.assignableTo(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(typeName)).as(typeName, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableFrom(String typeName) {
            return Predicates.assignableFrom(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(typeName)).as(typeName, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableTo(DescribedPredicate<? super JavaClass> predicate) {
            return new AssignableToPredicate(predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> assignableFrom(DescribedPredicate<? super JavaClass> predicate) {
            return new AssignableFromPredicate(predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> implement(Class<?> type) {
            if (!type.isInterface()) {
                throw new ArchUnitException.InvalidSyntaxUsageException(String.format("implement(type) can only ever be true, if type is an interface, but type %s is not. Do you maybe want to use the more generic assignableTo(type)?", type.getName()));
            }
            return Predicates.implement(type.getName());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> implement(String typeName) {
            return Predicates.implement(HasName.Functions.GET_NAME.is(DescribedPredicate.equalTo(typeName)).as(typeName, new Object[0]));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> implement(DescribedPredicate<? super JavaClass> predicate) {
            DescribedPredicate<JavaClass> selfIsImplementation = DescribedPredicate.not(INTERFACES);
            DescribedPredicate<JavaClass> interfacePredicate = predicate.forSubtype().and(INTERFACES);
            return selfIsImplementation.and(Predicates.assignableTo(interfacePredicate)).as("implement " + predicate.getDescription(), new Object[0]);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> resideInAPackage(String packageIdentifier) {
            return Predicates.resideInAnyPackage(new String[]{packageIdentifier}, String.format("reside in a package '%s'", packageIdentifier));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> resideInAnyPackage(String ... packageIdentifiers) {
            return Predicates.resideInAnyPackage(packageIdentifiers, String.format("reside in any package [%s]", Formatters.joinSingleQuoted(packageIdentifiers)));
        }

        private static DescribedPredicate<JavaClass> resideInAnyPackage(String[] packageIdentifiers, String description) {
            Set<PackageMatcher> packageMatchers = Arrays.stream(packageIdentifiers).map(PackageMatcher::of).collect(Collectors.toSet());
            return new PackageMatchesPredicate(packageMatchers, description);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> resideOutsideOfPackage(String packageIdentifier) {
            return DescribedPredicate.not(Predicates.resideInAPackage(packageIdentifier)).as("reside outside of package '%s'", packageIdentifier);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> resideOutsideOfPackages(String ... packageIdentifiers) {
            return DescribedPredicate.not(Predicates.resideInAnyPackage(packageIdentifiers)).as("reside outside of packages [%s]", Formatters.joinSingleQuoted(packageIdentifiers));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> equivalentTo(Class<?> clazz) {
            return new EquivalentToPredicate(clazz);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> belongToAnyOf(Class<?> ... classes) {
            return Predicates.belongTo(DescribedPredicate.describe("any of " + Formatters.formatNamesOf(classes), javaClass -> Arrays.stream(classes).anyMatch(javaClass::isEquivalentTo)));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> belongTo(DescribedPredicate<? super JavaClass> predicate) {
            return new BelongToPredicate(predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> containAnyMembersThat(DescribedPredicate<? super JavaMember> predicate) {
            return new ContainAnyMembersThatPredicate<JavaMember>("members", Functions.GET_MEMBERS, predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> containAnyFieldsThat(DescribedPredicate<? super JavaField> predicate) {
            return new ContainAnyMembersThatPredicate<JavaField>("fields", Functions.GET_FIELDS, predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> containAnyCodeUnitsThat(DescribedPredicate<? super JavaCodeUnit> predicate) {
            return new ContainAnyMembersThatPredicate<JavaCodeUnit>("code units", Functions.GET_CODE_UNITS, predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> containAnyMethodsThat(DescribedPredicate<? super JavaMethod> predicate) {
            return new ContainAnyMembersThatPredicate<JavaMethod>("methods", Functions.GET_METHODS, predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> containAnyConstructorsThat(DescribedPredicate<? super JavaConstructor> predicate) {
            return new ContainAnyMembersThatPredicate<JavaConstructor>("constructors", Functions.GET_CONSTRUCTORS, predicate);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static DescribedPredicate<JavaClass> containAnyStaticInitializersThat(DescribedPredicate<? super JavaStaticInitializer> predicate) {
            return new ContainAnyMembersThatPredicate<JavaStaticInitializer>("static initializers", Functions.GET_STATIC_INITIALIZER.then(AS_SET), predicate);
        }

        private static class SimpleNameStartingWithPredicate
        extends DescribedPredicate<JavaClass> {
            private final String prefix;

            SimpleNameStartingWithPredicate(String prefix) {
                super(String.format("simple name starting with '%s'", prefix), new Object[0]);
                this.prefix = prefix;
            }

            @Override
            public boolean test(JavaClass input) {
                return input.getSimpleName().startsWith(this.prefix);
            }
        }

        private static class SimpleNameContainingPredicate
        extends DescribedPredicate<JavaClass> {
            private final String infix;

            SimpleNameContainingPredicate(String infix) {
                super(String.format("simple name containing '%s'", infix), new Object[0]);
                this.infix = infix;
            }

            @Override
            public boolean test(JavaClass input) {
                return input.getSimpleName().contains(this.infix);
            }
        }

        private static class SimpleNameEndingWithPredicate
        extends DescribedPredicate<JavaClass> {
            private final String suffix;

            SimpleNameEndingWithPredicate(String suffix) {
                super(String.format("simple name ending with '%s'", suffix), new Object[0]);
                this.suffix = suffix;
            }

            @Override
            public boolean test(JavaClass input) {
                return input.getSimpleName().endsWith(this.suffix);
            }
        }

        private static class AssignableToPredicate
        extends DescribedPredicate<JavaClass> {
            private final DescribedPredicate<? super JavaClass> predicate;

            AssignableToPredicate(DescribedPredicate<? super JavaClass> predicate) {
                super("assignable to " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean test(JavaClass input) {
                return input.isAssignableTo(this.predicate);
            }
        }

        private static class AssignableFromPredicate
        extends DescribedPredicate<JavaClass> {
            private final DescribedPredicate<? super JavaClass> predicate;

            AssignableFromPredicate(DescribedPredicate<? super JavaClass> predicate) {
                super("assignable from " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean test(JavaClass input) {
                return input.isAssignableFrom(this.predicate);
            }
        }

        private static class PackageMatchesPredicate
        extends DescribedPredicate<JavaClass> {
            private final Set<PackageMatcher> packageMatchers;

            PackageMatchesPredicate(Set<PackageMatcher> packageMatchers, String description) {
                super(description, new Object[0]);
                this.packageMatchers = packageMatchers;
            }

            @Override
            public boolean test(JavaClass input) {
                return this.packageMatchers.stream().anyMatch(matcher -> matcher.matches(input.getPackageName()));
            }
        }

        private static class EquivalentToPredicate
        extends DescribedPredicate<JavaClass> {
            private final Class<?> clazz;

            EquivalentToPredicate(Class<?> clazz) {
                super("equivalent to %s", clazz.getName());
                this.clazz = clazz;
            }

            @Override
            public boolean test(JavaClass input) {
                return input.isEquivalentTo(this.clazz);
            }
        }

        private static class BelongToPredicate
        extends DescribedPredicate<JavaClass> {
            private final DescribedPredicate<? super JavaClass> predicate;

            BelongToPredicate(DescribedPredicate<? super JavaClass> predicate) {
                super("belong to " + predicate.getDescription(), new Object[0]);
                this.predicate = predicate;
            }

            @Override
            public boolean test(JavaClass input) {
                JavaClass toTest = input;
                boolean matches = this.predicate.test(toTest);
                while (!matches && toTest.getEnclosingClass().isPresent()) {
                    toTest = toTest.getEnclosingClass().get();
                    matches = this.predicate.test(toTest);
                }
                return matches;
            }
        }

        private static class ContainAnyMembersThatPredicate<T extends JavaMember>
        extends DescribedPredicate<JavaClass> {
            private final Function<JavaClass, Set<T>> getMembers;
            private final DescribedPredicate<? super T> predicate;

            ContainAnyMembersThatPredicate(String memberDescription, Function<JavaClass, Set<T>> getMembers, DescribedPredicate<? super T> predicate) {
                super("contain any " + memberDescription + " that " + predicate.getDescription(), new Object[0]);
                this.getMembers = getMembers;
                this.predicate = predicate;
            }

            @Override
            public boolean test(JavaClass input) {
                return this.getMembers.apply(input).stream().anyMatch(this.predicate);
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, String> GET_SIMPLE_NAME = new ChainableFunction<JavaClass, String>(){

            @Override
            public String apply(JavaClass input) {
                return input.getSimpleName();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, String> GET_PACKAGE_NAME = new ChainableFunction<JavaClass, String>(){

            @Override
            public String apply(JavaClass input) {
                return input.getPackageName();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, JavaPackage> GET_PACKAGE = new ChainableFunction<JavaClass, JavaPackage>(){

            @Override
            public JavaPackage apply(JavaClass input) {
                return input.getPackage();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaMember>> GET_MEMBERS = new ChainableFunction<JavaClass, Set<JavaMember>>(){

            @Override
            public Set<JavaMember> apply(JavaClass input) {
                return input.getMembers();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaField>> GET_FIELDS = new ChainableFunction<JavaClass, Set<JavaField>>(){

            @Override
            public Set<JavaField> apply(JavaClass input) {
                return input.getFields();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaCodeUnit>> GET_CODE_UNITS = new ChainableFunction<JavaClass, Set<JavaCodeUnit>>(){

            @Override
            public Set<JavaCodeUnit> apply(JavaClass input) {
                return input.getCodeUnits();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaMethod>> GET_METHODS = new ChainableFunction<JavaClass, Set<JavaMethod>>(){

            @Override
            public Set<JavaMethod> apply(JavaClass input) {
                return input.getMethods();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaConstructor>> GET_CONSTRUCTORS = new ChainableFunction<JavaClass, Set<JavaConstructor>>(){

            @Override
            public Set<JavaConstructor> apply(JavaClass input) {
                return input.getConstructors();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Optional<JavaStaticInitializer>> GET_STATIC_INITIALIZER = new ChainableFunction<JavaClass, Optional<JavaStaticInitializer>>(){

            @Override
            public Optional<JavaStaticInitializer> apply(JavaClass input) {
                return input.getStaticInitializer();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaFieldAccess>> GET_FIELD_ACCESSES_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaFieldAccess>>(){

            @Override
            public Set<JavaFieldAccess> apply(JavaClass input) {
                return input.getFieldAccessesFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaMethodCall>> GET_METHOD_CALLS_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaMethodCall>>(){

            @Override
            public Set<JavaMethodCall> apply(JavaClass input) {
                return input.getMethodCallsFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaConstructorCall>> GET_CONSTRUCTOR_CALLS_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaConstructorCall>>(){

            @Override
            public Set<JavaConstructorCall> apply(JavaClass input) {
                return input.getConstructorCallsFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaCall<?>>> GET_CODE_UNIT_CALLS_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaCall<?>>>(){

            @Override
            public Set<JavaCall<?>> apply(JavaClass input) {
                return input.getCodeUnitCallsFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaMethodReference>> GET_METHOD_REFERENCES_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaMethodReference>>(){

            @Override
            public Set<JavaMethodReference> apply(JavaClass input) {
                return input.getMethodReferencesFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaConstructorReference>> GET_CONSTRUCTOR_REFERENCES_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaConstructorReference>>(){

            @Override
            public Set<JavaConstructorReference> apply(JavaClass input) {
                return input.getConstructorReferencesFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaCodeUnitReference<?>>> GET_CODE_UNIT_REFERENCES_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaCodeUnitReference<?>>>(){

            @Override
            public Set<JavaCodeUnitReference<?>> apply(JavaClass input) {
                return input.getCodeUnitReferencesFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaMethodReference>> GET_METHOD_REFERENCES_TO_SELF = new ChainableFunction<JavaClass, Set<JavaMethodReference>>(){

            @Override
            public Set<JavaMethodReference> apply(JavaClass input) {
                return input.getMethodReferencesToSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaConstructorReference>> GET_CONSTRUCTOR_REFERENCES_TO_SELF = new ChainableFunction<JavaClass, Set<JavaConstructorReference>>(){

            @Override
            public Set<JavaConstructorReference> apply(JavaClass input) {
                return input.getConstructorReferencesToSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaCodeUnitReference<?>>> GET_CODE_UNIT_REFERENCES_TO_SELF = new ChainableFunction<JavaClass, Set<JavaCodeUnitReference<?>>>(){

            @Override
            public Set<JavaCodeUnitReference<?>> apply(JavaClass input) {
                return input.getCodeUnitReferencesToSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaAccess<?>>> GET_ACCESSES_FROM_SELF = new ChainableFunction<JavaClass, Set<JavaAccess<?>>>(){

            @Override
            public Set<JavaAccess<?>> apply(JavaClass input) {
                return input.getAccessesFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<Dependency>> GET_DIRECT_DEPENDENCIES_FROM_SELF = new ChainableFunction<JavaClass, Set<Dependency>>(){

            @Override
            public Set<Dependency> apply(JavaClass input) {
                return input.getDirectDependenciesFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<Dependency>> GET_TRANSITIVE_DEPENDENCIES_FROM_SELF = new ChainableFunction<JavaClass, Set<Dependency>>(){

            @Override
            public Set<Dependency> apply(JavaClass input) {
                return input.getTransitiveDependenciesFromSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<JavaAccess<?>>> GET_ACCESSES_TO_SELF = new ChainableFunction<JavaClass, Set<JavaAccess<?>>>(){

            @Override
            public Set<JavaAccess<?>> apply(JavaClass input) {
                return input.getAccessesToSelf();
            }
        };
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaClass, Set<Dependency>> GET_DIRECT_DEPENDENCIES_TO_SELF = new ChainableFunction<JavaClass, Set<Dependency>>(){

            @Override
            public Set<Dependency> apply(JavaClass input) {
                return input.getDirectDependenciesToSelf();
            }
        };

        private Functions() {
        }
    }

    private static class FullCompletionProcess
    extends CompletionProcess {
        private boolean classHierarchyComplete = false;
        private boolean enclosingDeclarationComplete = false;
        private boolean typeParametersComplete = false;
        private boolean genericSuperclassComplete = false;
        private boolean genericInterfacesComplete = false;
        private boolean membersComplete = false;
        private boolean annotationsComplete = false;
        private boolean dependenciesComplete = false;

        private FullCompletionProcess() {
        }

        @Override
        boolean hasFinished() {
            return this.classHierarchyComplete && this.enclosingDeclarationComplete && this.typeParametersComplete && this.genericSuperclassComplete && this.genericInterfacesComplete && this.membersComplete && this.annotationsComplete && this.dependenciesComplete;
        }

        @Override
        public void markClassHierarchyComplete() {
            this.classHierarchyComplete = true;
        }

        @Override
        public void markEnclosingDeclarationComplete() {
            this.enclosingDeclarationComplete = true;
        }

        @Override
        public void markTypeParametersComplete() {
            this.typeParametersComplete = true;
        }

        @Override
        public void markGenericSuperclassComplete() {
            this.genericSuperclassComplete = true;
        }

        @Override
        public void markGenericInterfacesComplete() {
            this.genericInterfacesComplete = true;
        }

        @Override
        public void markMembersComplete() {
            this.membersComplete = true;
        }

        @Override
        public void markAnnotationsComplete() {
            this.annotationsComplete = true;
        }

        @Override
        public void markDependenciesComplete() {
            this.dependenciesComplete = true;
        }
    }
}

