/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.ClassLoaders;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.ResolvesTypesViaReflection;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.thirdparty.com.google.common.base.CharMatcher;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Strings;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheBuilder;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheLoader;
import com.tngtech.archunit.thirdparty.com.google.common.cache.LoadingCache;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableBiMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableMap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Maps;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Primitives;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Internal
public interface JavaClassDescriptor {
    public String getFullyQualifiedClassName();

    public String getSimpleClassName();

    public String getPackageName();

    @ResolvesTypesViaReflection
    public Class<?> resolveClass();

    @ResolvesTypesViaReflection
    public Class<?> resolveClass(ClassLoader var1);

    public Optional<JavaClassDescriptor> tryGetComponentType();

    public boolean isPrimitive();

    public boolean isArray();

    public JavaClassDescriptor withSimpleClassName(String var1);

    public JavaClassDescriptor toArrayDescriptor();

    @Internal
    public static final class From {
        private static final LoadingCache<String, JavaClassDescriptor> descriptorCache = CacheBuilder.newBuilder().build(new CacheLoader<String, JavaClassDescriptor>(){

            @Override
            public JavaClassDescriptor load(String typeName) {
                if (primitiveClassesByNameOrDescriptor.containsKey(typeName)) {
                    return new PrimitiveClassDescriptor(Type.getType((Class)primitiveClassesByNameOrDescriptor.get(typeName)).getClassName());
                }
                if (From.isArray(typeName)) {
                    return new ArrayClassDescriptor(From.ensureCorrectArrayTypeName(typeName));
                }
                return new ObjectClassDescriptor(typeName);
            }
        });
        private static final ImmutableMap<String, Class<?>> primitiveClassesByName = Maps.uniqueIndex(Primitives.allPrimitiveTypes(), Class::getName);
        private static final ImmutableBiMap<String, Class<?>> primitiveClassesByDescriptor = ImmutableBiMap.copyOf(Maps.uniqueIndex(Primitives.allPrimitiveTypes(), input -> Type.getType(input).getDescriptor()));
        private static final Map<String, Class<?>> primitiveClassesByNameOrDescriptor = ImmutableMap.builder().putAll(primitiveClassesByName).putAll(primitiveClassesByDescriptor).build();

        public static JavaClassDescriptor name(String typeName) {
            return descriptorCache.getUnchecked(typeName);
        }

        private static boolean isArray(String typeName) {
            return typeName.startsWith("[") || typeName.endsWith("]");
        }

        private static String ensureCorrectArrayTypeName(String name) {
            return name.endsWith("[]") ? From.convertCanonicalArrayNameToClassName(name) : name;
        }

        private static String convertCanonicalArrayNameToClassName(String name) {
            String arrayDesignator = Strings.repeat("[", CharMatcher.is('[').countIn(name));
            return arrayDesignator + From.createComponentTypeName(name);
        }

        private static String createComponentTypeName(String name) {
            String baseName = name.substring(0, name.indexOf("[]"));
            return primitiveClassesByName.containsKey(baseName) ? From.createPrimitiveComponentType(baseName) : From.createObjectComponentType(baseName);
        }

        private static String createPrimitiveComponentType(String componentTypeName) {
            return (String)((ImmutableMap)((Object)primitiveClassesByDescriptor.inverse())).get(primitiveClassesByName.get(componentTypeName));
        }

        private static String createObjectComponentType(String componentTypeName) {
            return "L" + componentTypeName + ";";
        }

        public static JavaClassDescriptor javaClass(JavaClass javaClass) {
            return From.name(javaClass.getName());
        }

        private static String createPackage(String fullName) {
            int packageEnd = fullName.lastIndexOf(46);
            return packageEnd >= 0 ? fullName.substring(0, packageEnd) : "";
        }

        private static class ArrayClassDescriptor
        extends AbstractClassDescriptor {
            ArrayClassDescriptor(String fullName) {
                this(fullName, ArrayClassDescriptor.createSimpleName(fullName), ArrayClassDescriptor.createPackageOfComponentType(fullName));
            }

            private ArrayClassDescriptor(String fullName, String simpleName, String packageName) {
                super(fullName, simpleName, packageName);
            }

            private static String createPackageOfComponentType(String fullName) {
                String componentType = ArrayClassDescriptor.getCanonicalName(fullName).replace("[]", "");
                return From.name(componentType).getPackageName();
            }

            private static String createSimpleName(String fullName) {
                return Formatters.ensureSimpleName(ArrayClassDescriptor.getCanonicalName(fullName));
            }

            private static String getCanonicalName(String fullName) {
                return Type.getType(fullName).getClassName();
            }

            @Override
            public boolean isArray() {
                return true;
            }

            @Override
            public JavaClassDescriptor withSimpleClassName(String simpleName) {
                return new ArrayClassDescriptor(this.getFullyQualifiedClassName(), simpleName, this.getPackageName());
            }

            @Override
            public Optional<JavaClassDescriptor> tryGetComponentType() {
                String canonicalName = ArrayClassDescriptor.getCanonicalName(this.getFullyQualifiedClassName());
                String componentTypeName = canonicalName.substring(0, canonicalName.lastIndexOf("["));
                return Optional.of(From.name(componentTypeName));
            }

            @Override
            public JavaClassDescriptor toArrayDescriptor() {
                return new ArrayClassDescriptor("[" + this.getFullyQualifiedClassName());
            }
        }

        private static class PrimitiveClassDescriptor
        extends AbstractClassDescriptor {
            PrimitiveClassDescriptor(String fullName) {
                super(fullName, fullName, "java.lang");
                Preconditions.checkArgument(primitiveClassesByName.containsKey(fullName), "'%s' must be a primitive name", (Object)fullName);
            }

            @Override
            Class<?> classForName(ClassLoader classLoader) {
                return (Class)primitiveClassesByName.get(this.getFullyQualifiedClassName());
            }

            @Override
            public boolean isPrimitive() {
                return true;
            }

            @Override
            public JavaClassDescriptor withSimpleClassName(String simpleName) {
                throw new UnsupportedOperationException("It should never make sense to override the simple type of a primitive");
            }

            @Override
            public JavaClassDescriptor toArrayDescriptor() {
                return From.name(this.getFullyQualifiedClassName() + "[]");
            }
        }

        private static class ObjectClassDescriptor
        extends AbstractClassDescriptor {
            ObjectClassDescriptor(String fullName) {
                this(fullName, Formatters.ensureSimpleName(fullName), From.createPackage(fullName));
            }

            private ObjectClassDescriptor(String fullName, String simpleName, String packageName) {
                super(fullName, simpleName, packageName);
            }

            @Override
            public JavaClassDescriptor withSimpleClassName(String simpleName) {
                return new ObjectClassDescriptor(this.getFullyQualifiedClassName(), simpleName, this.getPackageName());
            }

            @Override
            public JavaClassDescriptor toArrayDescriptor() {
                return From.name(this.getFullyQualifiedClassName() + "[]");
            }
        }

        private static abstract class AbstractClassDescriptor
        implements JavaClassDescriptor {
            private final String name;
            private final String simpleName;
            private final String javaPackage;

            private AbstractClassDescriptor(String name, String simpleName, String javaPackage) {
                this.name = name;
                this.simpleName = simpleName;
                this.javaPackage = javaPackage;
            }

            @Override
            public String getFullyQualifiedClassName() {
                return this.name;
            }

            @Override
            public String getSimpleClassName() {
                return this.simpleName;
            }

            @Override
            public String getPackageName() {
                return this.javaPackage;
            }

            @Override
            public Class<?> resolveClass() {
                return this.resolveClass(ClassLoaders.getCurrentClassLoader(this.getClass()));
            }

            @Override
            public Class<?> resolveClass(ClassLoader classLoader) {
                try {
                    return this.classForName(classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw new ArchUnitException.ReflectionException(e);
                }
            }

            @MayResolveTypesViaReflection(reason="This method is one of the known sources for resolving via reflection")
            Class<?> classForName(ClassLoader classLoader) throws ClassNotFoundException {
                return Class.forName(this.getFullyQualifiedClassName(), false, classLoader);
            }

            @Override
            public Optional<JavaClassDescriptor> tryGetComponentType() {
                return Optional.empty();
            }

            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public boolean isArray() {
                return false;
            }

            public int hashCode() {
                return Objects.hash(this.getFullyQualifiedClassName());
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                JavaClassDescriptor other = (JavaClassDescriptor)obj;
                return Objects.equals(this.getFullyQualifiedClassName(), other.getFullyQualifiedClassName());
            }

            public String toString() {
                return this.getClass().getSimpleName() + "{" + this.getFullyQualifiedClassName() + "}";
            }
        }
    }
}

