/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.ResolvesTypesViaReflection;
import com.tngtech.archunit.base.Suppliers;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.core.importer.DomainBuilders;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class JavaField
extends JavaMember
implements HasType {
    private final JavaType type;
    private final Supplier<Field> fieldSupplier;

    JavaField(DomainBuilders.JavaFieldBuilder builder) {
        super(builder);
        this.type = builder.getType(this);
        this.fieldSupplier = Suppliers.memoize(new ReflectFieldSupplier());
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getFullName() {
        return this.getOwner().getName() + "." + this.getName();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaType getType() {
        return this.type;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getRawType() {
        return this.type.toErasure();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaClass> getAllInvolvedRawTypes() {
        return this.getType().getAllInvolvedRawTypes();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaFieldAccess> getAccessesToSelf() {
        return this.getReverseDependencies().getAccessesTo(this);
    }

    @Override
    public Set<JavaAnnotation<JavaField>> getAnnotations() {
        return super.getAnnotations();
    }

    @Override
    public JavaAnnotation<JavaField> getAnnotationOfType(String typeName) {
        return super.getAnnotationOfType(typeName);
    }

    @Override
    public Optional<JavaAnnotation<JavaField>> tryGetAnnotationOfType(String typeName) {
        return super.tryGetAnnotationOfType(typeName);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    @ResolvesTypesViaReflection
    @MayResolveTypesViaReflection(reason="This is not part of the import and a specific decision to rely on the classpath")
    public Field reflect() {
        return this.fieldSupplier.get();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return "Field <" + this.getFullName() + ">";
    }

    @ResolvesTypesViaReflection
    @MayResolveTypesViaReflection(reason="Just part of a bigger resolution process")
    private class ReflectFieldSupplier
    implements Supplier<Field> {
        private ReflectFieldSupplier() {
        }

        @Override
        public Field get() {
            Class<?> reflectedOwner = JavaField.this.getOwner().reflect();
            try {
                return reflectedOwner.getDeclaredField(JavaField.this.getName());
            }
            catch (NoSuchFieldException e) {
                throw new ArchUnitException.InconsistentClassPathException(String.format("Can't resolve field %s.%s", reflectedOwner.getName(), JavaField.this.getName()), e);
            }
        }
    }
}

