/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.base.Suppliers;
import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.InstanceofCheck;
import com.tngtech.archunit.core.domain.JavaAccess;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassDependencies;
import com.tngtech.archunit.core.domain.JavaCodeUnitAccess;
import com.tngtech.archunit.core.domain.JavaConstructor;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaConstructorReference;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaFieldAccess;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaMethodReference;
import com.tngtech.archunit.core.domain.ThrowsDeclaration;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheBuilder;
import com.tngtech.archunit.thirdparty.com.google.common.cache.CacheLoader;
import com.tngtech.archunit.thirdparty.com.google.common.cache.LoadingCache;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSetMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

final class ReverseDependencies {
    private final LoadingCache<JavaField, Set<JavaFieldAccess>> accessToFieldCache;
    private final LoadingCache<JavaMethod, Set<JavaMethodCall>> callToMethodCache;
    private final LoadingCache<JavaMethod, Set<JavaMethodReference>> referenceToMethodCache;
    private final LoadingCache<JavaConstructor, Set<JavaConstructorCall>> callToConstructorCache;
    private final LoadingCache<JavaConstructor, Set<JavaConstructorReference>> referenceToConstructorCache;
    private final SetMultimap<JavaClass, JavaField> fieldTypeDependencies;
    private final SetMultimap<JavaClass, JavaMethod> methodParameterTypeDependencies;
    private final SetMultimap<JavaClass, JavaMethod> methodReturnTypeDependencies;
    private final SetMultimap<JavaClass, ThrowsDeclaration<JavaMethod>> methodsThrowsDeclarationDependencies;
    private final SetMultimap<JavaClass, JavaConstructor> constructorParameterTypeDependencies;
    private final SetMultimap<JavaClass, ThrowsDeclaration<JavaConstructor>> constructorThrowsDeclarationDependencies;
    private final SetMultimap<JavaClass, JavaAnnotation<?>> annotationTypeDependencies;
    private final SetMultimap<JavaClass, JavaAnnotation<?>> annotationParameterTypeDependencies;
    private final SetMultimap<JavaClass, InstanceofCheck> instanceofCheckDependencies;
    private final Supplier<SetMultimap<JavaClass, Dependency>> directDependenciesToClass;
    static final ReverseDependencies EMPTY = new ReverseDependencies(new Creation());

    private ReverseDependencies(Creation creation) {
        this.accessToFieldCache = CacheBuilder.newBuilder().build(new ResolvingAccessLoader((SetMultimap)((Object)creation.fieldAccessDependencies.build())));
        this.callToMethodCache = CacheBuilder.newBuilder().build(new ResolvingAccessLoader((SetMultimap)((Object)creation.methodCallDependencies.build())));
        this.referenceToMethodCache = CacheBuilder.newBuilder().build(new ResolvingAccessLoader((SetMultimap)((Object)creation.methodReferenceDependencies.build())));
        this.callToConstructorCache = CacheBuilder.newBuilder().build(new ConstructorAccessLoader((SetMultimap)((Object)creation.constructorCallDependencies.build())));
        this.referenceToConstructorCache = CacheBuilder.newBuilder().build(new ConstructorAccessLoader((SetMultimap)((Object)creation.constructorReferenceDependencies.build())));
        this.fieldTypeDependencies = creation.fieldTypeDependencies.build();
        this.methodParameterTypeDependencies = creation.methodParameterTypeDependencies.build();
        this.methodReturnTypeDependencies = creation.methodReturnTypeDependencies.build();
        this.methodsThrowsDeclarationDependencies = creation.methodsThrowsDeclarationDependencies.build();
        this.constructorParameterTypeDependencies = creation.constructorParameterTypeDependencies.build();
        this.constructorThrowsDeclarationDependencies = creation.constructorThrowsDeclarationDependencies.build();
        this.annotationTypeDependencies = creation.annotationTypeDependencies.build();
        this.annotationParameterTypeDependencies = creation.annotationParameterTypeDependencies.build();
        this.instanceofCheckDependencies = creation.instanceofCheckDependencies.build();
        this.directDependenciesToClass = ReverseDependencies.createDirectDependenciesToClassSupplier(creation.allDependencies);
    }

    private static Supplier<SetMultimap<JavaClass, Dependency>> createDirectDependenciesToClassSupplier(List<JavaClassDependencies> allDependencies) {
        return Suppliers.memoize(() -> {
            ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
            for (JavaClassDependencies dependencies : allDependencies) {
                for (Dependency dependency : dependencies.getDirectDependenciesFromClass()) {
                    result.put(dependency.getTargetClass(), dependency);
                }
            }
            return result.build();
        });
    }

    Set<JavaFieldAccess> getAccessesTo(JavaField field) {
        return this.accessToFieldCache.getUnchecked(field);
    }

    Set<JavaMethodCall> getCallsTo(JavaMethod method) {
        return this.callToMethodCache.getUnchecked(method);
    }

    Set<JavaMethodReference> getReferencesTo(JavaMethod method) {
        return this.referenceToMethodCache.getUnchecked(method);
    }

    Set<JavaConstructorCall> getCallsTo(JavaConstructor constructor) {
        return this.callToConstructorCache.getUnchecked(constructor);
    }

    Set<JavaConstructorReference> getReferencesTo(JavaConstructor constructor) {
        return this.referenceToConstructorCache.getUnchecked(constructor);
    }

    Set<JavaField> getFieldsWithTypeOf(JavaClass clazz) {
        return this.fieldTypeDependencies.get((Object)clazz);
    }

    Set<JavaMethod> getMethodsWithParameterTypeOf(JavaClass clazz) {
        return this.methodParameterTypeDependencies.get((Object)clazz);
    }

    Set<JavaMethod> getMethodsWithReturnTypeOf(JavaClass clazz) {
        return this.methodReturnTypeDependencies.get((Object)clazz);
    }

    Set<ThrowsDeclaration<JavaMethod>> getMethodThrowsDeclarationsWithTypeOf(JavaClass clazz) {
        return this.methodsThrowsDeclarationDependencies.get((Object)clazz);
    }

    Set<JavaConstructor> getConstructorsWithParameterTypeOf(JavaClass clazz) {
        return this.constructorParameterTypeDependencies.get((Object)clazz);
    }

    Set<ThrowsDeclaration<JavaConstructor>> getConstructorsWithThrowsDeclarationTypeOf(JavaClass clazz) {
        return this.constructorThrowsDeclarationDependencies.get((Object)clazz);
    }

    Set<JavaAnnotation<?>> getAnnotationsWithTypeOf(JavaClass clazz) {
        return this.annotationTypeDependencies.get((Object)clazz);
    }

    Set<JavaAnnotation<?>> getAnnotationsWithParameterTypeOf(JavaClass clazz) {
        return this.annotationParameterTypeDependencies.get((Object)clazz);
    }

    Set<InstanceofCheck> getInstanceofChecksWithTypeOf(JavaClass clazz) {
        return this.instanceofCheckDependencies.get((Object)clazz);
    }

    Set<Dependency> getDirectDependenciesTo(JavaClass clazz) {
        return this.directDependenciesToClass.get().get((Object)clazz);
    }

    static class Creation {
        private final ImmutableSetMultimap.Builder<JavaClass, JavaFieldAccess> fieldAccessDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<JavaClass, JavaMethodCall> methodCallDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<JavaClass, JavaMethodReference> methodReferenceDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<String, JavaConstructorCall> constructorCallDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<String, JavaConstructorReference> constructorReferenceDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<JavaClass, JavaField> fieldTypeDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<JavaClass, JavaMethod> methodParameterTypeDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<JavaClass, JavaMethod> methodReturnTypeDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<JavaClass, ThrowsDeclaration<JavaMethod>> methodsThrowsDeclarationDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<JavaClass, JavaConstructor> constructorParameterTypeDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<JavaClass, ThrowsDeclaration<JavaConstructor>> constructorThrowsDeclarationDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<JavaClass, JavaAnnotation<?>> annotationTypeDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<JavaClass, JavaAnnotation<?>> annotationParameterTypeDependencies = ImmutableSetMultimap.builder();
        private final ImmutableSetMultimap.Builder<JavaClass, InstanceofCheck> instanceofCheckDependencies = ImmutableSetMultimap.builder();
        private final List<JavaClassDependencies> allDependencies = new ArrayList<JavaClassDependencies>();

        Creation() {
        }

        public void registerDependenciesOf(JavaClass clazz, JavaClassDependencies classDependencies) {
            this.registerAccesses(clazz);
            this.registerFields(clazz);
            this.registerMethods(clazz);
            this.registerConstructors(clazz);
            this.registerAnnotations(clazz);
            this.registerStaticInitializer(clazz);
            this.allDependencies.add(classDependencies);
        }

        private void registerAccesses(JavaClass clazz) {
            for (JavaFieldAccess javaFieldAccess : clazz.getFieldAccessesFromSelf()) {
                this.fieldAccessDependencies.put((Object)javaFieldAccess.getTargetOwner(), (Object)javaFieldAccess);
            }
            for (JavaMethodCall javaMethodCall : clazz.getMethodCallsFromSelf()) {
                this.methodCallDependencies.put((Object)javaMethodCall.getTargetOwner(), (Object)javaMethodCall);
            }
            for (JavaMethodReference javaMethodReference : clazz.getMethodReferencesFromSelf()) {
                this.methodReferenceDependencies.put((Object)javaMethodReference.getTargetOwner(), (Object)javaMethodReference);
            }
            for (JavaConstructorCall javaConstructorCall : clazz.getConstructorCallsFromSelf()) {
                this.constructorCallDependencies.put((Object)((AccessTarget.ConstructorCallTarget)javaConstructorCall.getTarget()).getFullName(), (Object)javaConstructorCall);
            }
            for (JavaConstructorReference javaConstructorReference : clazz.getConstructorReferencesFromSelf()) {
                this.constructorReferenceDependencies.put((Object)((AccessTarget.ConstructorReferenceTarget)javaConstructorReference.getTarget()).getFullName(), (Object)javaConstructorReference);
            }
        }

        private void registerFields(JavaClass clazz) {
            for (JavaField field : clazz.getFields()) {
                this.fieldTypeDependencies.put((Object)field.getRawType(), (Object)field);
            }
        }

        private void registerMethods(JavaClass clazz) {
            for (JavaMethod method : clazz.getMethods()) {
                for (JavaClass javaClass : method.getRawParameterTypes()) {
                    this.methodParameterTypeDependencies.put((Object)javaClass, (Object)method);
                }
                this.methodReturnTypeDependencies.put((Object)method.getRawReturnType(), (Object)method);
                for (ThrowsDeclaration throwsDeclaration : method.getThrowsClause()) {
                    this.methodsThrowsDeclarationDependencies.put((Object)throwsDeclaration.getRawType(), (Object)throwsDeclaration);
                }
                for (InstanceofCheck instanceofCheck : method.getInstanceofChecks()) {
                    this.instanceofCheckDependencies.put((Object)instanceofCheck.getRawType(), (Object)instanceofCheck);
                }
            }
        }

        private void registerConstructors(JavaClass clazz) {
            for (JavaConstructor constructor : clazz.getConstructors()) {
                for (JavaClass javaClass : constructor.getRawParameterTypes()) {
                    this.constructorParameterTypeDependencies.put((Object)javaClass, (Object)constructor);
                }
                for (ThrowsDeclaration throwsDeclaration : constructor.getThrowsClause()) {
                    this.constructorThrowsDeclarationDependencies.put((Object)throwsDeclaration.getRawType(), (Object)throwsDeclaration);
                }
                for (InstanceofCheck instanceofCheck : constructor.getInstanceofChecks()) {
                    this.instanceofCheckDependencies.put((Object)instanceofCheck.getRawType(), (Object)instanceofCheck);
                }
            }
        }

        private void registerAnnotations(JavaClass clazz) {
            for (final JavaAnnotation<?> annotation : this.findAnnotations(clazz)) {
                this.annotationTypeDependencies.put((Object)annotation.getRawType(), annotation);
                annotation.accept(new JavaAnnotation.DefaultParameterVisitor(){

                    @Override
                    public void visitClass(String propertyName, JavaClass javaClass) {
                        annotationParameterTypeDependencies.put(javaClass, annotation);
                    }

                    @Override
                    public void visitEnumConstant(String propertyName, JavaEnumConstant enumConstant) {
                        annotationParameterTypeDependencies.put(enumConstant.getDeclaringClass(), annotation);
                    }

                    @Override
                    public void visitAnnotation(String propertyName, JavaAnnotation<?> memberAnnotation) {
                        annotationParameterTypeDependencies.put(memberAnnotation.getRawType(), annotation);
                        memberAnnotation.accept(this);
                    }
                });
            }
        }

        private Set<JavaAnnotation<?>> findAnnotations(JavaClass clazz) {
            HashSet<JavaAnnotation<?>> result = Sets.newHashSet(clazz.getAnnotations());
            for (JavaMember member : clazz.getMembers()) {
                result.addAll(member.getAnnotations());
            }
            return result;
        }

        private void registerStaticInitializer(JavaClass clazz) {
            if (clazz.getStaticInitializer().isPresent()) {
                for (InstanceofCheck instanceofCheck : clazz.getStaticInitializer().get().getInstanceofChecks()) {
                    this.instanceofCheckDependencies.put((Object)instanceofCheck.getRawType(), (Object)instanceofCheck);
                }
            }
        }

        void finish(Iterable<JavaClass> classes) {
            ReverseDependencies reverseDependencies = new ReverseDependencies(this);
            for (JavaClass clazz : classes) {
                clazz.setReverseDependencies(reverseDependencies);
            }
        }
    }

    private static class ResolvingAccessLoader<MEMBER extends JavaMember, ACCESS extends JavaAccess<?>>
    extends CacheLoader<MEMBER, Set<ACCESS>> {
        private final SetMultimap<JavaClass, ACCESS> accessesToSelf;

        private ResolvingAccessLoader(SetMultimap<JavaClass, ACCESS> accessesToSelf) {
            this.accessesToSelf = accessesToSelf;
        }

        @Override
        public Set<ACCESS> load(MEMBER member) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (JavaClass javaClass : this.getPossibleTargetClassesForAccess(((JavaMember)member).getOwner())) {
                for (JavaAccess access : this.accessesToSelf.get((Object)javaClass)) {
                    Optional<? extends JavaMember> target = ((AccessTarget)access.getTarget()).resolveMember();
                    if (!target.isPresent() || !target.get().equals(member)) continue;
                    result.add(access);
                }
            }
            return result.build();
        }

        private Set<JavaClass> getPossibleTargetClassesForAccess(JavaClass owner) {
            return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(owner)).addAll(owner.getAllSubclasses())).build();
        }
    }

    private static class ConstructorAccessLoader<ACCESS extends JavaCodeUnitAccess<?>>
    extends CacheLoader<JavaConstructor, Set<ACCESS>> {
        private final SetMultimap<String, ACCESS> accessesToSelf;

        private ConstructorAccessLoader(SetMultimap<String, ACCESS> accessesToSelf) {
            this.accessesToSelf = accessesToSelf;
        }

        @Override
        public Set<ACCESS> load(JavaConstructor member) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            result.addAll((Iterable)this.accessesToSelf.get((Object)member.getFullName()));
            return result.build();
        }
    }
}

