/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.modules;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ForwardingSet;
import com.tngtech.archunit.base.Suppliers;
import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.library.modules.ModuleDependency;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
public final class ArchModule<DESCRIPTOR extends Descriptor>
extends ForwardingSet<JavaClass>
implements HasName {
    private final Identifier identifier;
    private final DESCRIPTOR descriptor;
    private final Set<JavaClass> classes;
    private final Set<Dependency> classDependenciesFromSelf;
    private final Supplier<Set<Dependency>> classDependenciesToSelf;
    private Set<ModuleDependency<DESCRIPTOR>> moduleDependenciesFromSelf;
    private Set<ModuleDependency<DESCRIPTOR>> moduleDependenciesToSelf;
    private Set<Dependency> undefinedDependencies;

    ArchModule(Identifier identifier, DESCRIPTOR descriptor, Set<JavaClass> classes) {
        this.identifier = Preconditions.checkNotNull(identifier);
        this.descriptor = (Descriptor)Preconditions.checkNotNull(descriptor);
        this.classes = ImmutableSet.copyOf(classes);
        this.classDependenciesFromSelf = classes.stream().flatMap(clazz -> clazz.getDirectDependenciesFromSelf().stream()).filter(dependency -> !classes.contains(dependency.getTargetClass().getBaseComponentType())).collect(ImmutableSet.toImmutableSet());
        this.classDependenciesToSelf = Suppliers.memoize(() -> classes.stream().flatMap(clazz -> clazz.getDirectDependenciesToSelf().stream()).filter(dependency -> !classes.contains(dependency.getOriginClass())).collect(ImmutableSet.toImmutableSet()));
    }

    void setModuleDependencies(Set<ModuleDependency<DESCRIPTOR>> moduleDependenciesFromSelf, Set<ModuleDependency<DESCRIPTOR>> moduleDependenciesToSelf) {
        this.moduleDependenciesFromSelf = ImmutableSet.copyOf(moduleDependenciesFromSelf);
        this.moduleDependenciesToSelf = ImmutableSet.copyOf(moduleDependenciesToSelf);
        this.undefinedDependencies = ImmutableSet.copyOf(Sets.difference(this.classDependenciesFromSelf, this.toClassDependencies(moduleDependenciesFromSelf)));
    }

    private Set<Dependency> toClassDependencies(Set<ModuleDependency<DESCRIPTOR>> moduleDependencies) {
        return moduleDependencies.stream().flatMap(it -> it.toClassDependencies().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    protected Set<JavaClass> delegate() {
        return this.classes;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public Identifier getIdentifier() {
        return this.identifier;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public String getName() {
        return this.descriptor.getName();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public DESCRIPTOR getDescriptor() {
        return this.descriptor;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public Set<Dependency> getClassDependenciesFromSelf() {
        return this.classDependenciesFromSelf;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public Set<Dependency> getClassDependenciesToSelf() {
        return this.classDependenciesToSelf.get();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public Set<ModuleDependency<DESCRIPTOR>> getModuleDependenciesFromSelf() {
        return this.moduleDependenciesFromSelf;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public Set<ModuleDependency<DESCRIPTOR>> getModuleDependenciesToSelf() {
        return this.moduleDependenciesToSelf;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public Set<Dependency> getUndefinedDependencies() {
        return this.undefinedDependencies;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ArchModule other = (ArchModule)obj;
        return Objects.equals(this.identifier, other.identifier);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{identifier=" + this.getIdentifier() + ", name=" + this.getName() + '}';
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
    public static final class Identifier
    implements Iterable<String> {
        private final List<String> parts;

        private Identifier(List<String> parts) {
            this.parts = ImmutableList.copyOf(parts);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public static Identifier from(String ... parts) {
            return Identifier.from(ImmutableList.copyOf(parts));
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public static Identifier from(List<String> parts) {
            Preconditions.checkArgument(!parts.isEmpty(), "Parts may not be empty");
            return new Identifier(parts);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public static Identifier ignore() {
            return new Identifier(Collections.emptyList());
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public int getNumberOfParts() {
            return this.parts.size();
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public String getPart(int index) {
            Preconditions.checkArgument(index >= 1 && index <= this.parts.size(), "Index %d is out of bounds", index);
            return this.parts.get(index - 1);
        }

        boolean shouldBeConsidered() {
            return !this.parts.isEmpty();
        }

        @Override
        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public Iterator<String> iterator() {
            return this.parts.iterator();
        }

        public int hashCode() {
            return Objects.hash(this.parts);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Identifier other = (Identifier)obj;
            return Objects.equals(this.parts, other.parts);
        }

        public String toString() {
            return this.parts.toString();
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
    public static interface Descriptor {
        public String getName();

        @PublicAPI(usage=PublicAPI.Usage.ACCESS, state=PublicAPI.State.EXPERIMENTAL)
        public static Descriptor create(String name) {
            return () -> name;
        }
    }
}

