/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.modules.syntax;

import com.tngtech.archunit.base.DescribedIterable;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.lang.ClassesTransformer;
import com.tngtech.archunit.library.modules.ArchModule;
import com.tngtech.archunit.library.modules.ArchModules;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class ModulesTransformer<D extends ArchModule.Descriptor>
implements ClassesTransformer<ArchModule<D>> {
    private final Function<JavaClasses, ArchModules<D>> transformFunction;
    private final Predicate<ArchModule<D>> predicate;
    private final String description;

    ModulesTransformer(Function<JavaClasses, ArchModules<D>> transformFunction) {
        this(transformFunction, __ -> true, "modules");
    }

    private ModulesTransformer(Function<JavaClasses, ArchModules<D>> transformFunction, Predicate<ArchModule<D>> predicate, String description) {
        this.transformFunction = transformFunction;
        this.predicate = predicate;
        this.description = description;
    }

    @Override
    public DescribedIterable<ArchModule<D>> transform(JavaClasses classes) {
        Collection modules = this.transformFunction.apply(classes).stream().filter(this.predicate).collect(Collectors.toList());
        return DescribedIterable.From.iterable(modules, this.description);
    }

    @Override
    public ModulesTransformer<D> that(DescribedPredicate<? super ArchModule<D>> predicate) {
        return new ModulesTransformer<D>(this.transformFunction, predicate.forSubtype(), this.description + " that " + predicate.getDescription());
    }

    ModulesTransformer<D> and(DescribedPredicate<? super ArchModule<D>> predicate) {
        return new ModulesTransformer<D>(this.transformFunction, x -> this.predicate.test((ArchModule<D>)x) && predicate.test((ArchModule<D>)x), this.description + " and " + predicate.getDescription());
    }

    ModulesTransformer<D> or(DescribedPredicate<? super ArchModule<D>> predicate) {
        return new ModulesTransformer<D>(this.transformFunction, x -> this.predicate.test((ArchModule<D>)x) || predicate.test((ArchModule<D>)x), this.description + " or " + predicate.getDescription());
    }

    @Override
    public ModulesTransformer<D> as(String description) {
        return new ModulesTransformer<D>(this.transformFunction, this.predicate, description);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

