// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!
#ifndef _GTKMM_SCROLLINFO_H
#define _GTKMM_SCROLLINFO_H

#include <gtkmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2023 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm/refptr.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkScrollInfo GtkScrollInfo;
#endif

namespace Gtk
{

/** Provides more accurate data on how a scroll operation should be performed.
 *
 * Scrolling functions usually allow passing an empty RefPtr scroll info which
 * will cause the default values to be used and just scroll the element into view.
 *
 * @newin{4,12}
 */
class GTKMM_API ScrollInfo final
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = ScrollInfo;
  using BaseObjectType = GtkScrollInfo;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GtkScrollInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GtkScrollInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkScrollInfo* gobj_copy() const;

  ScrollInfo() = delete;

  // noncopyable
  ScrollInfo(const ScrollInfo&) = delete;
  ScrollInfo& operator=(const ScrollInfo&) = delete;

protected:
  // Do not derive this.  Gtk::ScrollInfo can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

  
public:
  
  /** Creates a new scroll info for scrolling an element into view.
   * 
   * @newin{4,12}
   * 
   * @return A new scroll info.
   */
  static Glib::RefPtr<ScrollInfo> create();

  
  /** Turns horizontal scrolling on or off.
   * 
   * @newin{4,12}
   * 
   * @param horizontal If scrolling in the horizontal direction
   * should happen.
   */
  void set_enable_horizontal(bool horizontal =  true);
  
  /** Checks if horizontal scrolling is enabled.
   * 
   * @newin{4,12}
   * 
   * @return <tt>true</tt> if horizontal scrolling is enabled.
   */
  bool get_enable_horizontal() const;
  
  /** Turns vertical scrolling on or off.
   * 
   * @newin{4,12}
   * 
   * @param vertical If scrolling in the vertical direction
   * should happen.
   */
  void set_enable_vertical(bool vertical =  true);
  
  /** Checks if vertical scrolling is enabled.
   * 
   * @newin{4,12}
   * 
   * @return <tt>true</tt> if vertical scrolling is enabled.
   */
  bool get_enable_vertical() const;


};

} // namespace Gtk


namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gtk::ScrollInfo
 */
GTKMM_API
Glib::RefPtr<Gtk::ScrollInfo> wrap(GtkScrollInfo* object, bool take_copy = false);

} // namespace Glib


#endif /* _GTKMM_SCROLLINFO_H */

