/*
 *  @DVB-S/DVB-S2 STMicroelectronics STV0900 register defintions
 * Author Manfred Völkel, August 2013
 * (c) 2013 Digital Devices GmbH Germany.  All rights reserved
 * $Id: DD_STV091XRegister.h 504 2013-09-02 23:02:14Z manfred
 * =======================================================================
 * Registers Declaration (Internal ST, All Applications )
 * -------------------------
 * Each register (RSTV091X__XXXXX) is defined by its address (2 bytes).
 *
 * Each field (FSTV091X__XXXXX)is defined as follow:
 * [register address -- 2bytes][field sign -- 1byte][field mask -- 1byte]
 * =======================================================================
*/

/*MID*/
#define RSTV091X_MID  0xf100
#define FSTV091X_MCHIP_IDENT  0xf10000f0
#define FSTV091X_MRELEASE  0xf100000f

/*DID*/
#define RSTV091X_DID  0xf101
#define FSTV091X_DEVICE_ID  0xf10100ff

/*DACR1*/
#define RSTV091X_DACR1  0xf113
#define FSTV091X_DAC_MODE  0xf11300e0
#define FSTV091X_DAC_VALUE1  0xf113000f

/*DACR2*/
#define RSTV091X_DACR2  0xf114
#define FSTV091X_DAC_VALUE0  0xf11400ff

/*PADCFG*/
#define RSTV091X_PADCFG  0xf11a
#define FSTV091X_AGCRF2_OPD  0xf11a0008
#define FSTV091X_AGCRF2_XOR  0xf11a0004
#define FSTV091X_AGCRF1_OPD  0xf11a0002
#define FSTV091X_AGCRF1_XOR  0xf11a0001

/*OUTCFG2*/
#define RSTV091X_OUTCFG2  0xf11b
#define FSTV091X_TS2_ERROR_XOR  0xf11b0080
#define FSTV091X_TS2_DPN_XOR  0xf11b0040
#define FSTV091X_TS2_STROUT_XOR  0xf11b0020
#define FSTV091X_TS2_CLOCKOUT_XOR  0xf11b0010
#define FSTV091X_TS1_ERROR_XOR  0xf11b0008
#define FSTV091X_TS1_DPN_XOR  0xf11b0004
#define FSTV091X_TS1_STROUT_XOR  0xf11b0002
#define FSTV091X_TS1_CLOCKOUT_XOR  0xf11b0001

/*OUTCFG*/
#define RSTV091X_OUTCFG  0xf11c
#define FSTV091X_INV_DATA6  0xf11c0080
#define FSTV091X_TS2_OUTSER_HZ  0xf11c0020
#define FSTV091X_TS1_OUTSER_HZ  0xf11c0010
#define FSTV091X_TS2_OUTPAR_HZ  0xf11c0008
#define FSTV091X_TS1_OUTPAR_HZ  0xf11c0004
#define FSTV091X_TS_SERDATA0  0xf11c0002

/*IRQSTATUS3*/
#define RSTV091X_IRQSTATUS3  0xf120
#define FSTV091X_SPLL_LOCK  0xf1200020
#define FSTV091X_SSTREAM_LCK_1  0xf1200010
#define FSTV091X_SSTREAM_LCK_2  0xf1200008
#define FSTV091X_SDVBS1_PRF_2  0xf1200002
#define FSTV091X_SDVBS1_PRF_1  0xf1200001

/*IRQSTATUS2*/
#define RSTV091X_IRQSTATUS2  0xf121
#define FSTV091X_SSPY_ENDSIM_1  0xf1210080
#define FSTV091X_SSPY_ENDSIM_2  0xf1210040
#define FSTV091X_SPKTDEL_ERROR_2  0xf1210010
#define FSTV091X_SPKTDEL_LOCKB_2  0xf1210008
#define FSTV091X_SPKTDEL_LOCK_2  0xf1210004
#define FSTV091X_SPKTDEL_ERROR_1  0xf1210002
#define FSTV091X_SPKTDEL_LOCKB_1  0xf1210001

/*IRQSTATUS1*/
#define RSTV091X_IRQSTATUS1  0xf122
#define FSTV091X_SPKTDEL_LOCK_1  0xf1220080
#define FSTV091X_SFEC_LOCKB_2  0xf1220040
#define FSTV091X_SFEC_LOCK_2  0xf1220020
#define FSTV091X_SFEC_LOCKB_1  0xf1220010
#define FSTV091X_SFEC_LOCK_1  0xf1220008
#define FSTV091X_SDEMOD_LOCKB_2  0xf1220004
#define FSTV091X_SDEMOD_LOCK_2  0xf1220002
#define FSTV091X_SDEMOD_IRQ_2  0xf1220001

/*IRQSTATUS0*/
#define RSTV091X_IRQSTATUS0  0xf123
#define FSTV091X_SDEMOD_LOCKB_1  0xf1230080
#define FSTV091X_SDEMOD_LOCK_1  0xf1230040
#define FSTV091X_SDEMOD_IRQ_1  0xf1230020
#define FSTV091X_SBCH_ERRFLAG  0xf1230010
#define FSTV091X_SECW2_IRQ  0xf1230008
#define FSTV091X_SDISEQC2_IRQ  0xf1230004
#define FSTV091X_SECW1_IRQ  0xf1230002
#define FSTV091X_SDISEQC1_IRQ  0xf1230001

/*IRQMASK3*/
#define RSTV091X_IRQMASK3  0xf124
#define FSTV091X_MPLL_LOCK  0xf1240020
#define FSTV091X_MSTREAM_LCK_1  0xf1240010
#define FSTV091X_MSTREAM_LCK_2  0xf1240008
#define FSTV091X_MDVBS1_PRF_2  0xf1240002
#define FSTV091X_MDVBS1_PRF_1  0xf1240001

/*IRQMASK2*/
#define RSTV091X_IRQMASK2  0xf125
#define FSTV091X_MSPY_ENDSIM_1  0xf1250080
#define FSTV091X_MSPY_ENDSIM_2  0xf1250040
#define FSTV091X_MPKTDEL_ERROR_2  0xf1250010
#define FSTV091X_MPKTDEL_LOCKB_2  0xf1250008
#define FSTV091X_MPKTDEL_LOCK_2  0xf1250004
#define FSTV091X_MPKTDEL_ERROR_1  0xf1250002
#define FSTV091X_MPKTDEL_LOCKB_1  0xf1250001

/*IRQMASK1*/
#define RSTV091X_IRQMASK1  0xf126
#define FSTV091X_MPKTDEL_LOCK_1  0xf1260080
#define FSTV091X_MFEC_LOCKB_2  0xf1260040
#define FSTV091X_MFEC_LOCK_2  0xf1260020
#define FSTV091X_MFEC_LOCKB_1  0xf1260010
#define FSTV091X_MFEC_LOCK_1  0xf1260008
#define FSTV091X_MDEMOD_LOCKB_2  0xf1260004
#define FSTV091X_MDEMOD_LOCK_2  0xf1260002
#define FSTV091X_MDEMOD_IRQ_2  0xf1260001

/*IRQMASK0*/
#define RSTV091X_IRQMASK0  0xf127
#define FSTV091X_MDEMOD_LOCKB_1  0xf1270080
#define FSTV091X_MDEMOD_LOCK_1  0xf1270040
#define FSTV091X_MDEMOD_IRQ_1  0xf1270020
#define FSTV091X_MBCH_ERRFLAG  0xf1270010
#define FSTV091X_MECW2_IRQ  0xf1270008
#define FSTV091X_MDISEQC2_IRQ  0xf1270004
#define FSTV091X_MECW1_IRQ  0xf1270002
#define FSTV091X_MDISEQC1_IRQ  0xf1270001

/*I2CCFG*/
#define RSTV091X_I2CCFG  0xf129
#define FSTV091X_I2C2_FASTMODE  0xf1290080
#define FSTV091X_STATUS_WR2  0xf1290040
#define FSTV091X_I2C2ADDR_INC  0xf1290030
#define FSTV091X_I2C_FASTMODE  0xf1290008
#define FSTV091X_STATUS_WR  0xf1290004
#define FSTV091X_I2CADDR_INC  0xf1290003

/*P1_I2CRPT*/
#define RSTV091X_P1_I2CRPT  0xf12a
#define FSTV091X_P1_I2CT_ON  0xf12a0080
#define FSTV091X_P1_ENARPT_LEVEL  0xf12a0070
#define FSTV091X_P1_SCLT_DELAY  0xf12a0008
#define FSTV091X_P1_STOP_ENABLE  0xf12a0004
#define FSTV091X_P1_STOP_SDAT2SDA  0xf12a0002

/*P2_I2CRPT*/
#define RSTV091X_P2_I2CRPT  0xf12b
#define FSTV091X_P2_I2CT_ON  0xf12b0080
#define FSTV091X_P2_ENARPT_LEVEL  0xf12b0070
#define FSTV091X_P2_SCLT_DELAY  0xf12b0008
#define FSTV091X_P2_STOP_ENABLE  0xf12b0004
#define FSTV091X_P2_STOP_SDAT2SDA  0xf12b0002

/*GPIO0CFG*/
#define RSTV091X_GPIO0CFG  0xf140
#define FSTV091X_GPIO0_OPD  0xf1400080
#define FSTV091X_GPIO0_CONFIG  0xf140007e
#define FSTV091X_GPIO0_XOR  0xf1400001

/*GPIO1CFG*/
#define RSTV091X_GPIO1CFG  0xf141
#define FSTV091X_GPIO1_OPD  0xf1410080
#define FSTV091X_GPIO1_CONFIG  0xf141007e
#define FSTV091X_GPIO1_XOR  0xf1410001

/*GPIO2CFG*/
#define RSTV091X_GPIO2CFG  0xf142
#define FSTV091X_GPIO2_OPD  0xf1420080
#define FSTV091X_GPIO2_CONFIG  0xf142007e
#define FSTV091X_GPIO2_XOR  0xf1420001

/*GPIO3CFG*/
#define RSTV091X_GPIO3CFG  0xf143
#define FSTV091X_GPIO3_OPD  0xf1430080
#define FSTV091X_GPIO3_CONFIG  0xf143007e
#define FSTV091X_GPIO3_XOR  0xf1430001

/*GPIO4CFG*/
#define RSTV091X_GPIO4CFG  0xf144
#define FSTV091X_GPIO4_OPD  0xf1440080
#define FSTV091X_GPIO4_CONFIG  0xf144007e
#define FSTV091X_GPIO4_XOR  0xf1440001

/*GPIO5CFG*/
#define RSTV091X_GPIO5CFG  0xf145
#define FSTV091X_GPIO5_OPD  0xf1450080
#define FSTV091X_GPIO5_CONFIG  0xf145007e
#define FSTV091X_GPIO5_XOR  0xf1450001

/*GPIO6CFG*/
#define RSTV091X_GPIO6CFG  0xf146
#define FSTV091X_GPIO6_OPD  0xf1460080
#define FSTV091X_GPIO6_CONFIG  0xf146007e
#define FSTV091X_GPIO6_XOR  0xf1460001

/*GPIO7CFG*/
#define RSTV091X_GPIO7CFG  0xf147
#define FSTV091X_GPIO7_OPD  0xf1470080
#define FSTV091X_GPIO7_CONFIG  0xf147007e
#define FSTV091X_GPIO7_XOR  0xf1470001

/*GPIO8CFG*/
#define RSTV091X_GPIO8CFG  0xf148
#define FSTV091X_GPIO8_OPD  0xf1480080
#define FSTV091X_GPIO8_CONFIG  0xf148007e
#define FSTV091X_GPIO8_XOR  0xf1480001

/*GPIO9CFG*/
#define RSTV091X_GPIO9CFG  0xf149
#define FSTV091X_GPIO9_OPD  0xf1490080
#define FSTV091X_GPIO9_CONFIG  0xf149007e
#define FSTV091X_GPIO9_XOR  0xf1490001

/*GPIO10CFG*/
#define RSTV091X_GPIO10CFG  0xf14a
#define FSTV091X_GPIO10_OPD  0xf14a0080
#define FSTV091X_GPIO10_CONFIG  0xf14a007e
#define FSTV091X_GPIO10_XOR  0xf14a0001

/*GPIO11CFG*/
#define RSTV091X_GPIO11CFG  0xf14b
#define FSTV091X_GPIO11_OPD  0xf14b0080
#define FSTV091X_GPIO11_CONFIG  0xf14b007e
#define FSTV091X_GPIO11_XOR  0xf14b0001

/*GPIO12CFG*/
#define RSTV091X_GPIO12CFG  0xf14c
#define FSTV091X_GPIO12_OPD  0xf14c0080
#define FSTV091X_GPIO12_CONFIG  0xf14c007e
#define FSTV091X_GPIO12_XOR  0xf14c0001

/*GPIO13CFG*/
#define RSTV091X_GPIO13CFG  0xf14d
#define FSTV091X_GPIO13_OPD  0xf14d0080
#define FSTV091X_GPIO13_CONFIG  0xf14d007e
#define FSTV091X_GPIO13_XOR  0xf14d0001

/*GPIO14CFG*/
#define RSTV091X_GPIO14CFG  0xf14e
#define FSTV091X_GPIO14_OPD  0xf14e0080
#define FSTV091X_GPIO14_CONFIG  0xf14e007e
#define FSTV091X_GPIO14_XOR  0xf14e0001

/*GPIO15CFG*/
#define RSTV091X_GPIO15CFG  0xf14f
#define FSTV091X_GPIO15_OPD  0xf14f0080
#define FSTV091X_GPIO15_CONFIG  0xf14f007e
#define FSTV091X_GPIO15_XOR  0xf14f0001

/*GPIO16CFG*/
#define RSTV091X_GPIO16CFG  0xf150
#define FSTV091X_GPIO16_OPD  0xf1500080
#define FSTV091X_GPIO16_CONFIG  0xf150007e
#define FSTV091X_GPIO16_XOR  0xf1500001

/*GPIO17CFG*/
#define RSTV091X_GPIO17CFG  0xf151
#define FSTV091X_GPIO17_OPD  0xf1510080
#define FSTV091X_GPIO17_CONFIG  0xf151007e
#define FSTV091X_GPIO17_XOR  0xf1510001

/*GPIO18CFG*/
#define RSTV091X_GPIO18CFG  0xf152
#define FSTV091X_GPIO18_OPD  0xf1520080
#define FSTV091X_GPIO18_CONFIG  0xf152007e
#define FSTV091X_GPIO18_XOR  0xf1520001

/*GPIO19CFG*/
#define RSTV091X_GPIO19CFG  0xf153
#define FSTV091X_GPIO19_OPD  0xf1530080
#define FSTV091X_GPIO19_CONFIG  0xf153007e
#define FSTV091X_GPIO19_XOR  0xf1530001

/*GPIO20CFG*/
#define RSTV091X_GPIO20CFG  0xf154
#define FSTV091X_GPIO20_OPD  0xf1540080
#define FSTV091X_GPIO20_CONFIG  0xf154007e
#define FSTV091X_GPIO20_XOR  0xf1540001

/*GPIO21CFG*/
#define RSTV091X_GPIO21CFG  0xf155
#define FSTV091X_GPIO21_OPD  0xf1550080
#define FSTV091X_GPIO21_CONFIG  0xf155007e
#define FSTV091X_GPIO21_XOR  0xf1550001

/*GPIO22CFG*/
#define RSTV091X_GPIO22CFG  0xf156
#define FSTV091X_GPIO22_OPD  0xf1560080
#define FSTV091X_GPIO22_CONFIG  0xf156007e
#define FSTV091X_GPIO22_XOR  0xf1560001

/*STRSTATUS1*/
#define RSTV091X_STRSTATUS1  0xf16a
#define FSTV091X_STRSTATUS_SEL2  0xf16a00f0
#define FSTV091X_STRSTATUS_SEL1  0xf16a000f

/*STRSTATUS2*/
#define RSTV091X_STRSTATUS2  0xf16b
#define FSTV091X_STRSTATUS_SEL4  0xf16b00f0
#define FSTV091X_STRSTATUS_SEL3  0xf16b000f

/*STRSTATUS3*/
#define RSTV091X_STRSTATUS3  0xf16c
#define FSTV091X_STRSTATUS_SEL6  0xf16c00f0
#define FSTV091X_STRSTATUS_SEL5  0xf16c000f

/*FSKTFC2*/
#define RSTV091X_FSKTFC2  0xf170
#define FSTV091X_FSKT_KMOD  0xf17000fc
#define FSTV091X_FSKT_CAR2  0xf1700003

/*FSKTFC1*/
#define RSTV091X_FSKTFC1  0xf171
#define FSTV091X_FSKT_CAR1  0xf17100ff

/*FSKTFC0*/
#define RSTV091X_FSKTFC0  0xf172
#define FSTV091X_FSKT_CAR0  0xf17200ff

/*FSKTDELTAF1*/
#define RSTV091X_FSKTDELTAF1  0xf173
#define FSTV091X_FSKT_DELTAF1  0xf173000f

/*FSKTDELTAF0*/
#define RSTV091X_FSKTDELTAF0  0xf174
#define FSTV091X_FSKT_DELTAF0  0xf17400ff

/*FSKTCTRL*/
#define RSTV091X_FSKTCTRL  0xf175
#define FSTV091X_FSKT_PINSEL  0xf1750080
#define FSTV091X_FSKT_EN_SGN  0xf1750040
#define FSTV091X_FSKT_MOD_SGN  0xf1750020
#define FSTV091X_FSKT_MOD_EN  0xf175001c
#define FSTV091X_FSKT_DACMODE  0xf1750003

/*FSKRFC2*/
#define RSTV091X_FSKRFC2  0xf176
#define FSTV091X_FSKR_DETSGN  0xf1760040
#define FSTV091X_FSKR_OUTSGN  0xf1760020
#define FSTV091X_FSKR_KAGC  0xf176001c
#define FSTV091X_FSKR_CAR2  0xf1760003

/*FSKRFC1*/
#define RSTV091X_FSKRFC1  0xf177
#define FSTV091X_FSKR_CAR1  0xf17700ff

/*FSKRFC0*/
#define RSTV091X_FSKRFC0  0xf178
#define FSTV091X_FSKR_CAR0  0xf17800ff

/*FSKRK1*/
#define RSTV091X_FSKRK1  0xf179
#define FSTV091X_FSKR_K1_EXP  0xf17900e0
#define FSTV091X_FSKR_K1_MANT  0xf179001f

/*FSKRK2*/
#define RSTV091X_FSKRK2  0xf17a
#define FSTV091X_FSKR_K2_EXP  0xf17a00e0
#define FSTV091X_FSKR_K2_MANT  0xf17a001f

/*FSKRAGCR*/
#define RSTV091X_FSKRAGCR  0xf17b
#define FSTV091X_FSKR_OUTCTL  0xf17b00c0
#define FSTV091X_FSKR_AGC_REF  0xf17b003f

/*FSKRAGC*/
#define RSTV091X_FSKRAGC  0xf17c
#define FSTV091X_FSKR_AGC_ACCU  0xf17c00ff

/*FSKRALPHA*/
#define RSTV091X_FSKRALPHA  0xf17d
#define FSTV091X_FSKR_ALPHA_EXP  0xf17d001c
#define FSTV091X_FSKR_ALPHA_M  0xf17d0003

/*FSKRPLTH1*/
#define RSTV091X_FSKRPLTH1  0xf17e
#define FSTV091X_FSKR_BETA  0xf17e00f0
#define FSTV091X_FSKR_PLL_TRESH1  0xf17e000f

/*FSKRPLTH0*/
#define RSTV091X_FSKRPLTH0  0xf17f
#define FSTV091X_FSKR_PLL_TRESH0  0xf17f00ff

/*FSKRDF1*/
#define RSTV091X_FSKRDF1  0xf180
#define FSTV091X_FSKR_OUT  0xf1800080
#define FSTV091X_FSKR_STATE  0xf1800060
#define FSTV091X_FSKR_DELTAF1  0xf180001f

/*FSKRDF0*/
#define RSTV091X_FSKRDF0  0xf181
#define FSTV091X_FSKR_DELTAF0  0xf18100ff

/*FSKRSTEPP*/
#define RSTV091X_FSKRSTEPP  0xf182
#define FSTV091X_FSKR_STEP_PLUS  0xf18200ff

/*FSKRSTEPM*/
#define RSTV091X_FSKRSTEPM  0xf183
#define FSTV091X_FSKR_STEP_MINUS  0xf18300ff

/*FSKRDET1*/
#define RSTV091X_FSKRDET1  0xf184
#define FSTV091X_FSKR_DETECT  0xf1840080
#define FSTV091X_FSKR_CARDET_ACCU1  0xf184000f

/*FSKRDET0*/
#define RSTV091X_FSKRDET0  0xf185
#define FSTV091X_FSKR_CARDET_ACCU0  0xf18500ff

/*FSKRDTH1*/
#define RSTV091X_FSKRDTH1  0xf186
#define FSTV091X_FSKR_CARLOSS_THRESH1  0xf18600f0
#define FSTV091X_FSKR_CARDET_THRESH1  0xf186000f

/*FSKRDTH0*/
#define RSTV091X_FSKRDTH0  0xf187
#define FSTV091X_FSKR_CARDET_THRESH0  0xf18700ff

/*FSKRLOSS*/
#define RSTV091X_FSKRLOSS  0xf188
#define FSTV091X_FSKR_CARLOSS_THRESH0  0xf18800ff

/*NCOARSE*/
#define RSTV091X_NCOARSE  0xf1b3
#define FSTV091X_CP  0xf1b300f8
#define FSTV091X_IDF  0xf1b30007

/*NCOARSE1*/
#define RSTV091X_NCOARSE1  0xf1b4
#define FSTV091X_N_DIV  0xf1b400ff

/*NCOARSE2*/
#define RSTV091X_NCOARSE2  0xf1b5
#define FSTV091X_ODF  0xf1b5003f

/*SYNTCTRL*/
#define RSTV091X_SYNTCTRL  0xf1b6
#define FSTV091X_STANDBY  0xf1b60080
#define FSTV091X_BYPASSPLLCORE  0xf1b60040
#define FSTV091X_STOP_PLL  0xf1b60008
#define FSTV091X_OSCI_E  0xf1b60002

/*FILTCTRL*/
#define RSTV091X_FILTCTRL  0xf1b7
#define FSTV091X_INV_CLKFSK  0xf1b70002
#define FSTV091X_BYPASS_APPLI  0xf1b70001

/*PLLSTAT*/
#define RSTV091X_PLLSTAT  0xf1b8
#define FSTV091X_PLL_BIST_END  0xf1b80004
#define FSTV091X_PLLLOCK  0xf1b80001

/*STOPCLK1*/
#define RSTV091X_STOPCLK1  0xf1c2
#define FSTV091X_INV_CLKADCI2  0xf1c20004
#define FSTV091X_INV_CLKADCI1  0xf1c20001

/*STOPCLK2*/
#define RSTV091X_STOPCLK2  0xf1c3
#define FSTV091X_STOP_DVBS2FEC2  0xf1c30020
#define FSTV091X_STOP_DVBS2FEC  0xf1c30010
#define FSTV091X_STOP_DVBS1FEC2  0xf1c30008
#define FSTV091X_STOP_DVBS1FEC  0xf1c30004
#define FSTV091X_STOP_DEMOD2  0xf1c30002
#define FSTV091X_STOP_DEMOD  0xf1c30001

/*PREGCTL*/
#define RSTV091X_PREGCTL  0xf1c8
#define FSTV091X_REG3V3TO2V5_POFF  0xf1c80080

/*TSTTNR0*/
#define RSTV091X_TSTTNR0  0xf1df
#define FSTV091X_FSK_PON  0xf1df0004
#define FSTV091X_FSK_OPENLOOP  0xf1df0002

/*TSTTNR1*/
#define RSTV091X_TSTTNR1  0xf1e0
#define FSTV091X_BYPASS_ADC1  0xf1e00080
#define FSTV091X_INVADC1_CKOUT  0xf1e00040
#define FSTV091X_SELIQSRC1  0xf1e00030
#define FSTV091X_DEMOD2_SELADC  0xf1e00008
#define FSTV091X_DEMOD1_SELADC  0xf1e00004
#define FSTV091X_ADC1_PON  0xf1e00002

/*TSTTNR2*/
#define RSTV091X_TSTTNR2  0xf1e1
#define FSTV091X_I2C_DISEQC_BYPASS  0xf1e10080
#define FSTV091X_I2C_DISEQC_ENCH  0xf1e10040
#define FSTV091X_I2C_DISEQC_PON  0xf1e10020
#define FSTV091X_DISEQC_CLKDIV  0xf1e1000f

/*TSTTNR3*/
#define RSTV091X_TSTTNR3  0xf1e2
#define FSTV091X_BYPASS_ADC2  0xf1e20080
#define FSTV091X_INVADC2_CKOUT  0xf1e20040
#define FSTV091X_SELIQSRC2  0xf1e20030
#define FSTV091X_ADC2_PON  0xf1e20002

/*P2_IQCONST*/
#define RSTV091X_P2_IQCONST  0xf200
#define FSTV091X_P2_CONSTEL_SELECT  0xf2000060
#define FSTV091X_P2_IQSYMB_SEL  0xf200001f

/*P2_NOSCFG*/
#define RSTV091X_P2_NOSCFG  0xf201
#define FSTV091X_P2_DIS_ACMRATIO  0xf2010080
#define FSTV091X_P2_NOSIN_EGALSEL  0xf2010040
#define FSTV091X_P2_DUMMYPL_NOSDATA  0xf2010020
#define FSTV091X_P2_NOSPLH_BETA  0xf2010018
#define FSTV091X_P2_NOSDATA_BETA  0xf2010007

/*P2_ISYMB*/
#define RSTV091X_P2_ISYMB  0xf202
#define FSTV091X_P2_I_SYMBOL  0xf20201ff

/*P2_QSYMB*/
#define RSTV091X_P2_QSYMB  0xf203
#define FSTV091X_P2_Q_SYMBOL  0xf20301ff

/*P2_AGC1CFG*/
#define RSTV091X_P2_AGC1CFG  0xf204
#define FSTV091X_P2_DC_FROZEN  0xf2040080
#define FSTV091X_P2_DC_CORRECT  0xf2040040
#define FSTV091X_P2_AMM_FROZEN  0xf2040020
#define FSTV091X_P2_AMM_CORRECT  0xf2040010
#define FSTV091X_P2_QUAD_FROZEN  0xf2040008
#define FSTV091X_P2_QUAD_CORRECT  0xf2040004
#define FSTV091X_P2_DCCOMP_SLOW  0xf2040002
#define FSTV091X_P2_IQMISM_SLOW  0xf2040001

/*P2_AGC1CN*/
#define RSTV091X_P2_AGC1CN  0xf206
#define FSTV091X_P2_AGC1_LOCKED  0xf2060080
#define FSTV091X_P2_AGC1_OVERFLOW  0xf2060040
#define FSTV091X_P2_AGC1_NOSLOWLK  0xf2060020
#define FSTV091X_P2_AGC1_MINPOWER  0xf2060010
#define FSTV091X_P2_AGCOUT_FAST  0xf2060008
#define FSTV091X_P2_AGCIQ_BETA  0xf2060007

/*P2_AGC1REF*/
#define RSTV091X_P2_AGC1REF  0xf207
#define FSTV091X_P2_AGCIQ_REF  0xf20700ff

/*P2_IDCCOMP*/
#define RSTV091X_P2_IDCCOMP  0xf208
#define FSTV091X_P2_IAVERAGE_ADJ  0xf20801ff

/*P2_QDCCOMP*/
#define RSTV091X_P2_QDCCOMP  0xf209
#define FSTV091X_P2_QAVERAGE_ADJ  0xf20901ff

/*P2_POWERI*/
#define RSTV091X_P2_POWERI  0xf20a
#define FSTV091X_P2_POWER_I  0xf20a00ff

/*P2_POWERQ*/
#define RSTV091X_P2_POWERQ  0xf20b
#define FSTV091X_P2_POWER_Q  0xf20b00ff

/*P2_AGC1AMM*/
#define RSTV091X_P2_AGC1AMM  0xf20c
#define FSTV091X_P2_AMM_VALUE  0xf20c00ff

/*P2_AGC1QUAD*/
#define RSTV091X_P2_AGC1QUAD  0xf20d
#define FSTV091X_P2_QUAD_VALUE  0xf20d01ff

/*P2_AGCIQIN1*/
#define RSTV091X_P2_AGCIQIN1  0xf20e
#define FSTV091X_P2_AGCIQ_VALUE1  0xf20e00ff

/*P2_AGCIQIN0*/
#define RSTV091X_P2_AGCIQIN0  0xf20f
#define FSTV091X_P2_AGCIQ_VALUE0  0xf20f00ff

/*P2_DEMOD*/
#define RSTV091X_P2_DEMOD  0xf210
#define FSTV091X_P2_MANUALS2_ROLLOFF  0xf2100080
#define FSTV091X_P2_SPECINV_CONTROL  0xf2100030
#define FSTV091X_P2_MANUALSX_ROLLOFF  0xf2100004
#define FSTV091X_P2_ROLLOFF_CONTROL  0xf2100003

/*P2_DMDMODCOD*/
#define RSTV091X_P2_DMDMODCOD  0xf211
#define FSTV091X_P2_MANUAL_MODCOD  0xf2110080
#define FSTV091X_P2_DEMOD_MODCOD  0xf211007c
#define FSTV091X_P2_DEMOD_TYPE  0xf2110003

/*P2_DSTATUS*/
#define RSTV091X_P2_DSTATUS  0xf212
#define FSTV091X_P2_CAR_LOCK  0xf2120080
#define FSTV091X_P2_TMGLOCK_QUALITY  0xf2120060
#define FSTV091X_P2_SDVBS1_ENABLE  0xf2120010
#define FSTV091X_P2_LOCK_DEFINITIF  0xf2120008
#define FSTV091X_P2_TIMING_IS_LOCKED  0xf2120004
#define FSTV091X_P2_DEMOD_SYSCFG  0xf2120002
#define FSTV091X_P2_OVADC_DETECT  0xf2120001

/*P2_DSTATUS2*/
#define RSTV091X_P2_DSTATUS2  0xf213
#define FSTV091X_P2_DEMOD_DELOCK  0xf2130080
#define FSTV091X_P2_DEMOD_TIMEOUT  0xf2130040
#define FSTV091X_P2_MODCODRQ_SYNCTAG  0xf2130020
#define FSTV091X_P2_POLYPH_SATEVENT  0xf2130010
#define FSTV091X_P2_AGC1_NOSIGNALACK  0xf2130008
#define FSTV091X_P2_AGC2_OVERFLOW  0xf2130004
#define FSTV091X_P2_CFR_OVERFLOW  0xf2130002
#define FSTV091X_P2_GAMMA_OVERUNDER  0xf2130001

/*P2_DMDCFGMD*/
#define RSTV091X_P2_DMDCFGMD  0xf214
#define FSTV091X_P2_DVBS2_ENABLE  0xf2140080
#define FSTV091X_P2_DVBS1_ENABLE  0xf2140040
#define FSTV091X_P2_SCAN_ENABLE  0xf2140010
#define FSTV091X_P2_CFR_AUTOSCAN  0xf2140008
#define FSTV091X_P2_NOFORCE_RELOCK  0xf2140004
#define FSTV091X_P2_TUN_RNG  0xf2140003

/*P2_DMDCFG2*/
#define RSTV091X_P2_DMDCFG2  0xf215
#define FSTV091X_P2_AGC1_WAITLOCK  0xf2150080
#define FSTV091X_P2_S1S2_SEQUENTIAL  0xf2150040
#define FSTV091X_P2_BLINDPEA_MODE  0xf2150020
#define FSTV091X_P2_INFINITE_RELOCK  0xf2150010
#define FSTV091X_P2_BWOFFSET_COLDWARM  0xf2150008
#define FSTV091X_P2_TMGLOCK_NSCANSTOP  0xf2150004
#define FSTV091X_P2_COARSE_LK3MODE  0xf2150002
#define FSTV091X_P2_COARSE_LK2MODE  0xf2150001

/*P2_DMDISTATE*/
#define RSTV091X_P2_DMDISTATE  0xf216
#define FSTV091X_P2_I2C_NORESETDMODE  0xf2160080
#define FSTV091X_P2_FORCE_ETAPED  0xf2160040
#define FSTV091X_P2_SDMDRST_DIRCLK  0xf2160020
#define FSTV091X_P2_I2C_DEMOD_MODE  0xf216001f

/*P2_DMDT0M*/
#define RSTV091X_P2_DMDT0M  0xf217
#define FSTV091X_P2_DMDT0_MIN  0xf21700ff

/*P2_DMDSTATE*/
#define RSTV091X_P2_DMDSTATE  0xf21b
#define FSTV091X_P2_DEMOD_LOCKED  0xf21b0080
#define FSTV091X_P2_HEADER_MODE  0xf21b0060
#define FSTV091X_P2_DEMOD_MODE  0xf21b001f

/*P2_DMDFLYW*/
#define RSTV091X_P2_DMDFLYW  0xf21c
#define FSTV091X_P2_I2C_IRQVAL  0xf21c00f0
#define FSTV091X_P2_FLYWHEEL_CPT  0xf21c000f

/*P2_DSTATUS3*/
#define RSTV091X_P2_DSTATUS3  0xf21d
#define FSTV091X_P2_CFR_ZIGZAG  0xf21d0080
#define FSTV091X_P2_DEMOD_CFGMODE  0xf21d0060
#define FSTV091X_P2_GAMMA_LOWBAUDRATE  0xf21d0010
#define FSTV091X_P2_RELOCK_MODE  0xf21d0008
#define FSTV091X_P2_DEMOD_FAIL  0xf21d0004
#define FSTV091X_P2_ETAPE1A_DVBXMEM  0xf21d0003

/*P2_DMDCFG3*/
#define RSTV091X_P2_DMDCFG3  0xf21e
#define FSTV091X_P2_DVBS1_TMGWAIT  0xf21e0080
#define FSTV091X_P2_NO_BWCENTERING  0xf21e0040
#define FSTV091X_P2_INV_SEQSRCH  0xf21e0020
#define FSTV091X_P2_DIS_SFRUPLOW_TRK  0xf21e0010
#define FSTV091X_P2_NOSTOP_FIFOFULL  0xf21e0008
#define FSTV091X_P2_LOCKTIME_MODE  0xf21e0007

/*P2_DMDCFG4*/
#define RSTV091X_P2_DMDCFG4  0xf21f
#define FSTV091X_P2_DIS_VITLOCK  0xf21f0080
#define FSTV091X_P2_S1S2TOUT_FAST  0xf21f0040
#define FSTV091X_P2_DEMOD_FASTLOCK  0xf21f0020
#define FSTV091X_P2_S1HIER_ENABLE  0xf21f0010
#define FSTV091X_P2_TUNER_NRELAUNCH  0xf21f0008
#define FSTV091X_P2_DIS_CLKENABLE  0xf21f0004
#define FSTV091X_P2_DIS_HDRDIVLOCK  0xf21f0002
#define FSTV091X_P2_NO_TNRWBINIT  0xf21f0001

/*P2_CORRELMANT*/
#define RSTV091X_P2_CORRELMANT  0xf220
#define FSTV091X_P2_CORREL_MANT  0xf22000ff

/*P2_CORRELABS*/
#define RSTV091X_P2_CORRELABS  0xf221
#define FSTV091X_P2_CORREL_ABS  0xf22100ff

/*P2_CORRELEXP*/
#define RSTV091X_P2_CORRELEXP  0xf222
#define FSTV091X_P2_CORREL_ABSEXP  0xf22200f0
#define FSTV091X_P2_CORREL_EXP  0xf222000f

/*P2_PLHMODCOD*/
#define RSTV091X_P2_PLHMODCOD  0xf224
#define FSTV091X_P2_SPECINV_DEMOD  0xf2240080
#define FSTV091X_P2_PLH_MODCOD  0xf224007c
#define FSTV091X_P2_PLH_TYPE  0xf2240003

/*P2_DMDREG*/
#define RSTV091X_P2_DMDREG  0xf225
#define FSTV091X_P2_EXTPSK_MODE  0xf2250080
#define FSTV091X_P2_HIER_SHORTFRAME  0xf2250002
#define FSTV091X_P2_DECIM_PLFRAMES  0xf2250001

/*P2_AGC2O*/
#define RSTV091X_P2_AGC2O  0xf22c
#define FSTV091X_P2_CSTENV_MODE  0xf22c00c0
#define FSTV091X_P2_AGC2_LKSQRT  0xf22c0020
#define FSTV091X_P2_AGC2_LKMODE  0xf22c0010
#define FSTV091X_P2_AGC2_LKEQUA  0xf22c0008
#define FSTV091X_P2_AGC2_COEF  0xf22c0007

/*P2_AGC2REF*/
#define RSTV091X_P2_AGC2REF  0xf22d
#define FSTV091X_P2_AGC2_REF  0xf22d00ff

/*P2_AGC1ADJ*/
#define RSTV091X_P2_AGC1ADJ  0xf22e
#define FSTV091X_P2_AGC1ADJ_MANUAL  0xf22e0080
#define FSTV091X_P2_AGC1_ADJUSTED  0xf22e007f

/*P2_AGC2I1*/
#define RSTV091X_P2_AGC2I1  0xf236
#define FSTV091X_P2_AGC2_INTEGRATOR1  0xf23600ff

/*P2_AGC2I0*/
#define RSTV091X_P2_AGC2I0  0xf237
#define FSTV091X_P2_AGC2_INTEGRATOR0  0xf23700ff

/*P2_CARCFG*/
#define RSTV091X_P2_CARCFG  0xf238
#define FSTV091X_P2_CFRUPLOW_AUTO  0xf2380080
#define FSTV091X_P2_CFRUPLOW_TEST  0xf2380040
#define FSTV091X_P2_WIDE_FREQDET  0xf2380020
#define FSTV091X_P2_CARHDR_NODIV8  0xf2380010
#define FSTV091X_P2_I2C_ROTA  0xf2380008
#define FSTV091X_P2_ROTAON  0xf2380004
#define FSTV091X_P2_PH_DET_ALGO  0xf2380003

/*P2_ACLC*/
#define RSTV091X_P2_ACLC  0xf239
#define FSTV091X_P2_CARS1_ANOSAUTO  0xf2390040
#define FSTV091X_P2_CAR_ALPHA_MANT  0xf2390030
#define FSTV091X_P2_CAR_ALPHA_EXP  0xf239000f

/*P2_BCLC*/
#define RSTV091X_P2_BCLC  0xf23a
#define FSTV091X_P2_CARS1_BNOSAUTO  0xf23a0040
#define FSTV091X_P2_CAR_BETA_MANT  0xf23a0030
#define FSTV091X_P2_CAR_BETA_EXP  0xf23a000f

/*P2_CARFREQ*/
#define RSTV091X_P2_CARFREQ  0xf23d
#define FSTV091X_P2_KC_COARSE_EXP  0xf23d00f0
#define FSTV091X_P2_BETA_FREQ  0xf23d000f

/*P2_CARHDR*/
#define RSTV091X_P2_CARHDR  0xf23e
#define FSTV091X_P2_K_FREQ_HDR  0xf23e00ff

/*P2_LDT*/
#define RSTV091X_P2_LDT  0xf23f
#define FSTV091X_P2_CARLOCK_THRES  0xf23f01ff

/*P2_LDT2*/
#define RSTV091X_P2_LDT2  0xf240
#define FSTV091X_P2_CARLOCK_THRES2  0xf24001ff

/*P2_CFRICFG*/
#define RSTV091X_P2_CFRICFG  0xf241
#define FSTV091X_P2_CFRINIT_UNVALRNG  0xf2410080
#define FSTV091X_P2_CFRINIT_LUNVALCPT  0xf2410040
#define FSTV091X_P2_CFRINIT_ABORTDBL  0xf2410020
#define FSTV091X_P2_CFRINIT_ABORTPRED  0xf2410010
#define FSTV091X_P2_CFRINIT_UNVALSKIP  0xf2410008
#define FSTV091X_P2_CFRINIT_CSTINC  0xf2410004
#define FSTV091X_P2_CFRIROLL_GARDER  0xf2410002
#define FSTV091X_P2_NEG_CFRSTEP  0xf2410001

/*P2_CFRUP1*/
#define RSTV091X_P2_CFRUP1  0xf242
#define FSTV091X_P2_CFR_UP1  0xf24201ff

/*P2_CFRUP0*/
#define RSTV091X_P2_CFRUP0  0xf243
#define FSTV091X_P2_CFR_UP0  0xf24300ff

/*P2_CFRIBASE1*/
#define RSTV091X_P2_CFRIBASE1  0xf244
#define FSTV091X_P2_CFRINIT_BASE1  0xf24400ff

/*P2_CFRIBASE0*/
#define RSTV091X_P2_CFRIBASE0  0xf245
#define FSTV091X_P2_CFRINIT_BASE0  0xf24500ff

/*P2_CFRLOW1*/
#define RSTV091X_P2_CFRLOW1  0xf246
#define FSTV091X_P2_CFR_LOW1  0xf24601ff

/*P2_CFRLOW0*/
#define RSTV091X_P2_CFRLOW0  0xf247
#define FSTV091X_P2_CFR_LOW0  0xf24700ff

/*P2_CFRINIT1*/
#define RSTV091X_P2_CFRINIT1  0xf248
#define FSTV091X_P2_CFR_INIT1  0xf24801ff

/*P2_CFRINIT0*/
#define RSTV091X_P2_CFRINIT0  0xf249
#define FSTV091X_P2_CFR_INIT0  0xf24900ff

/*P2_CFRINC1*/
#define RSTV091X_P2_CFRINC1  0xf24a
#define FSTV091X_P2_MANUAL_CFRINC  0xf24a0080
#define FSTV091X_P2_CFR_INC1  0xf24a003f

/*P2_CFRINC0*/
#define RSTV091X_P2_CFRINC0  0xf24b
#define FSTV091X_P2_CFR_INC0  0xf24b00ff

/*P2_CFR2*/
#define RSTV091X_P2_CFR2  0xf24c
#define FSTV091X_P2_CAR_FREQ2  0xf24c01ff

/*P2_CFR1*/
#define RSTV091X_P2_CFR1  0xf24d
#define FSTV091X_P2_CAR_FREQ1  0xf24d00ff

/*P2_CFR0*/
#define RSTV091X_P2_CFR0  0xf24e
#define FSTV091X_P2_CAR_FREQ0  0xf24e00ff

/*P2_LDI*/
#define RSTV091X_P2_LDI  0xf24f
#define FSTV091X_P2_LOCK_DET_INTEGR  0xf24f01ff

/*P2_TMGCFG*/
#define RSTV091X_P2_TMGCFG  0xf250
#define FSTV091X_P2_TMGLOCK_BETA  0xf25000c0
#define FSTV091X_P2_DO_TIMING_CORR  0xf2500010
#define FSTV091X_P2_MANUAL_SCAN  0xf250000c
#define FSTV091X_P2_TMG_MINFREQ  0xf2500003

/*P2_RTC*/
#define RSTV091X_P2_RTC  0xf251
#define FSTV091X_P2_TMGALPHA_EXP  0xf25100f0
#define FSTV091X_P2_TMGBETA_EXP  0xf251000f

/*P2_RTCS2*/
#define RSTV091X_P2_RTCS2  0xf252
#define FSTV091X_P2_TMGALPHAS2_EXP  0xf25200f0
#define FSTV091X_P2_TMGBETAS2_EXP  0xf252000f

/*P2_TMGTHRISE*/
#define RSTV091X_P2_TMGTHRISE  0xf253
#define FSTV091X_P2_TMGLOCK_THRISE  0xf25300ff

/*P2_TMGTHFALL*/
#define RSTV091X_P2_TMGTHFALL  0xf254
#define FSTV091X_P2_TMGLOCK_THFALL  0xf25400ff

/*P2_SFRUPRATIO*/
#define RSTV091X_P2_SFRUPRATIO  0xf255
#define FSTV091X_P2_SFR_UPRATIO  0xf25500ff

/*P2_SFRLOWRATIO*/
#define RSTV091X_P2_SFRLOWRATIO  0xf256
#define FSTV091X_P2_SFR_LOWRATIO  0xf25600ff

/*P2_KTTMG*/
#define RSTV091X_P2_KTTMG  0xf257
#define FSTV091X_P2_KT_TMG_EXP  0xf25700f0

/*P2_KREFTMG*/
#define RSTV091X_P2_KREFTMG  0xf258
#define FSTV091X_P2_KREF_TMG  0xf25800ff

/*P2_SFRSTEP*/
#define RSTV091X_P2_SFRSTEP  0xf259
#define FSTV091X_P2_SFR_SCANSTEP  0xf25900f0
#define FSTV091X_P2_SFR_CENTERSTEP  0xf259000f

/*P2_TMGCFG2*/
#define RSTV091X_P2_TMGCFG2  0xf25a
#define FSTV091X_P2_KREFTMG2_DECMODE  0xf25a00c0
#define FSTV091X_P2_DIS_AUTOSAMP  0xf25a0008
#define FSTV091X_P2_SCANINIT_QUART  0xf25a0004
#define FSTV091X_P2_NOTMG_DVBS1DERAT  0xf25a0002
#define FSTV091X_P2_SFRRATIO_FINE  0xf25a0001

/*P2_KREFTMG2*/
#define RSTV091X_P2_KREFTMG2  0xf25b
#define FSTV091X_P2_KREF_TMG2  0xf25b00ff

/*P2_TMGCFG3*/
#define RSTV091X_P2_TMGCFG3  0xf25d
#define FSTV091X_P2_CFRINC_MODE  0xf25d0070
#define FSTV091X_P2_CONT_TMGCENTER  0xf25d0008
#define FSTV091X_P2_AUTO_GUP  0xf25d0004
#define FSTV091X_P2_AUTO_GLOW  0xf25d0002
#define FSTV091X_P2_SFRVAL_MINMODE  0xf25d0001

/*P2_SFRINIT1*/
#define RSTV091X_P2_SFRINIT1  0xf25e
#define FSTV091X_P2_SFR_INIT1  0xf25e00ff

/*P2_SFRINIT0*/
#define RSTV091X_P2_SFRINIT0  0xf25f
#define FSTV091X_P2_SFR_INIT0  0xf25f00ff

/*P2_SFRUP1*/
#define RSTV091X_P2_SFRUP1  0xf260
#define FSTV091X_P2_SYMB_FREQ_UP1  0xf26000ff

/*P2_SFRUP0*/
#define RSTV091X_P2_SFRUP0  0xf261
#define FSTV091X_P2_SYMB_FREQ_UP0  0xf26100ff

/*P2_SFRLOW1*/
#define RSTV091X_P2_SFRLOW1  0xf262
#define FSTV091X_P2_SYMB_FREQ_LOW1  0xf26200ff

/*P2_SFRLOW0*/
#define RSTV091X_P2_SFRLOW0  0xf263
#define FSTV091X_P2_SYMB_FREQ_LOW0  0xf26300ff

/*P2_SFR3*/
#define RSTV091X_P2_SFR3  0xf264
#define FSTV091X_P2_SYMB_FREQ3  0xf26400ff

/*P2_SFR2*/
#define RSTV091X_P2_SFR2  0xf265
#define FSTV091X_P2_SYMB_FREQ2  0xf26500ff

/*P2_SFR1*/
#define RSTV091X_P2_SFR1  0xf266
#define FSTV091X_P2_SYMB_FREQ1  0xf26600ff

/*P2_SFR0*/
#define RSTV091X_P2_SFR0  0xf267
#define FSTV091X_P2_SYMB_FREQ0  0xf26700ff

/*P2_TMGREG2*/
#define RSTV091X_P2_TMGREG2  0xf268
#define FSTV091X_P2_TMGREG2  0xf26800ff

/*P2_TMGREG1*/
#define RSTV091X_P2_TMGREG1  0xf269
#define FSTV091X_P2_TMGREG1  0xf26900ff

/*P2_TMGREG0*/
#define RSTV091X_P2_TMGREG0  0xf26a
#define FSTV091X_P2_TMGREG0  0xf26a00ff

/*P2_TMGLOCK1*/
#define RSTV091X_P2_TMGLOCK1  0xf26b
#define FSTV091X_P2_TMGLOCK_LEVEL1  0xf26b01ff

/*P2_TMGLOCK0*/
#define RSTV091X_P2_TMGLOCK0  0xf26c
#define FSTV091X_P2_TMGLOCK_LEVEL0  0xf26c00ff

/*P2_TMGOBS*/
#define RSTV091X_P2_TMGOBS  0xf26d
#define FSTV091X_P2_ROLLOFF_STATUS  0xf26d00c0
#define FSTV091X_P2_SCAN_SIGN  0xf26d0030
#define FSTV091X_P2_TMG_SCANNING  0xf26d0008
#define FSTV091X_P2_CHCENTERING_MODE  0xf26d0004
#define FSTV091X_P2_TMG_SCANFAIL  0xf26d0002

/*P2_EQUALCFG*/
#define RSTV091X_P2_EQUALCFG  0xf26f
#define FSTV091X_P2_NOTMG_NEGALWAIT  0xf26f0080
#define FSTV091X_P2_EQUAL_ON  0xf26f0040
#define FSTV091X_P2_SEL_EQUALCOR  0xf26f0038
#define FSTV091X_P2_MU_EQUALDFE  0xf26f0007

/*P2_EQUAI1*/
#define RSTV091X_P2_EQUAI1  0xf270
#define FSTV091X_P2_EQUA_ACCI1  0xf27001ff

/*P2_EQUAQ1*/
#define RSTV091X_P2_EQUAQ1  0xf271
#define FSTV091X_P2_EQUA_ACCQ1  0xf27101ff

/*P2_EQUAI2*/
#define RSTV091X_P2_EQUAI2  0xf272
#define FSTV091X_P2_EQUA_ACCI2  0xf27201ff

/*P2_EQUAQ2*/
#define RSTV091X_P2_EQUAQ2  0xf273
#define FSTV091X_P2_EQUA_ACCQ2  0xf27301ff

/*P2_EQUAI3*/
#define RSTV091X_P2_EQUAI3  0xf274
#define FSTV091X_P2_EQUA_ACCI3  0xf27401ff

/*P2_EQUAQ3*/
#define RSTV091X_P2_EQUAQ3  0xf275
#define FSTV091X_P2_EQUA_ACCQ3  0xf27501ff

/*P2_EQUAI4*/
#define RSTV091X_P2_EQUAI4  0xf276
#define FSTV091X_P2_EQUA_ACCI4  0xf27601ff

/*P2_EQUAQ4*/
#define RSTV091X_P2_EQUAQ4  0xf277
#define FSTV091X_P2_EQUA_ACCQ4  0xf27701ff

/*P2_EQUAI5*/
#define RSTV091X_P2_EQUAI5  0xf278
#define FSTV091X_P2_EQUA_ACCI5  0xf27801ff

/*P2_EQUAQ5*/
#define RSTV091X_P2_EQUAQ5  0xf279
#define FSTV091X_P2_EQUA_ACCQ5  0xf27901ff

/*P2_EQUAI6*/
#define RSTV091X_P2_EQUAI6  0xf27a
#define FSTV091X_P2_EQUA_ACCI6  0xf27a01ff

/*P2_EQUAQ6*/
#define RSTV091X_P2_EQUAQ6  0xf27b
#define FSTV091X_P2_EQUA_ACCQ6  0xf27b01ff

/*P2_EQUAI7*/
#define RSTV091X_P2_EQUAI7  0xf27c
#define FSTV091X_P2_EQUA_ACCI7  0xf27c01ff

/*P2_EQUAQ7*/
#define RSTV091X_P2_EQUAQ7  0xf27d
#define FSTV091X_P2_EQUA_ACCQ7  0xf27d01ff

/*P2_EQUAI8*/
#define RSTV091X_P2_EQUAI8  0xf27e
#define FSTV091X_P2_EQUA_ACCI8  0xf27e01ff

/*P2_EQUAQ8*/
#define RSTV091X_P2_EQUAQ8  0xf27f
#define FSTV091X_P2_EQUA_ACCQ8  0xf27f01ff

/*P2_NNOSDATAT1*/
#define RSTV091X_P2_NNOSDATAT1  0xf280
#define FSTV091X_P2_NOSDATAT_NORMED1  0xf28000ff

/*P2_NNOSDATAT0*/
#define RSTV091X_P2_NNOSDATAT0  0xf281
#define FSTV091X_P2_NOSDATAT_NORMED0  0xf28100ff

/*P2_NNOSDATA1*/
#define RSTV091X_P2_NNOSDATA1  0xf282
#define FSTV091X_P2_NOSDATA_NORMED1  0xf28200ff

/*P2_NNOSDATA0*/
#define RSTV091X_P2_NNOSDATA0  0xf283
#define FSTV091X_P2_NOSDATA_NORMED0  0xf28300ff

/*P2_NNOSPLHT1*/
#define RSTV091X_P2_NNOSPLHT1  0xf284
#define FSTV091X_P2_NOSPLHT_NORMED1  0xf28400ff

/*P2_NNOSPLHT0*/
#define RSTV091X_P2_NNOSPLHT0  0xf285
#define FSTV091X_P2_NOSPLHT_NORMED0  0xf28500ff

/*P2_NNOSPLH1*/
#define RSTV091X_P2_NNOSPLH1  0xf286
#define FSTV091X_P2_NOSPLH_NORMED1  0xf28600ff

/*P2_NNOSPLH0*/
#define RSTV091X_P2_NNOSPLH0  0xf287
#define FSTV091X_P2_NOSPLH_NORMED0  0xf28700ff

/*P2_NOSDATAT1*/
#define RSTV091X_P2_NOSDATAT1  0xf288
#define FSTV091X_P2_NOSDATAT_UNNORMED1  0xf28800ff

/*P2_NOSDATAT0*/
#define RSTV091X_P2_NOSDATAT0  0xf289
#define FSTV091X_P2_NOSDATAT_UNNORMED0  0xf28900ff

/*P2_NNOSFRAME1*/
#define RSTV091X_P2_NNOSFRAME1  0xf28a
#define FSTV091X_P2_NOSFRAME_NORMED1  0xf28a00ff

/*P2_NNOSFRAME0*/
#define RSTV091X_P2_NNOSFRAME0  0xf28b
#define FSTV091X_P2_NOSFRAME_NORMED0  0xf28b00ff

/*P2_NNOSRAD1*/
#define RSTV091X_P2_NNOSRAD1  0xf28c
#define FSTV091X_P2_NOSRADIAL_NORMED1  0xf28c00ff

/*P2_NNOSRAD0*/
#define RSTV091X_P2_NNOSRAD0  0xf28d
#define FSTV091X_P2_NOSRADIAL_NORMED0  0xf28d00ff

/*P2_NOSCFGF1*/
#define RSTV091X_P2_NOSCFGF1  0xf28e
#define FSTV091X_P2_LOWNOISE_MESURE  0xf28e0080
#define FSTV091X_P2_NOS_DELFRAME  0xf28e0040
#define FSTV091X_P2_NOSDATA_MODE  0xf28e0030
#define FSTV091X_P2_FRAMESEL_TYPESEL  0xf28e000c
#define FSTV091X_P2_FRAMESEL_TYPE  0xf28e0003

/*P2_CAR2CFG*/
#define RSTV091X_P2_CAR2CFG  0xf290
#define FSTV091X_P2_DESCRAMB_OFF  0xf2900080
#define FSTV091X_P2_EN_PHNOSRAM  0xf2900020
#define FSTV091X_P2_STOP_CFR2UPDATE  0xf2900010
#define FSTV091X_P2_STOP_NCO2UPDATE  0xf2900008
#define FSTV091X_P2_ROTA2ON  0xf2900004
#define FSTV091X_P2_PH_DET_ALGO2  0xf2900003

/*P2_CFR2CFR1*/
#define RSTV091X_P2_CFR2CFR1  0xf291
#define FSTV091X_P2_CFR2_S2CONTROL  0xf29100c0
#define FSTV091X_P2_EN_S2CAR2CENTER  0xf2910020
#define FSTV091X_P2_BCHERRCFR2_MODE  0xf2910018
#define FSTV091X_P2_CFR2TOCFR1_BETA  0xf2910007

/*P2_CAR3CFG*/
#define RSTV091X_P2_CAR3CFG  0xf292
#define FSTV091X_P2_CARRIER23_MODE  0xf29200c0
#define FSTV091X_P2_CAR3INTERM_DVBS1  0xf2920020
#define FSTV091X_P2_ABAMPLIF_MODE  0xf2920018
#define FSTV091X_P2_CARRIER3_ALPHA3DL  0xf2920007

/*P2_CFR22*/
#define RSTV091X_P2_CFR22  0xf293
#define FSTV091X_P2_CAR2_FREQ2  0xf29301ff

/*P2_CFR21*/
#define RSTV091X_P2_CFR21  0xf294
#define FSTV091X_P2_CAR2_FREQ1  0xf29400ff

/*P2_CFR20*/
#define RSTV091X_P2_CFR20  0xf295
#define FSTV091X_P2_CAR2_FREQ0  0xf29500ff

/*P2_ACLC2S2Q*/
#define RSTV091X_P2_ACLC2S2Q  0xf297
#define FSTV091X_P2_ENAB_SPSKSYMB  0xf2970080
#define FSTV091X_P2_CAR2S2_QANOSAUTO  0xf2970040
#define FSTV091X_P2_CAR2S2_Q_ALPH_M  0xf2970030
#define FSTV091X_P2_CAR2S2_Q_ALPH_E  0xf297000f

/*P2_ACLC2S28*/
#define RSTV091X_P2_ACLC2S28  0xf298
#define FSTV091X_P2_OLDI3Q_MODE  0xf2980080
#define FSTV091X_P2_CAR2S2_8ANOSAUTO  0xf2980040
#define FSTV091X_P2_CAR2S2_8_ALPH_M  0xf2980030
#define FSTV091X_P2_CAR2S2_8_ALPH_E  0xf298000f

/*P2_ACLC2S216A*/
#define RSTV091X_P2_ACLC2S216A  0xf299
#define FSTV091X_P2_CAR2S2_16ANOSAUTO  0xf2990040
#define FSTV091X_P2_CAR2S2_16A_ALPH_M  0xf2990030
#define FSTV091X_P2_CAR2S2_16A_ALPH_E  0xf299000f

/*P2_ACLC2S232A*/
#define RSTV091X_P2_ACLC2S232A  0xf29a
#define FSTV091X_P2_CAR2S2_32ANOSUATO  0xf29a0040
#define FSTV091X_P2_CAR2S2_32A_ALPH_M  0xf29a0030
#define FSTV091X_P2_CAR2S2_32A_ALPH_E  0xf29a000f

/*P2_BCLC2S2Q*/
#define RSTV091X_P2_BCLC2S2Q  0xf29c
#define FSTV091X_P2_DVBS2S2Q_NIP  0xf29c0080
#define FSTV091X_P2_CAR2S2_QBNOSAUTO  0xf29c0040
#define FSTV091X_P2_CAR2S2_Q_BETA_M  0xf29c0030
#define FSTV091X_P2_CAR2S2_Q_BETA_E  0xf29c000f

/*P2_BCLC2S28*/
#define RSTV091X_P2_BCLC2S28  0xf29d
#define FSTV091X_P2_DVBS2S28_NIP  0xf29d0080
#define FSTV091X_P2_CAR2S2_8BNOSAUTO  0xf29d0040
#define FSTV091X_P2_CAR2S2_8_BETA_M  0xf29d0030
#define FSTV091X_P2_CAR2S2_8_BETA_E  0xf29d000f

/* P2_BCLC2S216A */
#define RSTV091X_P2_BCLC2S216A  0xf29e
#define FSTV091X_P2_DVBS2S216A_NIP  0xf29e0080
#define FSTV091X_P2_CAR2S2_16A_BETA_M  0xf29e0030
#define FSTV091X_P2_CAR2S2_16A_BETA_E  0xf29e000f

/* P2_BCLC2S232A */
#define RSTV091X_P2_BCLC2S232A  0xf29f
#define FSTV091X_P2_DVBS2S232A_NIP  0xf29f0080
#define FSTV091X_P2_CAR2S2_32A_BETA_M  0xf29f0030
#define FSTV091X_P2_CAR2S2_32A_BETA_E  0xf29f000f

/*P2_PLROOT2*/
#define RSTV091X_P2_PLROOT2  0xf2ac
#define FSTV091X_P2_PLHAUTO_DISPLH  0xf2ac0040
#define FSTV091X_P2_PLHAUTO_FASTMODE  0xf2ac0020
#define FSTV091X_P2_PLHAUTO_ENABLE  0xf2ac0010
#define FSTV091X_P2_PLSCRAMB_MODE  0xf2ac000c
#define FSTV091X_P2_PLSCRAMB_ROOT2  0xf2ac0003

/*P2_PLROOT1*/
#define RSTV091X_P2_PLROOT1  0xf2ad
#define FSTV091X_P2_PLSCRAMB_ROOT1  0xf2ad00ff

/*P2_PLROOT0*/
#define RSTV091X_P2_PLROOT0  0xf2ae
#define FSTV091X_P2_PLSCRAMB_ROOT0  0xf2ae00ff

/*P2_MODCODLST7*/
#define RSTV091X_P2_MODCODLST7  0xf2b7
#define FSTV091X_P2_MODCOD_NNOSFILTER  0xf2b70080
#define FSTV091X_P2_MODCODLST_NOSTYPE  0xf2b70040
#define FSTV091X_P2_DIS_8PSK_9_10  0xf2b70030
#define FSTV091X_P2_DIS_8P_8_9  0xf2b7000f

/*P2_MODCODLST8*/
#define RSTV091X_P2_MODCODLST8  0xf2b8
#define FSTV091X_P2_DIS_8P_5_6  0xf2b800f0
#define FSTV091X_P2_DIS_8P_3_4  0xf2b8000f

/*P2_MODCODLST9*/
#define RSTV091X_P2_MODCODLST9  0xf2b9
#define FSTV091X_P2_DIS_8P_2_3  0xf2b900f0
#define FSTV091X_P2_DIS_8P_3_5  0xf2b9000f

/*P2_MODCODLSTA*/
#define RSTV091X_P2_MODCODLSTA  0xf2ba
#define FSTV091X_P2_NOSFILTER_LIMITE  0xf2ba0080
#define FSTV091X_P2_NOSFILTER_MODE  0xf2ba0040
#define FSTV091X_P2_DIS_QPSK_9_10  0xf2ba0030
#define FSTV091X_P2_DIS_QP_8_9  0xf2ba000f

/*P2_MODCODLSTB*/
#define RSTV091X_P2_MODCODLSTB  0xf2bb
#define FSTV091X_P2_DIS_QP_5_6  0xf2bb00f0
#define FSTV091X_P2_DIS_QP_4_5  0xf2bb000f

/*P2_MODCODLSTC*/
#define RSTV091X_P2_MODCODLSTC  0xf2bc
#define FSTV091X_P2_DIS_QP_3_4  0xf2bc00f0
#define FSTV091X_P2_DIS_QP_2_3  0xf2bc000f

/*P2_MODCODLSTD*/
#define RSTV091X_P2_MODCODLSTD  0xf2bd
#define FSTV091X_P2_DIS_QPSK_3_5  0xf2bd00f0
#define FSTV091X_P2_DIS_QPSK_1_2  0xf2bd000f

/*P2_GAUSSR0*/
#define RSTV091X_P2_GAUSSR0  0xf2c0
#define FSTV091X_P2_EN_CCIMODE  0xf2c00080
#define FSTV091X_P2_R0_GAUSSIEN  0xf2c0007f

/*P2_CCIR0*/
#define RSTV091X_P2_CCIR0  0xf2c1
#define FSTV091X_P2_CCIDETECT_PLHONLY  0xf2c10080
#define FSTV091X_P2_R0_CCI  0xf2c1007f

/*P2_CCIQUANT*/
#define RSTV091X_P2_CCIQUANT  0xf2c2
#define FSTV091X_P2_CCI_BETA  0xf2c200e0
#define FSTV091X_P2_CCI_QUANT  0xf2c2001f

/*P2_CCITHRES*/
#define RSTV091X_P2_CCITHRES  0xf2c3
#define FSTV091X_P2_CCI_THRESHOLD  0xf2c300ff

/*P2_CCIACC*/
#define RSTV091X_P2_CCIACC  0xf2c4
#define FSTV091X_P2_CCI_VALUE  0xf2c400ff

/*P2_DSTATUS4*/
#define RSTV091X_P2_DSTATUS4  0xf2c5
#define FSTV091X_P2_RAINFADE_DETECT  0xf2c50080
#define FSTV091X_P2_NOTHRES2_FAIL  0xf2c50040
#define FSTV091X_P2_NOTHRES1_FAIL  0xf2c50020
#define FSTV091X_P2_PILOT_FAILDETECT  0xf2c50010
#define FSTV091X_P2_HIER_DETECT  0xf2c50008
#define FSTV091X_P2_DMDPROG_ERROR  0xf2c50004
#define FSTV091X_P2_CSTENV_DETECT  0xf2c50002
#define FSTV091X_P2_DETECTION_TRIAX  0xf2c50001

/*P2_DMDRESCFG*/
#define RSTV091X_P2_DMDRESCFG  0xf2c6
#define FSTV091X_P2_DMDRES_RESET  0xf2c60080
#define FSTV091X_P2_DMDRES_NOISESQR  0xf2c60010
#define FSTV091X_P2_DMDRES_STRALL  0xf2c60008
#define FSTV091X_P2_DMDRES_NEWONLY  0xf2c60004
#define FSTV091X_P2_DMDRES_NOSTORE  0xf2c60002
#define FSTV091X_P2_DMDRES_AGC2MEM  0xf2c60001

/*P2_DMDRESADR*/
#define RSTV091X_P2_DMDRESADR  0xf2c7
#define FSTV091X_P2_SUSP_PREDCANAL  0xf2c70080
#define FSTV091X_P2_DMDRES_VALIDCFR  0xf2c70040
#define FSTV091X_P2_DMDRES_MEMFULL  0xf2c70030
#define FSTV091X_P2_DMDRES_RESNBR  0xf2c7000f

/*P2_DMDRESDATA7*/
#define RSTV091X_P2_DMDRESDATA7  0xf2c8
#define FSTV091X_P2_DMDRES_DATA7  0xf2c800ff

/*P2_DMDRESDATA6*/
#define RSTV091X_P2_DMDRESDATA6  0xf2c9
#define FSTV091X_P2_DMDRES_DATA6  0xf2c900ff

/*P2_DMDRESDATA5*/
#define RSTV091X_P2_DMDRESDATA5  0xf2ca
#define FSTV091X_P2_DMDRES_DATA5  0xf2ca00ff

/*P2_DMDRESDATA4*/
#define RSTV091X_P2_DMDRESDATA4  0xf2cb
#define FSTV091X_P2_DMDRES_DATA4  0xf2cb00ff

/*P2_DMDRESDATA3*/
#define RSTV091X_P2_DMDRESDATA3  0xf2cc
#define FSTV091X_P2_DMDRES_DATA3  0xf2cc00ff

/*P2_DMDRESDATA2*/
#define RSTV091X_P2_DMDRESDATA2  0xf2cd
#define FSTV091X_P2_DMDRES_DATA2  0xf2cd00ff

/*P2_DMDRESDATA1*/
#define RSTV091X_P2_DMDRESDATA1  0xf2ce
#define FSTV091X_P2_DMDRES_DATA1  0xf2ce00ff

/*P2_DMDRESDATA0*/
#define RSTV091X_P2_DMDRESDATA0  0xf2cf
#define FSTV091X_P2_DMDRES_DATA0  0xf2cf00ff

/*P2_FFEI1*/
#define RSTV091X_P2_FFEI1  0xf2d0
#define FSTV091X_P2_FFE_ACCI1  0xf2d001ff

/*P2_FFEQ1*/
#define RSTV091X_P2_FFEQ1  0xf2d1
#define FSTV091X_P2_FFE_ACCQ1  0xf2d101ff

/*P2_FFEI2*/
#define RSTV091X_P2_FFEI2  0xf2d2
#define FSTV091X_P2_FFE_ACCI2  0xf2d201ff

/*P2_FFEQ2*/
#define RSTV091X_P2_FFEQ2  0xf2d3
#define FSTV091X_P2_FFE_ACCQ2  0xf2d301ff

/*P2_FFEI3*/
#define RSTV091X_P2_FFEI3  0xf2d4
#define FSTV091X_P2_FFE_ACCI3  0xf2d401ff

/*P2_FFEQ3*/
#define RSTV091X_P2_FFEQ3  0xf2d5
#define FSTV091X_P2_FFE_ACCQ3  0xf2d501ff

/*P2_FFEI4*/
#define RSTV091X_P2_FFEI4  0xf2d6
#define FSTV091X_P2_FFE_ACCI4  0xf2d601ff

/*P2_FFEQ4*/
#define RSTV091X_P2_FFEQ4  0xf2d7
#define FSTV091X_P2_FFE_ACCQ4  0xf2d701ff

/*P2_FFECFG*/
#define RSTV091X_P2_FFECFG  0xf2d8
#define FSTV091X_P2_EQUALFFE_ON  0xf2d80040
#define FSTV091X_P2_EQUAL_USEDSYMB  0xf2d80030
#define FSTV091X_P2_MU_EQUALFFE  0xf2d80007

/*P2_TNRCFG2*/
#define RSTV091X_P2_TNRCFG2  0xf2e1
#define FSTV091X_P2_TUN_IQSWAP  0xf2e10080
#define FSTV091X_P2_STB6110_STEP2MHZ  0xf2e10040
#define FSTV091X_P2_STB6120_DBLI2C  0xf2e10020
#define FSTV091X_P2_TUNER_WIDEBAND  0xf2e10010
#define FSTV091X_P2_TUNER_OBSPAGE  0xf2e10008
#define FSTV091X_P2_DIS_BWCALC  0xf2e10004
#define FSTV091X_P2_SHORT_WAITSTATES  0xf2e10002
#define FSTV091X_P2_DIS_2BWAGC1  0xf2e10001

/*P2_SMAPCOEF7*/
#define RSTV091X_P2_SMAPCOEF7  0xf300
#define FSTV091X_P2_DIS_QSCALE  0xf3000080
#define FSTV091X_P2_SMAPCOEF_Q_LLR12  0xf300017f

/*P2_SMAPCOEF6*/
#define RSTV091X_P2_SMAPCOEF6  0xf301
#define FSTV091X_P2_DIS_AGC2SCALE  0xf3010080
#define FSTV091X_P2_DIS_16IQMULT  0xf3010040
#define FSTV091X_P2_OLD_16APSK47  0xf3010020
#define FSTV091X_P2_OLD_16APSK12  0xf3010010
#define FSTV091X_P2_DIS_NEWSCALE  0xf3010008
#define FSTV091X_P2_ADJ_8PSKLLR1  0xf3010004
#define FSTV091X_P2_OLD_8PSKLLR1  0xf3010002
#define FSTV091X_P2_DIS_AB8PSK  0xf3010001

/*P2_SMAPCOEF5*/
#define RSTV091X_P2_SMAPCOEF5  0xf302
#define FSTV091X_P2_DIS_8SCALE  0xf3020080
#define FSTV091X_P2_SMAPCOEF_8P_LLR23  0xf302017f

/*P2_NOSTHRES1*/
#define RSTV091X_P2_NOSTHRES1  0xf309
#define FSTV091X_P2_NOS_THRESHOLD1  0xf30900ff

/*P2_NOSTHRES2*/
#define RSTV091X_P2_NOSTHRES2  0xf30a
#define FSTV091X_P2_NOS_THRESHOLD2  0xf30a00ff

/*P2_NOSDIFF1*/
#define RSTV091X_P2_NOSDIFF1  0xf30b
#define FSTV091X_P2_NOSTHRES1_DIFF  0xf30b00ff

/*P2_RAINFADE*/
#define RSTV091X_P2_RAINFADE  0xf30c
#define FSTV091X_P2_NOSTHRES_DATAT  0xf30c0080
#define FSTV091X_P2_RAINFADE_CNLIMIT  0xf30c0070
#define FSTV091X_P2_RAINFADE_TIMEOUT  0xf30c0007

/*P2_NOSRAMCFG*/
#define RSTV091X_P2_NOSRAMCFG  0xf30d
#define FSTV091X_P2_NOSRAM_DVBS2DATA  0xf30d0080
#define FSTV091X_P2_NOSRAM_QUADRAT  0xf30d0040
#define FSTV091X_P2_NOSRAM_ACTIVATION  0xf30d0030
#define FSTV091X_P2_NOSRAM_CNRONLY  0xf30d0008
#define FSTV091X_P2_NOSRAM_LGNCNR1  0xf30d0007

/*P2_NOSRAMPOS*/
#define RSTV091X_P2_NOSRAMPOS  0xf30e
#define FSTV091X_P2_NOSRAM_LGNCNR0  0xf30e00f0
#define FSTV091X_P2_NOSRAM_VALIDE  0xf30e0004
#define FSTV091X_P2_NOSRAM_CNRVAL1  0xf30e0003

/*P2_NOSRAMVAL*/
#define RSTV091X_P2_NOSRAMVAL  0xf30f
#define FSTV091X_P2_NOSRAM_CNRVAL0  0xf30f00ff

/*P2_DMDPLHSTAT*/
#define RSTV091X_P2_DMDPLHSTAT  0xf320
#define FSTV091X_P2_PLH_STATISTIC  0xf32000ff

/*P2_LOCKTIME3*/
#define RSTV091X_P2_LOCKTIME3  0xf322
#define FSTV091X_P2_DEMOD_LOCKTIME3  0xf32200ff

/*P2_LOCKTIME2*/
#define RSTV091X_P2_LOCKTIME2  0xf323
#define FSTV091X_P2_DEMOD_LOCKTIME2  0xf32300ff

/*P2_LOCKTIME1*/
#define RSTV091X_P2_LOCKTIME1  0xf324
#define FSTV091X_P2_DEMOD_LOCKTIME1  0xf32400ff

/*P2_LOCKTIME0*/
#define RSTV091X_P2_LOCKTIME0  0xf325
#define FSTV091X_P2_DEMOD_LOCKTIME0  0xf32500ff

/*P2_VITSCALE*/
#define RSTV091X_P2_VITSCALE  0xf332
#define FSTV091X_P2_NVTH_NOSRANGE  0xf3320080
#define FSTV091X_P2_VERROR_MAXMODE  0xf3320040
#define FSTV091X_P2_KDIV_MODE  0xf3320030
#define FSTV091X_P2_NSLOWSN_LOCKED  0xf3320008
#define FSTV091X_P2_DELOCK_PRFLOSS  0xf3320004
#define FSTV091X_P2_DIS_RSFLOCK  0xf3320002

/*P2_FECM*/
#define RSTV091X_P2_FECM  0xf333
#define FSTV091X_P2_DSS_DVB  0xf3330080
#define FSTV091X_P2_DEMOD_BYPASS  0xf3330040
#define FSTV091X_P2_CMP_SLOWMODE  0xf3330020
#define FSTV091X_P2_DSS_SRCH  0xf3330010
#define FSTV091X_P2_DIFF_MODEVIT  0xf3330004
#define FSTV091X_P2_SYNCVIT  0xf3330002
#define FSTV091X_P2_IQINV  0xf3330001

/*P2_VTH12*/
#define RSTV091X_P2_VTH12  0xf334
#define FSTV091X_P2_VTH12  0xf33400ff

/*P2_VTH23*/
#define RSTV091X_P2_VTH23  0xf335
#define FSTV091X_P2_VTH23  0xf33500ff

/*P2_VTH34*/
#define RSTV091X_P2_VTH34  0xf336
#define FSTV091X_P2_VTH34  0xf33600ff

/*P2_VTH56*/
#define RSTV091X_P2_VTH56  0xf337
#define FSTV091X_P2_VTH56  0xf33700ff

/*P2_VTH67*/
#define RSTV091X_P2_VTH67  0xf338
#define FSTV091X_P2_VTH67  0xf33800ff

/*P2_VTH78*/
#define RSTV091X_P2_VTH78  0xf339
#define FSTV091X_P2_VTH78  0xf33900ff

/*P2_VITCURPUN*/
#define RSTV091X_P2_VITCURPUN  0xf33a
#define FSTV091X_P2_CYCLESLIP_VIT  0xf33a0080
#define FSTV091X_P2_VIT_ROTA180  0xf33a0040
#define FSTV091X_P2_VIT_ROTA90  0xf33a0020
#define FSTV091X_P2_VIT_CURPUN  0xf33a001f

/*P2_VERROR*/
#define RSTV091X_P2_VERROR  0xf33b
#define FSTV091X_P2_REGERR_VIT  0xf33b00ff

/*P2_PRVIT*/
#define RSTV091X_P2_PRVIT  0xf33c
#define FSTV091X_P2_DIS_VTHLOCK  0xf33c0040
#define FSTV091X_P2_E7_8VIT  0xf33c0020
#define FSTV091X_P2_E6_7VIT  0xf33c0010
#define FSTV091X_P2_E5_6VIT  0xf33c0008
#define FSTV091X_P2_E3_4VIT  0xf33c0004
#define FSTV091X_P2_E2_3VIT  0xf33c0002
#define FSTV091X_P2_E1_2VIT  0xf33c0001

/*P2_VAVSRVIT*/
#define RSTV091X_P2_VAVSRVIT  0xf33d
#define FSTV091X_P2_AMVIT  0xf33d0080
#define FSTV091X_P2_FROZENVIT  0xf33d0040
#define FSTV091X_P2_SNVIT  0xf33d0030
#define FSTV091X_P2_TOVVIT  0xf33d000c
#define FSTV091X_P2_HYPVIT  0xf33d0003

/*P2_VSTATUSVIT*/
#define RSTV091X_P2_VSTATUSVIT  0xf33e
#define FSTV091X_P2_VITERBI_ON  0xf33e0080
#define FSTV091X_P2_END_LOOPVIT  0xf33e0040
#define FSTV091X_P2_VITERBI_DEPRF  0xf33e0020
#define FSTV091X_P2_PRFVIT  0xf33e0010
#define FSTV091X_P2_LOCKEDVIT  0xf33e0008
#define FSTV091X_P2_VITERBI_DELOCK  0xf33e0004
#define FSTV091X_P2_VIT_DEMODSEL  0xf33e0002
#define FSTV091X_P2_VITERBI_COMPOUT  0xf33e0001

/*P2_VTHINUSE*/
#define RSTV091X_P2_VTHINUSE  0xf33f
#define FSTV091X_P2_VIT_INUSE  0xf33f00ff

/*P2_KDIV12*/
#define RSTV091X_P2_KDIV12  0xf340
#define FSTV091X_P2_KDIV12_MANUAL  0xf3400080
#define FSTV091X_P2_K_DIVIDER_12  0xf340007f

/*P2_KDIV23*/
#define RSTV091X_P2_KDIV23  0xf341
#define FSTV091X_P2_KDIV23_MANUAL  0xf3410080
#define FSTV091X_P2_K_DIVIDER_23  0xf341007f

/*P2_KDIV34*/
#define RSTV091X_P2_KDIV34  0xf342
#define FSTV091X_P2_KDIV34_MANUAL  0xf3420080
#define FSTV091X_P2_K_DIVIDER_34  0xf342007f

/*P2_KDIV56*/
#define RSTV091X_P2_KDIV56  0xf343
#define FSTV091X_P2_KDIV56_MANUAL  0xf3430080
#define FSTV091X_P2_K_DIVIDER_56  0xf343007f

/*P2_KDIV67*/
#define RSTV091X_P2_KDIV67  0xf344
#define FSTV091X_P2_KDIV67_MANUAL  0xf3440080
#define FSTV091X_P2_K_DIVIDER_67  0xf344007f

/*P2_KDIV78*/
#define RSTV091X_P2_KDIV78  0xf345
#define FSTV091X_P2_KDIV78_MANUAL  0xf3450080
#define FSTV091X_P2_K_DIVIDER_78  0xf345007f

/* P2_TSPIDFLT1 */
#define RSTV091X_P2_TSPIDFLT1  0xf346
#define FSTV091X_P2_PIDFLT_ADDR  0xf34600ff

/* P2_TSPIDFLT0 */
#define RSTV091X_P2_TSPIDFLT0  0xf347
#define FSTV091X_P2_PIDFLT_DATA  0xf34700ff

/*P2_PDELCTRL0*/
#define RSTV091X_P2_PDELCTRL0  0xf34f
#define FSTV091X_P2_ISIOBS_MODE  0xf34f0030
#define FSTV091X_P2_PDELDIS_BITWISE  0xf34f0004

/*P2_PDELCTRL1*/
#define RSTV091X_P2_PDELCTRL1  0xf350
#define FSTV091X_P2_INV_MISMASK  0xf3500080
#define FSTV091X_P2_FORCE_ACCEPTED  0xf3500040
#define FSTV091X_P2_FILTER_EN  0xf3500020
#define FSTV091X_P2_FORCE_PKTDELINUSE  0xf3500010
#define FSTV091X_P2_HYSTEN  0xf3500008
#define FSTV091X_P2_HYSTSWRST  0xf3500004
#define FSTV091X_P2_EN_MIS00  0xf3500002
#define FSTV091X_P2_ALGOSWRST  0xf3500001

/*P2_PDELCTRL2*/
#define RSTV091X_P2_PDELCTRL2  0xf351
#define FSTV091X_P2_FORCE_CONTINUOUS  0xf3510080
#define FSTV091X_P2_RESET_UPKO_COUNT  0xf3510040
#define FSTV091X_P2_USER_PKTDELIN_NB  0xf3510020
#define FSTV091X_P2_DATA_UNBBSCRAMBLED  0xf3510008
#define FSTV091X_P2_FORCE_LONGPKT  0xf3510004
#define FSTV091X_P2_FRAME_MODE  0xf3510002

/*P2_HYSTTHRESH*/
#define RSTV091X_P2_HYSTTHRESH  0xf354
#define FSTV091X_P2_DELIN_LOCKTHRES  0xf35400f0
#define FSTV091X_P2_DELIN_UNLOCKTHRES  0xf354000f

/*P2_ISIENTRY*/
#define RSTV091X_P2_ISIENTRY  0xf35e
#define FSTV091X_P2_ISI_ENTRY  0xf35e00ff

/*P2_ISIBITENA*/
#define RSTV091X_P2_ISIBITENA  0xf35f
#define FSTV091X_P2_ISI_BIT_EN  0xf35f00ff

/*P2_MATSTR1*/
#define RSTV091X_P2_MATSTR1  0xf360
#define FSTV091X_P2_MATYPE_CURRENT1  0xf36000ff

/*P2_MATSTR0*/
#define RSTV091X_P2_MATSTR0  0xf361
#define FSTV091X_P2_MATYPE_CURRENT0  0xf36100ff

/*P2_UPLSTR1*/
#define RSTV091X_P2_UPLSTR1  0xf362
#define FSTV091X_P2_UPL_CURRENT1  0xf36200ff

/*P2_UPLSTR0*/
#define RSTV091X_P2_UPLSTR0  0xf363
#define FSTV091X_P2_UPL_CURRENT0  0xf36300ff

/*P2_DFLSTR1*/
#define RSTV091X_P2_DFLSTR1  0xf364
#define FSTV091X_P2_DFL_CURRENT1  0xf36400ff

/*P2_DFLSTR0*/
#define RSTV091X_P2_DFLSTR0  0xf365
#define FSTV091X_P2_DFL_CURRENT0  0xf36500ff

/*P2_SYNCSTR*/
#define RSTV091X_P2_SYNCSTR  0xf366
#define FSTV091X_P2_SYNC_CURRENT  0xf36600ff

/*P2_SYNCDSTR1*/
#define RSTV091X_P2_SYNCDSTR1  0xf367
#define FSTV091X_P2_SYNCD_CURRENT1  0xf36700ff

/*P2_SYNCDSTR0*/
#define RSTV091X_P2_SYNCDSTR0  0xf368
#define FSTV091X_P2_SYNCD_CURRENT0  0xf36800ff

/*P2_PDELSTATUS1*/
#define RSTV091X_P2_PDELSTATUS1  0xf369
#define FSTV091X_P2_PKTDELIN_DELOCK  0xf3690080
#define FSTV091X_P2_SYNCDUPDFL_BADDFL  0xf3690040
#define FSTV091X_P2_CONTINUOUS_STREAM  0xf3690020
#define FSTV091X_P2_UNACCEPTED_STREAM  0xf3690010
#define FSTV091X_P2_BCH_ERROR_FLAG  0xf3690008
#define FSTV091X_P2_BBHCRCKO  0xf3690004
#define FSTV091X_P2_PKTDELIN_LOCK  0xf3690002
#define FSTV091X_P2_FIRST_LOCK  0xf3690001

/*P2_PDELSTATUS2*/
#define RSTV091X_P2_PDELSTATUS2  0xf36a
#define FSTV091X_P2_PKTDEL_DEMODSEL  0xf36a0080
#define FSTV091X_P2_FRAME_MODCOD  0xf36a007c
#define FSTV091X_P2_FRAME_TYPE  0xf36a0003

/*P2_BBFCRCKO1*/
#define RSTV091X_P2_BBFCRCKO1  0xf36b
#define FSTV091X_P2_BBHCRC_KOCNT1  0xf36b00ff

/*P2_BBFCRCKO0*/
#define RSTV091X_P2_BBFCRCKO0  0xf36c
#define FSTV091X_P2_BBHCRC_KOCNT0  0xf36c00ff

/*P2_UPCRCKO1*/
#define RSTV091X_P2_UPCRCKO1  0xf36d
#define FSTV091X_P2_PKTCRC_KOCNT1  0xf36d00ff

/*P2_UPCRCKO0*/
#define RSTV091X_P2_UPCRCKO0  0xf36e
#define FSTV091X_P2_PKTCRC_KOCNT0  0xf36e00ff

/*P2_PDELCTRL3*/
#define RSTV091X_P2_PDELCTRL3  0xf36f
#define FSTV091X_P2_PKTDEL_CONTFAIL  0xf36f0080
#define FSTV091X_P2_PKTDEL_ENLONGPKT  0xf36f0040
#define FSTV091X_P2_NOFIFO_BCHERR  0xf36f0020
#define FSTV091X_P2_PKTDELIN_DELACMERR  0xf36f0010
#define FSTV091X_P2_SATURATE_BBPKTKO  0xf36f0004
#define FSTV091X_P2_PKTDEL_BCHERRCONT  0xf36f0002
#define FSTV091X_P2_ETHERNET_DISFCS  0xf36f0001

/*P2_TSSTATEM*/
#define RSTV091X_P2_TSSTATEM  0xf370
#define FSTV091X_P2_TSDIL_ON  0xf3700080
#define FSTV091X_P2_TSSKIPRS_ON  0xf3700040
#define FSTV091X_P2_TSRS_ON  0xf3700020
#define FSTV091X_P2_TSDESCRAMB_ON  0xf3700010
#define FSTV091X_P2_TSFRAME_MODE  0xf3700008
#define FSTV091X_P2_TS_DISABLE  0xf3700004
#define FSTV091X_P2_TSACM_MODE  0xf3700002
#define FSTV091X_P2_TSOUT_NOSYNC  0xf3700001

/*P2_TSCFGH*/
#define RSTV091X_P2_TSCFGH  0xf372
#define FSTV091X_P2_TSFIFO_DVBCI  0xf3720080
#define FSTV091X_P2_TSFIFO_SERIAL  0xf3720040
#define FSTV091X_P2_TSFIFO_TEIUPDATE  0xf3720020
#define FSTV091X_P2_TSFIFO_DUTY50  0xf3720010
#define FSTV091X_P2_TSFIFO_HSGNLOUT  0xf3720008
#define FSTV091X_P2_TSFIFO_ERRMODE  0xf3720006
#define FSTV091X_P2_RST_HWARE  0xf3720001

/*P2_TSCFGM*/
#define RSTV091X_P2_TSCFGM  0xf373
#define FSTV091X_P2_TSFIFO_MANSPEED  0xf37300c0
#define FSTV091X_P2_TSFIFO_PERMDATA  0xf3730020
#define FSTV091X_P2_TSFIFO_NONEWSGNL  0xf3730010
#define FSTV091X_P2_NPD_SPECDVBS2  0xf3730004
#define FSTV091X_P2_TSFIFO_DPUNACTIVE  0xf3730002
#define FSTV091X_P2_TSFIFO_INVDATA  0xf3730001

/*P2_TSCFGL*/
#define RSTV091X_P2_TSCFGL  0xf374
#define FSTV091X_P2_TSFIFO_BCLKDEL1CK  0xf37400c0
#define FSTV091X_P2_BCHERROR_MODE  0xf3740030
#define FSTV091X_P2_TSFIFO_NSGNL2DATA  0xf3740008
#define FSTV091X_P2_TSFIFO_EMBINDVB  0xf3740004
#define FSTV091X_P2_TSFIFO_BITSPEED  0xf3740003

/*P2_TSINSDELH*/
#define RSTV091X_P2_TSINSDELH  0xf376
#define FSTV091X_P2_TSDEL_SYNCBYTE  0xf3760080
#define FSTV091X_P2_TSDEL_XXHEADER  0xf3760040
#define FSTV091X_P2_TSDEL_BBHEADER  0xf3760020
#define FSTV091X_P2_TSDEL_DATAFIELD  0xf3760010
#define FSTV091X_P2_TSINSDEL_ISCR  0xf3760008
#define FSTV091X_P2_TSINSDEL_NPD  0xf3760004
#define FSTV091X_P2_TSINSDEL_RSPARITY  0xf3760002
#define FSTV091X_P2_TSINSDEL_CRC8  0xf3760001

/*P2_TSDIVN*/
#define RSTV091X_P2_TSDIVN  0xf379
#define FSTV091X_P2_TSFIFO_SPEEDMODE  0xf37900c0
#define FSTV091X_P2_BYTE_OVERSAMPLING  0xf3790038
#define FSTV091X_P2_TSFIFO_RISEOK  0xf3790007

/*P2_TSCFG4*/
#define RSTV091X_P2_TSCFG4  0xf37a
#define FSTV091X_P2_TSFIFO_TSSPEEDMODE  0xf37a00c0
#define FSTV091X_P2_TSFIFO_HIERSEL  0xf37a0020
#define FSTV091X_P2_TSFIFO_SPECTOKEN  0xf37a0010
#define FSTV091X_P2_TSFIFO_MAXMODE  0xf37a0008
#define FSTV091X_P2_TSFIFO_FRFORCEPKT  0xf37a0004
#define FSTV091X_P2_EXT_FECSPYIN  0xf37a0002
#define FSTV091X_P2_TSFIFO_DELSPEEDUP  0xf37a0001

/*P2_TSSPEED*/
#define RSTV091X_P2_TSSPEED  0xf380
#define FSTV091X_P2_TSFIFO_OUTSPEED  0xf38000ff

/*P2_TSSTATUS*/
#define RSTV091X_P2_TSSTATUS  0xf381
#define FSTV091X_P2_TSFIFO_LINEOK  0xf3810080
#define FSTV091X_P2_TSFIFO_ERROR  0xf3810040
#define FSTV091X_P2_TSFIFO_DATA7  0xf3810020
#define FSTV091X_P2_TSFIFO_NOSYNC  0xf3810010
#define FSTV091X_P2_ISCR_INITIALIZED  0xf3810008
#define FSTV091X_P2_TSREGUL_ERROR  0xf3810004
#define FSTV091X_P2_SOFFIFO_UNREGUL  0xf3810002
#define FSTV091X_P2_DIL_READY  0xf3810001

/*P2_TSSTATUS2*/
#define RSTV091X_P2_TSSTATUS2  0xf382
#define FSTV091X_P2_TSFIFO_DEMODSEL  0xf3820080
#define FSTV091X_P2_TSFIFOSPEED_STORE  0xf3820040
#define FSTV091X_P2_DILXX_RESET  0xf3820020
#define FSTV091X_P2_TSSPEED_IMPOSSIBLE  0xf3820010
#define FSTV091X_P2_TSFIFO_LINENOK  0xf3820008
#define FSTV091X_P2_TSFIFO_MUXSTREAM  0xf3820004
#define FSTV091X_P2_SCRAMBDETECT  0xf3820002
#define FSTV091X_P2_ULDTV67_FALSELOCK  0xf3820001

/*P2_TSBITRATE1*/
#define RSTV091X_P2_TSBITRATE1  0xf383
#define FSTV091X_P2_TSFIFO_BITRATE1  0xf38300ff

/*P2_TSBITRATE0*/
#define RSTV091X_P2_TSBITRATE0  0xf384
#define FSTV091X_P2_TSFIFO_BITRATE0  0xf38400ff

/*P2_ERRCTRL1*/
#define RSTV091X_P2_ERRCTRL1  0xf398
#define FSTV091X_P2_ERR_SOURCE1  0xf39800f0
#define FSTV091X_P2_NUM_EVENT1  0xf3980007

/*P2_ERRCNT12*/
#define RSTV091X_P2_ERRCNT12  0xf399
#define FSTV091X_P2_ERRCNT1_OLDVALUE  0xf3990080
#define FSTV091X_P2_ERR_CNT12  0xf399007f

/*P2_ERRCNT11*/
#define RSTV091X_P2_ERRCNT11  0xf39a
#define FSTV091X_P2_ERR_CNT11  0xf39a00ff

/*P2_ERRCNT10*/
#define RSTV091X_P2_ERRCNT10  0xf39b
#define FSTV091X_P2_ERR_CNT10  0xf39b00ff

/*P2_ERRCTRL2*/
#define RSTV091X_P2_ERRCTRL2  0xf39c
#define FSTV091X_P2_ERR_SOURCE2  0xf39c00f0
#define FSTV091X_P2_NUM_EVENT2  0xf39c0007

/*P2_ERRCNT22*/
#define RSTV091X_P2_ERRCNT22  0xf39d
#define FSTV091X_P2_ERRCNT2_OLDVALUE  0xf39d0080
#define FSTV091X_P2_ERR_CNT22  0xf39d007f

/*P2_ERRCNT21*/
#define RSTV091X_P2_ERRCNT21  0xf39e
#define FSTV091X_P2_ERR_CNT21  0xf39e00ff

/*P2_ERRCNT20*/
#define RSTV091X_P2_ERRCNT20  0xf39f
#define FSTV091X_P2_ERR_CNT20  0xf39f00ff

/*P2_FECSPY*/
#define RSTV091X_P2_FECSPY  0xf3a0
#define FSTV091X_P2_SPY_ENABLE  0xf3a00080
#define FSTV091X_P2_NO_SYNCBYTE  0xf3a00040
#define FSTV091X_P2_SERIAL_MODE  0xf3a00020
#define FSTV091X_P2_UNUSUAL_PACKET  0xf3a00010
#define FSTV091X_P2_BERMETER_DATAMODE  0xf3a0000c
#define FSTV091X_P2_BERMETER_LMODE  0xf3a00002
#define FSTV091X_P2_BERMETER_RESET  0xf3a00001

/*P2_FSPYCFG*/
#define RSTV091X_P2_FSPYCFG  0xf3a1
#define FSTV091X_P2_FECSPY_INPUT  0xf3a100c0
#define FSTV091X_P2_RST_ON_ERROR  0xf3a10020
#define FSTV091X_P2_ONE_SHOT  0xf3a10010
#define FSTV091X_P2_I2C_MODE  0xf3a1000c
#define FSTV091X_P2_SPY_HYSTERESIS  0xf3a10003

/*P2_FSPYDATA*/
#define RSTV091X_P2_FSPYDATA  0xf3a2
#define FSTV091X_P2_SPY_STUFFING  0xf3a20080
#define FSTV091X_P2_NOERROR_PKTJITTER  0xf3a20040
#define FSTV091X_P2_SPY_CNULLPKT  0xf3a20020
#define FSTV091X_P2_SPY_OUTDATA_MODE  0xf3a2001f

/*P2_FSPYOUT*/
#define RSTV091X_P2_FSPYOUT  0xf3a3
#define FSTV091X_P2_FSPY_DIRECT  0xf3a30080
#define FSTV091X_P2_SPY_OUTDATA_BUS  0xf3a30038
#define FSTV091X_P2_STUFF_MODE  0xf3a30007

/*P2_FSTATUS*/
#define RSTV091X_P2_FSTATUS  0xf3a4
#define FSTV091X_P2_SPY_ENDSIM  0xf3a40080
#define FSTV091X_P2_VALID_SIM  0xf3a40040
#define FSTV091X_P2_FOUND_SIGNAL  0xf3a40020
#define FSTV091X_P2_DSS_SYNCBYTE  0xf3a40010
#define FSTV091X_P2_RESULT_STATE  0xf3a4000f

/*P2_FBERCPT4*/
#define RSTV091X_P2_FBERCPT4  0xf3a8
#define FSTV091X_P2_FBERMETER_CPT4  0xf3a800ff

/*P2_FBERCPT3*/
#define RSTV091X_P2_FBERCPT3  0xf3a9
#define FSTV091X_P2_FBERMETER_CPT3  0xf3a900ff

/*P2_FBERCPT2*/
#define RSTV091X_P2_FBERCPT2  0xf3aa
#define FSTV091X_P2_FBERMETER_CPT2  0xf3aa00ff

/*P2_FBERCPT1*/
#define RSTV091X_P2_FBERCPT1  0xf3ab
#define FSTV091X_P2_FBERMETER_CPT1  0xf3ab00ff

/*P2_FBERCPT0*/
#define RSTV091X_P2_FBERCPT0  0xf3ac
#define FSTV091X_P2_FBERMETER_CPT0  0xf3ac00ff

/*P2_FBERERR2*/
#define RSTV091X_P2_FBERERR2  0xf3ad
#define FSTV091X_P2_FBERMETER_ERR2  0xf3ad00ff

/*P2_FBERERR1*/
#define RSTV091X_P2_FBERERR1  0xf3ae
#define FSTV091X_P2_FBERMETER_ERR1  0xf3ae00ff

/*P2_FBERERR0*/
#define RSTV091X_P2_FBERERR0  0xf3af
#define FSTV091X_P2_FBERMETER_ERR0  0xf3af00ff

/*P2_FSPYBER*/
#define RSTV091X_P2_FSPYBER  0xf3b2
#define FSTV091X_P2_FSPYOBS_XORREAD  0xf3b20040
#define FSTV091X_P2_FSPYBER_OBSMODE  0xf3b20020
#define FSTV091X_P2_FSPYBER_SYNCBYTE  0xf3b20010
#define FSTV091X_P2_FSPYBER_UNSYNC  0xf3b20008
#define FSTV091X_P2_FSPYBER_CTIME  0xf3b20007

/*P2_SFERROR*/
#define RSTV091X_P2_SFERROR  0xf3c1
#define FSTV091X_P2_SFEC_REGERR_VIT  0xf3c100ff

/*P2_SFECSTATUS*/
#define RSTV091X_P2_SFECSTATUS  0xf3c3
#define FSTV091X_P2_SFEC_ON  0xf3c30080
#define FSTV091X_P2_SFEC_OFF  0xf3c30040
#define FSTV091X_P2_LOCKEDSFEC  0xf3c30008
#define FSTV091X_P2_SFEC_DELOCK  0xf3c30004
#define FSTV091X_P2_SFEC_DEMODSEL  0xf3c30002
#define FSTV091X_P2_SFEC_OVFON  0xf3c30001

/*P2_SFKDIV12*/
#define RSTV091X_P2_SFKDIV12  0xf3c4
#define FSTV091X_P2_SFECKDIV12_MAN  0xf3c40080
#define FSTV091X_P2_SFEC_K_DIVIDER_12  0xf3c4007f

/*P2_SFKDIV23*/
#define RSTV091X_P2_SFKDIV23  0xf3c5
#define FSTV091X_P2_SFECKDIV23_MAN  0xf3c50080
#define FSTV091X_P2_SFEC_K_DIVIDER_23  0xf3c5007f

/*P2_SFKDIV34*/
#define RSTV091X_P2_SFKDIV34  0xf3c6
#define FSTV091X_P2_SFECKDIV34_MAN  0xf3c60080
#define FSTV091X_P2_SFEC_K_DIVIDER_34  0xf3c6007f

/*P2_SFKDIV56*/
#define RSTV091X_P2_SFKDIV56  0xf3c7
#define FSTV091X_P2_SFECKDIV56_MAN  0xf3c70080
#define FSTV091X_P2_SFEC_K_DIVIDER_56  0xf3c7007f

/*P2_SFKDIV67*/
#define RSTV091X_P2_SFKDIV67  0xf3c8
#define FSTV091X_P2_SFECKDIV67_MAN  0xf3c80080
#define FSTV091X_P2_SFEC_K_DIVIDER_67  0xf3c8007f

/*P2_SFKDIV78*/
#define RSTV091X_P2_SFKDIV78  0xf3c9
#define FSTV091X_P2_SFECKDIV78_MAN  0xf3c90080
#define FSTV091X_P2_SFEC_K_DIVIDER_78  0xf3c9007f

/*P2_SFSTATUS*/
#define RSTV091X_P2_SFSTATUS  0xf3cc
#define FSTV091X_P2_SFEC_LINEOK  0xf3cc0080
#define FSTV091X_P2_SFEC_ERROR  0xf3cc0040
#define FSTV091X_P2_SFEC_DATA7  0xf3cc0020
#define FSTV091X_P2_SFEC_PKTDNBRFAIL  0xf3cc0010
#define FSTV091X_P2_TSSFEC_DEMODSEL  0xf3cc0008
#define FSTV091X_P2_SFEC_NOSYNC  0xf3cc0004
#define FSTV091X_P2_SFEC_UNREGULA  0xf3cc0002
#define FSTV091X_P2_SFEC_READY  0xf3cc0001

/*P2_SFDLYSET2*/
#define RSTV091X_P2_SFDLYSET2  0xf3d0
#define FSTV091X_P2_SFEC_OFFSET  0xf3d000c0
#define FSTV091X_P2_RST_SFEC  0xf3d00008
#define FSTV091X_P2_DILDLINE_ERROR  0xf3d00004
#define FSTV091X_P2_SFEC_DISABLE  0xf3d00002
#define FSTV091X_P2_SFEC_UNREGUL  0xf3d00001

/*P2_SFERRCTRL*/
#define RSTV091X_P2_SFERRCTRL  0xf3d8
#define FSTV091X_P2_SFEC_ERR_SOURCE  0xf3d800f0
#define FSTV091X_P2_SFEC_NUM_EVENT  0xf3d80007

/*P2_SFERRCNT2*/
#define RSTV091X_P2_SFERRCNT2  0xf3d9
#define FSTV091X_P2_SFERRC_OLDVALUE  0xf3d90080
#define FSTV091X_P2_SFEC_ERR_CNT2  0xf3d9007f

/*P2_SFERRCNT1*/
#define RSTV091X_P2_SFERRCNT1  0xf3da
#define FSTV091X_P2_SFEC_ERR_CNT1  0xf3da00ff

/*P2_SFERRCNT0*/
#define RSTV091X_P2_SFERRCNT0  0xf3db
#define FSTV091X_P2_SFEC_ERR_CNT0  0xf3db00ff

/*P1_IQCONST*/
#define RSTV091X_P1_IQCONST  0xf400
#define FSTV091X_P1_CONSTEL_SELECT  0xf4000060
#define FSTV091X_P1_IQSYMB_SEL  0xf400001f

/*P1_NOSCFG*/
#define RSTV091X_P1_NOSCFG  0xf401
#define FSTV091X_P1_DIS_ACMRATIO  0xf4010080
#define FSTV091X_P1_NOSIN_EGALSEL  0xf4010040
#define FSTV091X_P1_DUMMYPL_NOSDATA  0xf4010020
#define FSTV091X_P1_NOSPLH_BETA  0xf4010018
#define FSTV091X_P1_NOSDATA_BETA  0xf4010007

/*P1_ISYMB*/
#define RSTV091X_P1_ISYMB  0xf402
#define FSTV091X_P1_I_SYMBOL  0xf40201ff

/*P1_QSYMB*/
#define RSTV091X_P1_QSYMB  0xf403
#define FSTV091X_P1_Q_SYMBOL  0xf40301ff

/*P1_AGC1CFG*/
#define RSTV091X_P1_AGC1CFG  0xf404
#define FSTV091X_P1_DC_FROZEN  0xf4040080
#define FSTV091X_P1_DC_CORRECT  0xf4040040
#define FSTV091X_P1_AMM_FROZEN  0xf4040020
#define FSTV091X_P1_AMM_CORRECT  0xf4040010
#define FSTV091X_P1_QUAD_FROZEN  0xf4040008
#define FSTV091X_P1_QUAD_CORRECT  0xf4040004
#define FSTV091X_P1_DCCOMP_SLOW  0xf4040002
#define FSTV091X_P1_IQMISM_SLOW  0xf4040001

/*P1_AGC1CN*/
#define RSTV091X_P1_AGC1CN  0xf406
#define FSTV091X_P1_AGC1_LOCKED  0xf4060080
#define FSTV091X_P1_AGC1_OVERFLOW  0xf4060040
#define FSTV091X_P1_AGC1_NOSLOWLK  0xf4060020
#define FSTV091X_P1_AGC1_MINPOWER  0xf4060010
#define FSTV091X_P1_AGCOUT_FAST  0xf4060008
#define FSTV091X_P1_AGCIQ_BETA  0xf4060007

/*P1_AGC1REF*/
#define RSTV091X_P1_AGC1REF  0xf407
#define FSTV091X_P1_AGCIQ_REF  0xf40700ff

/*P1_IDCCOMP*/
#define RSTV091X_P1_IDCCOMP  0xf408
#define FSTV091X_P1_IAVERAGE_ADJ  0xf40801ff

/*P1_QDCCOMP*/
#define RSTV091X_P1_QDCCOMP  0xf409
#define FSTV091X_P1_QAVERAGE_ADJ  0xf40901ff

/*P1_POWERI*/
#define RSTV091X_P1_POWERI  0xf40a
#define FSTV091X_P1_POWER_I  0xf40a00ff

/*P1_POWERQ*/
#define RSTV091X_P1_POWERQ  0xf40b
#define FSTV091X_P1_POWER_Q  0xf40b00ff

/*P1_AGC1AMM*/
#define RSTV091X_P1_AGC1AMM  0xf40c
#define FSTV091X_P1_AMM_VALUE  0xf40c00ff

/*P1_AGC1QUAD*/
#define RSTV091X_P1_AGC1QUAD  0xf40d
#define FSTV091X_P1_QUAD_VALUE  0xf40d01ff

/*P1_AGCIQIN1*/
#define RSTV091X_P1_AGCIQIN1  0xf40e
#define FSTV091X_P1_AGCIQ_VALUE1  0xf40e00ff

/*P1_AGCIQIN0*/
#define RSTV091X_P1_AGCIQIN0  0xf40f
#define FSTV091X_P1_AGCIQ_VALUE0  0xf40f00ff

/*P1_DEMOD*/
#define RSTV091X_P1_DEMOD  0xf410
#define FSTV091X_P1_MANUALS2_ROLLOFF  0xf4100080
#define FSTV091X_P1_SPECINV_CONTROL  0xf4100030
#define FSTV091X_P1_MANUALSX_ROLLOFF  0xf4100004
#define FSTV091X_P1_ROLLOFF_CONTROL  0xf4100003

/*P1_DMDMODCOD*/
#define RSTV091X_P1_DMDMODCOD  0xf411
#define FSTV091X_P1_MANUAL_MODCOD  0xf4110080
#define FSTV091X_P1_DEMOD_MODCOD  0xf411007c
#define FSTV091X_P1_DEMOD_TYPE  0xf4110003

/*P1_DSTATUS*/
#define RSTV091X_P1_DSTATUS  0xf412
#define FSTV091X_P1_CAR_LOCK  0xf4120080
#define FSTV091X_P1_TMGLOCK_QUALITY  0xf4120060
#define FSTV091X_P1_SDVBS1_ENABLE  0xf4120010
#define FSTV091X_P1_LOCK_DEFINITIF  0xf4120008
#define FSTV091X_P1_TIMING_IS_LOCKED  0xf4120004
#define FSTV091X_P1_DEMOD_SYSCFG  0xf4120002
#define FSTV091X_P1_OVADC_DETECT  0xf4120001

/*P1_DSTATUS2*/
#define RSTV091X_P1_DSTATUS2  0xf413
#define FSTV091X_P1_DEMOD_DELOCK  0xf4130080
#define FSTV091X_P1_DEMOD_TIMEOUT  0xf4130040
#define FSTV091X_P1_MODCODRQ_SYNCTAG  0xf4130020
#define FSTV091X_P1_POLYPH_SATEVENT  0xf4130010
#define FSTV091X_P1_AGC1_NOSIGNALACK  0xf4130008
#define FSTV091X_P1_AGC2_OVERFLOW  0xf4130004
#define FSTV091X_P1_CFR_OVERFLOW  0xf4130002
#define FSTV091X_P1_GAMMA_OVERUNDER  0xf4130001

/*P1_DMDCFGMD*/
#define RSTV091X_P1_DMDCFGMD  0xf414
#define FSTV091X_P1_DVBS2_ENABLE  0xf4140080
#define FSTV091X_P1_DVBS1_ENABLE  0xf4140040
#define FSTV091X_P1_SCAN_ENABLE  0xf4140010
#define FSTV091X_P1_CFR_AUTOSCAN  0xf4140008
#define FSTV091X_P1_NOFORCE_RELOCK  0xf4140004
#define FSTV091X_P1_TUN_RNG  0xf4140003

/*P1_DMDCFG2*/
#define RSTV091X_P1_DMDCFG2  0xf415
#define FSTV091X_P1_AGC1_WAITLOCK  0xf4150080
#define FSTV091X_P1_S1S2_SEQUENTIAL  0xf4150040
#define FSTV091X_P1_BLINDPEA_MODE  0xf4150020
#define FSTV091X_P1_INFINITE_RELOCK  0xf4150010
#define FSTV091X_P1_BWOFFSET_COLDWARM  0xf4150008
#define FSTV091X_P1_TMGLOCK_NSCANSTOP  0xf4150004
#define FSTV091X_P1_COARSE_LK3MODE  0xf4150002
#define FSTV091X_P1_COARSE_LK2MODE  0xf4150001

/*P1_DMDISTATE*/
#define RSTV091X_P1_DMDISTATE  0xf416
#define FSTV091X_P1_I2C_NORESETDMODE  0xf4160080
#define FSTV091X_P1_FORCE_ETAPED  0xf4160040
#define FSTV091X_P1_SDMDRST_DIRCLK  0xf4160020
#define FSTV091X_P1_I2C_DEMOD_MODE  0xf416001f

/*P1_DMDT0M*/
#define RSTV091X_P1_DMDT0M  0xf417
#define FSTV091X_P1_DMDT0_MIN  0xf41700ff

/*P1_DMDSTATE*/
#define RSTV091X_P1_DMDSTATE  0xf41b
#define FSTV091X_P1_DEMOD_LOCKED  0xf41b0080
#define FSTV091X_P1_HEADER_MODE  0xf41b0060
#define FSTV091X_P1_DEMOD_MODE  0xf41b001f

/*P1_DMDFLYW*/
#define RSTV091X_P1_DMDFLYW  0xf41c
#define FSTV091X_P1_I2C_IRQVAL  0xf41c00f0
#define FSTV091X_P1_FLYWHEEL_CPT  0xf41c000f

/*P1_DSTATUS3*/
#define RSTV091X_P1_DSTATUS3  0xf41d
#define FSTV091X_P1_CFR_ZIGZAG  0xf41d0080
#define FSTV091X_P1_DEMOD_CFGMODE  0xf41d0060
#define FSTV091X_P1_GAMMA_LOWBAUDRATE  0xf41d0010
#define FSTV091X_P1_RELOCK_MODE  0xf41d0008
#define FSTV091X_P1_DEMOD_FAIL  0xf41d0004
#define FSTV091X_P1_ETAPE1A_DVBXMEM  0xf41d0003

/*P1_DMDCFG3*/
#define RSTV091X_P1_DMDCFG3  0xf41e
#define FSTV091X_P1_DVBS1_TMGWAIT  0xf41e0080
#define FSTV091X_P1_NO_BWCENTERING  0xf41e0040
#define FSTV091X_P1_INV_SEQSRCH  0xf41e0020
#define FSTV091X_P1_DIS_SFRUPLOW_TRK  0xf41e0010
#define FSTV091X_P1_NOSTOP_FIFOFULL  0xf41e0008
#define FSTV091X_P1_LOCKTIME_MODE  0xf41e0007

/*P1_DMDCFG4*/
#define RSTV091X_P1_DMDCFG4  0xf41f
#define FSTV091X_P1_DIS_VITLOCK  0xf41f0080
#define FSTV091X_P1_S1S2TOUT_FAST  0xf41f0040
#define FSTV091X_P1_DEMOD_FASTLOCK  0xf41f0020
#define FSTV091X_P1_S1HIER_ENABLE  0xf41f0010
#define FSTV091X_P1_TUNER_NRELAUNCH  0xf41f0008
#define FSTV091X_P1_DIS_CLKENABLE  0xf41f0004
#define FSTV091X_P1_DIS_HDRDIVLOCK  0xf41f0002
#define FSTV091X_P1_NO_TNRWBINIT  0xf41f0001

/*P1_CORRELMANT*/
#define RSTV091X_P1_CORRELMANT  0xf420
#define FSTV091X_P1_CORREL_MANT  0xf42000ff

/*P1_CORRELABS*/
#define RSTV091X_P1_CORRELABS  0xf421
#define FSTV091X_P1_CORREL_ABS  0xf42100ff

/*P1_CORRELEXP*/
#define RSTV091X_P1_CORRELEXP  0xf422
#define FSTV091X_P1_CORREL_ABSEXP  0xf42200f0
#define FSTV091X_P1_CORREL_EXP  0xf422000f

/*P1_PLHMODCOD*/
#define RSTV091X_P1_PLHMODCOD  0xf424
#define FSTV091X_P1_SPECINV_DEMOD  0xf4240080
#define FSTV091X_P1_PLH_MODCOD  0xf424007c
#define FSTV091X_P1_PLH_TYPE  0xf4240003

/*P1_DMDREG*/
#define RSTV091X_P1_DMDREG  0xf425
#define FSTV091X_P1_EXTPSK_MODE  0xf4250080
#define FSTV091X_P1_HIER_SHORTFRAME  0xf4250002
#define FSTV091X_P1_DECIM_PLFRAMES  0xf4250001

/*P1_AGC2O*/
#define RSTV091X_P1_AGC2O  0xf42c
#define FSTV091X_P1_CSTENV_MODE  0xf42c00c0
#define FSTV091X_P1_AGC2_LKSQRT  0xf42c0020
#define FSTV091X_P1_AGC2_LKMODE  0xf42c0010
#define FSTV091X_P1_AGC2_LKEQUA  0xf42c0008
#define FSTV091X_P1_AGC2_COEF  0xf42c0007

/*P1_AGC2REF*/
#define RSTV091X_P1_AGC2REF  0xf42d
#define FSTV091X_P1_AGC2_REF  0xf42d00ff

/*P1_AGC1ADJ*/
#define RSTV091X_P1_AGC1ADJ  0xf42e
#define FSTV091X_P1_AGC1ADJ_MANUAL  0xf42e0080
#define FSTV091X_P1_AGC1_ADJUSTED  0xf42e007f

/*P1_AGC2I1*/
#define RSTV091X_P1_AGC2I1  0xf436
#define FSTV091X_P1_AGC2_INTEGRATOR1  0xf43600ff

/*P1_AGC2I0*/
#define RSTV091X_P1_AGC2I0  0xf437
#define FSTV091X_P1_AGC2_INTEGRATOR0  0xf43700ff

/*P1_CARCFG*/
#define RSTV091X_P1_CARCFG  0xf438
#define FSTV091X_P1_CFRUPLOW_AUTO  0xf4380080
#define FSTV091X_P1_CFRUPLOW_TEST  0xf4380040
#define FSTV091X_P1_WIDE_FREQDET  0xf4380020
#define FSTV091X_P1_CARHDR_NODIV8  0xf4380010
#define FSTV091X_P1_I2C_ROTA  0xf4380008
#define FSTV091X_P1_ROTAON  0xf4380004
#define FSTV091X_P1_PH_DET_ALGO  0xf4380003

/*P1_ACLC*/
#define RSTV091X_P1_ACLC  0xf439
#define FSTV091X_P1_CARS1_ANOSAUTO  0xf4390040
#define FSTV091X_P1_CAR_ALPHA_MANT  0xf4390030
#define FSTV091X_P1_CAR_ALPHA_EXP  0xf439000f

/*P1_BCLC*/
#define RSTV091X_P1_BCLC  0xf43a
#define FSTV091X_P1_CARS1_BNOSAUTO  0xf43a0040
#define FSTV091X_P1_CAR_BETA_MANT  0xf43a0030
#define FSTV091X_P1_CAR_BETA_EXP  0xf43a000f

/*P1_CARFREQ*/
#define RSTV091X_P1_CARFREQ  0xf43d
#define FSTV091X_P1_KC_COARSE_EXP  0xf43d00f0
#define FSTV091X_P1_BETA_FREQ  0xf43d000f

/*P1_CARHDR*/
#define RSTV091X_P1_CARHDR  0xf43e
#define FSTV091X_P1_K_FREQ_HDR  0xf43e00ff

/*P1_LDT*/
#define RSTV091X_P1_LDT  0xf43f
#define FSTV091X_P1_CARLOCK_THRES  0xf43f01ff

/*P1_LDT2*/
#define RSTV091X_P1_LDT2  0xf440
#define FSTV091X_P1_CARLOCK_THRES2  0xf44001ff

/*P1_CFRICFG*/
#define RSTV091X_P1_CFRICFG  0xf441
#define FSTV091X_P1_CFRINIT_UNVALRNG  0xf4410080
#define FSTV091X_P1_CFRINIT_LUNVALCPT  0xf4410040
#define FSTV091X_P1_CFRINIT_ABORTDBL  0xf4410020
#define FSTV091X_P1_CFRINIT_ABORTPRED  0xf4410010
#define FSTV091X_P1_CFRINIT_UNVALSKIP  0xf4410008
#define FSTV091X_P1_CFRINIT_CSTINC  0xf4410004
#define FSTV091X_P1_CFRIROLL_GARDER  0xf4410002
#define FSTV091X_P1_NEG_CFRSTEP  0xf4410001

/*P1_CFRUP1*/
#define RSTV091X_P1_CFRUP1  0xf442
#define FSTV091X_P1_CFR_UP1  0xf44201ff

/*P1_CFRUP0*/
#define RSTV091X_P1_CFRUP0  0xf443
#define FSTV091X_P1_CFR_UP0  0xf44300ff

/*P1_CFRIBASE1*/
#define RSTV091X_P1_CFRIBASE1  0xf444
#define FSTV091X_P1_CFRINIT_BASE1  0xf44400ff

/*P1_CFRIBASE0*/
#define RSTV091X_P1_CFRIBASE0  0xf445
#define FSTV091X_P1_CFRINIT_BASE0  0xf44500ff

/*P1_CFRLOW1*/
#define RSTV091X_P1_CFRLOW1  0xf446
#define FSTV091X_P1_CFR_LOW1  0xf44601ff

/*P1_CFRLOW0*/
#define RSTV091X_P1_CFRLOW0  0xf447
#define FSTV091X_P1_CFR_LOW0  0xf44700ff

/*P1_CFRINIT1*/
#define RSTV091X_P1_CFRINIT1  0xf448
#define FSTV091X_P1_CFR_INIT1  0xf44801ff

/*P1_CFRINIT0*/
#define RSTV091X_P1_CFRINIT0  0xf449
#define FSTV091X_P1_CFR_INIT0  0xf44900ff

/*P1_CFRINC1*/
#define RSTV091X_P1_CFRINC1  0xf44a
#define FSTV091X_P1_MANUAL_CFRINC  0xf44a0080
#define FSTV091X_P1_CFR_INC1  0xf44a003f

/*P1_CFRINC0*/
#define RSTV091X_P1_CFRINC0  0xf44b
#define FSTV091X_P1_CFR_INC0  0xf44b00ff

/*P1_CFR2*/
#define RSTV091X_P1_CFR2  0xf44c
#define FSTV091X_P1_CAR_FREQ2  0xf44c01ff

/*P1_CFR1*/
#define RSTV091X_P1_CFR1  0xf44d
#define FSTV091X_P1_CAR_FREQ1  0xf44d00ff

/*P1_CFR0*/
#define RSTV091X_P1_CFR0  0xf44e
#define FSTV091X_P1_CAR_FREQ0  0xf44e00ff

/*P1_LDI*/
#define RSTV091X_P1_LDI  0xf44f
#define FSTV091X_P1_LOCK_DET_INTEGR  0xf44f01ff

/*P1_TMGCFG*/
#define RSTV091X_P1_TMGCFG  0xf450
#define FSTV091X_P1_TMGLOCK_BETA  0xf45000c0
#define FSTV091X_P1_DO_TIMING_CORR  0xf4500010
#define FSTV091X_P1_MANUAL_SCAN  0xf450000c
#define FSTV091X_P1_TMG_MINFREQ  0xf4500003

/*P1_RTC*/
#define RSTV091X_P1_RTC  0xf451
#define FSTV091X_P1_TMGALPHA_EXP  0xf45100f0
#define FSTV091X_P1_TMGBETA_EXP  0xf451000f

/*P1_RTCS2*/
#define RSTV091X_P1_RTCS2  0xf452
#define FSTV091X_P1_TMGALPHAS2_EXP  0xf45200f0
#define FSTV091X_P1_TMGBETAS2_EXP  0xf452000f

/*P1_TMGTHRISE*/
#define RSTV091X_P1_TMGTHRISE  0xf453
#define FSTV091X_P1_TMGLOCK_THRISE  0xf45300ff

/*P1_TMGTHFALL*/
#define RSTV091X_P1_TMGTHFALL  0xf454
#define FSTV091X_P1_TMGLOCK_THFALL  0xf45400ff

/*P1_SFRUPRATIO*/
#define RSTV091X_P1_SFRUPRATIO  0xf455
#define FSTV091X_P1_SFR_UPRATIO  0xf45500ff

/*P1_SFRLOWRATIO*/
#define RSTV091X_P1_SFRLOWRATIO  0xf456
#define FSTV091X_P1_SFR_LOWRATIO  0xf45600ff

/*P1_KTTMG*/
#define RSTV091X_P1_KTTMG  0xf457
#define FSTV091X_P1_KT_TMG_EXP  0xf45700f0

/*P1_KREFTMG*/
#define RSTV091X_P1_KREFTMG  0xf458
#define FSTV091X_P1_KREF_TMG  0xf45800ff

/*P1_SFRSTEP*/
#define RSTV091X_P1_SFRSTEP  0xf459
#define FSTV091X_P1_SFR_SCANSTEP  0xf45900f0
#define FSTV091X_P1_SFR_CENTERSTEP  0xf459000f

/*P1_TMGCFG2*/
#define RSTV091X_P1_TMGCFG2  0xf45a
#define FSTV091X_P1_KREFTMG2_DECMODE  0xf45a00c0
#define FSTV091X_P1_DIS_AUTOSAMP  0xf45a0008
#define FSTV091X_P1_SCANINIT_QUART  0xf45a0004
#define FSTV091X_P1_NOTMG_DVBS1DERAT  0xf45a0002
#define FSTV091X_P1_SFRRATIO_FINE  0xf45a0001

/*P1_KREFTMG2*/
#define RSTV091X_P1_KREFTMG2  0xf45b
#define FSTV091X_P1_KREF_TMG2  0xf45b00ff

/*P1_TMGCFG3*/
#define RSTV091X_P1_TMGCFG3  0xf45d
#define FSTV091X_P1_CFRINC_MODE  0xf45d0070
#define FSTV091X_P1_CONT_TMGCENTER  0xf45d0008
#define FSTV091X_P1_AUTO_GUP  0xf45d0004
#define FSTV091X_P1_AUTO_GLOW  0xf45d0002
#define FSTV091X_P1_SFRVAL_MINMODE  0xf45d0001

/*P1_SFRINIT1*/
#define RSTV091X_P1_SFRINIT1  0xf45e
#define FSTV091X_P1_SFR_INIT1  0xf45e00ff

/*P1_SFRINIT0*/
#define RSTV091X_P1_SFRINIT0  0xf45f
#define FSTV091X_P1_SFR_INIT0  0xf45f00ff

/*P1_SFRUP1*/
#define RSTV091X_P1_SFRUP1  0xf460
#define FSTV091X_P1_SYMB_FREQ_UP1  0xf46000ff

/*P1_SFRUP0*/
#define RSTV091X_P1_SFRUP0  0xf461
#define FSTV091X_P1_SYMB_FREQ_UP0  0xf46100ff

/*P1_SFRLOW1*/
#define RSTV091X_P1_SFRLOW1  0xf462
#define FSTV091X_P1_SYMB_FREQ_LOW1  0xf46200ff

/*P1_SFRLOW0*/
#define RSTV091X_P1_SFRLOW0  0xf463
#define FSTV091X_P1_SYMB_FREQ_LOW0  0xf46300ff

/*P1_SFR3*/
#define RSTV091X_P1_SFR3  0xf464
#define FSTV091X_P1_SYMB_FREQ3  0xf46400ff

/*P1_SFR2*/
#define RSTV091X_P1_SFR2  0xf465
#define FSTV091X_P1_SYMB_FREQ2  0xf46500ff

/*P1_SFR1*/
#define RSTV091X_P1_SFR1  0xf466
#define FSTV091X_P1_SYMB_FREQ1  0xf46600ff

/*P1_SFR0*/
#define RSTV091X_P1_SFR0  0xf467
#define FSTV091X_P1_SYMB_FREQ0  0xf46700ff

/*P1_TMGREG2*/
#define RSTV091X_P1_TMGREG2  0xf468
#define FSTV091X_P1_TMGREG2  0xf46800ff

/*P1_TMGREG1*/
#define RSTV091X_P1_TMGREG1  0xf469
#define FSTV091X_P1_TMGREG1  0xf46900ff

/*P1_TMGREG0*/
#define RSTV091X_P1_TMGREG0  0xf46a
#define FSTV091X_P1_TMGREG0  0xf46a00ff

/*P1_TMGLOCK1*/
#define RSTV091X_P1_TMGLOCK1  0xf46b
#define FSTV091X_P1_TMGLOCK_LEVEL1  0xf46b01ff

/*P1_TMGLOCK0*/
#define RSTV091X_P1_TMGLOCK0  0xf46c
#define FSTV091X_P1_TMGLOCK_LEVEL0  0xf46c00ff

/*P1_TMGOBS*/
#define RSTV091X_P1_TMGOBS  0xf46d
#define FSTV091X_P1_ROLLOFF_STATUS  0xf46d00c0
#define FSTV091X_P1_SCAN_SIGN  0xf46d0030
#define FSTV091X_P1_TMG_SCANNING  0xf46d0008
#define FSTV091X_P1_CHCENTERING_MODE  0xf46d0004
#define FSTV091X_P1_TMG_SCANFAIL  0xf46d0002

/*P1_EQUALCFG*/
#define RSTV091X_P1_EQUALCFG  0xf46f
#define FSTV091X_P1_NOTMG_NEGALWAIT  0xf46f0080
#define FSTV091X_P1_EQUAL_ON  0xf46f0040
#define FSTV091X_P1_SEL_EQUALCOR  0xf46f0038
#define FSTV091X_P1_MU_EQUALDFE  0xf46f0007

/*P1_EQUAI1*/
#define RSTV091X_P1_EQUAI1  0xf470
#define FSTV091X_P1_EQUA_ACCI1  0xf47001ff

/*P1_EQUAQ1*/
#define RSTV091X_P1_EQUAQ1  0xf471
#define FSTV091X_P1_EQUA_ACCQ1  0xf47101ff

/*P1_EQUAI2*/
#define RSTV091X_P1_EQUAI2  0xf472
#define FSTV091X_P1_EQUA_ACCI2  0xf47201ff

/*P1_EQUAQ2*/
#define RSTV091X_P1_EQUAQ2  0xf473
#define FSTV091X_P1_EQUA_ACCQ2  0xf47301ff

/*P1_EQUAI3*/
#define RSTV091X_P1_EQUAI3  0xf474
#define FSTV091X_P1_EQUA_ACCI3  0xf47401ff

/*P1_EQUAQ3*/
#define RSTV091X_P1_EQUAQ3  0xf475
#define FSTV091X_P1_EQUA_ACCQ3  0xf47501ff

/*P1_EQUAI4*/
#define RSTV091X_P1_EQUAI4  0xf476
#define FSTV091X_P1_EQUA_ACCI4  0xf47601ff

/*P1_EQUAQ4*/
#define RSTV091X_P1_EQUAQ4  0xf477
#define FSTV091X_P1_EQUA_ACCQ4  0xf47701ff

/*P1_EQUAI5*/
#define RSTV091X_P1_EQUAI5  0xf478
#define FSTV091X_P1_EQUA_ACCI5  0xf47801ff

/*P1_EQUAQ5*/
#define RSTV091X_P1_EQUAQ5  0xf479
#define FSTV091X_P1_EQUA_ACCQ5  0xf47901ff

/*P1_EQUAI6*/
#define RSTV091X_P1_EQUAI6  0xf47a
#define FSTV091X_P1_EQUA_ACCI6  0xf47a01ff

/*P1_EQUAQ6*/
#define RSTV091X_P1_EQUAQ6  0xf47b
#define FSTV091X_P1_EQUA_ACCQ6  0xf47b01ff

/*P1_EQUAI7*/
#define RSTV091X_P1_EQUAI7  0xf47c
#define FSTV091X_P1_EQUA_ACCI7  0xf47c01ff

/*P1_EQUAQ7*/
#define RSTV091X_P1_EQUAQ7  0xf47d
#define FSTV091X_P1_EQUA_ACCQ7  0xf47d01ff

/*P1_EQUAI8*/
#define RSTV091X_P1_EQUAI8  0xf47e
#define FSTV091X_P1_EQUA_ACCI8  0xf47e01ff

/*P1_EQUAQ8*/
#define RSTV091X_P1_EQUAQ8  0xf47f
#define FSTV091X_P1_EQUA_ACCQ8  0xf47f01ff

/*P1_NNOSDATAT1*/
#define RSTV091X_P1_NNOSDATAT1  0xf480
#define FSTV091X_P1_NOSDATAT_NORMED1  0xf48000ff

/*P1_NNOSDATAT0*/
#define RSTV091X_P1_NNOSDATAT0  0xf481
#define FSTV091X_P1_NOSDATAT_NORMED0  0xf48100ff

/*P1_NNOSDATA1*/
#define RSTV091X_P1_NNOSDATA1  0xf482
#define FSTV091X_P1_NOSDATA_NORMED1  0xf48200ff

/*P1_NNOSDATA0*/
#define RSTV091X_P1_NNOSDATA0  0xf483
#define FSTV091X_P1_NOSDATA_NORMED0  0xf48300ff

/*P1_NNOSPLHT1*/
#define RSTV091X_P1_NNOSPLHT1  0xf484
#define FSTV091X_P1_NOSPLHT_NORMED1  0xf48400ff

/*P1_NNOSPLHT0*/
#define RSTV091X_P1_NNOSPLHT0  0xf485
#define FSTV091X_P1_NOSPLHT_NORMED0  0xf48500ff

/*P1_NNOSPLH1*/
#define RSTV091X_P1_NNOSPLH1  0xf486
#define FSTV091X_P1_NOSPLH_NORMED1  0xf48600ff

/*P1_NNOSPLH0*/
#define RSTV091X_P1_NNOSPLH0  0xf487
#define FSTV091X_P1_NOSPLH_NORMED0  0xf48700ff

/*P1_NOSDATAT1*/
#define RSTV091X_P1_NOSDATAT1  0xf488
#define FSTV091X_P1_NOSDATAT_UNNORMED1  0xf48800ff

/*P1_NOSDATAT0*/
#define RSTV091X_P1_NOSDATAT0  0xf489
#define FSTV091X_P1_NOSDATAT_UNNORMED0  0xf48900ff

/*P1_NNOSFRAME1*/
#define RSTV091X_P1_NNOSFRAME1  0xf48a
#define FSTV091X_P1_NOSFRAME_NORMED1  0xf48a00ff

/*P1_NNOSFRAME0*/
#define RSTV091X_P1_NNOSFRAME0  0xf48b
#define FSTV091X_P1_NOSFRAME_NORMED0  0xf48b00ff

/*P1_NNOSRAD1*/
#define RSTV091X_P1_NNOSRAD1  0xf48c
#define FSTV091X_P1_NOSRADIAL_NORMED1  0xf48c00ff

/*P1_NNOSRAD0*/
#define RSTV091X_P1_NNOSRAD0  0xf48d
#define FSTV091X_P1_NOSRADIAL_NORMED0  0xf48d00ff

/*P1_NOSCFGF1*/
#define RSTV091X_P1_NOSCFGF1  0xf48e
#define FSTV091X_P1_LOWNOISE_MESURE  0xf48e0080
#define FSTV091X_P1_NOS_DELFRAME  0xf48e0040
#define FSTV091X_P1_NOSDATA_MODE  0xf48e0030
#define FSTV091X_P1_FRAMESEL_TYPESEL  0xf48e000c
#define FSTV091X_P1_FRAMESEL_TYPE  0xf48e0003

/*P1_CAR2CFG*/
#define RSTV091X_P1_CAR2CFG  0xf490
#define FSTV091X_P1_DESCRAMB_OFF  0xf4900080
#define FSTV091X_P1_EN_PHNOSRAM  0xf4900020
#define FSTV091X_P1_STOP_CFR2UPDATE  0xf4900010
#define FSTV091X_P1_STOP_NCO2UPDATE  0xf4900008
#define FSTV091X_P1_ROTA2ON  0xf4900004
#define FSTV091X_P1_PH_DET_ALGO2  0xf4900003

/*P1_CFR2CFR1*/
#define RSTV091X_P1_CFR2CFR1  0xf491
#define FSTV091X_P1_CFR2_S2CONTROL  0xf49100c0
#define FSTV091X_P1_EN_S2CAR2CENTER  0xf4910020
#define FSTV091X_P1_BCHERRCFR2_MODE  0xf4910018
#define FSTV091X_P1_CFR2TOCFR1_BETA  0xf4910007

/*P1_CAR3CFG*/
#define RSTV091X_P1_CAR3CFG  0xf492
#define FSTV091X_P1_CARRIER23_MODE  0xf49200c0
#define FSTV091X_P1_CAR3INTERM_DVBS1  0xf4920020
#define FSTV091X_P1_ABAMPLIF_MODE  0xf4920018
#define FSTV091X_P1_CARRIER3_ALPHA3DL  0xf4920007

/*P1_CFR22*/
#define RSTV091X_P1_CFR22  0xf493
#define FSTV091X_P1_CAR2_FREQ2  0xf49301ff

/*P1_CFR21*/
#define RSTV091X_P1_CFR21  0xf494
#define FSTV091X_P1_CAR2_FREQ1  0xf49400ff

/*P1_CFR20*/
#define RSTV091X_P1_CFR20  0xf495
#define FSTV091X_P1_CAR2_FREQ0  0xf49500ff

/*P1_ACLC2S2Q*/
#define RSTV091X_P1_ACLC2S2Q  0xf497
#define FSTV091X_P1_ENAB_SPSKSYMB  0xf4970080
#define FSTV091X_P1_CAR2S2_QANOSAUTO  0xf4970040
#define FSTV091X_P1_CAR2S2_Q_ALPH_M  0xf4970030
#define FSTV091X_P1_CAR2S2_Q_ALPH_E  0xf497000f

/*P1_ACLC2S28*/
#define RSTV091X_P1_ACLC2S28  0xf498
#define FSTV091X_P1_OLDI3Q_MODE  0xf4980080
#define FSTV091X_P1_CAR2S2_8ANOSAUTO  0xf4980040
#define FSTV091X_P1_CAR2S2_8_ALPH_M  0xf4980030
#define FSTV091X_P1_CAR2S2_8_ALPH_E  0xf498000f

/*P1_ACLC2S216A*/
#define RSTV091X_P1_ACLC2S216A  0xf499
#define FSTV091X_P1_CAR2S2_16ANOSAUTO  0xf4990040
#define FSTV091X_P1_CAR2S2_16A_ALPH_M  0xf4990030
#define FSTV091X_P1_CAR2S2_16A_ALPH_E  0xf499000f

/*P1_ACLC2S232A*/
#define RSTV091X_P1_ACLC2S232A  0xf49a
#define FSTV091X_P1_CAR2S2_32ANOSUATO  0xf49a0040
#define FSTV091X_P1_CAR2S2_32A_ALPH_M  0xf49a0030
#define FSTV091X_P1_CAR2S2_32A_ALPH_E  0xf49a000f

/*P1_BCLC2S2Q*/
#define RSTV091X_P1_BCLC2S2Q  0xf49c
#define FSTV091X_P1_DVBS2S2Q_NIP  0xf49c0080
#define FSTV091X_P1_CAR2S2_QBNOSAUTO  0xf49c0040
#define FSTV091X_P1_CAR2S2_Q_BETA_M  0xf49c0030
#define FSTV091X_P1_CAR2S2_Q_BETA_E  0xf49c000f

/*P1_BCLC2S28*/
#define RSTV091X_P1_BCLC2S28  0xf49d
#define FSTV091X_P1_DVBS2S28_NIP  0xf49d0080
#define FSTV091X_P1_CAR2S2_8BNOSAUTO  0xf49d0040
#define FSTV091X_P1_CAR2S2_8_BETA_M  0xf49d0030
#define FSTV091X_P1_CAR2S2_8_BETA_E  0xf49d000f

/* P1_BCLC2S216A */
#define RSTV091X_P1_BCLC2S216A  0xf49e
#define FSTV091X_P1_DVBS2S216A_NIP  0xf49e0080
#define FSTV091X_P1_CAR2S2_16A_BETA_M  0xf49e0030
#define FSTV091X_P1_CAR2S2_16A_BETA_E  0xf49e000f

/* P1_BCLC2S232A */
#define RSTV091X_P1_BCLC2S232A  0xf49f
#define FSTV091X_P1_DVBS2S232A_NIP  0xf49f0080
#define FSTV091X_P1_CAR2S2_32A_BETA_M  0xf49f0030
#define FSTV091X_P1_CAR2S2_32A_BETA_E  0xf49f000f

/*P1_PLROOT2*/
#define RSTV091X_P1_PLROOT2  0xf4ac
#define FSTV091X_P1_PLHAUTO_DISPLH  0xf4ac0040
#define FSTV091X_P1_PLHAUTO_FASTMODE  0xf4ac0020
#define FSTV091X_P1_PLHAUTO_ENABLE  0xf4ac0010
#define FSTV091X_P1_PLSCRAMB_MODE  0xf4ac000c
#define FSTV091X_P1_PLSCRAMB_ROOT2  0xf4ac0003

/*P1_PLROOT1*/
#define RSTV091X_P1_PLROOT1  0xf4ad
#define FSTV091X_P1_PLSCRAMB_ROOT1  0xf4ad00ff

/*P1_PLROOT0*/
#define RSTV091X_P1_PLROOT0  0xf4ae
#define FSTV091X_P1_PLSCRAMB_ROOT0  0xf4ae00ff

/*P1_MODCODLST7*/
#define RSTV091X_P1_MODCODLST7  0xf4b7
#define FSTV091X_P1_MODCOD_NNOSFILTER  0xf4b70080
#define FSTV091X_P1_MODCODLST_NOSTYPE  0xf4b70040
#define FSTV091X_P1_DIS_8PSK_9_10  0xf4b70030
#define FSTV091X_P1_DIS_8P_8_9  0xf4b7000f

/*P1_MODCODLST8*/
#define RSTV091X_P1_MODCODLST8  0xf4b8
#define FSTV091X_P1_DIS_8P_5_6  0xf4b800f0
#define FSTV091X_P1_DIS_8P_3_4  0xf4b8000f

/*P1_MODCODLST9*/
#define RSTV091X_P1_MODCODLST9  0xf4b9
#define FSTV091X_P1_DIS_8P_2_3  0xf4b900f0
#define FSTV091X_P1_DIS_8P_3_5  0xf4b9000f

/*P1_MODCODLSTA*/
#define RSTV091X_P1_MODCODLSTA  0xf4ba
#define FSTV091X_P1_NOSFILTER_LIMITE  0xf4ba0080
#define FSTV091X_P1_NOSFILTER_MODE  0xf4ba0040
#define FSTV091X_P1_DIS_QPSK_9_10  0xf4ba0030
#define FSTV091X_P1_DIS_QP_8_9  0xf4ba000f

/*P1_MODCODLSTB*/
#define RSTV091X_P1_MODCODLSTB  0xf4bb
#define FSTV091X_P1_DIS_QP_5_6  0xf4bb00f0
#define FSTV091X_P1_DIS_QP_4_5  0xf4bb000f

/*P1_MODCODLSTC*/
#define RSTV091X_P1_MODCODLSTC  0xf4bc
#define FSTV091X_P1_DIS_QP_3_4  0xf4bc00f0
#define FSTV091X_P1_DIS_QP_2_3  0xf4bc000f

/*P1_MODCODLSTD*/
#define RSTV091X_P1_MODCODLSTD  0xf4bd
#define FSTV091X_P1_DIS_QPSK_3_5  0xf4bd00f0
#define FSTV091X_P1_DIS_QPSK_1_2  0xf4bd000f

/*P1_GAUSSR0*/
#define RSTV091X_P1_GAUSSR0  0xf4c0
#define FSTV091X_P1_EN_CCIMODE  0xf4c00080
#define FSTV091X_P1_R0_GAUSSIEN  0xf4c0007f

/*P1_CCIR0*/
#define RSTV091X_P1_CCIR0  0xf4c1
#define FSTV091X_P1_CCIDETECT_PLHONLY  0xf4c10080
#define FSTV091X_P1_R0_CCI  0xf4c1007f

/*P1_CCIQUANT*/
#define RSTV091X_P1_CCIQUANT  0xf4c2
#define FSTV091X_P1_CCI_BETA  0xf4c200e0
#define FSTV091X_P1_CCI_QUANT  0xf4c2001f

/*P1_CCITHRES*/
#define RSTV091X_P1_CCITHRES  0xf4c3
#define FSTV091X_P1_CCI_THRESHOLD  0xf4c300ff

/*P1_CCIACC*/
#define RSTV091X_P1_CCIACC  0xf4c4
#define FSTV091X_P1_CCI_VALUE  0xf4c400ff

/*P1_DSTATUS4*/
#define RSTV091X_P1_DSTATUS4  0xf4c5
#define FSTV091X_P1_RAINFADE_DETECT  0xf4c50080
#define FSTV091X_P1_NOTHRES2_FAIL  0xf4c50040
#define FSTV091X_P1_NOTHRES1_FAIL  0xf4c50020
#define FSTV091X_P1_PILOT_FAILDETECT  0xf4c50010
#define FSTV091X_P1_HIER_DETECT  0xf4c50008
#define FSTV091X_P1_DMDPROG_ERROR  0xf4c50004
#define FSTV091X_P1_CSTENV_DETECT  0xf4c50002
#define FSTV091X_P1_DETECTION_TRIAX  0xf4c50001

/*P1_DMDRESCFG*/
#define RSTV091X_P1_DMDRESCFG  0xf4c6
#define FSTV091X_P1_DMDRES_RESET  0xf4c60080
#define FSTV091X_P1_DMDRES_NOISESQR  0xf4c60010
#define FSTV091X_P1_DMDRES_STRALL  0xf4c60008
#define FSTV091X_P1_DMDRES_NEWONLY  0xf4c60004
#define FSTV091X_P1_DMDRES_NOSTORE  0xf4c60002
#define FSTV091X_P1_DMDRES_AGC2MEM  0xf4c60001

/*P1_DMDRESADR*/
#define RSTV091X_P1_DMDRESADR  0xf4c7
#define FSTV091X_P1_SUSP_PREDCANAL  0xf4c70080
#define FSTV091X_P1_DMDRES_VALIDCFR  0xf4c70040
#define FSTV091X_P1_DMDRES_MEMFULL  0xf4c70030
#define FSTV091X_P1_DMDRES_RESNBR  0xf4c7000f

/*P1_DMDRESDATA7*/
#define RSTV091X_P1_DMDRESDATA7  0xf4c8
#define FSTV091X_P1_DMDRES_DATA7  0xf4c800ff

/*P1_DMDRESDATA6*/
#define RSTV091X_P1_DMDRESDATA6  0xf4c9
#define FSTV091X_P1_DMDRES_DATA6  0xf4c900ff

/*P1_DMDRESDATA5*/
#define RSTV091X_P1_DMDRESDATA5  0xf4ca
#define FSTV091X_P1_DMDRES_DATA5  0xf4ca00ff

/*P1_DMDRESDATA4*/
#define RSTV091X_P1_DMDRESDATA4  0xf4cb
#define FSTV091X_P1_DMDRES_DATA4  0xf4cb00ff

/*P1_DMDRESDATA3*/
#define RSTV091X_P1_DMDRESDATA3  0xf4cc
#define FSTV091X_P1_DMDRES_DATA3  0xf4cc00ff

/*P1_DMDRESDATA2*/
#define RSTV091X_P1_DMDRESDATA2  0xf4cd
#define FSTV091X_P1_DMDRES_DATA2  0xf4cd00ff

/*P1_DMDRESDATA1*/
#define RSTV091X_P1_DMDRESDATA1  0xf4ce
#define FSTV091X_P1_DMDRES_DATA1  0xf4ce00ff

/*P1_DMDRESDATA0*/
#define RSTV091X_P1_DMDRESDATA0  0xf4cf
#define FSTV091X_P1_DMDRES_DATA0  0xf4cf00ff

/*P1_FFEI1*/
#define RSTV091X_P1_FFEI1  0xf4d0
#define FSTV091X_P1_FFE_ACCI1  0xf4d001ff

/*P1_FFEQ1*/
#define RSTV091X_P1_FFEQ1  0xf4d1
#define FSTV091X_P1_FFE_ACCQ1  0xf4d101ff

/*P1_FFEI2*/
#define RSTV091X_P1_FFEI2  0xf4d2
#define FSTV091X_P1_FFE_ACCI2  0xf4d201ff

/*P1_FFEQ2*/
#define RSTV091X_P1_FFEQ2  0xf4d3
#define FSTV091X_P1_FFE_ACCQ2  0xf4d301ff

/*P1_FFEI3*/
#define RSTV091X_P1_FFEI3  0xf4d4
#define FSTV091X_P1_FFE_ACCI3  0xf4d401ff

/*P1_FFEQ3*/
#define RSTV091X_P1_FFEQ3  0xf4d5
#define FSTV091X_P1_FFE_ACCQ3  0xf4d501ff

/*P1_FFEI4*/
#define RSTV091X_P1_FFEI4  0xf4d6
#define FSTV091X_P1_FFE_ACCI4  0xf4d601ff

/*P1_FFEQ4*/
#define RSTV091X_P1_FFEQ4  0xf4d7
#define FSTV091X_P1_FFE_ACCQ4  0xf4d701ff

/*P1_FFECFG*/
#define RSTV091X_P1_FFECFG  0xf4d8
#define FSTV091X_P1_EQUALFFE_ON  0xf4d80040
#define FSTV091X_P1_EQUAL_USEDSYMB  0xf4d80030
#define FSTV091X_P1_MU_EQUALFFE  0xf4d80007

/*P1_TNRCFG2*/
#define RSTV091X_P1_TNRCFG2  0xf4e1
#define FSTV091X_P1_TUN_IQSWAP  0xf4e10080
#define FSTV091X_P1_STB6110_STEP2MHZ  0xf4e10040
#define FSTV091X_P1_STB6120_DBLI2C  0xf4e10020
#define FSTV091X_P1_TUNER_WIDEBAND  0xf4e10010
#define FSTV091X_P1_TUNER_OBSPAGE  0xf4e10008
#define FSTV091X_P1_DIS_BWCALC  0xf4e10004
#define FSTV091X_P1_SHORT_WAITSTATES  0xf4e10002
#define FSTV091X_P1_DIS_2BWAGC1  0xf4e10001

/*P1_SMAPCOEF7*/
#define RSTV091X_P1_SMAPCOEF7  0xf500
#define FSTV091X_P1_DIS_QSCALE  0xf5000080
#define FSTV091X_P1_SMAPCOEF_Q_LLR12  0xf500017f

/*P1_SMAPCOEF6*/
#define RSTV091X_P1_SMAPCOEF6  0xf501
#define FSTV091X_P1_DIS_AGC2SCALE  0xf5010080
#define FSTV091X_P1_DIS_16IQMULT  0xf5010040
#define FSTV091X_P1_OLD_16APSK47  0xf5010020
#define FSTV091X_P1_OLD_16APSK12  0xf5010010
#define FSTV091X_P1_DIS_NEWSCALE  0xf5010008
#define FSTV091X_P1_ADJ_8PSKLLR1  0xf5010004
#define FSTV091X_P1_OLD_8PSKLLR1  0xf5010002
#define FSTV091X_P1_DIS_AB8PSK  0xf5010001

/*P1_SMAPCOEF5*/
#define RSTV091X_P1_SMAPCOEF5  0xf502
#define FSTV091X_P1_DIS_8SCALE  0xf5020080
#define FSTV091X_P1_SMAPCOEF_8P_LLR23  0xf502017f

/*P1_NOSTHRES1*/
#define RSTV091X_P1_NOSTHRES1  0xf509
#define FSTV091X_P1_NOS_THRESHOLD1  0xf50900ff

/*P1_NOSTHRES2*/
#define RSTV091X_P1_NOSTHRES2  0xf50a
#define FSTV091X_P1_NOS_THRESHOLD2  0xf50a00ff

/*P1_NOSDIFF1*/
#define RSTV091X_P1_NOSDIFF1  0xf50b
#define FSTV091X_P1_NOSTHRES1_DIFF  0xf50b00ff

/*P1_RAINFADE*/
#define RSTV091X_P1_RAINFADE  0xf50c
#define FSTV091X_P1_NOSTHRES_DATAT  0xf50c0080
#define FSTV091X_P1_RAINFADE_CNLIMIT  0xf50c0070
#define FSTV091X_P1_RAINFADE_TIMEOUT  0xf50c0007

/*P1_NOSRAMCFG*/
#define RSTV091X_P1_NOSRAMCFG  0xf50d
#define FSTV091X_P1_NOSRAM_DVBS2DATA  0xf50d0080
#define FSTV091X_P1_NOSRAM_QUADRAT  0xf50d0040
#define FSTV091X_P1_NOSRAM_ACTIVATION  0xf50d0030
#define FSTV091X_P1_NOSRAM_CNRONLY  0xf50d0008
#define FSTV091X_P1_NOSRAM_LGNCNR1  0xf50d0007

/*P1_NOSRAMPOS*/
#define RSTV091X_P1_NOSRAMPOS  0xf50e
#define FSTV091X_P1_NOSRAM_LGNCNR0  0xf50e00f0
#define FSTV091X_P1_NOSRAM_VALIDE  0xf50e0004
#define FSTV091X_P1_NOSRAM_CNRVAL1  0xf50e0003

/*P1_NOSRAMVAL*/
#define RSTV091X_P1_NOSRAMVAL  0xf50f
#define FSTV091X_P1_NOSRAM_CNRVAL0  0xf50f00ff

/*P1_DMDPLHSTAT*/
#define RSTV091X_P1_DMDPLHSTAT  0xf520
#define FSTV091X_P1_PLH_STATISTIC  0xf52000ff

/*P1_LOCKTIME3*/
#define RSTV091X_P1_LOCKTIME3  0xf522
#define FSTV091X_P1_DEMOD_LOCKTIME3  0xf52200ff

/*P1_LOCKTIME2*/
#define RSTV091X_P1_LOCKTIME2  0xf523
#define FSTV091X_P1_DEMOD_LOCKTIME2  0xf52300ff

/*P1_LOCKTIME1*/
#define RSTV091X_P1_LOCKTIME1  0xf524
#define FSTV091X_P1_DEMOD_LOCKTIME1  0xf52400ff

/*P1_LOCKTIME0*/
#define RSTV091X_P1_LOCKTIME0  0xf525
#define FSTV091X_P1_DEMOD_LOCKTIME0  0xf52500ff

/*P1_VITSCALE*/
#define RSTV091X_P1_VITSCALE  0xf532
#define FSTV091X_P1_NVTH_NOSRANGE  0xf5320080
#define FSTV091X_P1_VERROR_MAXMODE  0xf5320040
#define FSTV091X_P1_KDIV_MODE  0xf5320030
#define FSTV091X_P1_NSLOWSN_LOCKED  0xf5320008
#define FSTV091X_P1_DELOCK_PRFLOSS  0xf5320004
#define FSTV091X_P1_DIS_RSFLOCK  0xf5320002

/*P1_FECM*/
#define RSTV091X_P1_FECM  0xf533
#define FSTV091X_P1_DSS_DVB  0xf5330080
#define FSTV091X_P1_DEMOD_BYPASS  0xf5330040
#define FSTV091X_P1_CMP_SLOWMODE  0xf5330020
#define FSTV091X_P1_DSS_SRCH  0xf5330010
#define FSTV091X_P1_DIFF_MODEVIT  0xf5330004
#define FSTV091X_P1_SYNCVIT  0xf5330002
#define FSTV091X_P1_IQINV  0xf5330001

/*P1_VTH12*/
#define RSTV091X_P1_VTH12  0xf534
#define FSTV091X_P1_VTH12  0xf53400ff

/*P1_VTH23*/
#define RSTV091X_P1_VTH23  0xf535
#define FSTV091X_P1_VTH23  0xf53500ff

/*P1_VTH34*/
#define RSTV091X_P1_VTH34  0xf536
#define FSTV091X_P1_VTH34  0xf53600ff

/*P1_VTH56*/
#define RSTV091X_P1_VTH56  0xf537
#define FSTV091X_P1_VTH56  0xf53700ff

/*P1_VTH67*/
#define RSTV091X_P1_VTH67  0xf538
#define FSTV091X_P1_VTH67  0xf53800ff

/*P1_VTH78*/
#define RSTV091X_P1_VTH78  0xf539
#define FSTV091X_P1_VTH78  0xf53900ff

/*P1_VITCURPUN*/
#define RSTV091X_P1_VITCURPUN  0xf53a
#define FSTV091X_P1_CYCLESLIP_VIT  0xf53a0080
#define FSTV091X_P1_VIT_ROTA180  0xf53a0040
#define FSTV091X_P1_VIT_ROTA90  0xf53a0020
#define FSTV091X_P1_VIT_CURPUN  0xf53a001f

/*P1_VERROR*/
#define RSTV091X_P1_VERROR  0xf53b
#define FSTV091X_P1_REGERR_VIT  0xf53b00ff

/*P1_PRVIT*/
#define RSTV091X_P1_PRVIT  0xf53c
#define FSTV091X_P1_DIS_VTHLOCK  0xf53c0040
#define FSTV091X_P1_E7_8VIT  0xf53c0020
#define FSTV091X_P1_E6_7VIT  0xf53c0010
#define FSTV091X_P1_E5_6VIT  0xf53c0008
#define FSTV091X_P1_E3_4VIT  0xf53c0004
#define FSTV091X_P1_E2_3VIT  0xf53c0002
#define FSTV091X_P1_E1_2VIT  0xf53c0001

/*P1_VAVSRVIT*/
#define RSTV091X_P1_VAVSRVIT  0xf53d
#define FSTV091X_P1_AMVIT  0xf53d0080
#define FSTV091X_P1_FROZENVIT  0xf53d0040
#define FSTV091X_P1_SNVIT  0xf53d0030
#define FSTV091X_P1_TOVVIT  0xf53d000c
#define FSTV091X_P1_HYPVIT  0xf53d0003

/*P1_VSTATUSVIT*/
#define RSTV091X_P1_VSTATUSVIT  0xf53e
#define FSTV091X_P1_VITERBI_ON  0xf53e0080
#define FSTV091X_P1_END_LOOPVIT  0xf53e0040
#define FSTV091X_P1_VITERBI_DEPRF  0xf53e0020
#define FSTV091X_P1_PRFVIT  0xf53e0010
#define FSTV091X_P1_LOCKEDVIT  0xf53e0008
#define FSTV091X_P1_VITERBI_DELOCK  0xf53e0004
#define FSTV091X_P1_VIT_DEMODSEL  0xf53e0002
#define FSTV091X_P1_VITERBI_COMPOUT  0xf53e0001

/*P1_VTHINUSE*/
#define RSTV091X_P1_VTHINUSE  0xf53f
#define FSTV091X_P1_VIT_INUSE  0xf53f00ff

/*P1_KDIV12*/
#define RSTV091X_P1_KDIV12  0xf540
#define FSTV091X_P1_KDIV12_MANUAL  0xf5400080
#define FSTV091X_P1_K_DIVIDER_12  0xf540007f

/*P1_KDIV23*/
#define RSTV091X_P1_KDIV23  0xf541
#define FSTV091X_P1_KDIV23_MANUAL  0xf5410080
#define FSTV091X_P1_K_DIVIDER_23  0xf541007f

/*P1_KDIV34*/
#define RSTV091X_P1_KDIV34  0xf542
#define FSTV091X_P1_KDIV34_MANUAL  0xf5420080
#define FSTV091X_P1_K_DIVIDER_34  0xf542007f

/*P1_KDIV56*/
#define RSTV091X_P1_KDIV56  0xf543
#define FSTV091X_P1_KDIV56_MANUAL  0xf5430080
#define FSTV091X_P1_K_DIVIDER_56  0xf543007f

/*P1_KDIV67*/
#define RSTV091X_P1_KDIV67  0xf544
#define FSTV091X_P1_KDIV67_MANUAL  0xf5440080
#define FSTV091X_P1_K_DIVIDER_67  0xf544007f

/*P1_KDIV78*/
#define RSTV091X_P1_KDIV78  0xf545
#define FSTV091X_P1_KDIV78_MANUAL  0xf5450080
#define FSTV091X_P1_K_DIVIDER_78  0xf545007f

/* P1_TSPIDFLT1 */
#define RSTV091X_P1_TSPIDFLT1  0xf546
#define FSTV091X_P1_PIDFLT_ADDR  0xf54600ff

/* P1_TSPIDFLT0 */
#define RSTV091X_P1_TSPIDFLT0  0xf547
#define FSTV091X_P1_PIDFLT_DATA  0xf54700ff

/*P1_PDELCTRL0*/
#define RSTV091X_P1_PDELCTRL0  0xf54f
#define FSTV091X_P1_ISIOBS_MODE  0xf54f0030
#define FSTV091X_P1_PDELDIS_BITWISE  0xf54f0004

/*P1_PDELCTRL1*/
#define RSTV091X_P1_PDELCTRL1  0xf550
#define FSTV091X_P1_INV_MISMASK  0xf5500080
#define FSTV091X_P1_FORCE_ACCEPTED  0xf5500040
#define FSTV091X_P1_FILTER_EN  0xf5500020
#define FSTV091X_P1_FORCE_PKTDELINUSE  0xf5500010
#define FSTV091X_P1_HYSTEN  0xf5500008
#define FSTV091X_P1_HYSTSWRST  0xf5500004
#define FSTV091X_P1_EN_MIS00  0xf5500002
#define FSTV091X_P1_ALGOSWRST  0xf5500001

/*P1_PDELCTRL2*/
#define RSTV091X_P1_PDELCTRL2  0xf551
#define FSTV091X_P1_FORCE_CONTINUOUS  0xf5510080
#define FSTV091X_P1_RESET_UPKO_COUNT  0xf5510040
#define FSTV091X_P1_USER_PKTDELIN_NB  0xf5510020
#define FSTV091X_P1_DATA_UNBBSCRAMBLED  0xf5510008
#define FSTV091X_P1_FORCE_LONGPKT  0xf5510004
#define FSTV091X_P1_FRAME_MODE  0xf5510002

/*P1_HYSTTHRESH*/
#define RSTV091X_P1_HYSTTHRESH  0xf554
#define FSTV091X_P1_DELIN_LOCKTHRES  0xf55400f0
#define FSTV091X_P1_DELIN_UNLOCKTHRES  0xf554000f

/*P1_ISIENTRY*/
#define RSTV091X_P1_ISIENTRY  0xf55e
#define FSTV091X_P1_ISI_ENTRY  0xf55e00ff

/*P1_ISIBITENA*/
#define RSTV091X_P1_ISIBITENA  0xf55f
#define FSTV091X_P1_ISI_BIT_EN  0xf55f00ff

/*P1_MATSTR1*/
#define RSTV091X_P1_MATSTR1  0xf560
#define FSTV091X_P1_MATYPE_CURRENT1  0xf56000ff

/*P1_MATSTR0*/
#define RSTV091X_P1_MATSTR0  0xf561
#define FSTV091X_P1_MATYPE_CURRENT0  0xf56100ff

/*P1_UPLSTR1*/
#define RSTV091X_P1_UPLSTR1  0xf562
#define FSTV091X_P1_UPL_CURRENT1  0xf56200ff

/*P1_UPLSTR0*/
#define RSTV091X_P1_UPLSTR0  0xf563
#define FSTV091X_P1_UPL_CURRENT0  0xf56300ff

/*P1_DFLSTR1*/
#define RSTV091X_P1_DFLSTR1  0xf564
#define FSTV091X_P1_DFL_CURRENT1  0xf56400ff

/*P1_DFLSTR0*/
#define RSTV091X_P1_DFLSTR0  0xf565
#define FSTV091X_P1_DFL_CURRENT0  0xf56500ff

/*P1_SYNCSTR*/
#define RSTV091X_P1_SYNCSTR  0xf566
#define FSTV091X_P1_SYNC_CURRENT  0xf56600ff

/*P1_SYNCDSTR1*/
#define RSTV091X_P1_SYNCDSTR1  0xf567
#define FSTV091X_P1_SYNCD_CURRENT1  0xf56700ff

/*P1_SYNCDSTR0*/
#define RSTV091X_P1_SYNCDSTR0  0xf568
#define FSTV091X_P1_SYNCD_CURRENT0  0xf56800ff

/*P1_PDELSTATUS1*/
#define RSTV091X_P1_PDELSTATUS1  0xf569
#define FSTV091X_P1_PKTDELIN_DELOCK  0xf5690080
#define FSTV091X_P1_SYNCDUPDFL_BADDFL  0xf5690040
#define FSTV091X_P1_CONTINUOUS_STREAM  0xf5690020
#define FSTV091X_P1_UNACCEPTED_STREAM  0xf5690010
#define FSTV091X_P1_BCH_ERROR_FLAG  0xf5690008
#define FSTV091X_P1_BBHCRCKO  0xf5690004
#define FSTV091X_P1_PKTDELIN_LOCK  0xf5690002
#define FSTV091X_P1_FIRST_LOCK  0xf5690001

/*P1_PDELSTATUS2*/
#define RSTV091X_P1_PDELSTATUS2  0xf56a
#define FSTV091X_P1_PKTDEL_DEMODSEL  0xf56a0080
#define FSTV091X_P1_FRAME_MODCOD  0xf56a007c
#define FSTV091X_P1_FRAME_TYPE  0xf56a0003

/*P1_BBFCRCKO1*/
#define RSTV091X_P1_BBFCRCKO1  0xf56b
#define FSTV091X_P1_BBHCRC_KOCNT1  0xf56b00ff

/*P1_BBFCRCKO0*/
#define RSTV091X_P1_BBFCRCKO0  0xf56c
#define FSTV091X_P1_BBHCRC_KOCNT0  0xf56c00ff

/*P1_UPCRCKO1*/
#define RSTV091X_P1_UPCRCKO1  0xf56d
#define FSTV091X_P1_PKTCRC_KOCNT1  0xf56d00ff

/*P1_UPCRCKO0*/
#define RSTV091X_P1_UPCRCKO0  0xf56e
#define FSTV091X_P1_PKTCRC_KOCNT0  0xf56e00ff

/*P1_PDELCTRL3*/
#define RSTV091X_P1_PDELCTRL3  0xf56f
#define FSTV091X_P1_PKTDEL_CONTFAIL  0xf56f0080
#define FSTV091X_P1_PKTDEL_ENLONGPKT  0xf56f0040
#define FSTV091X_P1_NOFIFO_BCHERR  0xf56f0020
#define FSTV091X_P1_PKTDELIN_DELACMERR  0xf56f0010
#define FSTV091X_P1_SATURATE_BBPKTKO  0xf56f0004
#define FSTV091X_P1_PKTDEL_BCHERRCONT  0xf56f0002
#define FSTV091X_P1_ETHERNET_DISFCS  0xf56f0001

/*P1_TSSTATEM*/
#define RSTV091X_P1_TSSTATEM  0xf570
#define FSTV091X_P1_TSDIL_ON  0xf5700080
#define FSTV091X_P1_TSSKIPRS_ON  0xf5700040
#define FSTV091X_P1_TSRS_ON  0xf5700020
#define FSTV091X_P1_TSDESCRAMB_ON  0xf5700010
#define FSTV091X_P1_TSFRAME_MODE  0xf5700008
#define FSTV091X_P1_TS_DISABLE  0xf5700004
#define FSTV091X_P1_TSACM_MODE  0xf5700002
#define FSTV091X_P1_TSOUT_NOSYNC  0xf5700001

/*P1_TSCFGH*/
#define RSTV091X_P1_TSCFGH  0xf572
#define FSTV091X_P1_TSFIFO_DVBCI  0xf5720080
#define FSTV091X_P1_TSFIFO_SERIAL  0xf5720040
#define FSTV091X_P1_TSFIFO_TEIUPDATE  0xf5720020
#define FSTV091X_P1_TSFIFO_DUTY50  0xf5720010
#define FSTV091X_P1_TSFIFO_HSGNLOUT  0xf5720008
#define FSTV091X_P1_TSFIFO_ERRMODE  0xf5720006
#define FSTV091X_P1_RST_HWARE  0xf5720001

/*P1_TSCFGM*/
#define RSTV091X_P1_TSCFGM  0xf573
#define FSTV091X_P1_TSFIFO_MANSPEED  0xf57300c0
#define FSTV091X_P1_TSFIFO_PERMDATA  0xf5730020
#define FSTV091X_P1_TSFIFO_NONEWSGNL  0xf5730010
#define FSTV091X_P1_NPD_SPECDVBS2  0xf5730004
#define FSTV091X_P1_TSFIFO_DPUNACTIVE  0xf5730002
#define FSTV091X_P1_TSFIFO_INVDATA  0xf5730001

/*P1_TSCFGL*/
#define RSTV091X_P1_TSCFGL  0xf574
#define FSTV091X_P1_TSFIFO_BCLKDEL1CK  0xf57400c0
#define FSTV091X_P1_BCHERROR_MODE  0xf5740030
#define FSTV091X_P1_TSFIFO_NSGNL2DATA  0xf5740008
#define FSTV091X_P1_TSFIFO_EMBINDVB  0xf5740004
#define FSTV091X_P1_TSFIFO_BITSPEED  0xf5740003

/*P1_TSINSDELH*/
#define RSTV091X_P1_TSINSDELH  0xf576
#define FSTV091X_P1_TSDEL_SYNCBYTE  0xf5760080
#define FSTV091X_P1_TSDEL_XXHEADER  0xf5760040
#define FSTV091X_P1_TSDEL_BBHEADER  0xf5760020
#define FSTV091X_P1_TSDEL_DATAFIELD  0xf5760010
#define FSTV091X_P1_TSINSDEL_ISCR  0xf5760008
#define FSTV091X_P1_TSINSDEL_NPD  0xf5760004
#define FSTV091X_P1_TSINSDEL_RSPARITY  0xf5760002
#define FSTV091X_P1_TSINSDEL_CRC8  0xf5760001

/*P1_TSDIVN*/
#define RSTV091X_P1_TSDIVN  0xf579
#define FSTV091X_P1_TSFIFO_SPEEDMODE  0xf57900c0
#define FSTV091X_P1_BYTE_OVERSAMPLING  0xf5790038
#define FSTV091X_P1_TSFIFO_RISEOK  0xf5790007

/*P1_TSCFG4*/
#define RSTV091X_P1_TSCFG4  0xf57a
#define FSTV091X_P1_TSFIFO_TSSPEEDMODE  0xf57a00c0
#define FSTV091X_P1_TSFIFO_HIERSEL  0xf57a0020
#define FSTV091X_P1_TSFIFO_SPECTOKEN  0xf57a0010
#define FSTV091X_P1_TSFIFO_MAXMODE  0xf57a0008
#define FSTV091X_P1_TSFIFO_FRFORCEPKT  0xf57a0004
#define FSTV091X_P1_EXT_FECSPYIN  0xf57a0002
#define FSTV091X_P1_TSFIFO_DELSPEEDUP  0xf57a0001

/*P1_TSSPEED*/
#define RSTV091X_P1_TSSPEED  0xf580
#define FSTV091X_P1_TSFIFO_OUTSPEED  0xf58000ff

/*P1_TSSTATUS*/
#define RSTV091X_P1_TSSTATUS  0xf581
#define FSTV091X_P1_TSFIFO_LINEOK  0xf5810080
#define FSTV091X_P1_TSFIFO_ERROR  0xf5810040
#define FSTV091X_P1_TSFIFO_DATA7  0xf5810020
#define FSTV091X_P1_TSFIFO_NOSYNC  0xf5810010
#define FSTV091X_P1_ISCR_INITIALIZED  0xf5810008
#define FSTV091X_P1_TSREGUL_ERROR  0xf5810004
#define FSTV091X_P1_SOFFIFO_UNREGUL  0xf5810002
#define FSTV091X_P1_DIL_READY  0xf5810001

/*P1_TSSTATUS2*/
#define RSTV091X_P1_TSSTATUS2  0xf582
#define FSTV091X_P1_TSFIFO_DEMODSEL  0xf5820080
#define FSTV091X_P1_TSFIFOSPEED_STORE  0xf5820040
#define FSTV091X_P1_DILXX_RESET  0xf5820020
#define FSTV091X_P1_TSSPEED_IMPOSSIBLE  0xf5820010
#define FSTV091X_P1_TSFIFO_LINENOK  0xf5820008
#define FSTV091X_P1_TSFIFO_MUXSTREAM  0xf5820004
#define FSTV091X_P1_SCRAMBDETECT  0xf5820002
#define FSTV091X_P1_ULDTV67_FALSELOCK  0xf5820001

/*P1_TSBITRATE1*/
#define RSTV091X_P1_TSBITRATE1  0xf583
#define FSTV091X_P1_TSFIFO_BITRATE1  0xf58300ff

/*P1_TSBITRATE0*/
#define RSTV091X_P1_TSBITRATE0  0xf584
#define FSTV091X_P1_TSFIFO_BITRATE0  0xf58400ff

/*P1_ERRCTRL1*/
#define RSTV091X_P1_ERRCTRL1  0xf598
#define FSTV091X_P1_ERR_SOURCE1  0xf59800f0
#define FSTV091X_P1_NUM_EVENT1  0xf5980007

/*P1_ERRCNT12*/
#define RSTV091X_P1_ERRCNT12  0xf599
#define FSTV091X_P1_ERRCNT1_OLDVALUE  0xf5990080
#define FSTV091X_P1_ERR_CNT12  0xf599007f

/*P1_ERRCNT11*/
#define RSTV091X_P1_ERRCNT11  0xf59a
#define FSTV091X_P1_ERR_CNT11  0xf59a00ff

/*P1_ERRCNT10*/
#define RSTV091X_P1_ERRCNT10  0xf59b
#define FSTV091X_P1_ERR_CNT10  0xf59b00ff

/*P1_ERRCTRL2*/
#define RSTV091X_P1_ERRCTRL2  0xf59c
#define FSTV091X_P1_ERR_SOURCE2  0xf59c00f0
#define FSTV091X_P1_NUM_EVENT2  0xf59c0007

/*P1_ERRCNT22*/
#define RSTV091X_P1_ERRCNT22  0xf59d
#define FSTV091X_P1_ERRCNT2_OLDVALUE  0xf59d0080
#define FSTV091X_P1_ERR_CNT22  0xf59d007f

/*P1_ERRCNT21*/
#define RSTV091X_P1_ERRCNT21  0xf59e
#define FSTV091X_P1_ERR_CNT21  0xf59e00ff

/*P1_ERRCNT20*/
#define RSTV091X_P1_ERRCNT20  0xf59f
#define FSTV091X_P1_ERR_CNT20  0xf59f00ff

/*P1_FECSPY*/
#define RSTV091X_P1_FECSPY  0xf5a0
#define FSTV091X_P1_SPY_ENABLE  0xf5a00080
#define FSTV091X_P1_NO_SYNCBYTE  0xf5a00040
#define FSTV091X_P1_SERIAL_MODE  0xf5a00020
#define FSTV091X_P1_UNUSUAL_PACKET  0xf5a00010
#define FSTV091X_P1_BERMETER_DATAMODE  0xf5a0000c
#define FSTV091X_P1_BERMETER_LMODE  0xf5a00002
#define FSTV091X_P1_BERMETER_RESET  0xf5a00001

/*P1_FSPYCFG*/
#define RSTV091X_P1_FSPYCFG  0xf5a1
#define FSTV091X_P1_FECSPY_INPUT  0xf5a100c0
#define FSTV091X_P1_RST_ON_ERROR  0xf5a10020
#define FSTV091X_P1_ONE_SHOT  0xf5a10010
#define FSTV091X_P1_I2C_MODE  0xf5a1000c
#define FSTV091X_P1_SPY_HYSTERESIS  0xf5a10003

/*P1_FSPYDATA*/
#define RSTV091X_P1_FSPYDATA  0xf5a2
#define FSTV091X_P1_SPY_STUFFING  0xf5a20080
#define FSTV091X_P1_NOERROR_PKTJITTER  0xf5a20040
#define FSTV091X_P1_SPY_CNULLPKT  0xf5a20020
#define FSTV091X_P1_SPY_OUTDATA_MODE  0xf5a2001f

/*P1_FSPYOUT*/
#define RSTV091X_P1_FSPYOUT  0xf5a3
#define FSTV091X_P1_FSPY_DIRECT  0xf5a30080
#define FSTV091X_P1_SPY_OUTDATA_BUS  0xf5a30038
#define FSTV091X_P1_STUFF_MODE  0xf5a30007

/*P1_FSTATUS*/
#define RSTV091X_P1_FSTATUS  0xf5a4
#define FSTV091X_P1_SPY_ENDSIM  0xf5a40080
#define FSTV091X_P1_VALID_SIM  0xf5a40040
#define FSTV091X_P1_FOUND_SIGNAL  0xf5a40020
#define FSTV091X_P1_DSS_SYNCBYTE  0xf5a40010
#define FSTV091X_P1_RESULT_STATE  0xf5a4000f

/*P1_FBERCPT4*/
#define RSTV091X_P1_FBERCPT4  0xf5a8
#define FSTV091X_P1_FBERMETER_CPT4  0xf5a800ff

/*P1_FBERCPT3*/
#define RSTV091X_P1_FBERCPT3  0xf5a9
#define FSTV091X_P1_FBERMETER_CPT3  0xf5a900ff

/*P1_FBERCPT2*/
#define RSTV091X_P1_FBERCPT2  0xf5aa
#define FSTV091X_P1_FBERMETER_CPT2  0xf5aa00ff

/*P1_FBERCPT1*/
#define RSTV091X_P1_FBERCPT1  0xf5ab
#define FSTV091X_P1_FBERMETER_CPT1  0xf5ab00ff

/*P1_FBERCPT0*/
#define RSTV091X_P1_FBERCPT0  0xf5ac
#define FSTV091X_P1_FBERMETER_CPT0  0xf5ac00ff

/*P1_FBERERR2*/
#define RSTV091X_P1_FBERERR2  0xf5ad
#define FSTV091X_P1_FBERMETER_ERR2  0xf5ad00ff

/*P1_FBERERR1*/
#define RSTV091X_P1_FBERERR1  0xf5ae
#define FSTV091X_P1_FBERMETER_ERR1  0xf5ae00ff

/*P1_FBERERR0*/
#define RSTV091X_P1_FBERERR0  0xf5af
#define FSTV091X_P1_FBERMETER_ERR0  0xf5af00ff

/*P1_FSPYBER*/
#define RSTV091X_P1_FSPYBER  0xf5b2
#define FSTV091X_P1_FSPYOBS_XORREAD  0xf5b20040
#define FSTV091X_P1_FSPYBER_OBSMODE  0xf5b20020
#define FSTV091X_P1_FSPYBER_SYNCBYTE  0xf5b20010
#define FSTV091X_P1_FSPYBER_UNSYNC  0xf5b20008
#define FSTV091X_P1_FSPYBER_CTIME  0xf5b20007

/*P1_SFERROR*/
#define RSTV091X_P1_SFERROR  0xf5c1
#define FSTV091X_P1_SFEC_REGERR_VIT  0xf5c100ff

/*P1_SFECSTATUS*/
#define RSTV091X_P1_SFECSTATUS  0xf5c3
#define FSTV091X_P1_SFEC_ON  0xf5c30080
#define FSTV091X_P1_SFEC_OFF  0xf5c30040
#define FSTV091X_P1_LOCKEDSFEC  0xf5c30008
#define FSTV091X_P1_SFEC_DELOCK  0xf5c30004
#define FSTV091X_P1_SFEC_DEMODSEL  0xf5c30002
#define FSTV091X_P1_SFEC_OVFON  0xf5c30001

/*P1_SFKDIV12*/
#define RSTV091X_P1_SFKDIV12  0xf5c4
#define FSTV091X_P1_SFECKDIV12_MAN  0xf5c40080
#define FSTV091X_P1_SFEC_K_DIVIDER_12  0xf5c4007f

/*P1_SFKDIV23*/
#define RSTV091X_P1_SFKDIV23  0xf5c5
#define FSTV091X_P1_SFECKDIV23_MAN  0xf5c50080
#define FSTV091X_P1_SFEC_K_DIVIDER_23  0xf5c5007f

/*P1_SFKDIV34*/
#define RSTV091X_P1_SFKDIV34  0xf5c6
#define FSTV091X_P1_SFECKDIV34_MAN  0xf5c60080
#define FSTV091X_P1_SFEC_K_DIVIDER_34  0xf5c6007f

/*P1_SFKDIV56*/
#define RSTV091X_P1_SFKDIV56  0xf5c7
#define FSTV091X_P1_SFECKDIV56_MAN  0xf5c70080
#define FSTV091X_P1_SFEC_K_DIVIDER_56  0xf5c7007f

/*P1_SFKDIV67*/
#define RSTV091X_P1_SFKDIV67  0xf5c8
#define FSTV091X_P1_SFECKDIV67_MAN  0xf5c80080
#define FSTV091X_P1_SFEC_K_DIVIDER_67  0xf5c8007f

/*P1_SFKDIV78*/
#define RSTV091X_P1_SFKDIV78  0xf5c9
#define FSTV091X_P1_SFECKDIV78_MAN  0xf5c90080
#define FSTV091X_P1_SFEC_K_DIVIDER_78  0xf5c9007f

/*P1_SFSTATUS*/
#define RSTV091X_P1_SFSTATUS  0xf5cc
#define FSTV091X_P1_SFEC_LINEOK  0xf5cc0080
#define FSTV091X_P1_SFEC_ERROR  0xf5cc0040
#define FSTV091X_P1_SFEC_DATA7  0xf5cc0020
#define FSTV091X_P1_SFEC_PKTDNBRFAIL  0xf5cc0010
#define FSTV091X_P1_TSSFEC_DEMODSEL  0xf5cc0008
#define FSTV091X_P1_SFEC_NOSYNC  0xf5cc0004
#define FSTV091X_P1_SFEC_UNREGULA  0xf5cc0002
#define FSTV091X_P1_SFEC_READY  0xf5cc0001

/*P1_SFDLYSET2*/
#define RSTV091X_P1_SFDLYSET2  0xf5d0
#define FSTV091X_P1_SFEC_OFFSET  0xf5d000c0
#define FSTV091X_P1_RST_SFEC  0xf5d00008
#define FSTV091X_P1_DILDLINE_ERROR  0xf5d00004
#define FSTV091X_P1_SFEC_DISABLE  0xf5d00002
#define FSTV091X_P1_SFEC_UNREGUL  0xf5d00001

/*P1_SFERRCTRL*/
#define RSTV091X_P1_SFERRCTRL  0xf5d8
#define FSTV091X_P1_SFEC_ERR_SOURCE  0xf5d800f0
#define FSTV091X_P1_SFEC_NUM_EVENT  0xf5d80007

/*P1_SFERRCNT2*/
#define RSTV091X_P1_SFERRCNT2  0xf5d9
#define FSTV091X_P1_SFERRC_OLDVALUE  0xf5d90080
#define FSTV091X_P1_SFEC_ERR_CNT2  0xf5d9007f

/*P1_SFERRCNT1*/
#define RSTV091X_P1_SFERRCNT1  0xf5da
#define FSTV091X_P1_SFEC_ERR_CNT1  0xf5da00ff

/*P1_SFERRCNT0*/
#define RSTV091X_P1_SFERRCNT0  0xf5db
#define FSTV091X_P1_SFEC_ERR_CNT0  0xf5db00ff

/*TSGENERAL*/
#define RSTV091X_TSGENERAL  0xf630
#define FSTV091X_EN_LGNERROR  0xf6300080
#define FSTV091X_TSFIFO_DISTS2PAR  0xf6300040
#define FSTV091X_MUXSTREAM_COMPMOSE  0xf6300030
#define FSTV091X_MUXSTREAM_OUTMODE  0xf6300008
#define FSTV091X_TSFIFO_PERMPARAL  0xf6300006
#define FSTV091X_RST_REEDSOLO  0xf6300001

/*P1_DISIRQCFG*/
#define RSTV091X_P1_DISIRQCFG  0xf700
#define FSTV091X_P1_ENRXEND  0xf7000040
#define FSTV091X_P1_ENRXFIFO8B  0xf7000020
#define FSTV091X_P1_ENTRFINISH  0xf7000010
#define FSTV091X_P1_ENTIMEOUT  0xf7000008
#define FSTV091X_P1_ENTXEND  0xf7000004
#define FSTV091X_P1_ENTXFIFO64B  0xf7000002
#define FSTV091X_P1_ENGAPBURST  0xf7000001

/*P1_DISIRQSTAT*/
#define RSTV091X_P1_DISIRQSTAT  0xf701
#define FSTV091X_P1_IRQRXEND  0xf7010040
#define FSTV091X_P1_IRQRXFIFO8B  0xf7010020
#define FSTV091X_P1_IRQTRFINISH  0xf7010010
#define FSTV091X_P1_IRQTIMEOUT  0xf7010008
#define FSTV091X_P1_IRQTXEND  0xf7010004
#define FSTV091X_P1_IRQTXFIFO64B  0xf7010002
#define FSTV091X_P1_IRQGAPBURST  0xf7010001

/*P1_DISTXCFG*/
#define RSTV091X_P1_DISTXCFG  0xf702
#define FSTV091X_P1_DISTX_RESET  0xf7020080
#define FSTV091X_P1_TIM_OFF  0xf7020040
#define FSTV091X_P1_TIM_CMD  0xf7020030
#define FSTV091X_P1_ENVELOP  0xf7020008
#define FSTV091X_P1_DIS_PRECHARGE  0xf7020004
#define FSTV091X_P1_DISEQC_MODE  0xf7020003

/*P1_DISTXSTATUS*/
#define RSTV091X_P1_DISTXSTATUS  0xf703
#define FSTV091X_P1_TX_FIFO_FULL  0xf7030040
#define FSTV091X_P1_TX_IDLE  0xf7030020
#define FSTV091X_P1_GAP_BURST  0xf7030010
#define FSTV091X_P1_TX_FIFO64B  0xf7030008
#define FSTV091X_P1_TX_END  0xf7030004
#define FSTV091X_P1_TR_TIMEOUT  0xf7030002
#define FSTV091X_P1_TR_FINISH  0xf7030001

/*P1_DISTXBYTES*/
#define RSTV091X_P1_DISTXBYTES  0xf704
#define FSTV091X_P1_TXFIFO_BYTES  0xf70400ff

/*P1_DISTXFIFO*/
#define RSTV091X_P1_DISTXFIFO  0xf705
#define FSTV091X_P1_DISEQC_TX_FIFO  0xf70500ff

/*P1_DISTXF22*/
#define RSTV091X_P1_DISTXF22  0xf706
#define FSTV091X_P1_F22TX  0xf70600ff

/*P1_DISTIMEOCFG*/
#define RSTV091X_P1_DISTIMEOCFG  0xf708
#define FSTV091X_P1_RXCHOICE  0xf7080006
#define FSTV091X_P1_TIMEOUT_OFF  0xf7080001

/*P1_DISTIMEOUT*/
#define RSTV091X_P1_DISTIMEOUT  0xf709
#define FSTV091X_P1_TIMEOUT_COUNT  0xf70900ff

/*P1_DISRXCFG*/
#define RSTV091X_P1_DISRXCFG  0xf70a
#define FSTV091X_P1_DISRX_RESET  0xf70a0080
#define FSTV091X_P1_EXTENVELOP  0xf70a0040
#define FSTV091X_P1_PINSELECT  0xf70a0038
#define FSTV091X_P1_IGNORE_SHORT22K  0xf70a0004
#define FSTV091X_P1_SIGNED_RXIN  0xf70a0002
#define FSTV091X_P1_DISRX_ON  0xf70a0001

/*P1_DISRXSTAT1*/
#define RSTV091X_P1_DISRXSTAT1  0xf70b
#define FSTV091X_P1_RXEND  0xf70b0080
#define FSTV091X_P1_RXACTIVE  0xf70b0040
#define FSTV091X_P1_RXDETECT  0xf70b0020
#define FSTV091X_P1_CONTTONE  0xf70b0010
#define FSTV091X_P1_8BFIFOREADY  0xf70b0008
#define FSTV091X_P1_FIFOEMPTY  0xf70b0004

/*P1_DISRXSTAT0*/
#define RSTV091X_P1_DISRXSTAT0  0xf70c
#define FSTV091X_P1_RXFAIL  0xf70c0080
#define FSTV091X_P1_FIFOPFAIL  0xf70c0040
#define FSTV091X_P1_RXNONBYTE  0xf70c0020
#define FSTV091X_P1_FIFOOVF  0xf70c0010
#define FSTV091X_P1_SHORT22K  0xf70c0008
#define FSTV091X_P1_RXMSGLOST  0xf70c0004

/*P1_DISRXBYTES*/
#define RSTV091X_P1_DISRXBYTES  0xf70d
#define FSTV091X_P1_RXFIFO_BYTES  0xf70d001f

/*P1_DISRXPARITY1*/
#define RSTV091X_P1_DISRXPARITY1  0xf70e
#define FSTV091X_P1_DISRX_PARITY1  0xf70e00ff

/*P1_DISRXPARITY0*/
#define RSTV091X_P1_DISRXPARITY0  0xf70f
#define FSTV091X_P1_DISRX_PARITY0  0xf70f00ff

/*P1_DISRXFIFO*/
#define RSTV091X_P1_DISRXFIFO  0xf710
#define FSTV091X_P1_DISEQC_RX_FIFO  0xf71000ff

/*P1_DISRXDC1*/
#define RSTV091X_P1_DISRXDC1  0xf711
#define FSTV091X_P1_DC_VALUE1  0xf7110103

/*P1_DISRXDC0*/
#define RSTV091X_P1_DISRXDC0  0xf712
#define FSTV091X_P1_DC_VALUE0  0xf71200ff

/*P1_DISRXF221*/
#define RSTV091X_P1_DISRXF221  0xf714
#define FSTV091X_P1_F22RX1  0xf714000f

/*P1_DISRXF220*/
#define RSTV091X_P1_DISRXF220  0xf715
#define FSTV091X_P1_F22RX0  0xf71500ff

/*P1_DISRXF100*/
#define RSTV091X_P1_DISRXF100  0xf716
#define FSTV091X_P1_F100RX  0xf71600ff

/*P1_DISRXSHORT22K*/
#define RSTV091X_P1_DISRXSHORT22K  0xf71c
#define FSTV091X_P1_SHORT22K_LENGTH  0xf71c001f

/*P1_ACRPRESC*/
#define RSTV091X_P1_ACRPRESC  0xf71e
#define FSTV091X_P1_ACR_CODFRDY  0xf71e0008
#define FSTV091X_P1_ACR_PRESC  0xf71e0007

/*P1_ACRDIV*/
#define RSTV091X_P1_ACRDIV  0xf71f
#define FSTV091X_P1_ACR_DIV  0xf71f00ff

/*P2_DISIRQCFG*/
#define RSTV091X_P2_DISIRQCFG  0xf740
#define FSTV091X_P2_ENRXEND  0xf7400040
#define FSTV091X_P2_ENRXFIFO8B  0xf7400020
#define FSTV091X_P2_ENTRFINISH  0xf7400010
#define FSTV091X_P2_ENTIMEOUT  0xf7400008
#define FSTV091X_P2_ENTXEND  0xf7400004
#define FSTV091X_P2_ENTXFIFO64B  0xf7400002
#define FSTV091X_P2_ENGAPBURST  0xf7400001

/*P2_DISIRQSTAT*/
#define RSTV091X_P2_DISIRQSTAT  0xf741
#define FSTV091X_P2_IRQRXEND  0xf7410040
#define FSTV091X_P2_IRQRXFIFO8B  0xf7410020
#define FSTV091X_P2_IRQTRFINISH  0xf7410010
#define FSTV091X_P2_IRQTIMEOUT  0xf7410008
#define FSTV091X_P2_IRQTXEND  0xf7410004
#define FSTV091X_P2_IRQTXFIFO64B  0xf7410002
#define FSTV091X_P2_IRQGAPBURST  0xf7410001

/*P2_DISTXCFG*/
#define RSTV091X_P2_DISTXCFG  0xf742
#define FSTV091X_P2_DISTX_RESET  0xf7420080
#define FSTV091X_P2_TIM_OFF  0xf7420040
#define FSTV091X_P2_TIM_CMD  0xf7420030
#define FSTV091X_P2_ENVELOP  0xf7420008
#define FSTV091X_P2_DIS_PRECHARGE  0xf7420004
#define FSTV091X_P2_DISEQC_MODE  0xf7420003

/*P2_DISTXSTATUS*/
#define RSTV091X_P2_DISTXSTATUS  0xf743
#define FSTV091X_P2_TX_FIFO_FULL  0xf7430040
#define FSTV091X_P2_TX_IDLE  0xf7430020
#define FSTV091X_P2_GAP_BURST  0xf7430010
#define FSTV091X_P2_TX_FIFO64B  0xf7430008
#define FSTV091X_P2_TX_END  0xf7430004
#define FSTV091X_P2_TR_TIMEOUT  0xf7430002
#define FSTV091X_P2_TR_FINISH  0xf7430001

/*P2_DISTXBYTES*/
#define RSTV091X_P2_DISTXBYTES  0xf744
#define FSTV091X_P2_TXFIFO_BYTES  0xf74400ff

/*P2_DISTXFIFO*/
#define RSTV091X_P2_DISTXFIFO  0xf745
#define FSTV091X_P2_DISEQC_TX_FIFO  0xf74500ff

/*P2_DISTXF22*/
#define RSTV091X_P2_DISTXF22  0xf746
#define FSTV091X_P2_F22TX  0xf74600ff

/*P2_DISTIMEOCFG*/
#define RSTV091X_P2_DISTIMEOCFG  0xf748
#define FSTV091X_P2_RXCHOICE  0xf7480006
#define FSTV091X_P2_TIMEOUT_OFF  0xf7480001

/*P2_DISTIMEOUT*/
#define RSTV091X_P2_DISTIMEOUT  0xf749
#define FSTV091X_P2_TIMEOUT_COUNT  0xf74900ff

/*P2_DISRXCFG*/
#define RSTV091X_P2_DISRXCFG  0xf74a
#define FSTV091X_P2_DISRX_RESET  0xf74a0080
#define FSTV091X_P2_EXTENVELOP  0xf74a0040
#define FSTV091X_P2_PINSELECT  0xf74a0038
#define FSTV091X_P2_IGNORE_SHORT22K  0xf74a0004
#define FSTV091X_P2_SIGNED_RXIN  0xf74a0002
#define FSTV091X_P2_DISRX_ON  0xf74a0001

/*P2_DISRXSTAT1*/
#define RSTV091X_P2_DISRXSTAT1  0xf74b
#define FSTV091X_P2_RXEND  0xf74b0080
#define FSTV091X_P2_RXACTIVE  0xf74b0040
#define FSTV091X_P2_RXDETECT  0xf74b0020
#define FSTV091X_P2_CONTTONE  0xf74b0010
#define FSTV091X_P2_8BFIFOREADY  0xf74b0008
#define FSTV091X_P2_FIFOEMPTY  0xf74b0004

/*P2_DISRXSTAT0*/
#define RSTV091X_P2_DISRXSTAT0  0xf74c
#define FSTV091X_P2_RXFAIL  0xf74c0080
#define FSTV091X_P2_FIFOPFAIL  0xf74c0040
#define FSTV091X_P2_RXNONBYTE  0xf74c0020
#define FSTV091X_P2_FIFOOVF  0xf74c0010
#define FSTV091X_P2_SHORT22K  0xf74c0008
#define FSTV091X_P2_RXMSGLOST  0xf74c0004

/*P2_DISRXBYTES*/
#define RSTV091X_P2_DISRXBYTES  0xf74d
#define FSTV091X_P2_RXFIFO_BYTES  0xf74d001f

/*P2_DISRXPARITY1*/
#define RSTV091X_P2_DISRXPARITY1  0xf74e
#define FSTV091X_P2_DISRX_PARITY1  0xf74e00ff

/*P2_DISRXPARITY0*/
#define RSTV091X_P2_DISRXPARITY0  0xf74f
#define FSTV091X_P2_DISRX_PARITY0  0xf74f00ff

/*P2_DISRXFIFO*/
#define RSTV091X_P2_DISRXFIFO  0xf750
#define FSTV091X_P2_DISEQC_RX_FIFO  0xf75000ff

/*P2_DISRXDC1*/
#define RSTV091X_P2_DISRXDC1  0xf751
#define FSTV091X_P2_DC_VALUE1  0xf7510103

/*P2_DISRXDC0*/
#define RSTV091X_P2_DISRXDC0  0xf752
#define FSTV091X_P2_DC_VALUE0  0xf75200ff

/*P2_DISRXF221*/
#define RSTV091X_P2_DISRXF221  0xf754
#define FSTV091X_P2_F22RX1  0xf754000f

/*P2_DISRXF220*/
#define RSTV091X_P2_DISRXF220  0xf755
#define FSTV091X_P2_F22RX0  0xf75500ff

/*P2_DISRXF100*/
#define RSTV091X_P2_DISRXF100  0xf756
#define FSTV091X_P2_F100RX  0xf75600ff

/*P2_DISRXSHORT22K*/
#define RSTV091X_P2_DISRXSHORT22K  0xf75c
#define FSTV091X_P2_SHORT22K_LENGTH  0xf75c001f

/*P2_ACRPRESC*/
#define RSTV091X_P2_ACRPRESC  0xf75e
#define FSTV091X_P2_ACR_CODFRDY  0xf75e0008
#define FSTV091X_P2_ACR_PRESC  0xf75e0007

/*P2_ACRDIV*/
#define RSTV091X_P2_ACRDIV  0xf75f
#define FSTV091X_P2_ACR_DIV  0xf75f00ff

/*P1_NBITER_NF4*/
#define RSTV091X_P1_NBITER_NF4  0xfa03
#define FSTV091X_P1_NBITER_NF_QPSK_1_2  0xfa0300ff

/*P1_NBITER_NF5*/
#define RSTV091X_P1_NBITER_NF5  0xfa04
#define FSTV091X_P1_NBITER_NF_QPSK_3_5  0xfa0400ff

/*P1_NBITER_NF6*/
#define RSTV091X_P1_NBITER_NF6  0xfa05
#define FSTV091X_P1_NBITER_NF_QPSK_2_3  0xfa0500ff

/*P1_NBITER_NF7*/
#define RSTV091X_P1_NBITER_NF7  0xfa06
#define FSTV091X_P1_NBITER_NF_QPSK_3_4  0xfa0600ff

/*P1_NBITER_NF8*/
#define RSTV091X_P1_NBITER_NF8  0xfa07
#define FSTV091X_P1_NBITER_NF_QPSK_4_5  0xfa0700ff

/*P1_NBITER_NF9*/
#define RSTV091X_P1_NBITER_NF9  0xfa08
#define FSTV091X_P1_NBITER_NF_QPSK_5_6  0xfa0800ff

/*P1_NBITER_NF10*/
#define RSTV091X_P1_NBITER_NF10  0xfa09
#define FSTV091X_P1_NBITER_NF_QPSK_8_9  0xfa0900ff

/*P1_NBITER_NF11*/
#define RSTV091X_P1_NBITER_NF11  0xfa0a
#define FSTV091X_P1_NBITER_NF_QPSK_9_10  0xfa0a00ff

/*P1_NBITER_NF12*/
#define RSTV091X_P1_NBITER_NF12  0xfa0b
#define FSTV091X_P1_NBITER_NF_8PSK_3_5  0xfa0b00ff

/*P1_NBITER_NF13*/
#define RSTV091X_P1_NBITER_NF13  0xfa0c
#define FSTV091X_P1_NBITER_NF_8PSK_2_3  0xfa0c00ff

/*P1_NBITER_NF14*/
#define RSTV091X_P1_NBITER_NF14  0xfa0d
#define FSTV091X_P1_NBITER_NF_8PSK_3_4  0xfa0d00ff

/*P1_NBITER_NF15*/
#define RSTV091X_P1_NBITER_NF15  0xfa0e
#define FSTV091X_P1_NBITER_NF_8PSK_5_6  0xfa0e00ff

/*P1_NBITER_NF16*/
#define RSTV091X_P1_NBITER_NF16  0xfa0f
#define FSTV091X_P1_NBITER_NF_8PSK_8_9  0xfa0f00ff

/*P1_NBITER_NF17*/
#define RSTV091X_P1_NBITER_NF17  0xfa10
#define FSTV091X_P1_NBITER_NF_8PSK_9_10  0xfa1000ff

/*GAINLLR_NF4*/
#define RSTV091X_GAINLLR_NF4  0xfa43
#define FSTV091X_GAINLLR_NF_QPSK_1_2  0xfa43007f

/*GAINLLR_NF5*/
#define RSTV091X_GAINLLR_NF5  0xfa44
#define FSTV091X_GAINLLR_NF_QPSK_3_5  0xfa44007f

/*GAINLLR_NF6*/
#define RSTV091X_GAINLLR_NF6  0xfa45
#define FSTV091X_GAINLLR_NF_QPSK_2_3  0xfa45007f

/*GAINLLR_NF7*/
#define RSTV091X_GAINLLR_NF7  0xfa46
#define FSTV091X_GAINLLR_NF_QPSK_3_4  0xfa46007f

/*GAINLLR_NF8*/
#define RSTV091X_GAINLLR_NF8  0xfa47
#define FSTV091X_GAINLLR_NF_QPSK_4_5  0xfa47007f

/*GAINLLR_NF9*/
#define RSTV091X_GAINLLR_NF9  0xfa48
#define FSTV091X_GAINLLR_NF_QPSK_5_6  0xfa48007f

/*GAINLLR_NF10*/
#define RSTV091X_GAINLLR_NF10  0xfa49
#define FSTV091X_GAINLLR_NF_QPSK_8_9  0xfa49007f

/*GAINLLR_NF11*/
#define RSTV091X_GAINLLR_NF11  0xfa4a
#define FSTV091X_GAINLLR_NF_QPSK_9_10  0xfa4a007f

/*GAINLLR_NF12*/
#define RSTV091X_GAINLLR_NF12  0xfa4b
#define FSTV091X_GAINLLR_NF_8PSK_3_5  0xfa4b007f

/*GAINLLR_NF13*/
#define RSTV091X_GAINLLR_NF13  0xfa4c
#define FSTV091X_GAINLLR_NF_8PSK_2_3  0xfa4c007f

/*GAINLLR_NF14*/
#define RSTV091X_GAINLLR_NF14  0xfa4d
#define FSTV091X_GAINLLR_NF_8PSK_3_4  0xfa4d007f

/*GAINLLR_NF15*/
#define RSTV091X_GAINLLR_NF15  0xfa4e
#define FSTV091X_GAINLLR_NF_8PSK_5_6  0xfa4e007f

/*GAINLLR_NF16*/
#define RSTV091X_GAINLLR_NF16  0xfa4f
#define FSTV091X_GAINLLR_NF_8PSK_8_9  0xfa4f007f

/*GAINLLR_NF17*/
#define RSTV091X_GAINLLR_NF17  0xfa50
#define FSTV091X_GAINLLR_NF_8PSK_9_10  0xfa50007f

/*CFGEXT*/
#define RSTV091X_CFGEXT  0xfa80
#define FSTV091X_BYPFIFOBCH  0xfa800080
#define FSTV091X_BYPBCH  0xfa800040
#define FSTV091X_BYPLDPC  0xfa800020
#define FSTV091X_BYPFIFOBCHF  0xfa800010
#define FSTV091X_INVLLRSIGN  0xfa800008
#define FSTV091X_SHORTMULT  0xfa800004
#define FSTV091X_ENSTOPDEC  0xfa800002

/*GENCFG*/
#define RSTV091X_GENCFG  0xfa86
#define FSTV091X_LEG_ITER  0xfa860040
#define FSTV091X_NOSHFRD1  0xfa860020
#define FSTV091X_BROADCAST  0xfa860010
#define FSTV091X_NOSHFRD2  0xfa860008
#define FSTV091X_BCHERRFLAG  0xfa860004
#define FSTV091X_CROSSINPUT  0xfa860002
#define FSTV091X_DDEMOD  0xfa860001

/*LDPCERR1*/
#define RSTV091X_LDPCERR1  0xfa96
#define FSTV091X_LDPC_ERRORS1  0xfa9600ff

/*LDPCERR0*/
#define RSTV091X_LDPCERR0  0xfa97
#define FSTV091X_LDPC_ERRORS0  0xfa9700ff

/*BCHERR*/
#define RSTV091X_BCHERR  0xfa98
#define FSTV091X_ERRORFLAG  0xfa980010
#define FSTV091X_BCH_ERRORS_COUNTER  0xfa98000f

/*P1_MAXEXTRAITER*/
#define RSTV091X_P1_MAXEXTRAITER  0xfab1
#define FSTV091X_P1_MAX_EXTRA_ITER  0xfab100ff

/*P2_MAXEXTRAITER*/
#define RSTV091X_P2_MAXEXTRAITER  0xfab6
#define FSTV091X_P2_MAX_EXTRA_ITER  0xfab600ff

/*P1_STATUSITER*/
#define RSTV091X_P1_STATUSITER  0xfabc
#define FSTV091X_P1_STATUS_ITER  0xfabc00ff

/*P1_STATUSMAXITER*/
#define RSTV091X_P1_STATUSMAXITER  0xfabd
#define FSTV091X_P1_STATUS_MAX_ITER  0xfabd00ff

/*P2_STATUSITER*/
#define RSTV091X_P2_STATUSITER  0xfabe
#define FSTV091X_P2_STATUS_ITER  0xfabe00ff

/*P2_STATUSMAXITER*/
#define RSTV091X_P2_STATUSMAXITER  0xfabf
#define FSTV091X_P2_STATUS_MAX_ITER  0xfabf00ff

/*P2_NBITER_NF4*/
#define RSTV091X_P2_NBITER_NF4  0xfac3
#define FSTV091X_P2_NBITER_NF_QPSK_1_2  0xfac300ff

/*P2_NBITER_NF5*/
#define RSTV091X_P2_NBITER_NF5  0xfac4
#define FSTV091X_P2_NBITER_NF_QPSK_3_5  0xfac400ff

/*P2_NBITER_NF6*/
#define RSTV091X_P2_NBITER_NF6  0xfac5
#define FSTV091X_P2_NBITER_NF_QPSK_2_3  0xfac500ff

/*P2_NBITER_NF7*/
#define RSTV091X_P2_NBITER_NF7  0xfac6
#define FSTV091X_P2_NBITER_NF_QPSK_3_4  0xfac600ff

/*P2_NBITER_NF8*/
#define RSTV091X_P2_NBITER_NF8  0xfac7
#define FSTV091X_P2_NBITER_NF_QPSK_4_5  0xfac700ff

/*P2_NBITER_NF9*/
#define RSTV091X_P2_NBITER_NF9  0xfac8
#define FSTV091X_P2_NBITER_NF_QPSK_5_6  0xfac800ff

/*P2_NBITER_NF10*/
#define RSTV091X_P2_NBITER_NF10  0xfac9
#define FSTV091X_P2_NBITER_NF_QPSK_8_9  0xfac900ff

/*P2_NBITER_NF11*/
#define RSTV091X_P2_NBITER_NF11  0xfaca
#define FSTV091X_P2_NBITER_NF_QPSK_9_10  0xfaca00ff

/*P2_NBITER_NF12*/
#define RSTV091X_P2_NBITER_NF12  0xfacb
#define FSTV091X_P2_NBITER_NF_8PSK_3_5  0xfacb00ff

/*P2_NBITER_NF13*/
#define RSTV091X_P2_NBITER_NF13  0xfacc
#define FSTV091X_P2_NBITER_NF_8PSK_2_3  0xfacc00ff

/*P2_NBITER_NF14*/
#define RSTV091X_P2_NBITER_NF14  0xfacd
#define FSTV091X_P2_NBITER_NF_8PSK_3_4  0xfacd00ff

/*P2_NBITER_NF15*/
#define RSTV091X_P2_NBITER_NF15  0xface
#define FSTV091X_P2_NBITER_NF_8PSK_5_6  0xface00ff

/*P2_NBITER_NF16*/
#define RSTV091X_P2_NBITER_NF16  0xfacf
#define FSTV091X_P2_NBITER_NF_8PSK_8_9  0xfacf00ff

/*P2_NBITER_NF17*/
#define RSTV091X_P2_NBITER_NF17  0xfad0
#define FSTV091X_P2_NBITER_NF_8PSK_9_10  0xfad000ff

/*TSTRES0*/
#define RSTV091X_TSTRES0  0xff11
#define FSTV091X_FRESFEC  0xff110080
#define FSTV091X_FRESTS  0xff110040
#define FSTV091X_FRESVIT1  0xff110020
#define FSTV091X_FRESVIT2  0xff110010
#define FSTV091X_FRESSYM1  0xff110008
#define FSTV091X_FRESSYM2  0xff110004
#define FSTV091X_FRESMAS  0xff110002
#define FSTV091X_FRESINT  0xff110001

/*P2_TCTL4*/
#define RSTV091X_P2_TCTL4  0xff28
#define FSTV091X_P2_CFR2TOCFR1_DVBS1  0xff2800c0
#define FSTV091X_P2_TSTINV_PHERR  0xff280020
#define FSTV091X_P2_EN_PLHCALC  0xff280010
#define FSTV091X_P2_TETA3L_RSTTETA3D  0xff280008
#define FSTV091X_P2_DIS_FORCEBETA2  0xff280004
#define FSTV091X_P2_CAR3_NOTRACEBACK  0xff280002
#define FSTV091X_P2_CAR3_NOFORWARD  0xff280001

/*P1_TCTL4*/
#define RSTV091X_P1_TCTL4  0xff48
#define FSTV091X_P1_CFR2TOCFR1_DVBS1  0xff4800c0
#define FSTV091X_P1_TSTINV_PHERR  0xff480020
#define FSTV091X_P1_EN_PLHCALC  0xff480010
#define FSTV091X_P1_TETA3L_RSTTETA3D  0xff480008
#define FSTV091X_P1_DIS_FORCEBETA2  0xff480004
#define FSTV091X_P1_CAR3_NOTRACEBACK  0xff480002
#define FSTV091X_P1_CAR3_NOFORWARD  0xff480001

#define STV091X_NBREGS		735
#define STV091X_NBFIELDS		1776

#define STV091X_WRITE_REG(__state, __reg, __data)                         \
	(((__state)->nr == 0) ?                                           \
		stv091x_write_reg(__state, RSTV091X_P1_##__reg, __data) : \
		stv091x_write_reg(__state, RSTV091X_P2_##__reg, __data))

#define STV091X_WRITE_REGS(__state, __reg, __data, __count)                         \
	(((__state)->nr == 0) ?                                                     \
		stv091x_write_regs(__state, RSTV091X_P1_##__reg, __data, __count) : \
		stv091x_write_regs(__state, RSTV091X_P2_##__reg, __data, __count))

#define STV091X_READ_REG(__state, __reg)                         \
	(((__state)->nr == 0) ?                                          \
		stv091x_read_reg(__state, RSTV091X_P1_##__reg) : \
		stv091x_read_reg(__state, RSTV091X_P2_##__reg))

#define STV091X_READ_REGS(__state, __reg, __data, __count)                         \
	(((__state)->nr == 0) ?                                                    \
		stv091x_read_regs(__state, RSTV091X_P1_##__reg, __data, __count) : \
		stv091x_read_regs(__state, RSTV091X_P2_##__reg, __data, __count))

#define STV091X_WRITE_FIELD(__state, __reg, __data)                         \
	(((__state)->nr == 0) ?                                           \
		stv091x_write_field(__state, FSTV091X_P1_##__reg, __data) : \
		stv091x_write_field(__state, FSTV091X_P2_##__reg, __data))

#define STV091X_READ_FIELD(__state, __reg)                         \
	(((__state)->nr == 0) ?                                           \
		stv091x_read_field(__state, FSTV091X_P1_##__reg) : \
		stv091x_read_field(__state, FSTV091X_P2_##__reg))
