/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestContext;
import org.opensearch.common.annotation.InternalApi;

@InternalApi
public abstract class SearchRequestOperationsListener {
    private volatile boolean enabled;
    public static final SearchRequestOperationsListener NOOP = new SearchRequestOperationsListener(false){

        @Override
        protected void onPhaseStart(SearchPhaseContext context) {
        }

        @Override
        protected void onPhaseEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
        }

        @Override
        protected void onPhaseFailure(SearchPhaseContext context, Throwable cause) {
        }
    };

    protected SearchRequestOperationsListener() {
        this.enabled = true;
    }

    protected SearchRequestOperationsListener(boolean enabled) {
        this.enabled = enabled;
    }

    protected void onPhaseStart(SearchPhaseContext context) {
    }

    protected void onPhaseEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
    }

    protected void onPhaseFailure(SearchPhaseContext context, Throwable cause) {
    }

    protected void onRequestStart(SearchRequestContext searchRequestContext) {
    }

    protected void onRequestEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
    }

    protected void onRequestFailure(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
    }

    protected boolean isEnabled(SearchRequest searchRequest) {
        return this.isEnabled();
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    static final class CompositeListener
    extends SearchRequestOperationsListener {
        private final List<SearchRequestOperationsListener> listeners;
        private final Logger logger;

        CompositeListener(List<SearchRequestOperationsListener> listeners, Logger logger) {
            this.listeners = listeners;
            this.logger = logger;
        }

        @Override
        protected void onPhaseStart(SearchPhaseContext context) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onPhaseStart(context);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPhaseStart listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        protected void onPhaseEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onPhaseEnd(context, searchRequestContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPhaseEnd listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        protected void onPhaseFailure(SearchPhaseContext context, Throwable cause) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onPhaseFailure(context, cause);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPhaseFailure listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        protected void onRequestStart(SearchRequestContext searchRequestContext) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onRequestStart(searchRequestContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onRequestStart listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onRequestEnd(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onRequestEnd(context, searchRequestContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onRequestEnd listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onRequestFailure(SearchPhaseContext context, SearchRequestContext searchRequestContext) {
            for (SearchRequestOperationsListener listener : this.listeners) {
                try {
                    listener.onRequestFailure(context, searchRequestContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onRequestFailure listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        public List<SearchRequestOperationsListener> getListeners() {
            return this.listeners;
        }
    }
}

