/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.jcajce.provider.ErasableByteArrayOutputStream;

class WrappedByteArrayOutputStream
extends OutputStream {
    private final ErasableByteArrayOutputStream ebOut = new ErasableByteArrayOutputStream();
    private byte[] buf;
    private int start;
    private int offset;

    public void setWrappedMode(byte[] byArray, int n) {
        this.buf = byArray;
        this.start = n;
        this.offset = n;
    }

    public void clearWrappedMode() {
        this.buf = null;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        if (this.buf != null) {
            System.arraycopy(byArray, 0, this.buf, this.offset, byArray.length);
            this.offset += byArray.length;
        } else {
            this.ebOut.write(byArray);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.buf != null) {
            System.arraycopy(byArray, n, this.buf, this.offset, n2);
            this.offset += n2;
        } else {
            this.ebOut.write(byArray, n, n2);
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.buf != null) {
            this.buf[this.offset++] = 0;
        } else {
            this.ebOut.write(n);
        }
    }

    public void reset() {
        this.offset = this.start;
        this.ebOut.reset();
    }

    public int size() {
        if (this.buf != null) {
            return this.offset - this.start;
        }
        return this.ebOut.size();
    }

    public byte[] toByteArray() {
        if (this.buf != null) {
            throw new IllegalStateException("attempt to call toByteArray in wrap mode");
        }
        return this.ebOut.toByteArray();
    }

    public void erase() {
        this.ebOut.erase();
    }
}

