// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import { _decryptStream } from './decrypt_stream';
import { _decrypt } from './decrypt';
import { CommitmentPolicy, needs, SignaturePolicy, } from '@aws-crypto/material-management-node';
export function buildDecrypt(options = {}) {
    const { commitmentPolicy = CommitmentPolicy.REQUIRE_ENCRYPT_REQUIRE_DECRYPT, maxEncryptedDataKeys = false, } = typeof options === 'string' ? { commitmentPolicy: options } : options;
    /* Precondition: node buildDecrypt needs a valid commitmentPolicy. */
    needs(CommitmentPolicy[commitmentPolicy], 'Invalid commitment policy.');
    /* Precondition: node buildDecrypt needs a valid maxEncryptedDataKeys. */
    needs(maxEncryptedDataKeys === false || maxEncryptedDataKeys >= 1, 'Invalid maxEncryptedDataKeys value.');
    const clientOptions = {
        commitmentPolicy,
        maxEncryptedDataKeys,
    };
    return {
        decryptUnsignedMessageStream: _decryptStream.bind({}, {
            signaturePolicy: SignaturePolicy.ALLOW_ENCRYPT_FORBID_DECRYPT,
            clientOptions,
        }),
        decryptStream: _decryptStream.bind({}, {
            signaturePolicy: SignaturePolicy.ALLOW_ENCRYPT_ALLOW_DECRYPT,
            clientOptions,
        }),
        decrypt: _decrypt.bind({}, {
            signaturePolicy: SignaturePolicy.ALLOW_ENCRYPT_ALLOW_DECRYPT,
            clientOptions,
        }),
    };
}
// @ts-ignore
const { decryptUnsignedMessageStream, decryptStream, decrypt } = buildDecrypt();
decryptUnsignedMessageStream({});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVjcnlwdF9jbGllbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvZGVjcnlwdF9jbGllbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsb0VBQW9FO0FBQ3BFLHNDQUFzQztBQUV0QyxPQUFPLEVBQUUsY0FBYyxFQUFFLE1BQU0sa0JBQWtCLENBQUE7QUFDakQsT0FBTyxFQUFFLFFBQVEsRUFBRSxNQUFNLFdBQVcsQ0FBQTtBQUNwQyxPQUFPLEVBQ0wsZ0JBQWdCLEVBQ2hCLEtBQUssRUFDTCxlQUFlLEdBRWhCLE1BQU0sc0NBQXNDLENBQUE7QUFTN0MsTUFBTSxVQUFVLFlBQVksQ0FDMUIsVUFBcUQsRUFBRTtJQVV2RCxNQUFNLEVBQ0osZ0JBQWdCLEdBQUcsZ0JBQWdCLENBQUMsK0JBQStCLEVBQ25FLG9CQUFvQixHQUFHLEtBQUssR0FDN0IsR0FBRyxPQUFPLE9BQU8sS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDLEVBQUUsZ0JBQWdCLEVBQUUsT0FBTyxFQUFFLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQTtJQUV6RSxxRUFBcUU7SUFDckUsS0FBSyxDQUFDLGdCQUFnQixDQUFDLGdCQUFnQixDQUFDLEVBQUUsNEJBQTRCLENBQUMsQ0FBQTtJQUN2RSx5RUFBeUU7SUFDekUsS0FBSyxDQUNILG9CQUFvQixLQUFLLEtBQUssSUFBSSxvQkFBb0IsSUFBSSxDQUFDLEVBQzNELHFDQUFxQyxDQUN0QyxDQUFBO0lBRUQsTUFBTSxhQUFhLEdBQWtCO1FBQ25DLGdCQUFnQjtRQUNoQixvQkFBb0I7S0FDckIsQ0FBQTtJQUNELE9BQU87UUFDTCw0QkFBNEIsRUFBRSxjQUFjLENBQUMsSUFBSSxDQUMvQyxFQUFFLEVBQ0Y7WUFDRSxlQUFlLEVBQUUsZUFBZSxDQUFDLDRCQUE0QjtZQUM3RCxhQUFhO1NBQ2QsQ0FDRjtRQUNELGFBQWEsRUFBRSxjQUFjLENBQUMsSUFBSSxDQUNoQyxFQUFFLEVBQ0Y7WUFDRSxlQUFlLEVBQUUsZUFBZSxDQUFDLDJCQUEyQjtZQUM1RCxhQUFhO1NBQ2QsQ0FDRjtRQUNELE9BQU8sRUFBRSxRQUFRLENBQUMsSUFBSSxDQUNwQixFQUFFLEVBQ0Y7WUFDRSxlQUFlLEVBQUUsZUFBZSxDQUFDLDJCQUEyQjtZQUM1RCxhQUFhO1NBQ2QsQ0FDRjtLQUNGLENBQUE7QUFDSCxDQUFDO0FBRUQsYUFBYTtBQUNiLE1BQU0sRUFBRSw0QkFBNEIsRUFBRSxhQUFhLEVBQUUsT0FBTyxFQUFFLEdBQUcsWUFBWSxFQUFFLENBQUE7QUFDL0UsNEJBQTRCLENBQUMsRUFBUyxDQUFDLENBQUEifQ==