"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports._encrypt = void 0;
const encrypt_stream_1 = require("./encrypt_stream");
// @ts-ignore
const readable_stream_1 = require("readable-stream");
async function _encrypt(clientOptions, cmm, plaintext, op = {}) {
    const { encoding } = op;
    if (plaintext instanceof Uint8Array) {
        op.plaintextLength = plaintext.byteLength;
    }
    else if (typeof plaintext === 'string') {
        plaintext = Buffer.from(plaintext, encoding);
        op.plaintextLength = plaintext.byteLength;
    }
    const stream = (0, encrypt_stream_1._encryptStream)(clientOptions, cmm, op);
    const result = [];
    let messageHeader = false;
    stream
        .once('MessageHeader', (header) => {
        messageHeader = header;
    })
        .on('data', (chunk) => result.push(chunk));
    // This will check both Uint8Array|Buffer
    if (plaintext instanceof Uint8Array) {
        stream.end(plaintext);
    }
    else if (plaintext.readable) {
        plaintext.pipe(stream);
    }
    else {
        throw new Error('Unsupported plaintext');
    }
    await finishedAsync(stream);
    if (!messageHeader)
        throw new Error('Unknown format');
    return {
        result: Buffer.concat(result),
        messageHeader,
    };
}
exports._encrypt = _encrypt;
async function finishedAsync(stream) {
    return new Promise((resolve, reject) => {
        (0, readable_stream_1.finished)(stream, (err) => (err ? reject(err) : resolve()));
    });
}
//# sourceMappingURL=data:application/json;base64,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