/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.action.upload.geojson;

import java.io.IOException;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.StepListener;
import org.opensearch.action.ingest.DeletePipelineRequest;
import org.opensearch.action.ingest.PutPipelineRequest;
import org.opensearch.client.ClusterAdminClient;
import org.opensearch.common.UUIDs;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;

public class PipelineManager {
    @Generated
    private static final Logger log = LogManager.getLogger(PipelineManager.class);
    @NonNull
    private final ClusterAdminClient client;

    public void create(String fieldName, StepListener<String> createPipelineStep) {
        String pipeline = UUIDs.randomBase64UUID();
        this.create(pipeline, fieldName, createPipelineStep);
    }

    private void create(String pipelineName, String fieldName, StepListener<String> createPipelineStep) {
        try (XContentBuilder pipelineRequestContent = this.buildPipelineRequestContent(fieldName);){
            this.createPipeline(pipelineRequestContent, pipelineName, createPipelineStep);
        }
        catch (IOException mappingException) {
            createPipelineStep.onFailure((Exception)mappingException);
        }
    }

    public void delete(String pipeline, StepListener<Exception> deletePipelineStep, Supplier<Exception> supplier) {
        DeletePipelineRequest pipelineRequest = new DeletePipelineRequest(pipeline);
        this.client.deletePipeline(pipelineRequest, ActionListener.wrap(acknowledgedResponse -> {
            StringBuilder message = new StringBuilder("Deleted pipeline: ").append(pipeline);
            log.info(message.toString());
            deletePipelineStep.onResponse((Object)((Exception)supplier.get()));
        }, deletePipelineRequestFailed -> {
            StringBuilder message = new StringBuilder("Failed to delete the pipeline: ").append(pipeline).append(" due to ").append(deletePipelineRequestFailed.getMessage());
            if (supplier.get() != null) {
                message.append("\n").append("Another exception occurred: ").append(((Exception)supplier.get()).getMessage());
            }
            deletePipelineStep.onFailure((Exception)new IllegalStateException(message.toString()));
        }));
    }

    private XContentBuilder buildPipelineRequestContent(String fieldName) throws IOException {
        return XContentFactory.jsonBuilder().startObject().startArray("processors").startObject().startObject("geojson-feature").field("field", fieldName).endObject().endObject().endArray().endObject();
    }

    private void createPipeline(XContentBuilder pipelineRequestXContent, String pipelineID, StepListener<String> createPipelineStep) {
        BytesReference pipelineRequestBodyBytes = BytesReference.bytes((XContentBuilder)pipelineRequestXContent);
        PutPipelineRequest pipelineRequest = new PutPipelineRequest(pipelineID, pipelineRequestBodyBytes, (MediaType)XContentType.JSON);
        this.client.putPipeline(pipelineRequest, ActionListener.wrap(acknowledgedResponse -> {
            StringBuilder pipelineMessage = new StringBuilder("Created pipeline: ").append(pipelineID);
            log.info(pipelineMessage.toString());
            createPipelineStep.onResponse((Object)pipelineID);
        }, putPipelineRequestFailedException -> {
            StringBuilder message = new StringBuilder("Failed to create the pipeline: ").append(pipelineID).append(" due to ").append(putPipelineRequestFailedException.getMessage());
            createPipelineStep.onFailure((Exception)new IllegalStateException(message.toString()));
        }));
    }

    @Generated
    public PipelineManager(@NonNull ClusterAdminClient client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }
}

