/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.spi.tools.WithModelTool;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.repackage.com.google.common.annotations.VisibleForTesting;

@ToolAnnotation(value="McpSseTool")
public class McpSseTool
implements WithModelTool {
    @Generated
    private static final Logger log = LogManager.getLogger(McpSseTool.class);
    public static final String TYPE = "McpSseTool";
    private String name = "McpSseTool";
    private Map<String, Object> attributes;
    @VisibleForTesting
    public static String DEFAULT_DESCRIPTION = "A tool from MCP Server";
    private String description = DEFAULT_DESCRIPTION;
    private McpSyncClient mcpSyncClient;
    private Parser inputParser;
    @VisibleForTesting
    private Parser outputParser;

    public McpSseTool(McpSyncClient mcpSyncClient) {
        this.mcpSyncClient = mcpSyncClient;
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        try {
            String input = parameters.get("input");
            Map inputArgs = StringUtils.fromJson((String)input, (String)"input");
            McpSchema.CallToolResult result = this.mcpSyncClient.callTool(new McpSchema.CallToolRequest(this.name, inputArgs));
            String resultJson = StringUtils.toJson((Object)result.content());
            listener.onResponse((Object)resultJson);
        }
        catch (Exception e) {
            log.error("Failed to call MCP tool: {}", (Object)this.getName(), (Object)e);
            listener.onFailure(e);
        }
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.size() != 0;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public McpSyncClient getMcpSyncClient() {
        return this.mcpSyncClient;
    }

    @Generated
    public void setInputParser(Parser inputParser) {
        this.inputParser = inputParser;
    }

    @Generated
    public void setOutputParser(Parser outputParser) {
        this.outputParser = outputParser;
    }

    @Generated
    public Parser getOutputParser() {
        return this.outputParser;
    }

    public static class Factory
    implements WithModelTool.Factory<McpSseTool> {
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<McpSseTool> clazz = McpSseTool.class;
            synchronized (McpSseTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init() {
        }

        public McpSseTool create(Map<String, Object> map) {
            return new McpSseTool((McpSyncClient)map.get("mcp_sync_client"));
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return McpSseTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        public List<String> getAllModelKeys() {
            return List.of();
        }
    }
}

