/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.dlic.rest.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.JsonDiff;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedBiConsumer;
import org.opensearch.common.action.ActionFuture;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.dlic.rest.api.AbstractApiAction;
import org.opensearch.security.dlic.rest.api.Endpoint;
import org.opensearch.security.dlic.rest.api.Responses;
import org.opensearch.security.dlic.rest.api.RestApiAdminPrivilegesEvaluator;
import org.opensearch.security.dlic.rest.api.SecurityApiDependencies;
import org.opensearch.security.dlic.rest.api.SecurityConfiguration;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.dlic.rest.validation.EndpointValidator;
import org.opensearch.security.dlic.rest.validation.RequestContentValidator;
import org.opensearch.security.dlic.rest.validation.ValidationResult;
import org.opensearch.security.securityconf.impl.CType;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.support.ConfigHelper;
import org.opensearch.threadpool.ThreadPool;

public class ConfigUpgradeApiAction
extends AbstractApiAction {
    private static final Logger LOGGER = LogManager.getLogger(ConfigUpgradeApiAction.class);
    private static final Set<CType<?>> SUPPORTED_CTYPES = ImmutableSet.of(CType.ROLES);
    private static final String REQUEST_PARAM_CONFIGS_KEY = "configs";
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_upgrade_check"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/_upgrade_perform")));

    @Inject
    public ConfigUpgradeApiAction(ClusterService clusterService, ThreadPool threadPool, SecurityApiDependencies securityApiDependencies) {
        super(Endpoint.CONFIG, clusterService, threadPool, securityApiDependencies);
        this.requestHandlersBuilder.configureRequestHandlers(rhb -> rhb.allMethodsNotImplemented().add(RestRequest.Method.GET, this::canUpgrade).add(RestRequest.Method.POST, this::performUpgrade));
    }

    void canUpgrade(RestChannel channel, RestRequest request, Client client) throws IOException {
        this.getAndValidateConfigurationsToUpgrade(request).map(this::configurationDifferences).valid(differencesList -> {
            List<ConfigItemChanges> allConfigItemChanges = differencesList.stream().map(kvp -> new ConfigItemChanges((CType)kvp.v1(), (JsonNode)kvp.v2())).collect(Collectors.toList());
            boolean upgradeAvailable = allConfigItemChanges.stream().anyMatch(ConfigItemChanges::hasChanges);
            ObjectNode response = JsonNodeFactory.instance.objectNode();
            response.put("status", "OK");
            response.put("upgradeAvailable", upgradeAvailable);
            if (upgradeAvailable) {
                ObjectNode differences = JsonNodeFactory.instance.objectNode();
                allConfigItemChanges.forEach(configItemChanges -> configItemChanges.addToNode(differences));
                response.set("upgradeActions", (JsonNode)differences);
            }
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, XContentType.JSON.mediaType(), response.toPrettyString()));
        }).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent)));
    }

    void performUpgrade(RestChannel channel, RestRequest request, Client client) throws IOException {
        this.getAndValidateConfigurationsToUpgrade(request).map(this::configurationDifferences).map(this::verifyHasDifferences).map(diffs -> this.applyDifferences(request, client, (List<Tuple<CType<?>, JsonNode>>)diffs)).valid(updatedConfigs -> {
            ObjectNode response = JsonNodeFactory.instance.objectNode();
            response.put("status", "OK");
            ObjectNode allUpdates = JsonNodeFactory.instance.objectNode();
            updatedConfigs.forEach(configItemChanges -> configItemChanges.addToNode(allUpdates));
            response.set("upgrades", (JsonNode)allUpdates);
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, XContentType.JSON.mediaType(), response.toPrettyString()));
        }).error((CheckedBiConsumer<RestStatus, ToXContent, IOException>)((CheckedBiConsumer)(status, toXContent) -> Responses.response(channel, status, toXContent)));
    }

    private ValidationResult<List<ConfigItemChanges>> applyDifferences(RestRequest request, Client client, List<Tuple<CType<?>, JsonNode>> differencesToUpdate) {
        try {
            ArrayList updatedResources = new ArrayList();
            for (Tuple<CType<?>, JsonNode> difference : differencesToUpdate) {
                updatedResources.add(this.loadConfiguration((CType)difference.v1(), false, false).map(configuration -> this.patchEntities(request, (JsonNode)difference.v2(), SecurityConfiguration.of(null, configuration)).map(patchResults -> {
                    ActionFuture<IndexResponse> response = ConfigUpgradeApiAction.saveAndUpdateConfigs(this.securityApiDependencies, client, (CType)difference.v1(), patchResults.configuration());
                    return ValidationResult.success((IndexResponse)response.actionGet());
                }).map(indexResponse -> {
                    ConfigItemChanges itemsGroupedByOperation = new ConfigItemChanges((CType)difference.v1(), (JsonNode)difference.v2());
                    return ValidationResult.success(itemsGroupedByOperation);
                })));
            }
            return ValidationResult.merge(updatedResources);
        }
        catch (Exception ioe) {
            LOGGER.debug("Error while applying differences", (Throwable)ioe);
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Error applying configuration, see the log file to troubleshoot."));
        }
    }

    ValidationResult<List<Tuple<CType<?>, JsonNode>>> verifyHasDifferences(List<Tuple<CType<?>, JsonNode>> diffs) {
        if (diffs.isEmpty()) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Unable to upgrade, no differences found"));
        }
        for (Tuple<CType<?>, JsonNode> diff : diffs) {
            if (((JsonNode)diff.v2()).size() != 0) continue;
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Unable to upgrade, no differences found in '" + ((CType)diff.v1()).toLCString() + "' config"));
        }
        return ValidationResult.success(diffs);
    }

    private ValidationResult<List<Tuple<CType<?>, JsonNode>>> configurationDifferences(Set<CType<?>> configurations) {
        try {
            ArrayList differences = new ArrayList();
            for (CType<?> configuration : configurations) {
                differences.add(this.computeDifferenceToUpdate(configuration));
            }
            return ValidationResult.merge(differences);
        }
        catch (UncheckedIOException ioe) {
            LOGGER.error("Error while processing differences", (Throwable)ioe.getCause());
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Error processing configuration, see the log file to troubleshoot."));
        }
    }

    ValidationResult<Tuple<CType<?>, JsonNode>> computeDifferenceToUpdate(CType<?> configType) {
        return (ValidationResult)Utils.withIOException(() -> this.loadConfiguration(configType, false, false).map(activeRoles -> {
            JsonNode activeRolesJson = Utils.convertJsonToJackson(activeRoles, true);
            JsonNode defaultRolesJson = this.loadConfigFileAsJson(configType);
            JsonNode rawDiff = JsonDiff.asJson((JsonNode)activeRolesJson, (JsonNode)defaultRolesJson, EnumSet.of(DiffFlags.OMIT_VALUE_ON_REMOVE));
            return ValidationResult.success(new Tuple((Object)configType, (Object)this.filterRemoveOperations(rawDiff)));
        }));
    }

    private ValidationResult<Set<CType<?>>> getAndValidateConfigurationsToUpgrade(RestRequest request) {
        Set<CType<CType<?>>> configurations;
        String[] configs = request.paramAsStringArray(REQUEST_PARAM_CONFIGS_KEY, null);
        try {
            configurations = Optional.ofNullable(configs).map(CType::fromStringValues).orElse(SUPPORTED_CTYPES);
        }
        catch (IllegalArgumentException iae) {
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Found invalid configuration option, valid options are: " + String.valueOf(CType.lcStringValues())));
        }
        if (!configurations.stream().allMatch(SUPPORTED_CTYPES::contains)) {
            configurations.removeAll(SUPPORTED_CTYPES);
            return ValidationResult.error(RestStatus.BAD_REQUEST, Responses.badRequestMessage("Unsupported configurations for upgrade, " + String.valueOf(configurations)));
        }
        return ValidationResult.success(configurations);
    }

    private JsonNode filterRemoveOperations(JsonNode diff) {
        ArrayNode filteredDiff = JsonNodeFactory.instance.arrayNode();
        diff.forEach(node -> {
            if (!ConfigUpgradeApiAction.isRemoveOperation(node)) {
                filteredDiff.add(node);
                return;
            }
            if (!ConfigUpgradeApiAction.hasRootLevelPath(node)) {
                filteredDiff.add(node);
            }
        });
        return filteredDiff;
    }

    private static String pathRoot(JsonNode node) {
        return node.get("path").asText().split("/")[1];
    }

    private static boolean hasRootLevelPath(JsonNode node) {
        String jsonPath = node.get("path").asText();
        return jsonPath.charAt(0) == '/' && !jsonPath.substring(1).contains("/");
    }

    private static boolean isRemoveOperation(JsonNode node) {
        return node.get("op").asText().equals("remove");
    }

    private <T> SecurityDynamicConfiguration<T> loadYamlFile(String filepath, CType<T> cType) throws IOException {
        return ConfigHelper.fromYamlFile(filepath, cType, 2, 0L, 0L);
    }

    JsonNode loadConfigFileAsJson(CType<?> cType) throws IOException {
        String cd = this.securityApiDependencies.configurationRepository().getConfigDirectory();
        String filepath = cType.configFile(Path.of(cd, new String[0])).toString();
        try {
            return AccessController.doPrivileged(() -> {
                SecurityDynamicConfiguration loadedConfiguration = this.loadYamlFile(filepath, cType);
                return Utils.convertJsonToJackson(loadedConfiguration, true);
            });
        }
        catch (PrivilegedActionException e) {
            LOGGER.error("Error when loading configuration from file", (Throwable)e);
            throw (IOException)e.getCause();
        }
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    @Override
    protected CType<?> getConfigType() {
        throw new UnsupportedOperationException("This class supports multiple configuration types");
    }

    @Override
    protected EndpointValidator createEndpointValidator() {
        return new EndpointValidator(){

            @Override
            public Endpoint endpoint() {
                return ConfigUpgradeApiAction.this.endpoint;
            }

            @Override
            public RestApiAdminPrivilegesEvaluator restApiAdminPrivilegesEvaluator() {
                return ConfigUpgradeApiAction.this.securityApiDependencies.restApiAdminPrivilegesEvaluator();
            }

            @Override
            public ValidationResult<SecurityConfiguration> entityReserved(SecurityConfiguration securityConfiguration) {
                return ValidationResult.success(securityConfiguration);
            }

            @Override
            public ValidationResult<SecurityConfiguration> entityHidden(SecurityConfiguration securityConfiguration) {
                return ValidationResult.success(securityConfiguration);
            }

            @Override
            public RequestContentValidator createRequestContentValidator(final Object ... params) {
                return new ConfigUpgradeContentValidator(new RequestContentValidator.ValidationContext(){

                    @Override
                    public Object[] params() {
                        return params;
                    }

                    @Override
                    public Settings settings() {
                        return ConfigUpgradeApiAction.this.securityApiDependencies.settings();
                    }

                    @Override
                    public Map<String, RequestContentValidator.DataType> allowedKeys() {
                        return Map.of(ConfigUpgradeApiAction.REQUEST_PARAM_CONFIGS_KEY, RequestContentValidator.DataType.ARRAY);
                    }
                });
            }
        };
    }

    static class ConfigItemChanges {
        private final CType<?> config;
        private final Map<String, List<String>> itemsGroupedByOperation;

        public ConfigItemChanges(CType<?> config, JsonNode differences) {
            this.config = config;
            this.itemsGroupedByOperation = ConfigItemChanges.classifyChanges(differences);
        }

        public boolean hasChanges() {
            return !this.itemsGroupedByOperation.isEmpty();
        }

        public void addToNode(ObjectNode node) {
            ObjectNode allOperations = JsonNodeFactory.instance.objectNode();
            this.itemsGroupedByOperation.forEach((operation, items) -> {
                ArrayNode arrayNode = allOperations.putArray(operation);
                items.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
            });
            node.set(this.config.toLCString(), (JsonNode)allOperations);
        }

        private static Map<String, List<String>> classifyChanges(JsonNode differences) {
            HashMap items = new HashMap();
            differences.forEach(node -> {
                String item = ConfigUpgradeApiAction.pathRoot(node);
                String operation = node.get("op").asText();
                if (items.containsKey(item) && !((String)items.get(item)).equals(operation)) {
                    items.put(item, "modify");
                } else {
                    items.put(item, operation);
                }
            });
            Map<String, List<String>> itemsGroupedByOperation = items.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
            return itemsGroupedByOperation;
        }
    }

    static class ConfigUpgradeContentValidator
    extends RequestContentValidator {
        protected ConfigUpgradeContentValidator(RequestContentValidator.ValidationContext validationContext) {
            super(validationContext);
        }

        @Override
        public ValidationResult<JsonNode> validate(RestRequest request, JsonNode jsonContent) throws IOException {
            return this.validateContentSize(jsonContent);
        }
    }
}

