/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auditlog.AuditLog;
import org.opensearch.security.configuration.ClusterInfoHolder;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.support.SnapshotRestoreHelper;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportRequest;

public class SnapshotRestoreEvaluator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final boolean enableSnapshotRestorePrivilege;
    private final String securityIndex;
    private final AuditLog auditLog;
    private final boolean restoreSecurityIndexEnabled;

    public SnapshotRestoreEvaluator(Settings settings, AuditLog auditLog) {
        this.enableSnapshotRestorePrivilege = settings.getAsBoolean("plugins.security.enable_snapshot_restore_privilege", Boolean.valueOf(true));
        this.restoreSecurityIndexEnabled = settings.getAsBoolean("plugins.security.unsupported.restore.securityindex.enabled", Boolean.valueOf(false));
        this.securityIndex = settings.get("plugins.security.config_index_name", ".opendistro_security");
        this.auditLog = auditLog;
    }

    public PrivilegesEvaluatorResponse evaluate(ActionRequest request, Task task, String action, ClusterInfoHolder clusterInfoHolder, PrivilegesEvaluatorResponse presponse) {
        if (!(request instanceof RestoreSnapshotRequest)) {
            return presponse;
        }
        if (!this.enableSnapshotRestorePrivilege) {
            this.log.warn("{} is not allowed for a regular user", (Object)action);
            presponse.allowed = false;
            return presponse.markComplete();
        }
        if (this.restoreSecurityIndexEnabled) {
            presponse.allowed = true;
            return presponse;
        }
        if (clusterInfoHolder.isLocalNodeElectedClusterManager() == Boolean.FALSE) {
            presponse.allowed = true;
            return presponse.markComplete();
        }
        RestoreSnapshotRequest restoreRequest = (RestoreSnapshotRequest)request;
        if (restoreRequest.includeGlobalState()) {
            this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
            this.log.warn("{} with 'include_global_state' enabled is not allowed", (Object)action);
            presponse.allowed = false;
            return presponse.markComplete();
        }
        List<String> rs = SnapshotRestoreHelper.resolveOriginalIndices(restoreRequest);
        if (rs != null && (rs.contains(this.securityIndex) || rs.contains("_all") || rs.contains("*"))) {
            this.auditLog.logSecurityIndexAttempt((TransportRequest)request, action, task);
            this.log.warn("{} for '{}' as source index is not allowed", (Object)action, (Object)this.securityIndex);
            presponse.allowed = false;
            return presponse.markComplete();
        }
        return presponse;
    }
}

