/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.perl.inline.java.InlineJavaCastException;
import org.perl.inline.java.InlineJavaClass;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaUtils;

class InlineJavaArray {
    private InlineJavaClass ijc;

    InlineJavaArray(InlineJavaClass _ijc) {
        this.ijc = _ijc;
    }

    Object CreateArray(Class c, StringTokenizer st) throws InlineJavaException {
        StringBuffer sb = new StringBuffer(st.nextToken());
        sb.replace(0, 1, "");
        sb.replace(sb.length() - 1, sb.length(), "");
        StringTokenizer st2 = new StringTokenizer(sb.toString(), ",");
        ArrayList<String> al = new ArrayList<String>();
        while (st2.hasMoreTokens()) {
            al.add(al.size(), st2.nextToken());
        }
        int size = al.size();
        int[] dims = new int[size];
        for (int i = 0; i < size; ++i) {
            dims[i] = Integer.parseInt((String)al.get(i));
            InlineJavaUtils.debug(4, "array dimension: " + (String)al.get(i));
        }
        Object array = null;
        try {
            array = Array.newInstance(c, dims);
            ArrayList<String> args = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                args.add(args.size(), st.nextToken());
            }
            this.PopulateArray(array, c, dims, args);
        }
        catch (IllegalArgumentException e) {
            throw new InlineJavaException("Arguments to array constructor for class " + c.getName() + " are incompatible: " + e.getMessage());
        }
        return array;
    }

    void PopulateArray(Object array, Class elem, int[] dims, ArrayList args) throws InlineJavaException {
        if (dims.length > 1) {
            int i;
            int nb_args = args.size();
            int nb_sub_dims = dims[0];
            int nb_args_per_sub_dim = nb_args / nb_sub_dims;
            int[] sub_dims = new int[dims.length - 1];
            for (i = 1; i < dims.length; ++i) {
                sub_dims[i - 1] = dims[i];
            }
            for (i = 0; i < nb_sub_dims; ++i) {
                ArrayList<String> sub_args = new ArrayList<String>();
                for (int j = i * nb_args_per_sub_dim; j < (i + 1) * nb_args_per_sub_dim; ++j) {
                    sub_args.add(sub_args.size(), (String)args.get(j));
                }
                this.PopulateArray(((Object[])array)[i], elem, sub_dims, sub_args);
            }
        } else {
            String msg = "In creation of array of " + elem.getName() + ": ";
            try {
                for (int i = 0; i < dims[0]; ++i) {
                    String arg = (String)args.get(i);
                    Object o = this.ijc.CastArgument(elem, arg);
                    Array.set(array, i, o);
                    if (o != null) {
                        InlineJavaUtils.debug(4, "setting array element " + String.valueOf(i) + " to " + o.toString());
                        continue;
                    }
                    InlineJavaUtils.debug(4, "setting array element " + String.valueOf(i) + " to " + String.valueOf(o));
                }
            }
            catch (InlineJavaCastException e) {
                throw new InlineJavaCastException(msg + e.getMessage());
            }
            catch (InlineJavaException e) {
                throw new InlineJavaException(msg + e.getMessage());
            }
        }
    }
}

